/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Player;
import com.jcloisterzone.bugreport.ReportingTool;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.GameListChangedEvent;
import com.jcloisterzone.event.GameOverEvent;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.online.Channel;
import com.jcloisterzone.ui.ChannelController;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.ClientMessageListener;
import com.jcloisterzone.ui.EventProxyUiController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.MenuBar;
import com.jcloisterzone.ui.PlayerColors;
import com.jcloisterzone.ui.controls.chat.GameChatPanel;
import com.jcloisterzone.ui.dialog.DiscardedTilesDialog;
import com.jcloisterzone.ui.panel.GameOverPanel;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.view.ChannelView;
import com.jcloisterzone.ui.view.GameChatView;
import com.jcloisterzone.ui.view.GameView;
import com.jcloisterzone.ui.view.StartView;
import com.jcloisterzone.wsio.Connection;
import com.jcloisterzone.wsio.message.GameMessage;
import com.jcloisterzone.wsio.message.LeaveGameMessage;
import com.jcloisterzone.wsio.message.WsChainedMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import com.jcloisterzone.wsio.message.WsMessage;
import io.vavr.collection.Array;
import io.vavr.collection.Stream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameController
extends EventProxyUiController<Game> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Game game;
    private GameMessage.GameStatus gameStatus;
    private String channel;
    private boolean passwordProtected;
    private ReportingTool reportingTool;
    private GameView gameView;
    private Connection connProxy;
    private AtomicReference<String> chainMessageId = new AtomicReference();
    private AtomicBoolean actionLock = new AtomicBoolean();

    public GameController(Client client, Game game) {
        super(client, game);
        this.game = game;
        this.connProxy = new ConnectionProxy();
    }

    public Game getGame() {
        return this.game;
    }

    public String getGameId() {
        return this.game.getGameId();
    }

    public GameMessage.GameStatus getGameStatus() {
        return this.gameStatus;
    }

    public AtomicReference<String> getChainMessageIdRef() {
        return this.chainMessageId;
    }

    public AtomicBoolean getActionLock() {
        return this.actionLock;
    }

    public void setGameStatus(GameMessage.GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }

    public void onGameStarted(Game game) {
        Stream<PlayerSlot> slots = Stream.ofAll(Arrays.asList(game.getPlayerSlots()));
        Array occupiedSlots = slots.filter(slot -> slot != null && slot.isOccupied()).toArray();
        Array freeColors = Stream.range(0, 6).filter(i -> occupiedSlots.find(s -> s.getNumber() == i.intValue()).isEmpty()).map(i -> this.getConfig().getPlayerColor((int)i)).toArray();
        int occupiedSize = occupiedSlots.size();
        int freeSize = freeColors.size();
        int i2 = 0;
        for (PlayerSlot slot2 : occupiedSlots) {
            HashMap<TunnelCapability.Tunnel, Color> tunnelColors = new HashMap<TunnelCapability.Tunnel, Color>();
            tunnelColors.put(TunnelCapability.Tunnel.TUNNEL_A, slot2.getColors().getMeepleColor());
            if (freeSize >= occupiedSize) {
                tunnelColors.put(TunnelCapability.Tunnel.TUNNEL_B, ((PlayerColors)freeColors.get(i2)).getMeepleColor());
                ++i2;
            }
            if (freeSize >= 2 * occupiedSize) {
                tunnelColors.put(TunnelCapability.Tunnel.TUNNEL_C, ((PlayerColors)freeColors.get(i2)).getMeepleColor());
                ++i2;
            }
            slot2.getColors().setTunnelColors(tunnelColors);
        }
        if (this.gameView == null) {
            this.gameView = new GameView(this.client, this);
            if (this.client.getView() instanceof GameChatView) {
                GameChatView prevView = (GameChatView)((Object)this.client.getView());
                this.gameView.setChatPanel(prevView.getChatPanel());
            } else {
                this.gameView.setChatPanel(new GameChatPanel(this.client, game));
            }
        } else {
            this.gameView.getGridPanel().hideErrorMessage("RECONNECTING");
        }
        if (this.client.getView() != this.gameView) {
            SwingUtilities.invokeLater(() -> this.client.mountView(this.gameView));
        }
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        Player pl;
        if (this.gameView == null) {
            this.logger.warn("gameView is null");
            return;
        }
        GameState state = ev.getCurrentState();
        if (ev.hasDiscardedTilesChanged()) {
            DiscardedTilesDialog discardedTilesDialog = this.client.getDiscardedTilesDialog();
            if (discardedTilesDialog == null) {
                discardedTilesDialog = new DiscardedTilesDialog(this.client);
                this.client.setDiscardedTilesDialog(discardedTilesDialog);
                this.client.getJMenuBar().setItemEnabled(MenuBar.MenuItem.DISCARDED_TILES, true);
            }
            discardedTilesDialog.setDiscardedTiles(state.getDiscardedTiles());
            discardedTilesDialog.setVisible(true);
        }
        if (ev.hasPlayerActionsChanged()) {
            pl = state.getActivePlayer();
            boolean canUndo = pl != null && pl.isLocalHuman() && this.game.isUndoAllowed();
            this.client.getJMenuBar().setItemEnabled(MenuBar.MenuItem.UNDO, canUndo);
        }
        if (ev.hasTurnPlayerChanged()) {
            pl = state.getTurnPlayer();
            if (pl.isLocalHuman()) {
                this.client.beep();
            }
            Color c = pl.getColors().getMeepleColor();
            Image image = this.client.getResourceManager().getLayeredImage(new LayeredImageDescriptor(SmallFollower.class, c));
            this.client.setIconImage(image);
        }
    }

    @Subscribe
    public void handleGameStateChange(GameOverEvent ev) {
        boolean showPlayAgain = this.client.getLocalServer() != null;
        this.gameView.setGameRunning(false);
        if (this.getChannel() == null && this.gameView.getChatPanel() != null) {
            this.gameView.getGridPanel().remove(this.gameView.getChatPanel());
        }
        this.client.closeGame(true);
        GameOverPanel panel = new GameOverPanel(this.client, this, showPlayAgain);
        this.gameView.getGridPanel().add((Component)panel, "pos 0 35");
        this.gameView.getGridPanel().revalidate();
    }

    public void refreshWindowTitle() {
        StringBuilder title = new StringBuilder("JCloisterZone");
        GameState state = this.game.getState();
        Player activePlayer = state.getActivePlayer();
        if (activePlayer != null) {
            title.append(" \u22c5 ").append(activePlayer.getNick());
        }
        int packSize = state.getTilePack().totalSize();
        title.append(" \u22c5 ").append(String.format(I18nUtils._tr("%d tiles left", new Object[0]), packSize));
        this.client.setTitle(title.toString());
    }

    public void showWarning(String title, String message) {
        JOptionPane.showMessageDialog(this.client, message, title, 2);
    }

    public void leaveGame() {
        if (this.getChannel() == null) {
            this.client.mountView(new StartView(this.client));
        } else if (this.getConnection().isClosed()) {
            this.client.mountView(new StartView(this.client));
        } else {
            ClientMessageListener cml = this.client.getClientMessageListener();
            this.getConnection().send(new LeaveGameMessage());
            ChannelController ctrl = cml.getChannelControllers().get(this.channel);
            this.client.mountView(new ChannelView(this.client, ctrl));
            List<GameController> gcs = cml.getGameControllers(this.channel);
            ((Channel)ctrl.getEventProxy()).post(new GameListChangedEvent(gcs.toArray(new GameController[gcs.size()])));
        }
    }

    public GameView getGameView() {
        return this.gameView;
    }

    public void setGameView(GameView gameView) {
        this.gameView = gameView;
    }

    public ReportingTool getReportingTool() {
        return this.reportingTool;
    }

    public void setReportingTool(ReportingTool reportingTool) {
        this.reportingTool = reportingTool;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public void setPasswordProtected(boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
    }

    @Override
    public Connection getConnection() {
        return this.connProxy;
    }

    class ConnectionProxy
    implements Connection {
        ConnectionProxy() {
        }

        private Connection getConnection() {
            return GameController.this.client.getConnection();
        }

        @Override
        public void send(WsMessage msg) {
            if (msg.getMessageId() == null) {
                msg.setMessageId(UUID.randomUUID().toString());
            }
            if (msg instanceof WsInGameMessage) {
                ((WsInGameMessage)msg).setGameId(GameController.this.game.getGameId());
            }
            if (msg instanceof WsChainedMessage) {
                ((WsChainedMessage)((Object)msg)).setParentId((String)GameController.this.chainMessageId.get());
            }
            this.getConnection().send(msg);
        }

        @Override
        public boolean isClosed() {
            if (this.getConnection() != null) {
                return this.getConnection().isClosed();
            }
            return false;
        }

        @Override
        public void close() {
            if (this.getConnection() != null) {
                this.getConnection().close();
            }
        }

        @Override
        public void reconnect(String gameId, long initialDelay) {
            if (this.getConnection() != null) {
                this.getConnection().reconnect(gameId, initialDelay);
            }
        }

        @Override
        public void stopReconnecting() {
            if (this.getConnection() != null) {
                this.getConnection().stopReconnecting();
            }
        }

        @Override
        public String getSessionId() {
            return this.getConnection().getSessionId();
        }

        @Override
        public String getNickname() {
            return GameController.this.client.getConnection().getNickname();
        }
    }
}

