/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.jcloisterzone.board.Rotation;
import java.awt.Point;
import java.awt.geom.AffineTransform;

public class ImmutablePoint {
    public static final ImmutablePoint ZERO = new ImmutablePoint(0, 0);
    private final int x;
    private final int y;

    public ImmutablePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ImmutablePoint add(int tx, int ty) {
        return new ImmutablePoint(this.x + tx, this.y + ty);
    }

    public ImmutablePoint transform(AffineTransform tx) {
        Point ptSrc = new Point(this.x, this.y);
        Point ptDst = new Point();
        tx.transform(ptSrc, ptDst);
        return new ImmutablePoint(ptDst.x, ptDst.y);
    }

    public ImmutablePoint scale(int tileWidth, int tileHeight) {
        return this.scale(tileWidth, tileHeight, 0, 0);
    }

    public ImmutablePoint scale(int tileWidth, int tileHeight, int boxSize) {
        return this.scale(tileWidth, tileHeight, boxSize, boxSize);
    }

    public ImmutablePoint scale(int tileWidth, int tileHeight, int xSize, int ySize) {
        return new ImmutablePoint((int)((double)tileWidth * ((double)this.x / 100.0)) - xSize / 2, (int)((double)tileHeight * ((double)this.y / 100.0)) - ySize / 2);
    }

    public ImmutablePoint mirrorX() {
        return new ImmutablePoint(100 - this.x, this.y);
    }

    public ImmutablePoint mirrorY() {
        return new ImmutablePoint(this.x, 100 - this.y);
    }

    public ImmutablePoint rotate() {
        return new ImmutablePoint(100 - this.y, this.x);
    }

    public ImmutablePoint rotate100(Rotation r) {
        int x = this.x;
        int y = this.y;
        for (int i = 0; i < r.ordinal(); ++i) {
            int _y = y;
            y = x;
            x = 100 - _y;
        }
        return new ImmutablePoint(x, y);
    }

    public ImmutablePoint rotate(Rotation r) {
        int x = this.x;
        int y = this.y;
        for (int i = 0; i < r.ordinal(); ++i) {
            int _y = y;
            y = x;
            x = -_y;
        }
        return new ImmutablePoint(x, y);
    }

    public ImmutablePoint translate(int dx, int dy) {
        return new ImmutablePoint(this.x + dx, this.y + dy);
    }

    public int hashCode() {
        return this.x << 16 ^ this.y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutablePoint) {
            ImmutablePoint p = (ImmutablePoint)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
    }
}

