/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui;

import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.JCloisterZone;
import com.jcloisterzone.ui.view.ConnectP2PView;
import com.jcloisterzone.ui.view.ConnectPlayOnlineView;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuBar
extends JMenuBar {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client client;
    private EnumMap<MenuItem, JMenuItem> items = new EnumMap(MenuItem.class);

    public MenuBar(Client _client) {
        this.client = _client;
        boolean isMac = JCloisterZone.isMac();
        JMenu menu = new JMenu(I18nUtils._tr("Session", new Object[0]));
        menu.setMnemonic(80);
        menu.add(this.createMenuItem(MenuItem.NEW_GAME, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.createGame();
            }
        }));
        menu.add(this.createMenuItem(MenuItem.CONNECT_P2P, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.mountView(new ConnectP2PView(MenuBar.this.client));
            }
        }));
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.PLAY_ONLINE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.mountView(new ConnectPlayOnlineView(MenuBar.this.client));
            }
        }));
        menu.add(this.createMenuItem(MenuItem.DISCONNECT, false));
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.LEAVE_GAME, false));
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.SAVE, false));
        menu.add(this.createMenuItem(MenuItem.LOAD, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.handleLoad();
            }
        }));
        if (!isMac) {
            menu.addSeparator();
            menu.add(this.createMenuItem(MenuItem.QUIT, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuBar.this.client.handleQuit();
                }
            }));
        }
        this.add(menu);
        menu = new JMenu(I18nUtils._tr("Game", new Object[0]));
        menu.setMnemonic(71);
        menu.add(this.createMenuItem(MenuItem.UNDO, false));
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.ZOOM_IN, false));
        menu.add(this.createMenuItem(MenuItem.ZOOM_OUT, false));
        menu.add(this.createMenuItem(MenuItem.ROTATE_BOARD, false));
        menu.addSeparator();
        JCheckBoxMenuItem chbox = this.createCheckBoxMenuItem(MenuItem.GAME_EVENTS, false);
        chbox.setSelected(true);
        menu.add(chbox);
        menu.add(this.createCheckBoxMenuItem(MenuItem.LAST_PLACEMENTS, false));
        menu.add(this.createCheckBoxMenuItem(MenuItem.FARM_HINTS, false));
        menu.add(this.createCheckBoxMenuItem(MenuItem.PROJECTED_POINTS, false));
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.DISCARDED_TILES, false));
        menu.add(this.createMenuItem(MenuItem.GAME_SETUP, false));
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.TAKE_SCREENSHOT, false));
        this.add(menu);
        menu = new JMenu(I18nUtils._tr("Settings", new Object[0]));
        chbox = this.createCheckBoxMenuItem(MenuItem.BEEP_ALERT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
                MenuBar.this.client.getConfig().setBeep_alert(ch.isSelected());
                MenuBar.this.client.saveConfig();
            }
        });
        menu.add(chbox);
        chbox.setSelected(this.client.getConfig().getBeep_alert());
        menu.addSeparator();
        chbox = this.createCheckBoxMenuItem(MenuItem.CONFIRM_ANY_DEPLOYMENT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
                MenuBar.this.client.getConfig().getConfirm().setAny_deployment(ch.isSelected());
                MenuBar.this.client.saveConfig();
            }
        });
        menu.add(chbox);
        chbox.setSelected(this.client.getConfig().getConfirm().getAny_deployment());
        chbox = this.createCheckBoxMenuItem(MenuItem.CONFIRM_FARM_DEPLOYMENT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
                MenuBar.this.client.getConfig().getConfirm().setFarm_deployment(ch.isSelected());
                MenuBar.this.client.saveConfig();
            }
        });
        menu.add(chbox);
        chbox.setSelected(this.client.getConfig().getConfirm().getFarm_deployment());
        chbox = this.createCheckBoxMenuItem(MenuItem.CONFIRM_TOWER_DEPLOYMENT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
                MenuBar.this.client.getConfig().getConfirm().setOn_tower_deployment(ch.isSelected());
                MenuBar.this.client.saveConfig();
            }
        });
        menu.add(chbox);
        chbox.setSelected(this.client.getConfig().getConfirm().getOn_tower_deployment());
        menu.addSeparator();
        chbox = this.createCheckBoxMenuItem(MenuItem.CONFIRM_RANSOM, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem ch = (JCheckBoxMenuItem)e.getSource();
                MenuBar.this.client.getConfig().getConfirm().setRansom_payment(ch.isSelected());
                MenuBar.this.client.saveConfig();
            }
        });
        menu.add(chbox);
        chbox.setSelected(this.client.getConfig().getConfirm().getRansom_payment());
        menu.addSeparator();
        menu.add(this.createMenuItem(MenuItem.PREFERENCES, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.showPreferncesDialog();
            }
        }));
        this.add(menu);
        menu = new JMenu(I18nUtils._tr("Help", new Object[0]));
        if (!isMac) {
            menu.add(this.createMenuItem(MenuItem.ABOUT, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuBar.this.client.showAboutDialog();
                }
            }));
        }
        menu.add(this.createMenuItem(MenuItem.TILE_DISTRIBUTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.showTileDistribution();
            }
        }));
        menu.add(this.createMenuItem(MenuItem.CONTROLS, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.client.showHelpDialog();
            }
        }));
        menu.add(this.createMenuItem(MenuItem.REPORT_BUG, false));
        this.add(menu);
    }

    private JMenuItem createMenuItem(MenuItem def, boolean enabled) {
        return this.createMenuItem(def, null, enabled);
    }

    private JMenuItem createMenuItem(MenuItem def, ActionListener handler) {
        return this.createMenuItem(def, handler, true);
    }

    private JMenuItem createMenuItem(MenuItem def, ActionListener handler, boolean enabled) {
        JMenuItem instance = new JMenuItem(def.title);
        this.initMenuItem(instance, def, handler);
        instance.setEnabled(enabled);
        return instance;
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(MenuItem def, boolean enabled) {
        return this.createCheckBoxMenuItem(def, null, enabled);
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(MenuItem def, ActionListener handler) {
        return this.createCheckBoxMenuItem(def, handler, true);
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(MenuItem def, ActionListener handler, boolean enabled) {
        JCheckBoxMenuItem instance = new JCheckBoxMenuItem(def.title);
        this.initMenuItem(instance, def, handler);
        instance.setEnabled(enabled);
        return instance;
    }

    private void initMenuItem(JMenuItem instance, MenuItem def, ActionListener handler) {
        if (def.accelerator != null) {
            instance.setAccelerator(def.accelerator);
        }
        if (handler != null) {
            instance.addActionListener(handler);
        }
        this.items.put(def, instance);
    }

    public void setItemEnabled(MenuItem item, boolean state) {
        this.items.get((Object)item).setEnabled(state);
    }

    public void setItemActionListener(MenuItem item, ActionListener handler) {
        ActionListener[] listeners;
        JMenuItem instance = this.items.get((Object)item);
        for (ActionListener listener : listeners = instance.getActionListeners()) {
            instance.removeActionListener(listener);
        }
        if (handler != null) {
            instance.addActionListener(handler);
        }
    }

    public boolean isSelected(MenuItem item) {
        JCheckBoxMenuItem instance = (JCheckBoxMenuItem)this.items.get((Object)item);
        return instance.isSelected();
    }

    public static enum MenuItem {
        NEW_GAME(I18nUtils._tr("New game", new Object[0]), KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        CONNECT_P2P(I18nUtils._tr("Connect", new Object[0]), KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        PLAY_ONLINE(I18nUtils._tr("Play Online", new Object[0]), KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        DISCONNECT(I18nUtils._tr("Disconnect", new Object[0])),
        LEAVE_GAME(I18nUtils._tr("Leave Game", new Object[0])),
        SAVE(I18nUtils._tr("Save Game", new Object[0]), KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        LOAD(I18nUtils._tr("Load Game", new Object[0]), KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        QUIT(I18nUtils._tr("Quit", new Object[0]), KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        UNDO(I18nUtils._tr("Undo", new Object[0]), KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        ZOOM_IN(I18nUtils._tr("Zoom In", new Object[0])),
        ZOOM_OUT(I18nUtils._tr("Zoom Out", new Object[0])),
        ROTATE_BOARD(I18nUtils._tr("Rotate Board", new Object[0]), KeyStroke.getKeyStroke('/')),
        GAME_EVENTS(I18nUtils._tr("Show Game Events", new Object[0]), KeyStroke.getKeyStroke('e')),
        LAST_PLACEMENTS(I18nUtils._tr("Show Last Placements", new Object[0]), KeyStroke.getKeyStroke('x')),
        FARM_HINTS(I18nUtils._tr("Show Farm Hints", new Object[0]), KeyStroke.getKeyStroke('f')),
        PROJECTED_POINTS(I18nUtils._tr("Show Projected Points", new Object[0]), KeyStroke.getKeyStroke('p')),
        DISCARDED_TILES(I18nUtils._tr("Show Discarded Tiles", new Object[0]), KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())),
        GAME_SETUP(I18nUtils._tr("Show Game Setup", new Object[0])),
        TAKE_SCREENSHOT(I18nUtils._tr("Take Screenshot", new Object[0]), KeyStroke.getKeyStroke(123, 0)),
        BEEP_ALERT(I18nUtils._tr("Beep Alert at Player Turn", new Object[0])),
        CONFIRM_ANY_DEPLOYMENT(I18nUtils._tr("Confirm Every Meeple Deployment", new Object[0])),
        CONFIRM_FARM_DEPLOYMENT(I18nUtils._tr("Confirm Meeple Deployment on a Farm", new Object[0])),
        CONFIRM_TOWER_DEPLOYMENT(I18nUtils._tr("Confirm Meeple Deployment on a Tower", new Object[0])),
        CONFIRM_RANSOM(I18nUtils._tr("Confirm Ransom Payment", new Object[0])),
        PREFERENCES(I18nUtils._tr("Preferences", new Object[0]), JCloisterZone.isMac() ? KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) : null),
        ABOUT(I18nUtils._tr("About", new Object[0])),
        TILE_DISTRIBUTION(I18nUtils._tr("Tile Distribution", new Object[0]), KeyStroke.getKeyStroke(122, 0)),
        CONTROLS(I18nUtils._tr("Controls", new Object[0])),
        REPORT_BUG(I18nUtils._tr("Report Bug", new Object[0]));

        String title;
        KeyStroke accelerator;

        private MenuItem(String title) {
            this(title, null);
        }

        private MenuItem(String title, KeyStroke accelerator) {
            this.title = title;
            this.accelerator = accelerator;
        }
    }
}

