/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.animation;

import com.jcloisterzone.ui.animation.Animation;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAnimation
implements Animation {
    protected long nextFrame;

    @Override
    public long getDelay(TimeUnit unit) {
        assert (unit == TimeUnit.NANOSECONDS);
        return (this.nextFrame - System.currentTimeMillis()) * 1000000L;
    }

    @Override
    public long getNextFrameTs() {
        return this.nextFrame;
    }

    @Override
    public int compareTo(Delayed o) {
        long aTs = ((Animation)o).getNextFrameTs();
        if (this.nextFrame < aTs) {
            return -1;
        }
        if (this.nextFrame > aTs) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean switchFrame() {
        return false;
    }
}

