/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.animation;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.ui.animation.AbstractAnimation;
import com.jcloisterzone.ui.grid.layer.AnimationLayer;
import java.awt.Color;
import java.awt.Graphics2D;

public class FlierDiceRollAnimation
extends AbstractAnimation {
    private final Position tilePosition;
    private final int roll;

    public FlierDiceRollAnimation(Position tilePosition, int roll) {
        assert (roll >= 1 && roll <= 3);
        this.tilePosition = tilePosition;
        this.roll = roll;
        this.nextFrame = System.currentTimeMillis() + 5000L;
    }

    @Override
    public void paint(AnimationLayer l, Graphics2D g2) {
        int size = l.getTileWidth();
        int s = (int)((double)size * 0.4);
        int padding = (int)((double)size * 0.05);
        int dotSize = (int)((double)size * 0.08);
        int x = l.getOffsetX(this.tilePosition);
        int y = l.getOffsetY(this.tilePosition);
        int boxX = x + size - padding - s;
        int boxY = y + padding;
        g2.setColor(Color.WHITE);
        g2.fillRect(boxX, boxY, s, s);
        g2.setColor(Color.BLACK);
        if (this.roll == 2) {
            int s1_3 = (int)((double)s * 0.33);
            int s2_3 = (int)((double)s * 0.67);
            g2.fillOval(boxX + s1_3 - dotSize / 2, boxY + s2_3 - dotSize / 2, dotSize, dotSize);
            g2.fillOval(boxX + s2_3 - dotSize / 2, boxY + s1_3 - dotSize / 2, dotSize, dotSize);
        } else {
            g2.fillOval(boxX + s / 2 - dotSize / 2, boxY + s / 2 - dotSize / 2, dotSize, dotSize);
            if (this.roll == 3) {
                int s1_4 = (int)((double)s * 0.25);
                int s3_4 = (int)((double)s * 0.75);
                g2.fillOval(boxX + s1_4 - dotSize / 2, boxY + s3_4 - dotSize / 2, dotSize, dotSize);
                g2.fillOval(boxX + s3_4 - dotSize / 2, boxY + s1_4 - dotSize / 2, dotSize, dotSize);
            }
        }
    }
}

