/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.animation;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.ui.animation.AbstractAnimation;
import com.jcloisterzone.ui.grid.layer.AnimationLayer;
import java.awt.Color;
import java.awt.Graphics2D;

public class RecentPlacement
extends AbstractAnimation {
    private static final int FRAME_DURATION = 75;
    private static final int ALPHA_STEP = 8;
    private int alpha = 192;
    private Color color;
    private Position position;

    public RecentPlacement(Position position) {
        this.position = position;
        this.nextFrame = System.currentTimeMillis() + 75L;
        this.color = this.createColor();
    }

    private Color createColor() {
        return new Color(0, 0, 0, this.alpha);
    }

    @Override
    public boolean switchFrame() {
        this.alpha -= 8;
        if (this.alpha <= 0) {
            return false;
        }
        this.color = this.createColor();
        this.nextFrame += 75L;
        return true;
    }

    @Override
    public void paint(AnimationLayer l, Graphics2D g) {
        g.setColor(this.color);
        g.fillRect(l.getOffsetX(this.position), l.getOffsetY(this.position), l.getTileWidth(), l.getTileHeight());
    }
}

