/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.animation;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.animation.AbstractAnimation;
import com.jcloisterzone.ui.grid.layer.AnimationLayer;
import java.awt.Color;
import java.awt.Graphics2D;

public class ScoreAnimation
extends AbstractAnimation {
    private static final Color POINTS_BLACK_BACKGROUND_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.7f);
    private static final Color POINTS_BACKGROUND_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.7f);
    private final Position tilePosition;
    private final String points;
    private final ImmutablePoint offset;
    private final Color color;

    public ScoreAnimation(Position tilePosition, String points, ImmutablePoint point, Color color, Integer duration) {
        this.tilePosition = tilePosition;
        this.points = points;
        this.offset = point;
        this.color = color;
        this.nextFrame = duration == null ? 0x7FFFFFFFFFFL : System.currentTimeMillis() + (long)duration.intValue() * 1000L;
    }

    @Override
    public void paint(AnimationLayer l, Graphics2D g) {
        Color bgColor = UiUtils.isBrightColor(this.color) ? POINTS_BLACK_BACKGROUND_COLOR : POINTS_BACKGROUND_COLOR;
        l.drawAntialiasedTextCentered(g, this.points, 22, this.tilePosition, this.offset, this.color, bgColor);
    }
}

