/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.NeutralFigureAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.action.TilePlacementAction;
import com.jcloisterzone.action.TunnelAction;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.annotations.LinkedGridLayer;
import com.jcloisterzone.ui.component.MultiLineLabel;
import com.jcloisterzone.ui.controls.MouseListeningRegion;
import com.jcloisterzone.ui.controls.MouseTrackingComponent;
import com.jcloisterzone.ui.controls.RegionMouseListener;
import com.jcloisterzone.ui.controls.action.ActionWrapper;
import com.jcloisterzone.ui.controls.action.MeepleActionWrapper;
import com.jcloisterzone.ui.controls.action.NeutralFigureActionWrapper;
import com.jcloisterzone.ui.controls.action.TilePlacementActionWrapper;
import com.jcloisterzone.ui.controls.action.TunnelActionWrapper;
import com.jcloisterzone.ui.grid.ActionLayer;
import com.jcloisterzone.ui.grid.ForwardBackwardListener;
import com.jcloisterzone.ui.view.GameView;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import net.miginfocom.swing.MigLayout;

public class ActionPanel
extends MouseTrackingComponent
implements ForwardBackwardListener,
RegionMouseListener {
    public static final int FAKE_ACTION_SIZE = 62;
    public static final int LINE_HEIGHT = 30;
    public static final int LINE_Y = 46;
    public static final int PADDING = 3;
    public static final int LEFT_MARGIN = 10;
    public static final double ACTIVE_SIZE_RATIO = 1.375;
    private ActionsState actionsState;
    private boolean active;
    private IndexedSeq<ActionWrapper> actions = Vector.empty();
    private int selectedActionIndex = -1;
    private boolean showConfirmRequest;
    private static final String CONFIRMATION_HINT = I18nUtils._tr("Confirm or undo a meeple placement.", new Object[0]);
    private static final String REMOTE_CONFIRMATION_HINT = I18nUtils._tr("Waiting for a confirmation by remote player.", new Object[0]);
    private static final String NO_ACTION_HINT = I18nUtils._tr("No action available. Pass or undo a tile placement.", new Object[0]);
    private MultiLineLabel hintMessage;
    private Image[] selected;
    private Image[] deselected;
    private int imgOffset = 0;
    private boolean refreshImages;
    private boolean refreshMouseRegions;
    private final Client client;
    private final GameView gameView;

    public ActionPanel(GameView gameView) {
        this.client = gameView.getClient();
        this.gameView = gameView;
        Font hintFont = new Font(null, 2, 12);
        this.setLayout(new MigLayout());
        this.hintMessage = new MultiLineLabel();
        this.hintMessage.setFont(hintFont);
        this.hintMessage.setVisible(false);
        this.add((Component)this.hintMessage, "pos 0 50 200 100");
        this.setOpaque(false);
    }

    public IndexedSeq<ActionWrapper> getActions() {
        return this.actions;
    }

    public void onPlayerActionsChanged(ActionsState actionsState) {
        this.actionsState = actionsState;
        Vector<PlayerAction<?>> actions = actionsState.getActions();
        this.active = actionsState.getPlayer().isLocalHuman();
        this.selected = new Image[actions.size()];
        this.deselected = new Image[actions.size()];
        this.refreshImages = true;
        this.refreshMouseRegions = true;
        this.actions = actions.map(a -> {
            if (a instanceof TilePlacementAction) {
                return new TilePlacementActionWrapper((TilePlacementAction)a);
            }
            if (a instanceof MeepleAction) {
                return new MeepleActionWrapper((MeepleAction)a);
            }
            if (a instanceof TunnelAction) {
                return new TunnelActionWrapper((TunnelAction)a);
            }
            if (a instanceof NeutralFigureAction) {
                return new NeutralFigureActionWrapper((NeutralFigureAction)a);
            }
            return new ActionWrapper((PlayerAction<?>)a);
        });
        if (this.active) {
            if (actions.isEmpty()) {
                this.hintMessage.setText(NO_ACTION_HINT);
                this.hintMessage.setVisible(true);
            } else {
                this.setSelectedActionIndex(0);
            }
        }
        this.repaint();
    }

    public void refreshImageCache() {
        this.refreshImages = true;
        this.repaint();
    }

    private void doRefreshImageCache() {
        if (this.actions.isEmpty()) {
            this.selected = null;
            this.deselected = null;
            return;
        }
        int maxIconSize = 40;
        this.imgOffset = 0;
        PlayerAction<?> action = ((ActionWrapper)this.actions.get()).getAction();
        if (action instanceof TilePlacementAction) {
            TilePlacementAction tpa = (TilePlacementAction)action;
            if (AbbeyCapability.isAbbey(tpa.getTile()) || this.actionsState.isPassAllowed()) {
                this.imgOffset = 4;
                maxIconSize = 52;
            } else {
                this.imgOffset = -10;
                maxIconSize = 62;
            }
        } else {
            maxIconSize = 40;
        }
        int availableWidth = this.getWidth() - 10 - (this.actions.size() - 1) * 3;
        double units = (double)this.actions.size() + 0.375;
        int baseSize = Math.min(maxIconSize, (int)Math.floor((double)availableWidth / units));
        int activeSize = (int)((double)baseSize * 1.375);
        Player activePlayer = this.gameView.getGame().getState().getActivePlayer();
        for (int i = 0; i < this.actions.size(); ++i) {
            this.selected[i] = new ImageIcon(((ActionWrapper)this.actions.get(i)).getImage(this.client.getResourceManager(), activePlayer, true).getScaledInstance(activeSize, activeSize, 4)).getImage();
            this.deselected[i] = new ImageIcon(((ActionWrapper)this.actions.get(i)).getImage(this.client.getResourceManager(), activePlayer, false).getScaledInstance(baseSize, baseSize, 4)).getImage();
        }
    }

    public void clearActions() {
        this.deselectAction();
        this.hintMessage.setVisible(false);
        this.actions = Vector.empty();
        this.selectedActionIndex = -1;
        this.refreshImages = true;
        this.refreshMouseRegions = true;
        this.active = false;
        this.actionsState = null;
        this.repaint();
    }

    @Override
    public void forward() {
        if (this.active) {
            ActionWrapper selected = (ActionWrapper)this.getSelectedActionWrapper().getOrNull();
            if (selected instanceof ForwardBackwardListener) {
                ((ForwardBackwardListener)((Object)selected)).forward();
            } else {
                this.rollAction(1);
            }
        }
    }

    @Override
    public void backward() {
        if (this.active && this.selectedActionIndex != -1) {
            ActionWrapper selected = (ActionWrapper)this.getSelectedActionWrapper().getOrNull();
            if (selected instanceof ForwardBackwardListener) {
                ((ForwardBackwardListener)((Object)selected)).backward();
            } else {
                this.rollAction(-1);
            }
        }
    }

    public void rollAction(int change) {
        if (this.active && !this.actions.isEmpty()) {
            int idx = (this.selectedActionIndex + change + this.actions.size()) % this.actions.size();
            this.setSelectedActionIndex(idx);
            this.repaint();
        }
    }

    private void deselectAction() {
        ActionWrapper prev = (ActionWrapper)this.getSelectedActionWrapper().getOrNull();
        if (prev == null) {
            return;
        }
        ActionLayer layer = this.getActionLayer(prev);
        if (layer != null) {
            layer.setActionWrapper(false, null);
            this.gameView.getGridPanel().hideLayer(layer);
        }
    }

    private ActionLayer getActionLayer(ActionWrapper actionWrapper) {
        PlayerAction<?> action = actionWrapper.getAction();
        if (!action.getClass().isAnnotationPresent(LinkedGridLayer.class)) {
            return null;
        }
        Class<? extends ActionLayer> layerType = action.getClass().getAnnotation(LinkedGridLayer.class).value();
        return this.gameView.getGridPanel().findLayer(layerType);
    }

    private void setSelectedActionIndex(int selectedActionIndex) {
        this.deselectAction();
        this.selectedActionIndex = selectedActionIndex;
        ActionWrapper actionWrapper = (ActionWrapper)this.getSelectedActionWrapper().getOrNull();
        if (actionWrapper == null) {
            return;
        }
        ActionLayer layer = this.getActionLayer(actionWrapper);
        if (layer != null) {
            layer.setActionWrapper(this.active, actionWrapper);
            this.gameView.getGridPanel().showLayer(layer);
        }
    }

    public Option<ActionWrapper> getSelectedActionWrapper() {
        if (this.selectedActionIndex == -1) {
            return Option.none();
        }
        return Option.some((ActionWrapper)this.actions.get(this.selectedActionIndex));
    }

    public Option<PlayerAction<?>> getSelectedAction() {
        return this.getSelectedActionWrapper().map(ActionWrapper::getAction);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.showConfirmRequest || this.hintMessage.isVisible()) {
            super.paint(g2);
            return;
        }
        g2.setColor(this.client.getTheme().getPlayerBoxBg());
        g2.fillRoundRect(0, 46, this.getWidth() + 16, 30, 16, 16);
        int x = 10;
        if (!this.actions.isEmpty()) {
            boolean refreshImages = this.refreshImages;
            this.refreshImages = false;
            boolean refreshMouseRegions = this.refreshMouseRegions;
            this.refreshMouseRegions = false;
            if (refreshImages) {
                this.doRefreshImageCache();
            }
            if (refreshMouseRegions) {
                this.getMouseRegions().clear();
            }
            for (int i = 0; i < this.actions.size(); ++i) {
                boolean active = i == this.selectedActionIndex;
                Image img = active ? this.selected[i] : this.deselected[i];
                int size = img.getWidth(null);
                int iy = 46 + (30 - size) / 2;
                if (refreshMouseRegions && this.selectedActionIndex != -1) {
                    this.getMouseRegions().add(new MouseListeningRegion(new Rectangle(x, iy + this.imgOffset, size, size), this, i));
                }
                g2.drawImage(img, x, iy + this.imgOffset, size, size, null);
                x += size + 3;
            }
        }
        super.paint(g2);
    }

    @Override
    public void mouseClicked(MouseEvent e, MouseListeningRegion origin) {
        if (this.showConfirmRequest || this.actions.isEmpty()) {
            return;
        }
        if (e.getButton() == 1) {
            Integer i = (Integer)origin.getData();
            if (this.selectedActionIndex == i) {
                if (this.getSelectedAction() instanceof ForwardBackwardListener) {
                    if ((e.getModifiers() & 0x40) != 0) {
                        ((ForwardBackwardListener)((Object)this.getSelectedAction())).backward();
                    } else {
                        ((ForwardBackwardListener)((Object)this.getSelectedAction())).forward();
                    }
                }
            } else {
                this.setSelectedActionIndex(i);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e, MouseListeningRegion origin) {
        if (this.showConfirmRequest) {
            return;
        }
        Integer i = (Integer)origin.getData();
        if (i != this.selectedActionIndex) {
            this.gameView.getGridPanel().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e, MouseListeningRegion origin) {
        if (this.showConfirmRequest) {
            return;
        }
        this.gameView.getGridPanel().setCursor(Cursor.getDefaultCursor());
    }

    public void setShowConfirmRequest(boolean showConfirmRequest, boolean remote) {
        this.showConfirmRequest = showConfirmRequest;
        if (showConfirmRequest) {
            this.hintMessage.setText(remote ? REMOTE_CONFIRMATION_HINT : CONFIRMATION_HINT);
        }
        this.hintMessage.setVisible(showConfirmRequest);
    }
}

