/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls;

import com.jcloisterzone.ui.controls.MouseListeningRegion;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MouseTrackingComponent
extends JComponent {
    private List<MouseListeningRegion> mouseRegions = new ArrayList<MouseListeningRegion>();
    private MouseListeningRegion mouseOver = null;

    public MouseTrackingComponent() {
        this.initMouseTracking();
    }

    private void initMouseTracking() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (MouseListeningRegion mlr : MouseTrackingComponent.this.mouseRegions) {
                    Rectangle r = mlr.getRegion();
                    if (!r.contains(e.getX(), e.getY())) continue;
                    mlr.getListener().mouseClicked(e, mlr);
                    e.consume();
                    break;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseTrackingComponent.this.mouseOver == null) {
                    for (MouseListeningRegion mlr : MouseTrackingComponent.this.mouseRegions) {
                        Rectangle r = mlr.getRegion();
                        if (!r.contains(e.getX(), e.getY())) continue;
                        MouseTrackingComponent.this.mouseOver = mlr;
                        MouseTrackingComponent.this.mouseOver.getListener().mouseEntered(e, MouseTrackingComponent.this.mouseOver);
                        e.consume();
                        break;
                    }
                } else {
                    Rectangle r = MouseTrackingComponent.this.mouseOver.getRegion();
                    if (r.contains(e.getX(), e.getY())) {
                        e.consume();
                        return;
                    }
                    MouseTrackingComponent.this.mouseOver.getListener().mouseExited(e, MouseTrackingComponent.this.mouseOver);
                    MouseTrackingComponent.this.mouseOver = null;
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    protected List<MouseListeningRegion> getMouseRegions() {
        return this.mouseRegions;
    }
}

