/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls;

import com.jcloisterzone.Player;
import com.jcloisterzone.PlayerClock;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Mayor;
import com.jcloisterzone.figure.Phantom;
import com.jcloisterzone.figure.Pig;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.game.capability.KingAndRobberBaronCapability;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.capability.TradeGoodsCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlayersState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.controls.MouseListeningRegion;
import com.jcloisterzone.ui.controls.MouseTrackingComponent;
import com.jcloisterzone.ui.controls.PlayerPanelImageCache;
import com.jcloisterzone.ui.controls.RegionMouseListener;
import com.jcloisterzone.ui.view.GameView;
import com.jcloisterzone.wsio.message.PayRansomMessage;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class PlayerPanel
extends MouseTrackingComponent
implements RegionMouseListener {
    private static final Color KING_ROBBER_OVERLAY = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private static final Color POTENTIAL_POINTS_COLOR = new Color(160, 160, 160);
    private static Font FONT_POINTS = new Font("Georgia", 1, 30);
    private static Font FONT_MEEPLE = new Font("Georgia", 1, 18);
    private static Font FONT_KING_ROBBER_OVERLAY = new Font("Georgia", 1, 22);
    private static Font FONT_NICKNAME = new Font(null, 1, 18);
    private static Font FONT_OFFLINE = new Font(null, 1, 20);
    private static final int PADDING_L = 9;
    private static final int PADDING_R = 11;
    private static final int LINE_HEIGHT = 32;
    private static final int DELIMITER_Y = 34;
    private final Client client;
    private final GameView gameView;
    private final GameController gc;
    private final Player player;
    private Color fontColor;
    private int potentialPoints = 0;
    private final PlayerPanelImageCache cache;
    private int PANEL_WIDTH = 1;
    private BufferedImage bimg;
    private Graphics2D g2;
    private int realHeight = 1;
    private int bx;
    private int by;
    private String mouseOverKey = null;
    private Integer timeLimit;

    public PlayerPanel(Client client, GameView gameView, Player player, PlayerPanelImageCache cache) {
        this.client = client;
        this.player = player;
        this.gameView = gameView;
        this.gc = gameView.getGameController();
        this.cache = cache;
        this.fontColor = player.getColors().getFontColor();
        Game game = this.gc.getGame();
        this.timeLimit = (Integer)game.getState().getRules().get(Rule.CLOCK_PLAYER_TIME).getOrNull();
    }

    private void drawDelimiter(int y) {
        this.g2.setColor(this.client.getTheme().getDelimiterTopColor());
        this.g2.drawLine(9, y, this.PANEL_WIDTH, y);
        this.g2.setColor(this.client.getTheme().getDelimiterBottomColor());
        this.g2.drawLine(9, y + 1, this.PANEL_WIDTH, y + 1);
    }

    private void drawTextShadow(String text, int x, int y) {
        this.drawTextShadow(text, x, y, this.fontColor);
    }

    private void drawTextShadow(String text, int x, int y, Color color) {
        Color shadowColor = this.client.getTheme().getFontShadowColor();
        if (shadowColor != null) {
            this.g2.setColor(shadowColor);
            this.g2.drawString(text, x + 1, y + 1);
        }
        this.g2.setColor(color);
        this.g2.drawString(text, x, y);
    }

    public Player getPlayer() {
        return this.player;
    }

    private Rectangle drawMeepleBox(Player playerKey, String imgKey, int count, boolean showOne) {
        return this.drawMeepleBox(playerKey, imgKey, count, showOne, null, false);
    }

    private Rectangle drawMeepleBox(Player playerKey, String imgKey, int count, boolean showOne, Object regionData) {
        return this.drawMeepleBox(playerKey, imgKey, count, showOne, regionData, false);
    }

    private Rectangle drawMeepleBox(Player playerKey, String imgKey, int count, boolean showOne, Object regionData, boolean active) {
        if (count == 0) {
            return null;
        }
        int w = 30;
        if (count > 1 || count == 1 && showOne) {
            w = count < 10 ? 47 : 60;
        }
        int h = 22;
        if (this.bx + w > this.PANEL_WIDTH - 11 - 9) {
            this.bx = 9;
            this.by += 32;
        }
        this.g2.setColor(active ? Color.BLACK : Color.WHITE);
        this.g2.fillRoundRect(this.bx, this.by, w, h, 8, 8);
        this.g2.drawImage(this.cache.get(playerKey, imgKey), this.bx, this.by - 4, null);
        Rectangle rect = null;
        if (regionData != null) {
            rect = new Rectangle(this.bx, this.by - 4, w, h + 8);
            this.getMouseRegions().add(new MouseListeningRegion(rect, this, regionData));
        }
        if (count > 1 || count == 1 && showOne) {
            this.g2.setColor(active ? Color.WHITE : Color.BLACK);
            this.g2.drawString("" + count, this.bx + 32, this.by + 17);
        }
        this.bx += w + 8;
        return rect;
    }

    private void drawTimeTextBox(String text, Color textColor) {
        int w = 64;
        int h = 22;
        if (this.bx + w > this.PANEL_WIDTH - 11 - 9) {
            this.bx = 9;
            this.by += 32;
        }
        this.g2.setColor(Color.WHITE);
        this.g2.fillRoundRect(this.bx, this.by, w, h, 8, 8);
        this.g2.setColor(textColor);
        this.g2.drawString(text, this.bx + 4, this.by + 17);
        this.bx += w + 8;
    }

    public boolean repaintContent(int width) {
        int size;
        KingAndRobberBaronCapability cap;
        Game game = this.gc.getGame();
        this.PANEL_WIDTH = width;
        this.bimg = UiUtils.newTransparentImage(this.PANEL_WIDTH, 200);
        this.g2 = this.bimg.createGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(this.client.getTheme().getPlayerBoxBg());
        this.g2.fillRect(8, 8, this.PANEL_WIDTH, 36);
        this.getMouseRegions().clear();
        this.drawDelimiter(34);
        this.g2.setFont(FONT_POINTS);
        this.drawTextShadow("" + this.player.getPoints(game.getState()), 9, 27);
        if (!game.isOver() && this.gc.getGameView().getControlPanel().isShowPotentialPoints()) {
            this.drawTextShadow("/ " + this.potentialPoints, 78, 27, POTENTIAL_POINTS_COLOR);
        } else if (this.player.getSlot().isDisconnected()) {
            this.g2.setFont(FONT_OFFLINE);
            this.g2.setColor(POTENTIAL_POINTS_COLOR);
            this.g2.drawString("OFFLINE " + this.player.getNick(), 65, 27);
        } else {
            this.g2.setFont(FONT_NICKNAME);
            this.drawTextShadow(this.player.getNick(), 78, 27);
        }
        this.g2.setFont(FONT_MEEPLE);
        this.bx = 9;
        this.by = 43;
        GameState state = game.getState();
        PlayersState ps = state.getPlayers();
        int index = this.player.getIndex();
        if (this.timeLimit != null) {
            PlayerClock clock = game.getClocks().get(this.player.getIndex());
            long remainingMs = (long)(this.timeLimit * 1000) - clock.getTime(System.currentTimeMillis() - game.getClockStart());
            if (remainingMs <= 0L) {
                this.drawTimeTextBox("00.00", Color.RED);
            } else {
                long remaining = remainingMs / 1000L;
                this.drawTimeTextBox(String.format("%02d.%02d", remaining / 60L, remaining % 60L), Color.DARK_GRAY);
            }
        }
        this.player.getFollowers(state).filter(f -> f.isInSupply(state)).groupBy(Object::getClass).toArray().sortBy(t -> {
            if (((Class)t._1).equals(SmallFollower.class)) {
                return 1;
            }
            if (((Class)t._1).equals(Phantom.class)) {
                return 2;
            }
            if (((Class)t._1).equals(BigFollower.class)) {
                return 3;
            }
            if (((Class)t._1).equals(Mayor.class)) {
                return 4;
            }
            if (((Class)t._1).equals(Wagon.class)) {
                return 4;
            }
            return 99;
        }).forEach(t -> this.drawMeepleBox(this.player, ((Class)t._1).getSimpleName(), ((Seq)t._2).length(), ((Class)t._1).equals(SmallFollower.class)));
        this.player.getSpecialMeeples(state).filter(f -> f.isInSupply(state)).groupBy(Object::getClass).toArray().sortBy(t -> {
            if (((Class)t._1).equals(Builder.class)) {
                return 1;
            }
            if (((Class)t._1).equals(Shepherd.class)) {
                return 2;
            }
            if (((Class)t._1).equals(Pig.class)) {
                return 3;
            }
            if (((Class)t._1).equals(Barn.class)) {
                return 4;
            }
            return 99;
        }).forEach(t -> this.drawMeepleBox(this.player, ((Class)t._1).getSimpleName(), ((Seq)t._2).length(), false));
        this.drawMeepleBox(null, "abbey", ps.getPlayerTokenCount(index, AbbeyCapability.AbbeyToken.ABBEY_TILE), false);
        this.drawMeepleBox(null, "tower_piece", ps.getPlayerTokenCount(index, TowerCapability.TowerToken.TOWER_PIECE), true);
        this.drawMeepleBox(null, "bridge", ps.getPlayerTokenCount(index, BridgeCapability.BrigeToken.BRIDGE), true);
        this.drawMeepleBox(null, "castle", ps.getPlayerTokenCount(index, CastleCapability.CastleToken.CASTLE), true);
        this.drawMeepleBox(this.player, "tunnel.A", ps.getPlayerTokenCount(index, TunnelCapability.Tunnel.TUNNEL_A), true);
        this.drawMeepleBox(this.player, "tunnel.B", ps.getPlayerTokenCount(index, TunnelCapability.Tunnel.TUNNEL_B), true);
        this.drawMeepleBox(this.player, "tunnel.C", ps.getPlayerTokenCount(index, TunnelCapability.Tunnel.TUNNEL_C), true);
        this.drawMeepleBox(null, "lb_shed", ps.getPlayerTokenCount(index, LittleBuildingsCapability.LittleBuilding.LB_SHED), true);
        this.drawMeepleBox(null, "lb_house", ps.getPlayerTokenCount(index, LittleBuildingsCapability.LittleBuilding.LB_HOUSE), true);
        this.drawMeepleBox(null, "lb_tower", ps.getPlayerTokenCount(index, LittleBuildingsCapability.LittleBuilding.LB_TOWER), true);
        if (ps.getPlayerTokenCount(index, KingAndRobberBaronCapability.BiggestFeatureAward.KING) > 0) {
            cap = state.getCapabilities().get(KingAndRobberBaronCapability.class);
            Rectangle r = this.drawMeepleBox(null, "king", 1, false, "king");
            if ("king".equals(this.mouseOverKey)) {
                this.g2.setFont(FONT_KING_ROBBER_OVERLAY);
                this.g2.setColor(KING_ROBBER_OVERLAY);
                this.g2.fillRect(r.x, r.y, r.width, r.height);
                this.g2.setColor(Color.WHITE);
                size = cap.getBiggestCitySize(state);
                this.g2.drawString((size < 10 ? " " : "") + size, r.x + 2, r.y + 20);
                this.g2.setFont(FONT_MEEPLE);
            }
        }
        if (ps.getPlayerTokenCount(index, KingAndRobberBaronCapability.BiggestFeatureAward.ROBBER) > 0) {
            cap = state.getCapabilities().get(KingAndRobberBaronCapability.class);
            Rectangle r = this.drawMeepleBox(null, "robber", 1, false, "robber");
            if ("robber".equals(this.mouseOverKey)) {
                this.g2.setFont(FONT_KING_ROBBER_OVERLAY);
                this.g2.setColor(KING_ROBBER_OVERLAY);
                this.g2.fillRect(r.x, r.y, r.width, r.height);
                this.g2.setColor(Color.WHITE);
                size = cap.getLongestRoadSize(state);
                this.g2.drawString((size < 10 ? " " : "") + size, r.x + 2, r.y + 20);
                this.g2.setFont(FONT_MEEPLE);
            }
        }
        this.drawMeepleBox(null, "cloth", ps.getPlayerTokenCount(index, TradeGoodsCapability.TradeGoods.CLOTH), true);
        this.drawMeepleBox(null, "grain", ps.getPlayerTokenCount(index, TradeGoodsCapability.TradeGoods.GRAIN), true);
        this.drawMeepleBox(null, "wine", ps.getPlayerTokenCount(index, TradeGoodsCapability.TradeGoods.WINE), true);
        this.drawMeepleBox(null, "gold", ps.getPlayerTokenCount(index, GoldminesCapability.GoldToken.GOLD), true);
        Array towerModel = (Array)state.getCapabilityModel(TowerCapability.class);
        if (towerModel != null) {
            ((List)towerModel.get(this.player.getIndex())).groupBy(m -> m.getPlayer()).forEach((opponent, prisoners) -> {
                boolean isOpponentActive = opponent.equals(state.getActivePlayer()) && opponent.isLocalHuman();
                boolean clickable = isOpponentActive && !state.hasFlag(Flag.RANSOM_PAID);
                prisoners.groupBy(f -> f.getClass()).forEach((cls, items) -> this.drawMeepleBox((Player)opponent, cls.getSimpleName(), items.length(), false, clickable ? ((Follower)items.get()).getId() : null, clickable));
            });
        }
        int oldValue = this.realHeight;
        this.realHeight = this.by + (this.bx > 9 ? 32 : 0);
        this.g2.dispose();
        this.g2 = null;
        return this.realHeight != oldValue;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.PANEL_WIDTH, this.realHeight);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D parentGraphics = (Graphics2D)g;
        parentGraphics.setColor(this.client.getTheme().getPlayerBoxBg());
        parentGraphics.fillRoundRect(0, 0, this.PANEL_WIDTH + 16, this.realHeight, 16, 16);
        parentGraphics.drawImage(this.bimg, 0, 0, this.PANEL_WIDTH, this.realHeight, 0, 0, this.PANEL_WIDTH, this.realHeight, null);
        super.paintComponent(g);
    }

    public int getRealHeight() {
        return this.realHeight;
    }

    public int getPotentialPoints() {
        return this.potentialPoints;
    }

    public void setPotentialPoints(int potentialPoints) {
        this.potentialPoints = potentialPoints;
    }

    public void addPotentialPoints(int potentialPoints) {
        this.potentialPoints += potentialPoints;
    }

    @Override
    public void mouseClicked(MouseEvent e, MouseListeningRegion origin) {
        String meepleId = (String)origin.getData();
        if (meepleId != null && !"king".equals(meepleId) && !"robber".equals(meepleId)) {
            this.gc.getConnection().send(new PayRansomMessage(meepleId));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e, MouseListeningRegion origin) {
        if (origin.getData() instanceof String) {
            this.mouseOverKey = (String)origin.getData();
            this.gameView.getGridPanel().repaint();
        } else {
            this.gameView.getGridPanel().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e, MouseListeningRegion origin) {
        if (this.mouseOverKey != null) {
            this.mouseOverKey = null;
            this.gameView.getGridPanel().repaint();
        } else {
            this.gameView.getGridPanel().setCursor(Cursor.getDefaultCursor());
        }
    }
}

