/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.controls.chat;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.event.ChatEvent;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.component.TextPrompt;
import com.jcloisterzone.wsio.message.PostChatMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChatPanel
extends JPanel
implements WindowStateListener,
UIEventListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DISPLAY_MESSAGES_INTERVAL = 9000;
    protected final Client client;
    private boolean hidingMode;
    private boolean forceFocus;
    private boolean messageReceivedWhileIconified;
    private JTextField input;
    private JTextPane messagesPane;
    private final Deque<ReceivedChatMessage> formattedMessages = new ArrayDeque<ReceivedChatMessage>();
    private Timer repaintTimer;

    public ChatPanel(final Client client) {
        this.client = client;
        this.input = new JTextField();
        this.input.setFocusable(false);
        this.input.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatPanel.this.activateChat();
            }
        });
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ChatPanel.this.clean();
                }
            }
        });
        this.input.addActionListener(new ActionListener(){
            final /* synthetic */ ChatPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = this.this$0.input.getText();
                if (!"".equals(msg)) {
                    this.this$0.forceFocus = true;
                    client.getConnection().send(this.this$0.createPostChatMessage(msg));
                }
                this.this$0.clean();
            }
        });
        this.input.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ChatPanel.this.updateMessaagesVisibility();
            }

            @Override
            public void focusGained(FocusEvent e) {
                ChatPanel.this.updateMessaagesVisibility();
            }
        });
        this.input.setOpaque(false);
        this.input.setBackground(client.getTheme().getTransparentInputBg());
        Color textColor = client.getTheme().getTextColor();
        if (textColor != null) {
            this.input.setForeground(client.getTheme().getTextColor());
            this.input.setCaretColor(client.getTheme().getTextColor());
        }
        TextPrompt tp = new TextPrompt(I18nUtils._tr("Type to chat", new Object[0]), this.input);
        tp.setShow(TextPrompt.Show.FOCUS_LOST);
        tp.changeStyle(2);
        tp.changeAlpha(0.4f);
        this.messagesPane = new JTextPane();
        this.messagesPane.setEditorKit(new WrapEditorKit());
        this.messagesPane.setFocusable(false);
        this.messagesPane.setOpaque(false);
        this.setBackground(client.getTheme().getTransparentPanelBg());
        this.setLayout(new MigLayout(""));
        this.add((Component)this.messagesPane, "pos 10 n (100%-10) (100%-35)");
        this.add((Component)this.input, "pos 10 (100%-35) (100%-10) (100%-10)");
    }

    public void initHidingMode() {
        this.hidingMode = true;
        this.repaintTimer = new Timer(9000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPanel.this.forceFocus = false;
                ChatPanel.this.repaintTimer.stop();
                ChatPanel.this.updateMessaagesVisibility();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ChatPanel.this.repaintTimer.stop();
            }
        });
        if (this.forceFocus) {
            this.repaintTimer.start();
        }
        this.setBackground(new Color(0, 0, 0, 0));
        this.input.setBackground(this.client.getTheme().getInputBg());
        this.updateMessaagesVisibility();
    }

    private void updateMessaagesVisibility() {
        this.messagesPane.setVisible(!this.hidingMode || !this.isFolded());
        if (this.getParent() == null) {
            this.repaint();
        } else {
            this.getParent().repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.client.getTheme().getTransparentPanelBg());
        if (this.messagesPane.isVisible()) {
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            g2.fillRect(0, this.getHeight() - 40, this.getWidth(), 40);
        }
        super.paint(g);
    }

    protected abstract ReceivedChatMessage createReceivedMessage(ChatEvent var1);

    protected abstract PostChatMessage createPostChatMessage(String var1);

    public void activateChat() {
        this.input.setFocusable(true);
        this.input.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatPanel.this.input.requestFocusInWindow();
            }
        });
    }

    private void clean() {
        this.input.setText("");
        this.input.setFocusable(false);
        this.client.requestFocusInWindow();
        this.client.getContentPane().repaint();
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        if (e.getOldState() == 1 && this.messageReceivedWhileIconified) {
            this.setForceFocus();
            this.messageReceivedWhileIconified = false;
        }
    }

    private boolean isFolded() {
        return !this.forceFocus && !this.input.hasFocus();
    }

    public JTextField getInput() {
        return this.input;
    }

    public JTextPane getMessagesPane() {
        return this.messagesPane;
    }

    private void setForceFocus() {
        if (this.repaintTimer == null) {
            return;
        }
        if (this.repaintTimer.isRunning()) {
            this.repaintTimer.restart();
        } else {
            this.forceFocus = true;
            this.updateMessaagesVisibility();
            this.repaintTimer.start();
        }
    }

    @Subscribe
    public void displayChatMessage(ChatEvent ev) {
        ReceivedChatMessage fm = this.createReceivedMessage(ev);
        this.formattedMessages.addLast(fm);
        if (this.client.getState() == 1) {
            this.messageReceivedWhileIconified = true;
        } else {
            this.setForceFocus();
        }
        DefaultStyledDocument doc = new DefaultStyledDocument();
        int offset = 0;
        try {
            for (ReceivedChatMessage msg : this.formattedMessages) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.ColorConstants.setForeground(attrs, msg.color);
                String nick = msg.nickname;
                String text = msg.ev.getText();
                doc.insertString(offset, nick + ": ", attrs);
                offset += nick.length() + 2;
                Color textColor = this.client.getTheme().getTextColor();
                if (textColor == null) {
                    attrs = null;
                } else {
                    attrs = new SimpleAttributeSet();
                    StyleConstants.ColorConstants.setForeground(attrs, this.client.getTheme().getTextColor());
                }
                doc.insertString(offset, text + "\n", attrs);
                offset += text.length() + 1;
            }
        }
        catch (BadLocationException e) {
            this.logger.error(e.getMessage(), e);
        }
        this.messagesPane.setDocument(doc);
        this.repaint();
    }

    static class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory = new WrapColumnFactory();

        WrapEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    static class ReceivedChatMessage {
        final ChatEvent ev;
        final String nickname;
        final Color color;
        final long time;

        public ReceivedChatMessage(ChatEvent ev, String nickname, Color color) {
            this.ev = ev;
            this.color = color;
            this.nickname = nickname;
            this.time = System.currentTimeMillis();
        }
    }

    static class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    static class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

