/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.dialog;

import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import io.vavr.collection.List;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class DiscardedTilesDialog
extends JDialog {
    public static final int ICON_SIZE = 120;
    private final Client client;
    private JPanel panel;
    private JScrollPane scroll;

    public DiscardedTilesDialog(Client client) {
        super(client);
        this.client = client;
        this.setTitle(I18nUtils._tr("Discarded tiles", new Object[0]));
        Point p = client.getLocation();
        this.setLocation(p.x + 200, p.y + 150);
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.setBackground(client.getTheme().getPanelBg());
        pane.setLayout(new MigLayout("", "[grow]", "[][]"));
        pane.add((Component)new ThemedJLabel(I18nUtils._tr("These tiles have been discarded during the game", new Object[0])), "wrap, growx, gapbottom 10");
        this.panel = new ThemedJPanel();
        this.scroll = new JScrollPane(this.panel);
        pane.add((Component)this.scroll, "wrap, grow, width 400::, height 150::");
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.panel.setLayout(new MigLayout("", "[]", ""));
        this.pack();
    }

    public void setDiscardedTiles(List<Tile> tiles) {
        int skip = this.panel.getComponentCount();
        for (Tile tile : tiles) {
            if (skip > 0) {
                --skip;
                continue;
            }
            Image icon = this.client.getResourceManager().getTileImage(tile.getId(), Rotation.R0).getImage().getScaledInstance(120, 120, 2);
            this.panel.add((Component)new JLabel(new ImageIcon(icon)), "");
            this.scroll.getViewport().setViewPosition(new Point(this.panel.getWidth(), 0));
        }
    }
}

