/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.dialog;

import com.google.common.base.Objects;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.component.MultiLineLabel;
import com.jcloisterzone.ui.component.StrechIconPanel;
import com.jcloisterzone.ui.gtk.ThemedJCheckBox;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJList;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesDialog
extends JDialog {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Font HINT_FONT = new Font(null, 2, 10);
    private static final Font PLUGIN_DESCRIPTION_FONT = new Font(null, 2, 11);
    private static final Font PLUGIN_TITLE_FONT = new Font(null, 1, 12);
    private final Client client;
    private final Config config;
    private String initialLocale;
    private String initialTheme;
    private JComponent[] tabs;
    private JComponent visibleTab;
    private JLabel languageHint;
    private JLabel themeHint;
    private JComboBox<StringOption> langComboBox;
    private JComboBox<StringOption> themeComboBox;
    private JComboBox<EnumOption<Config.TileRotationControls>> mousePlacementComboBox;
    private JTextField aiPlaceTileDelay;
    private JTextField scoreDisplayDuration;
    private List<PluginModel> pluginRows = new ArrayList<PluginModel>();

    private void initLocaleOptions(JComboBox<StringOption> comboBox) {
        ArrayList<StringOption> result = new ArrayList<StringOption>();
        result.add(new StringOption(null, I18nUtils._tr("Use system language", new Object[0])));
        result.add(new StringOption("ca", "catal\u00e0 (ca)"));
        result.add(new StringOption("cs", "\u010de\u0161tina (cs)"));
        result.add(new StringOption("de", "deutch (de)"));
        result.add(new StringOption("el", "\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac (el)"));
        result.add(new StringOption("en", "english (en)"));
        result.add(new StringOption("es", "espa\u00f1ol (es)"));
        result.add(new StringOption("fr", "fran\u00e7ais (fr)"));
        result.add(new StringOption("hu", "magyar (hu)"));
        result.add(new StringOption("it", "italiano (it)"));
        result.add(new StringOption("ja", "\u65e5\u672c\u8a9e (ja)"));
        result.add(new StringOption("nl", "nederlands (nl)"));
        result.add(new StringOption("pl", "polski (pl)"));
        result.add(new StringOption("ro", "rom\u00e2n (ro)"));
        result.add(new StringOption("ru", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439 (ru)"));
        result.add(new StringOption("sk", "sloven\u010dina (sk)"));
        result.add(new StringOption("zh", "\u4e2d\u6587 (zh)"));
        boolean match = false;
        for (StringOption opt : result) {
            comboBox.addItem(opt);
            if (!Objects.equal(opt.getKey(), this.config.getLocale())) continue;
            comboBox.setSelectedItem(opt);
            match = true;
        }
        if (!match) {
            StringOption unknown = new StringOption(this.config.getLocale(), this.config.getLocale());
            comboBox.addItem(unknown);
            comboBox.setSelectedItem(unknown);
        }
        this.initialLocale = this.config.getLocale();
    }

    private void initThemeOptions(JComboBox<StringOption> comboBox) {
        ArrayList<StringOption> result = new ArrayList<StringOption>();
        result.add(new StringOption("light", "Light"));
        result.add(new StringOption("dark", "Dark"));
        boolean match = false;
        for (StringOption opt : result) {
            comboBox.addItem(opt);
            if (!Objects.equal(opt.getKey(), this.config.getTheme())) continue;
            comboBox.setSelectedItem(opt);
            match = true;
        }
        if (!match) {
            comboBox.setSelectedItem(result.get(0));
        }
        this.initialTheme = this.config.getTheme();
    }

    private void initRotateBasedOnMousePositionOptions(JComboBox<EnumOption<Config.TileRotationControls>> comboBox) {
        ArrayList<EnumOption<Config.TileRotationControls>> result = new ArrayList<EnumOption<Config.TileRotationControls>>();
        result.add(new EnumOption<Config.TileRotationControls>(Config.TileRotationControls.TAB_RCLICK, I18nUtils._tr("TAB / right click", new Object[0])));
        result.add(new EnumOption<Config.TileRotationControls>(Config.TileRotationControls.TAB_RCLICK_MOUSEMOVE, I18nUtils._tr("+ mouse over spot", new Object[0]) + " " + I18nUtils._tr("(experimental)", new Object[0])));
        for (EnumOption enumOption : result) {
            comboBox.addItem(enumOption);
            if (enumOption.getKey() != this.config.getTile_rotation()) continue;
            comboBox.setSelectedItem(enumOption);
        }
    }

    private String valueOf(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private Integer intValue(String value) {
        if ("".equals(value = value.trim())) {
            return null;
        }
        return Integer.parseInt(value);
    }

    private void save() {
        StringOption opt = (StringOption)this.langComboBox.getSelectedItem();
        this.config.setLocale(opt.getKey());
        opt = (StringOption)this.themeComboBox.getSelectedItem();
        this.config.setTheme(opt.getKey());
        EnumOption mousePlacementOption = (EnumOption)this.mousePlacementComboBox.getSelectedItem();
        this.config.setTile_rotation((Config.TileRotationControls)mousePlacementOption.key);
        this.config.getAi().setPlace_tile_delay(this.intValue(this.aiPlaceTileDelay.getText()));
        this.config.setScore_display_duration(this.intValue(this.scoreDisplayDuration.getText()));
        ArrayList<String> enabledPlugins = new ArrayList<String>();
        for (PluginModel row : this.pluginRows) {
            Plugin plugin = row.plugin;
            if (row.isEnabled()) {
                try {
                    plugin.load();
                    plugin.setEnabled(true);
                    enabledPlugins.add(plugin.getRelativePath().toString());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
                continue;
            }
            plugin.unload();
            plugin.setEnabled(false);
        }
        this.config.getPlugins().setEnabled_plugins(enabledPlugins);
        this.client.saveConfig();
    }

    private JPanel createInerfaceTab() {
        ThemedJPanel panel = new ThemedJPanel(new MigLayout("", "[]10px[]", ""));
        panel.add((Component)new ThemedJLabel(I18nUtils._tr("Language", new Object[0])), "alignx trailing");
        this.langComboBox = new JComboBox();
        this.langComboBox.setEditable(false);
        this.initLocaleOptions(this.langComboBox);
        this.langComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                StringOption opt = (StringOption)comboBox.getSelectedItem();
                PreferencesDialog.this.languageHint.setVisible(!Objects.equal(opt.getKey(), PreferencesDialog.this.initialLocale));
            }
        });
        panel.add(this.langComboBox, "wrap, growx");
        this.languageHint = new ThemedJLabel(I18nUtils._tr("To apply new language you must restart the application", new Object[0]));
        this.languageHint.setVisible(false);
        this.languageHint.setFont(HINT_FONT);
        this.languageHint.setForeground(this.client.getTheme().getHintColor());
        panel.add((Component)this.languageHint, "sx 2, wrap");
        panel.add((Component)new ThemedJLabel(I18nUtils._tr("Theme", new Object[0])), "alignx trailing");
        this.themeComboBox = new JComboBox();
        this.themeComboBox.setEditable(false);
        this.initThemeOptions(this.themeComboBox);
        this.themeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                StringOption opt = (StringOption)comboBox.getSelectedItem();
                PreferencesDialog.this.themeHint.setVisible(!Objects.equal(opt.getKey(), PreferencesDialog.this.initialTheme));
            }
        });
        panel.add(this.themeComboBox, "wrap, growx");
        this.themeHint = new ThemedJLabel(I18nUtils._tr("To apply new theme you must restart the application", new Object[0]));
        this.themeHint.setVisible(false);
        this.themeHint.setFont(HINT_FONT);
        this.themeHint.setForeground(this.client.getTheme().getHintColor());
        panel.add((Component)this.themeHint, "sx 2, wrap");
        panel.add((Component)new ThemedJLabel(I18nUtils._tr("Tile rotation", new Object[0])), "alignx trailing");
        this.mousePlacementComboBox = new JComboBox();
        this.initRotateBasedOnMousePositionOptions(this.mousePlacementComboBox);
        panel.add(this.mousePlacementComboBox, "wrap, growx");
        panel.add((Component)new ThemedJLabel(I18nUtils._tr("AI placement delay (ms)", new Object[0])), "gaptop 10, alignx trailing");
        this.aiPlaceTileDelay = new JTextField();
        this.aiPlaceTileDelay.setText(this.valueOf(this.config.getAi().getPlace_tile_delay()));
        panel.add((Component)this.aiPlaceTileDelay, "wrap, growx");
        panel.add((Component)new ThemedJLabel(I18nUtils._tr("Score display duration (sec)", new Object[0])), "alignx trailing");
        this.scoreDisplayDuration = new JTextField();
        this.scoreDisplayDuration.setText(this.valueOf(this.config.getScore_display_duration()));
        panel.add((Component)this.scoreDisplayDuration, "wrap, growx");
        return panel;
    }

    private JComponent createPluginsTab() {
        ThemedJPanel panel = new ThemedJPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ArrayList<Plugin> arr = new ArrayList<Plugin>(this.client.getPlugins());
        ListIterator<Plugin> li = arr.listIterator(arr.size());
        while (li.hasPrevious()) {
            PluginModel row = new PluginModel(li.previous());
            this.pluginRows.add(row);
            panel.add(new PluginPanel(row));
        }
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        return scrollPane;
    }

    public PreferencesDialog(Client client) {
        super(client);
        this.client = client;
        this.config = client.getConfig();
        this.setTitle(I18nUtils._tr("Preferences", new Object[0]));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        UiUtils.centerDialog(this, 650, Math.min(client.getHeight(), 600));
        this.getContentPane().setLayout(new MigLayout("ins 0", "[][grow]", "[grow][]"));
        this.getContentPane().setBackground(client.getTheme().getPanelBg());
        this.tabs = new JComponent[]{this.createInerfaceTab(), this.createPluginsTab()};
        this.visibleTab = this.tabs[0];
        ThemedJList<String> tabList = new ThemedJList<String>((T[])new String[]{I18nUtils._tr("Interface", new Object[0]), I18nUtils._tr("Plugins", new Object[0])});
        tabList.setSelectionMode(0);
        tabList.setLayoutOrientation(0);
        tabList.setSelectedIndex(0);
        tabList.setBorder(new EmptyBorder(4, 4, 4, 4));
        tabList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList tabList = (JList)e.getSource();
                int idx = tabList.getSelectedIndex();
                PreferencesDialog.this.getContentPane().remove(PreferencesDialog.this.visibleTab);
                PreferencesDialog.this.visibleTab = PreferencesDialog.this.tabs[idx];
                PreferencesDialog.this.getContentPane().add((Component)PreferencesDialog.this.visibleTab, "cell 1 0, aligny top, grow");
                PreferencesDialog.this.revalidate();
                PreferencesDialog.this.repaint();
            }
        });
        this.getContentPane().add(tabList, "cell 0 0, growy, w 160!");
        this.getContentPane().add((Component)this.visibleTab, "cell 1 0, aligny top, grow");
        ThemedJPanel buttonBox = new ThemedJPanel(new MigLayout("fill", "[grow][][]", "[]"));
        JButton cancel = new JButton(I18nUtils._tr("Cancel", new Object[0]));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.dispose();
            }
        });
        buttonBox.add((Component)cancel, "skip 1");
        JButton ok = new JButton(I18nUtils._tr("Save", new Object[0]));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.save();
                PreferencesDialog.this.dispose();
            }
        });
        buttonBox.add((Component)ok, "");
        this.getContentPane().add((Component)buttonBox, "cell 0 1,gaptop 5, spanx 2, growx");
        this.setVisible(true);
    }

    private static class StringOption {
        private final String key;
        private final String title;

        public StringOption(String key, String title) {
            this.key = key;
            this.title = title;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.title;
        }
    }

    private static class EnumOption<T extends Enum> {
        private final String title;
        private final T key;

        public EnumOption(T key, String title) {
            this.key = key;
            this.title = title;
        }

        public T getKey() {
            return this.key;
        }

        public String toString() {
            return this.title;
        }
    }

    private class PluginModel {
        private final Plugin plugin;
        private boolean enabled;
        private Image icon;

        public PluginModel(Plugin plugin) {
            this.plugin = plugin;
            this.enabled = plugin.isEnabled();
            this.icon = plugin.getIcon();
        }

        public Image getIcon() {
            return this.icon;
        }

        public String getTitle() {
            return this.plugin.getTitle();
        }

        public String getDescription() {
            return this.plugin.getDescription();
        }

        public boolean isReadOnly() {
            return this.plugin.isDefault();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class PluginPanel
    extends ThemedJPanel {
        private final PluginModel model;
        private JCheckBox chbox;

        public PluginPanel(PluginModel model) {
            super(new MigLayout("fillx", "[][][grow]"));
            this.model = model;
            this.add((Component)new StrechIconPanel(model.getIcon()), "w 120!, h 120!, sy 2, gapright 10");
            this.chbox = new ThemedJCheckBox();
            this.chbox.setSelected(model.isEnabled());
            if (model.isReadOnly()) {
                this.chbox.setEnabled(false);
            } else {
                this.chbox.addActionListener(new ActionListener(){
                    final /* synthetic */ PluginPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.this$1.model.setEnabled(this.this$1.chbox.isSelected());
                    }
                });
            }
            this.add((Component)this.chbox, "");
            ThemedJLabel label = new ThemedJLabel(model.getTitle());
            label.setHorizontalAlignment(2);
            label.setFont(PLUGIN_TITLE_FONT);
            this.add((Component)label, "alignx left, wrap");
            MultiLineLabel desc = new MultiLineLabel(model.getDescription());
            desc.setFont(PLUGIN_DESCRIPTION_FONT);
            this.add((Component)desc, "sx 2, growx, aligny top");
        }
    }
}

