/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class DragInsensitiveMouseClickListener
implements MouseInputListener {
    protected static final int MAX_CLICK_DISTANCE = 15;
    private final MouseInputListener target;
    public MouseEvent pressed;

    public DragInsensitiveMouseClickListener(MouseInputListener target) {
        this.target = target;
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.pressed = e;
        this.target.mousePressed(e);
    }

    private int getDragDistance(MouseEvent e) {
        int distance = 0;
        distance += Math.abs(this.pressed.getXOnScreen() - e.getXOnScreen());
        return distance += Math.abs(this.pressed.getYOnScreen() - e.getYOnScreen());
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.target.mouseReleased(e);
        if (this.pressed != null) {
            if (this.getDragDistance(e) < 15) {
                MouseEvent clickEvent = new MouseEvent((Component)this.pressed.getSource(), 500, e.getWhen(), this.pressed.getModifiers(), this.pressed.getX(), this.pressed.getY(), this.pressed.getXOnScreen(), this.pressed.getYOnScreen(), this.pressed.getClickCount(), this.pressed.isPopupTrigger(), this.pressed.getButton());
                this.target.mouseClicked(clickEvent);
            }
            this.pressed = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.target.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.target.mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pressed != null) {
            if (this.getDragDistance(e) < 15) {
                return;
            }
            this.pressed = null;
        }
        this.target.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.target.mouseMoved(e);
    }
}

