/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.play.CastleCreated;
import com.jcloisterzone.event.play.DoubleTurnEvent;
import com.jcloisterzone.event.play.FlierRollEvent;
import com.jcloisterzone.event.play.FollowerCaptured;
import com.jcloisterzone.event.play.MeepleDeployed;
import com.jcloisterzone.event.play.MeepleReturned;
import com.jcloisterzone.event.play.NeutralFigureMoved;
import com.jcloisterzone.event.play.NeutralFigureReturned;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.PlayerTurnEvent;
import com.jcloisterzone.event.play.PrisonersExchangeEvent;
import com.jcloisterzone.event.play.RansomPaidEvent;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.event.play.TileDiscardedEvent;
import com.jcloisterzone.event.play.TilePlacedEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.event.play.TokenReceivedEvent;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.neutral.Count;
import com.jcloisterzone.figure.neutral.Dragon;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.grid.eventpanel.EventItem;
import com.jcloisterzone.ui.grid.eventpanel.ImageEventItem;
import com.jcloisterzone.ui.grid.eventpanel.RansomPaidEventItem;
import com.jcloisterzone.ui.grid.eventpanel.ScoreEventItem;
import com.jcloisterzone.ui.grid.layer.EventsOverlayLayer;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.ui.resources.ResourceManager;
import com.jcloisterzone.ui.resources.TileImage;
import com.jcloisterzone.ui.theme.Theme;
import io.vavr.Function1;
import io.vavr.collection.HashMap;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Queue;
import io.vavr.collection.Vector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameEventsPanel
extends JPanel {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ICON_WIDTH = 30;
    public static final int ICON_HEIGHT = 30;
    private EventsOverlayLayer eventsOverlayPanel;
    private GameState state;
    private ArrayList<EventItem> model = new ArrayList();
    private Integer mouseOverIdx;
    private int skipItems;
    io.vavr.collection.Map<Class<? extends PlayEvent>, Function1<PlayEvent, EventItem>> mapping;
    protected final Theme theme;
    protected final ResourceManager rm;
    private Color turnColor;
    private Color triggeringColor;

    public GameEventsPanel(GameController gc) {
        this.theme = gc.getClient().getTheme();
        this.setBackground(this.theme.getEventsBg());
        this.rm = gc.getClient().getResourceManager();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int idx = GameEventsPanel.this.skipItems + e.getX() / 30;
                GameEventsPanel.this.setMouseOverIdx(idx < GameEventsPanel.this.model.size() ? Integer.valueOf(idx) : null);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                GameEventsPanel.this.setMouseOverIdx(null);
            }
        });
        this.mapping = HashMap.empty();
        this.mapping = this.mapping.put(TilePlacedEvent.class, this::processTilePlacedEvent);
        this.mapping = this.mapping.put(TileDiscardedEvent.class, this::processTileDiscardedEvent);
        this.mapping = this.mapping.put(MeepleDeployed.class, this::processMeepleDeployedEvent);
        this.mapping = this.mapping.put(MeepleReturned.class, this::processMeepleReturnedEvent);
        this.mapping = this.mapping.put(FollowerCaptured.class, this::processFollowerCapturedEvent);
        this.mapping = this.mapping.put(ScoreEvent.class, this::processScoreEvent);
        this.mapping = this.mapping.put(NeutralFigureMoved.class, this::processNeutralFigureMoved);
        this.mapping = this.mapping.put(NeutralFigureReturned.class, this::processNeutralFigureReturned);
        this.mapping = this.mapping.put(TokenPlacedEvent.class, this::processTokenPlacedEvent);
        this.mapping = this.mapping.put(TokenReceivedEvent.class, this::processTokenReceivedEvent);
        this.mapping = this.mapping.put(CastleCreated.class, this::processCastleCreatedEvent);
        this.mapping = this.mapping.put(RansomPaidEvent.class, this::processRansomPaidEvent);
        this.mapping = this.mapping.put(PrisonersExchangeEvent.class, ev -> null);
        this.mapping = this.mapping.put(DoubleTurnEvent.class, ev -> null);
        this.mapping = this.mapping.put(FlierRollEvent.class, ev -> null);
    }

    private EventItem processTilePlacedEvent(PlayEvent _ev) {
        TilePlacedEvent ev = (TilePlacedEvent)_ev;
        TileImage img = this.rm.getTileImage(ev.getTile().getId(), ev.getRotation());
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        item.setImage(img.getImage());
        item.setHighlightedPositions(Vector.of(ev.getPosition()));
        return item;
    }

    private EventItem processTileDiscardedEvent(PlayEvent _ev) {
        TileDiscardedEvent ev = (TileDiscardedEvent)_ev;
        TileImage img = this.rm.getTileImage(ev.getTile().getId(), Rotation.R0);
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        item.setImage(img.getImage());
        item.setDrawCross(true);
        return item;
    }

    private EventItem processMeepleDeployedEvent(PlayEvent _ev) {
        MeepleDeployed ev = (MeepleDeployed)_ev;
        return this.getMeepleItem(ev, ev.getMeeple(), ev.getPointer().asFeaturePointer());
    }

    private EventItem processFollowerCapturedEvent(PlayEvent _ev) {
        FollowerCaptured ev = (FollowerCaptured)_ev;
        ImageEventItem item = this.getMeepleItem(ev, ev.getFollower(), ev.getFrom().asFeaturePointer());
        item.setDrawCross(true);
        return item;
    }

    private EventItem processMeepleReturnedEvent(PlayEvent _ev) {
        MeepleReturned ev = (MeepleReturned)_ev;
        if (!ev.isForced()) {
            return null;
        }
        ImageEventItem item = this.getMeepleItem(ev, ev.getMeeple(), ev.getFrom().asFeaturePointer());
        item.setDrawCross(true);
        return item;
    }

    private EventItem processScoreEvent(PlayEvent _ev) {
        ScoreEvent ev = (ScoreEvent)_ev;
        ScoreEventItem item = new ScoreEventItem(this.theme, ev, this.turnColor, this.triggeringColor);
        if (ev.getSource() != null) {
            item.setHighlightedPositions(ev.getSource().toVector());
        } else if (ev.getCategory() == PointCategory.FAIRY || ev.getFeaturePointer() == null) {
            item.setHighlightedPositions(Vector.of(ev.getPosition()));
        } else {
            Feature feature = this.state.getFeature(ev.getFeaturePointer());
            item.setHighlightedFeature(feature);
        }
        return item;
    }

    private EventItem processRansomPaidEvent(PlayEvent _ev) {
        RansomPaidEvent ev = (RansomPaidEvent)_ev;
        RansomPaidEventItem item = new RansomPaidEventItem(this.theme, ev, this.turnColor, this.triggeringColor);
        return item;
    }

    private EventItem processNeutralFigureMoved(PlayEvent _ev) {
        NeutralFigureMoved ev = (NeutralFigureMoved)_ev;
        Image img = this.rm.getImage("neutral/" + ev.getNeutralFigure().getClass().getSimpleName().toLowerCase());
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        item.setImage(img);
        if (ev.getNeutralFigure() instanceof Count) {
            Feature feature = this.state.getFeature(ev.getTo().asFeaturePointer());
            item.setHighlightedFeature(feature);
        } else {
            Position from = ev.getFrom() == null ? null : ev.getFrom().getPosition();
            Position to = ev.getTo() == null ? null : ev.getTo().getPosition();
            IndexedSeq positions = Vector.empty();
            if (from != null) {
                positions = positions.append(from);
            }
            if (!(to == null || from != null && to.equals(from))) {
                positions = positions.append(to);
            }
            item.setHighlightedPositions((Vector<Position>)positions);
        }
        return item;
    }

    private EventItem processNeutralFigureReturned(PlayEvent _ev) {
        NeutralFigureReturned ev = (NeutralFigureReturned)_ev;
        Image img = this.rm.getImage("neutral/" + ev.getNeutralFigure().getClass().getSimpleName().toLowerCase());
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        item.setImage(img);
        item.setDrawCross(true);
        Feature feature = this.state.getFeature(ev.getFrom().asFeaturePointer());
        item.setHighlightedFeature(feature);
        return item;
    }

    private EventItem processTokenPlacedEvent(PlayEvent _ev) {
        TokenPlacedEvent ev = (TokenPlacedEvent)_ev;
        Token token = ev.getToken();
        if (token == GoldminesCapability.GoldToken.GOLD) {
            return null;
        }
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        if (token instanceof TunnelCapability.Tunnel) {
            Player player = this.state.getPlayers().getPlayer(ev.getMetadata().getTriggeringPlayerIndex());
            Map<TunnelCapability.Tunnel, Color> tunnelColors = player.getColors().getTunnelColors();
            Image img = this.rm.getLayeredImage(new LayeredImageDescriptor("player-meeples/tunnel", tunnelColors.get(token)));
            item.setImage(img);
        } else {
            item.setImage(this.rm.getImage("neutral/" + token.name().toLowerCase()));
        }
        item.setHighlightedPositions(Vector.of(ev.getPointer().getPosition()));
        return item;
    }

    private EventItem processTokenReceivedEvent(PlayEvent _ev) {
        TokenReceivedEvent ev = (TokenReceivedEvent)_ev;
        Color playerColor = this.getMeepleColor(ev.getPlayer());
        Image img = this.rm.getImage("neutral/" + ev.getToken().name().toLowerCase());
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, playerColor);
        item.setImage(img);
        if (ev.getSourceFeature() != null) {
            item.setHighlightedFeature(ev.getSourceFeature());
        }
        if (ev.getSourcePositions() != null) {
            item.setHighlightedPositions(ev.getSourcePositions());
        }
        return item;
    }

    private EventItem processCastleCreatedEvent(PlayEvent _ev) {
        CastleCreated ev = (CastleCreated)_ev;
        Image img = this.rm.getImage("neutral/castle");
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        item.setImage(img);
        item.setHighlightedFeature(ev.getCastle());
        return item;
    }

    private ImageEventItem getMeepleItem(PlayEvent ev, Meeple meeple, FeaturePointer fp) {
        Image img = this.rm.getLayeredImage(new LayeredImageDescriptor(meeple.getClass(), meeple.getPlayer().getColors().getMeepleColor()));
        ImageEventItem item = new ImageEventItem(ev, this.turnColor, this.triggeringColor);
        item.setImage(img);
        item.setPadding(2);
        Feature feature = this.state.getFeature(fp);
        item.setHighlightedFeature(feature);
        return item;
    }

    public void setMouseOverIdx(Integer mouseOverIdx) {
        if (this.mouseOverIdx == mouseOverIdx) {
            return;
        }
        this.mouseOverIdx = mouseOverIdx;
        if (mouseOverIdx == null) {
            this.eventsOverlayPanel.clearHighlight();
            return;
        }
        EventItem item = this.model.get(mouseOverIdx);
        Vector<Position> positions = item.getHighlightedPositions();
        Feature feature = item.getHighlightedFeature();
        if (positions != null) {
            this.eventsOverlayPanel.setHighlightedPositions(this.state, positions);
        } else if (feature != null) {
            this.eventsOverlayPanel.setHighlightedFeature(this.state, feature);
        } else {
            this.eventsOverlayPanel.clearHighlight();
        }
    }

    public void handleGameChanged(GameChangedEvent ev) {
        this.state = ev.getCurrentState();
        this.model = this.prepareModel(this.state, ev.getCurrentState().getEvents());
        this.repaint();
    }

    private ArrayList<EventItem> prepareModel(GameState state, Queue<PlayEvent> events) {
        ArrayList<EventItem> model = new ArrayList<EventItem>();
        this.turnColor = Color.GRAY;
        this.triggeringColor = null;
        boolean ignore = true;
        boolean finalScoring = false;
        EventItem dragonItem = null;
        for (PlayEvent ev : events) {
            Function1 fn;
            if (ev instanceof PlayerTurnEvent) {
                this.turnColor = this.getMeepleColor(((PlayerTurnEvent)ev).getPlayer());
                ignore = false;
                dragonItem = null;
                continue;
            }
            if (ignore) continue;
            if (dragonItem != null && this.isDragonMoveEvent(ev)) {
                IndexedSeq<Position> positions = dragonItem.getHighlightedPositions();
                positions = positions.append((Object)((NeutralFigureMoved)ev).getTo().getPosition());
                dragonItem.setHighlightedPositions((Vector<Position>)positions);
                continue;
            }
            if (!finalScoring) {
                if (ev instanceof ScoreEvent && ((ScoreEvent)ev).isFinal()) {
                    this.turnColor = Color.GRAY;
                    this.triggeringColor = null;
                    finalScoring = true;
                } else {
                    Integer idx = ev.getMetadata().getTriggeringPlayerIndex();
                    this.triggeringColor = idx == null ? this.turnColor : this.getMeepleColor(state.getPlayers().getPlayer(idx));
                }
            }
            if ((fn = (Function1)this.mapping.get(ev.getClass()).getOrNull()) == null) {
                this.logger.warn("Unhandled event {}", (Object)ev.getClass());
                continue;
            }
            EventItem item = (EventItem)fn.apply(ev);
            if (item == null) continue;
            if (this.isDragonMoveEvent(ev)) {
                dragonItem = item;
            }
            model.add(item);
        }
        return model;
    }

    private boolean isDragonMoveEvent(PlayEvent ev) {
        return ev instanceof NeutralFigureMoved && ((NeutralFigureMoved)ev).getNeutralFigure() instanceof Dragon;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int size = this.model.size();
        this.skipItems = Math.max(0, size - this.getWidth() / 30);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform orig = g2.getTransform();
        g2.translate(0, 5);
        for (int i = this.skipItems; i < size; ++i) {
            Color bottom;
            EventItem item = this.model.get(i);
            Color top = item.getTurnColor();
            if (top.equals(bottom = item.getColor())) {
                g2.setColor(top);
                g2.fillRect(0, -5, 30, 4);
            } else {
                g2.setColor(top);
                g2.fillRect(0, -5, 30, 2);
                g2.setColor(bottom);
                g2.fillRect(0, -3, 30, 3);
            }
            item.draw(g2);
            g2.translate(30, 0);
        }
        g2.setTransform(orig);
    }

    private Color getMeepleColor(Player player) {
        return player.getColors().getMeepleColor();
    }

    public EventsOverlayLayer getEventsOverlayPanel() {
        return this.eventsOverlayPanel;
    }

    public void setEventsOverlayPanel(EventsOverlayLayer eventsOverlayPanel) {
        this.eventsOverlayPanel = eventsOverlayPanel;
    }
}

