/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.ui.grid.GridMouseListener;
import com.jcloisterzone.ui.grid.GridPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.event.MouseInputListener;

public class GridMouseAdapter
extends MouseAdapter
implements MouseInputListener {
    final GridPanel gridPanel;
    final GridMouseListener listener;
    private Position currentPosition;

    public GridMouseAdapter(GridPanel gridPanel, GridMouseListener listener) {
        this.gridPanel = gridPanel;
        this.listener = listener;
    }

    public Position getCurrentPosition() {
        return this.currentPosition;
    }

    private Position getGridPosition(MouseEvent e) {
        int w = this.gridPanel.getTileWidth();
        int h = this.gridPanel.getTileHeight();
        Point2D point = this.gridPanel.getRelativePoint(e.getPoint());
        int clickX = (int)point.getX();
        int clickY = (int)point.getY();
        int x = clickX / w + (clickX < 0 ? -1 : 0);
        int y = clickY / h + (clickY < 0 ? -1 : 0);
        return new Position(x, y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Position p = this.getGridPosition(e);
        if (this.currentPosition != null && !this.currentPosition.equals(p)) {
            this.listener.tileExited(e, this.currentPosition);
            this.currentPosition = null;
        }
        if (p != null && !p.equals(this.currentPosition)) {
            this.currentPosition = p;
            this.listener.tileEntered(e, this.currentPosition);
        }
        this.listener.mouseMoved(e, p);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Position p = this.getGridPosition(e);
        if (p != null) {
            this.listener.mouseClicked(e, p);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.currentPosition != null) {
            this.listener.tileExited(e, this.currentPosition);
            this.currentPosition = null;
        }
    }
}

