/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.actionpanel;

import com.jcloisterzone.action.BazaarBidAction;
import com.jcloisterzone.action.BazaarSelectBuyOrSellAction;
import com.jcloisterzone.action.BazaarSelectTileAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.BazaarCapability;
import com.jcloisterzone.game.capability.BazaarCapabilityModel;
import com.jcloisterzone.game.capability.BazaarItem;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.grid.ForwardBackwardListener;
import com.jcloisterzone.ui.grid.actionpanel.ActionInteractionPanel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.wsio.message.BazaarBidMessage;
import com.jcloisterzone.wsio.message.BazaarBuyOrSellMessage;
import com.jcloisterzone.wsio.message.PassMessage;
import io.vavr.collection.Queue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;

public class BazaarPanel
extends ActionInteractionPanel<PlayerAction<?>>
implements ForwardBackwardListener {
    private static Font FONT_HEADER = new Font(null, 1, 18);
    private static Font FONT_BUTTON = new Font(null, 1, 12);
    private static Font FONT_ACTION = new Font(null, 0, 12);
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private BazaarCapabilityModel model;
    private int selectedItem = -1;
    private BazaarPanelState panelState = BazaarPanelState.INACTIVE;
    private BazaarItemPanel[] itemPanels;
    private boolean noAuction;
    private JLabel hint;
    private OverlayPanel overlay;

    public BazaarPanel(Client client, GameController gc) {
        super(client, gc);
    }

    private void initComponents(GameState state) {
        this.noAuction = state.getBooleanValue(Rule.BAZAAR_NO_AUCTION);
        this.setOpaque(true);
        this.setBackground(this.client.getTheme().getTransparentPanelBg());
        this.setLayout(new MigLayout("ins 0", "[grow]", ""));
        ThemedJLabel label = new ThemedJLabel(I18nUtils._tr("Bazaar supply", new Object[0]));
        label.setFont(FONT_HEADER);
        label.setForeground(this.client.getTheme().getHeaderFontColor());
        this.add((Component)label, "wrap, gap 20 20 10 5");
        this.hint = new ThemedJLabel();
        this.hint.setFont(FONT_ACTION);
        this.add((Component)this.hint, "wrap, gap 20 20 0 5");
        BazaarCapabilityModel model = (BazaarCapabilityModel)state.getCapabilityModel(BazaarCapability.class);
        this.itemPanels = new BazaarItemPanel[model.getSupply().size()];
        int idx = 0;
        for (BazaarItem bi : model.getSupply()) {
            this.itemPanels[idx] = new BazaarItemPanel(idx);
            this.add((Component)this.itemPanels[idx], "wrap, gap 0, growx, h 92");
            ++idx;
        }
        this.overlay = new OverlayPanel();
    }

    @Override
    public void setGameState(GameState state) {
        super.setGameState(state);
        if (this.overlay == null) {
            this.initComponents(state);
        }
        this.model = (BazaarCapabilityModel)state.getCapabilityModel(BazaarCapability.class);
        Object action = this.getAction();
        if (!state.getActivePlayer().isLocalHuman()) {
            this.setPanelState(BazaarPanelState.INACTIVE);
            return;
        }
        if (action instanceof BazaarSelectTileAction) {
            Queue<BazaarItem> supply = this.model.getSupply();
            for (int i = 0; i < supply.size(); ++i) {
                if (supply.get(i).getOwner() != null) continue;
                this.setSelectedItem(i);
                break;
            }
            this.setPanelState(BazaarPanelState.SELECT_TILE);
        } else if (action instanceof BazaarBidAction) {
            this.setSelectedItem(this.model.getAuctionedItemIndex());
            this.setPanelState(BazaarPanelState.MAKE_BID);
        } else if (action instanceof BazaarSelectBuyOrSellAction) {
            this.setSelectedItem(this.model.getAuctionedItemIndex());
            this.setPanelState(BazaarPanelState.BUY_OR_SELL);
        }
    }

    public BazaarPanelState getState() {
        return this.panelState;
    }

    public void setPanelState(BazaarPanelState panelState) {
        this.panelState = panelState;
        this.overlay.setPanelState(panelState);
        this.revalidate();
    }

    private void updateBidRange() {
        this.overlay.bidAmountModel.setMaximum(Integer.valueOf(999));
        if (this.model.getAuctionedItemIndex() == null) {
            this.overlay.bidAmountModel.setMinimum(Integer.valueOf(0));
            this.overlay.bidAmountModel.setValue(0);
        } else {
            int min = this.model.getAuctionedItem().getCurrentPrice() + 1;
            this.overlay.bidAmountModel.setMinimum(Integer.valueOf(min));
            this.overlay.bidAmountModel.setValue(min);
        }
    }

    public void setSelectedItem(int selectedItem) {
        if (this.selectedItem != -1) {
            this.itemPanels[selectedItem].remove(this.overlay);
        }
        this.selectedItem = selectedItem;
        if (selectedItem != -1) {
            this.itemPanels[selectedItem].add((Component)this.overlay, "gapleft 110, grow x, h 100%");
        }
        this.revalidate();
        this.gc.getGameView().getGridPanel().repaint();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void forward() {
        if (this.panelState == BazaarPanelState.SELECT_TILE) {
            int selected = this.selectedItem;
            Queue<BazaarItem> supply = this.model.getSupply();
            do {
                if (++selected != supply.size()) continue;
                selected = 0;
            } while (supply.get(selected).getOwner() != null);
            this.setSelectedItem(selected);
        }
    }

    @Override
    public void backward() {
        if (this.panelState == BazaarPanelState.SELECT_TILE) {
            int selected = this.selectedItem;
            Queue<BazaarItem> supply = this.model.getSupply();
            do {
                if (--selected != 0) continue;
                selected = supply.size() - 1;
            } while (supply.get(selected).getOwner() != null);
            this.setSelectedItem(selected);
        }
    }

    public static enum BazaarPanelState {
        INACTIVE,
        SELECT_TILE,
        MAKE_BID,
        BUY_OR_SELL;

    }

    class BazaarItemPanel
    extends ThemedJPanel {
        final int idx;

        public BazaarItemPanel(final int idx) {
            this.idx = idx;
            this.setOpaque(false);
            this.setBackground(TRANSPARENT_COLOR);
            this.setLayout(new MigLayout("ins 0", "", ""));
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ BazaarItemPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    BazaarItem bi;
                    if (this.this$1.BazaarPanel.this.panelState == BazaarPanelState.SELECT_TILE && (bi = this.this$1.BazaarPanel.this.model.getSupply().get(idx)).getOwner() == null) {
                        this.this$1.BazaarPanel.this.setSelectedItem(idx);
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            BazaarItem bi = BazaarPanel.this.model.getSupply().get(this.idx);
            Image img = BazaarPanel.this.client.getResourceManager().getTileImage(bi.getTile().getId(), Rotation.R0).getImage();
            if (BazaarPanel.this.selectedItem == this.idx) {
                g2.setColor(BazaarPanel.this.client.getTheme().getPlayerBoxBg());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g2.drawImage(img, 20, 0, 90, 90, null);
            if (bi.getCurrentBidder() == null && bi.getOwner() != null) {
                Image playerImage = BazaarPanel.this.client.getResourceManager().getLayeredImage(new LayeredImageDescriptor(SmallFollower.class, bi.getOwner().getColors().getMeepleColor()));
                g2.drawImage(playerImage, 140, 12, 64, 64, null);
            }
        }
    }

    class OverlayPanel
    extends JPanel {
        private JLabel bidAmountLabel;
        private JButton leftButton;
        private JButton rightButton;
        private JSpinner bidAmount;
        private SpinnerNumberModel bidAmountModel;

        public OverlayPanel() {
            this.setBackground(TRANSPARENT_COLOR);
            this.setOpaque(false);
            this.setLayout(new MigLayout("ins 0", "", ""));
            this.bidAmountModel = new SpinnerNumberModel(0, 0, 1, 1);
            if (!BazaarPanel.this.noAuction) {
                this.bidAmount = new JSpinner(this.bidAmountModel);
                this.bidAmount.setFont(new Font(null, 1, 14));
                this.add((Component)this.bidAmount, "pos 20 15");
                this.bidAmountLabel = new ThemedJLabel();
                this.add(this.bidAmountLabel);
            }
            this.leftButton = new JButton();
            this.leftButton.setFont(FONT_BUTTON);
            this.leftButton.setMargin(new Insets(1, 1, 1, 1));
            this.leftButton.addActionListener(new ActionListener(){
                final /* synthetic */ OverlayPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    switch (this.this$1.BazaarPanel.this.panelState.ordinal()) {
                        case 1: 
                        case 2: {
                            this.this$1.BazaarPanel.this.gc.getConnection().send(new BazaarBidMessage(this.this$1.BazaarPanel.this.selectedItem, this.this$1.bidAmountModel.getNumber().intValue()));
                            break;
                        }
                        case 3: {
                            this.this$1.BazaarPanel.this.gc.getConnection().send(new BazaarBuyOrSellMessage(BazaarBuyOrSellMessage.BuyOrSellOption.BUY));
                        }
                    }
                }
            });
            this.add(this.leftButton);
            this.rightButton = new JButton();
            this.rightButton.setFont(FONT_BUTTON);
            this.rightButton.addActionListener(new ActionListener(){
                final /* synthetic */ OverlayPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    switch (this.this$1.BazaarPanel.this.panelState.ordinal()) {
                        case 1: 
                        case 2: {
                            this.this$1.BazaarPanel.this.gc.getConnection().send(new PassMessage());
                            break;
                        }
                        case 3: {
                            this.this$1.BazaarPanel.this.gc.getConnection().send(new BazaarBuyOrSellMessage(BazaarBuyOrSellMessage.BuyOrSellOption.SELL));
                        }
                    }
                }
            });
            this.rightButton.setMargin(new Insets(1, 1, 1, 1));
            this.add(this.rightButton);
        }

        public void setPanelState(BazaarPanelState panelState) {
            MigLayout layout = (MigLayout)this.getLayout();
            switch (panelState.ordinal()) {
                case 0: {
                    BazaarPanel.this.hint.setText("");
                    break;
                }
                case 1: {
                    if (BazaarPanel.this.noAuction) {
                        BazaarPanel.this.hint.setText(I18nUtils._tr("Choose your tile.", new Object[0]));
                        break;
                    }
                    BazaarPanel.this.hint.setText(I18nUtils._tr("<html>Choose tile for next auction<br>and make initial offer.</html>", new Object[0]));
                    BazaarPanel.this.updateBidRange();
                    break;
                }
                case 2: {
                    BazaarPanel.this.hint.setText(I18nUtils._tr("Raise bid or pass.", new Object[0]));
                    BazaarPanel.this.updateBidRange();
                    break;
                }
                case 3: {
                    BazaarPanel.this.hint.setText(I18nUtils._tr("Buy or sell tile from latest bidder.", new Object[0]));
                }
            }
            if (this.bidAmountLabel != null) {
                if (panelState == BazaarPanelState.BUY_OR_SELL) {
                    int points = BazaarPanel.this.model.getAuctionedItem().getCurrentPrice();
                    this.bidAmountLabel.setText(points + "  " + I18nUtils._tr("points", new Object[0]));
                    layout.setComponentConstraints(this.bidAmountLabel, "pos 20 20");
                } else {
                    this.bidAmountLabel.setText(I18nUtils._tr("points", new Object[0]));
                    layout.setComponentConstraints(this.bidAmountLabel, "pos 75 20");
                }
            }
            if (panelState == BazaarPanelState.SELECT_TILE) {
                layout.setComponentConstraints(this.leftButton, "pos 20 55 120 80");
            } else {
                layout.setComponentConstraints(this.leftButton, "pos 8 55 68 80");
                layout.setComponentConstraints(this.rightButton, "pos 72 55 132 80");
            }
            switch (panelState.ordinal()) {
                case 3: {
                    this.leftButton.setText(I18nUtils._tr("Buy", new Object[0]));
                    this.rightButton.setText(I18nUtils._tr("Sell", new Object[0]));
                    this.leftButton.setVisible(true);
                    this.rightButton.setVisible(true);
                    if (this.bidAmount == null) break;
                    this.bidAmount.setVisible(false);
                    this.bidAmountLabel.setVisible(true);
                    break;
                }
                case 1: {
                    this.leftButton.setText(I18nUtils._tr("Select", new Object[0]));
                    this.leftButton.setVisible(true);
                    this.rightButton.setVisible(false);
                    if (this.bidAmount == null) break;
                    this.bidAmount.setVisible(true);
                    this.bidAmountLabel.setVisible(true);
                    break;
                }
                case 2: {
                    this.leftButton.setText(I18nUtils._tr("Bid", new Object[0]));
                    this.rightButton.setText(I18nUtils._tr("Pass", new Object[0]));
                    this.leftButton.setVisible(true);
                    this.rightButton.setVisible(true);
                    if (this.bidAmount == null) break;
                    this.bidAmount.setVisible(true);
                    this.bidAmountLabel.setVisible(true);
                    break;
                }
                default: {
                    this.leftButton.setVisible(false);
                    this.rightButton.setVisible(false);
                    if (this.bidAmount == null) break;
                    this.bidAmount.setVisible(false);
                    this.bidAmountLabel.setVisible(false);
                }
            }
            this.revalidate();
        }
    }
}

