/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.actionpanel;

import com.jcloisterzone.action.CornCircleSelectDeployOrRemoveAction;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.capability.CornCircleCapability;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.grid.actionpanel.ActionInteractionPanel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.wsio.message.CornCircleRemoveOrDeployMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;

public class CornCirclesPanel
extends ActionInteractionPanel<CornCircleSelectDeployOrRemoveAction> {
    private JButton deploymentOption;
    private JButton removalOption;

    public CornCirclesPanel(Client client, final GameController gc) {
        super(client, gc);
        this.setOpaque(true);
        this.setBackground(gc.getClient().getTheme().getTransparentPanelBg());
        this.setLayout(new MigLayout("ins 10 20 10 20", "[grow]", ""));
        ThemedJLabel label = new ThemedJLabel(I18nUtils._tr("Corn circle", new Object[0]));
        label.setFont(FONT_HEADER);
        label.setForeground(gc.getClient().getTheme().getHeaderFontColor());
        this.add((Component)label, "wrap, gapbottom 10");
        label = new ThemedJLabel(I18nUtils._tr("Each player\u2026", new Object[0]));
        this.add((Component)label, "wrap, gapbottom 5");
        boolean isActive = gc.getGame().getState().getActivePlayer().isLocalHuman();
        this.deploymentOption = new JButton();
        this.deploymentOption.setText(I18nUtils._tr("may deploy additional follower", new Object[0]));
        this.deploymentOption.setEnabled(isActive);
        this.deploymentOption.addActionListener(new ActionListener(){
            final /* synthetic */ CornCirclesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                gc.getConnection().send(new CornCircleRemoveOrDeployMessage(CornCircleRemoveOrDeployMessage.CornCircleOption.DEPLOY));
            }
        });
        this.add((Component)this.deploymentOption, "wrap, growx, h 40, gapbottom 5");
        this.removalOption = new JButton();
        this.removalOption.setText(I18nUtils._tr("must remove follower", new Object[0]));
        this.removalOption.setEnabled(isActive);
        this.removalOption.addActionListener(new ActionListener(){
            final /* synthetic */ CornCirclesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                gc.getConnection().send(new CornCircleRemoveOrDeployMessage(CornCircleRemoveOrDeployMessage.CornCircleOption.REMOVE));
            }
        });
        this.add((Component)this.removalOption, "wrap, growx, h 40, gapbottom 5");
        Tile tile = gc.getGame().getState().getLastPlaced().getTile();
        String feature = (String)tile.getTileModifiers().find(m -> m instanceof CornCircleCapability.CornCircleModifier).map(m -> Feature.getLocalizedNamefor(((CornCircleCapability.CornCircleModifier)m).getFeatureType())).getOrElseThrow(IllegalArgumentException::new);
        label = new ThemedJLabel(I18nUtils._tr("on/from a {0}.", feature.toLowerCase()));
        this.add((Component)label, "wrap");
    }
}

