/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.actionpanel;

import com.jcloisterzone.action.SelectPrisonerToExchangeAction;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.component.MultiLineLabel;
import com.jcloisterzone.ui.grid.actionpanel.ActionInteractionPanel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.resources.ConvenientResourceManager;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.wsio.message.ExchangeFollowerChoiceMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;

public class PrisonersExchangePanel
extends ActionInteractionPanel<SelectPrisonerToExchangeAction> {
    public PrisonersExchangePanel(Client client, GameController gc) {
        super(client, gc);
    }

    @Override
    public void setGameState(GameState state) {
        super.setGameState(state);
        SelectPrisonerToExchangeAction action = (SelectPrisonerToExchangeAction)this.getAction();
        this.setOpaque(true);
        this.setBackground(this.gc.getClient().getTheme().getTransparentPanelBg());
        this.setLayout(new MigLayout("ins 10 20 10 20", "[grow]", ""));
        ThemedJLabel label = new ThemedJLabel(I18nUtils._tr("Prisoners exchange", new Object[0]));
        label.setFont(FONT_HEADER);
        label.setForeground(this.gc.getClient().getTheme().getHeaderFontColor());
        this.add((Component)label, "wrap, gapbottom 10");
        MultiLineLabel mll = new MultiLineLabel(I18nUtils._tr("The captured prisoner is going to be immediately exchanged. You can select which follower you want to exchange for.", new Object[0]));
        this.add((Component)mll, "wrap, growx, gapbottom 5");
        ConvenientResourceManager rm = this.gc.getGameView().getClient().getResourceManager();
        boolean isActive = state.getActivePlayer().isLocalHuman();
        action.getOptions().forEach(f -> {
            Color color = f.getPlayer().getColors().getMeepleColor();
            LayeredImageDescriptor lid = new LayeredImageDescriptor(f.getClass(), color);
            Image image = rm.getLayeredImage(lid);
            image = image.getScaledInstance(60, 60, 4);
            JButton btn = new JButton();
            btn.setIcon(new ImageIcon(image));
            btn.setEnabled(isActive);
            btn.addActionListener(new ActionListener(){
                final /* synthetic */ Follower val$f;
                final /* synthetic */ PrisonersExchangePanel this$0;
                {
                    this.val$f = follower;
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).setEnabled(false);
                    this.this$0.gc.getConnection().send(new ExchangeFollowerChoiceMessage(this.val$f.getId()));
                }
            });
            this.add((Component)btn, "wrap, growx, h 60, gapbottom 5");
        });
    }
}

