/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.eventpanel;

import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.ui.grid.eventpanel.EventItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;

public class ImageEventItem
extends EventItem {
    private static final BasicStroke BORDER_STROKE = new BasicStroke(4.0f, 1, 1);
    private static final BasicStroke STROKE = new BasicStroke(2.0f, 1, 1);
    protected Image image;
    protected int padding;
    protected boolean drawCross;

    public ImageEventItem(PlayEvent event, Color turnColor, Color color) {
        super(event, turnColor, color);
    }

    @Override
    public void draw(Graphics2D g2) {
        int width = 30 - 2 * this.padding;
        int height = 30 - 2 * this.padding;
        g2.drawImage(this.image, this.padding, this.padding, width, height, null);
        if (this.drawCross) {
            int x1 = this.padding + 2;
            int x2 = 30 - this.padding - 2;
            int y1 = this.padding + 2;
            int y2 = 30 - this.padding - 2;
            g2.setStroke(BORDER_STROKE);
            g2.setColor(Color.WHITE);
            g2.drawLine(x1, y1, x2, y2);
            g2.drawLine(x2, y1, x1, y2);
            g2.setStroke(STROKE);
            g2.setColor(Color.BLACK);
            g2.drawLine(x1, y1, x2, y2);
            g2.drawLine(x2, y1, x1, y2);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public boolean isDrawCross() {
        return this.drawCross;
    }

    public void setDrawCross(boolean drawCross) {
        this.drawCross = drawCross;
    }
}

