/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import com.jcloisterzone.ui.grid.layer.MeepleLayer;
import com.jcloisterzone.ui.resources.FeatureArea;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class BridgeLayer
extends AbstractGridLayer {
    private static final AlphaComposite BRIDGE_FILL_COMPOSITE = AlphaComposite.getInstance(3, 0.6f);
    private List<FeatureArea> model = List.empty();
    private MeepleLayer meepleLayer;

    public BridgeLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        boolean bridgesChanged = false;
        for (PlayEvent pe : ev.getPlayEventsSymmetricDifference()) {
            if (!(pe instanceof TokenPlacedEvent) || ((TokenPlacedEvent)pe).getToken() != BridgeCapability.BrigeToken.BRIDGE) continue;
            bridgesChanged = true;
            break;
        }
        if (bridgesChanged) {
            this.model = this.createModel(ev.getCurrentState());
        }
    }

    private List<FeatureArea> createModel(GameState state) {
        Set placedBridges = (Set)state.getCapabilityModel(BridgeCapability.class);
        return placedBridges.toList().map(bridge -> {
            Position pos = bridge.getPosition();
            Location loc = bridge.getLocation();
            return this.rm.getBridgeArea(loc).translateTo(pos);
        });
    }

    @Override
    public void paint(Graphics2D g2) {
        Composite oldComposite = g2.getComposite();
        g2.setColor(Color.BLACK);
        g2.setComposite(BRIDGE_FILL_COMPOSITE);
        AffineTransform scaleTx = this.getZoomScale();
        for (FeatureArea bridgeArea : this.model) {
            Area a = bridgeArea.getDisplayArea().createTransformedArea(scaleTx);
            g2.fill(a);
        }
        g2.setComposite(oldComposite);
        this.meepleLayer.paintMeeplesOnBridges(g2);
    }

    public MeepleLayer getMeepleLayer() {
        return this.meepleLayer;
    }

    public void setMeepleLayer(MeepleLayer meepleLayer) {
        this.meepleLayer = meepleLayer;
    }
}

