/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.event.play.CastleCreated;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import io.vavr.Predicates;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import java.awt.Graphics2D;
import java.awt.Image;

public class CastleLayer
extends AbstractGridLayer {
    private final Image castleImage;
    private CastleLayerModel model = new CastleLayerModel();

    public CastleLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
        this.castleImage = this.rm.getImage("neutral/castle");
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        boolean changed = false;
        for (PlayEvent pe : ev.getPlayEventsSymmetricDifference()) {
            if (!(pe instanceof CastleCreated)) continue;
            changed = true;
            break;
        }
        if (changed) {
            this.model = this.createModel(ev.getCurrentState());
            this.gridPanel.repaint();
        }
    }

    private CastleLayerModel createModel(GameState state) {
        CastleLayerModel model = new CastleLayerModel();
        model.castles = Stream.ofAll(state.getFeatureMap().values()).filter(Predicates.instanceOf(Castle.class)).distinct().map(c -> ((Castle)c).getEdge()).toList();
        return model;
    }

    @Override
    public void paint(Graphics2D g2) {
        for (Edge edge : this.model.castles) {
            int size;
            Position pos = edge.getP1();
            if (edge.isHorizontal()) {
                size = this.getTileWidth();
                g2.drawImage(this.castleImage, this.getOffsetX(pos), this.getOffsetY(pos) + size / 2, size, size, null);
                continue;
            }
            size = this.getTileHeight();
            g2.drawImage(this.castleImage, this.getOffsetX(pos) + size / 2, this.getOffsetY(pos), size, size, null);
        }
    }

    public static class CastleLayerModel {
        List<Edge> castles = List.empty();
    }
}

