/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import io.vavr.collection.Vector;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;

public class EventsOverlayLayer
extends AbstractGridLayer {
    private GameState state;
    private Feature highlightedFeature;
    private Vector<Position> highlightedPositions;

    public EventsOverlayLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Override
    public void paint(Graphics2D g2) {
        if (this.highlightedPositions == null && this.highlightedFeature == null) {
            return;
        }
        g2.setColor(this.gc.getClient().getTheme().getBoardOverlay());
        Area wholeGrid = new Area(new Rectangle(-this.gridPanel.getOffsetX(), -this.gridPanel.getOffsetY(), this.gridPanel.getWidth(), this.gridPanel.getHeight()));
        if (this.highlightedPositions != null) {
            int sx = this.gridPanel.getTileHeight();
            int sy = this.gridPanel.getTileHeight();
            for (Position pos : this.highlightedPositions) {
                wholeGrid.subtract(new Area(new Rectangle(pos.x * sx, pos.y * sy, sx, sy)));
            }
        }
        if (this.highlightedFeature != null) {
            Area featureArea = this.getFeatureArea(this.state, this.highlightedFeature);
            featureArea = featureArea.createTransformedArea(this.getZoomScale());
            wholeGrid.subtract(featureArea);
        }
        g2.fill(wholeGrid);
    }

    public void clearHighlight() {
        this.state = null;
        this.highlightedFeature = null;
        this.highlightedPositions = null;
        this.gridPanel.repaint();
    }

    public Feature getHighlightedFeature() {
        return this.highlightedFeature;
    }

    public void setHighlightedFeature(GameState state, Feature highlightedFeature) {
        this.state = state;
        this.highlightedFeature = highlightedFeature;
        this.highlightedPositions = null;
        this.gridPanel.repaint();
    }

    public Vector<Position> getHighlightedPositions() {
        return this.highlightedPositions;
    }

    public void setHighlightedPositions(GameState state, Vector<Position> highlightedPosition) {
        this.state = state;
        this.highlightedFeature = null;
        this.highlightedPositions = highlightedPosition;
        this.gridPanel.repaint();
    }
}

