/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public class GoldLayer
extends AbstractGridLayer {
    private static final Color FILL_COLOR = new Color(40, 40, 40, 120);
    private final Image goldImage;
    private final double widthHeightRatio;
    private Map<Position, Integer> placedGold = HashMap.empty();

    public GoldLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
        this.goldImage = this.rm.getImage("neutral/gold");
        this.widthHeightRatio = (double)this.goldImage.getWidth(null) / (double)this.goldImage.getHeight(null);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        this.placedGold = (Map)ev.getCurrentState().getCapabilityModel(GoldminesCapability.class);
    }

    @Override
    public void paint(Graphics2D g2) {
        int size = this.getTileWidth();
        int w = (int)((double)size * 0.4);
        int h = (int)((double)w / this.widthHeightRatio);
        g2.setColor(FILL_COLOR);
        this.placedGold.forEach((pos, count) -> {
            int tx = (int)((double)size * 0.45);
            AffineTransform at = this.getAffineTransformIgnoringRotation((Position)pos);
            Rectangle rect = new Rectangle(tx, 0, w + (int)((double)size * 0.15), h);
            g2.fill(at.createTransformedShape(rect));
            this.drawImageIgnoringRotation(g2, this.goldImage, (Position)pos, tx, 0, w, h);
            ImmutablePoint point = new ImmutablePoint(90, 10).rotate100(this.gridPanel.getBoardRotation().inverse());
            this.drawAntialiasedTextCentered(g2, "" + count, 20, (Position)pos, point, Color.WHITE, null);
        });
    }
}

