/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.GameChangedEvent;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.ImmutablePoint;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class SheepLayer
extends AbstractGridLayer {
    private static final Color FILL_COLOR = new Color(76, 170, 13, 140);
    private Map<Tuple2<FeaturePointer, ImmutablePoint>, Integer> placedTokens = HashMap.empty();

    public SheepLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Subscribe
    public void handleGameChanged(GameChangedEvent ev) {
        GameState state = ev.getCurrentState();
        this.placedTokens = ((Map)state.getCapabilityModel(SheepCapability.class)).mapKeys(fp -> {
            PlacedTile tile = state.getPlacedTile(fp.getPosition());
            ImmutablePoint point = this.rm.getMeeplePlacement(tile.getTile(), tile.getRotation(), fp.getLocation());
            return new Tuple2<FeaturePointer, ImmutablePoint>((FeaturePointer)fp, point.translate(20, -5));
        }).mapValues(tokens -> tokens.foldLeft(0, (acc, token) -> acc + token.sheepCount()));
    }

    @Override
    public void paint(Graphics2D g2) {
        int width = this.getTileWidth();
        int height = this.getTileHeight();
        int rx = (int)((double)width * 0.15);
        int ry = (int)((double)height * 0.15);
        g2.setColor(FILL_COLOR);
        this.placedTokens.forEach((t, count) -> {
            FeaturePointer fp = (FeaturePointer)t._1;
            ImmutablePoint point = (ImmutablePoint)t._2;
            AffineTransform at = this.getAffineTransformIgnoringRotation(fp.getPosition());
            int x = (int)((double)point.getX() / 100.0 * (double)width);
            int y = (int)((double)point.getY() / 100.0 * (double)height);
            Ellipse2D.Double shape = new Ellipse2D.Double(x - rx, y - ry, 2 * rx, 2 * ry);
            g2.fill(at.createTransformedShape(shape));
            ImmutablePoint rotatedPoint = point.rotate100(this.gridPanel.getBoardRotation().inverse());
            this.drawAntialiasedTextCentered(g2, "" + count, 20, fp.getPosition(), rotatedPoint, Color.WHITE, null);
        });
    }
}

