/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.grid.layer;

import com.jcloisterzone.action.FairyOnTileAction;
import com.jcloisterzone.action.GoldPieceAction;
import com.jcloisterzone.action.MoveDragonAction;
import com.jcloisterzone.action.SelectTileAction;
import com.jcloisterzone.action.TowerPieceAction;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.controls.action.ActionWrapper;
import com.jcloisterzone.ui.grid.ActionLayer;
import com.jcloisterzone.ui.grid.GridMouseAdapter;
import com.jcloisterzone.ui.grid.GridMouseListener;
import com.jcloisterzone.ui.grid.GridPanel;
import com.jcloisterzone.ui.grid.layer.AbstractGridLayer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class TileActionLayer
extends AbstractGridLayer
implements GridMouseListener,
ActionLayer {
    private ActionWrapper actionWrapper;
    private boolean active;
    private Image gridDecoration;

    public TileActionLayer(GridPanel gridPanel, GameController gc) {
        super(gridPanel, gc);
    }

    @Override
    public void onShow() {
        super.onShow();
        this.attachMouseInputListener(new GridMouseAdapter(this.gridPanel, this));
    }

    @Override
    public void setActionWrapper(boolean active, ActionWrapper actionWrapper) {
        this.actionWrapper = actionWrapper;
        this.active = active;
        SelectTileAction action = this.getAction();
        if (action == null) {
            this.gridDecoration = null;
        } else if (action instanceof FairyOnTileAction) {
            this.gridDecoration = this.rm.getImage("decorations/fairy");
        } else if (action instanceof TowerPieceAction) {
            this.gridDecoration = this.rm.getImage("decorations/tower");
        } else if (action instanceof GoldPieceAction) {
            this.gridDecoration = this.rm.getImage("decorations/gold");
        } else if (action instanceof MoveDragonAction) {
            this.gridDecoration = this.rm.getImage("decorations/dragon");
        }
    }

    @Override
    public ActionWrapper getActionWrapper() {
        return this.actionWrapper;
    }

    public SelectTileAction getAction() {
        return this.actionWrapper == null ? null : (SelectTileAction)this.actionWrapper.getAction();
    }

    @Override
    public void paint(Graphics2D g2) {
        int imgSize = this.gridDecoration.getWidth(null);
        for (Position pos : this.getAction().getOptions()) {
            g2.drawImage(this.gridDecoration, this.getAffineTransform(imgSize, imgSize, pos), null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e, Position p) {
        SelectTileAction action;
        if (!this.active) {
            return;
        }
        if (e.getButton() == 1 && (action = this.getAction()).getOptions().contains(p)) {
            e.consume();
            if (!this.gc.getActionLock().get()) {
                this.gc.getConnection().send(action.select(p));
            }
        }
    }

    @Override
    public void tileEntered(MouseEvent e, Position p) {
    }

    @Override
    public void tileExited(MouseEvent e, Position p) {
    }
}

