/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.gtk;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class MenuFix {
    public static void installGtkPopupBugWorkaround() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        Class<?> lafClass = laf.getClass();
        if (!lafClass.getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            return;
        }
        try {
            Field field = lafClass.getDeclaredField("styleFactory");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Object styleFactory = field.get(laf);
            field.setAccessible(accessible);
            Object style = MenuFix.getGtkStyle(styleFactory, new JPopupMenu(), "POPUP_MENU");
            MenuFix.fixGtkThickness(style, "yThickness");
            MenuFix.fixGtkThickness(style, "xThickness");
            style = MenuFix.getGtkStyle(styleFactory, new JSeparator(), "POPUP_MENU_SEPARATOR");
            MenuFix.fixGtkThickness(style, "yThickness");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fixGtkThickness(Object style, String fieldName) throws Exception {
        Field field = style.getClass().getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        field.setInt(style, Math.max(1, field.getInt(style)));
        field.setAccessible(accessible);
    }

    private static Object getGtkStyle(Object styleFactory, JComponent component, String regionName) throws Exception {
        Class<?> regionClass = Class.forName("javax.swing.plaf.synth.Region");
        Field field = regionClass.getField(regionName);
        Object region = field.get(regionClass);
        Class<?> styleFactoryClass = styleFactory.getClass();
        Method method = styleFactoryClass.getMethod("getStyle", JComponent.class, regionClass);
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        Object style = method.invoke(styleFactory, component, region);
        method.setAccessible(accessible);
        return style;
    }
}

