/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.jcloisterzone.Expansion;
import com.jcloisterzone.event.ClientListChangedEvent;
import com.jcloisterzone.event.GameListChangedEvent;
import com.jcloisterzone.event.setup.ExpansionChangedEvent;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.ui.ChannelController;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.LengthRestrictedDocument;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.controls.chat.ChannelChatPanel;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.panel.ConnectedClientsPanel;
import com.jcloisterzone.wsio.WebSocketConnection;
import com.jcloisterzone.wsio.message.AbandonGameMessage;
import com.jcloisterzone.wsio.message.CreateGameMessage;
import com.jcloisterzone.wsio.message.GameMessage;
import com.jcloisterzone.wsio.message.JoinGameMessage;
import com.jcloisterzone.wsio.server.RemoteClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ChannelPanel
extends ThemedJPanel
implements UIEventListener {
    private static final int MAX_GAME_TITLE_LENGTH = 60;
    private final Client client;
    private final ChannelController cc;
    private ChatPanel chatPanel;
    private ConnectedClientsPanel connectedClientsPanel;
    private JPanel gameListPanel;
    private static Font FONT_GAME_TITLE = new Font(null, 1, 20);

    public ChannelPanel(Client client, ChannelController cc) {
        this.client = client;
        this.cc = cc;
        this.setLayout(new MigLayout("ins 0", "[][]0[grow]", "[][grow]"));
        this.setBackground(client.getTheme().getMainBg());
        this.connectedClientsPanel = new ConnectedClientsPanel(client, "play.jcz");
        this.add((Component)this.connectedClientsPanel, "cell 0 0, sy 2, width 150::, grow");
        this.chatPanel = new ChannelChatPanel(client, cc);
        this.add((Component)this.chatPanel, "cell 1 0, grow, w 250, sy 2");
        this.add((Component)this.createCreateGamePanel(), "cell 2 0, growx");
        this.gameListPanel = new JPanel();
        this.gameListPanel.setLayout(new MigLayout("ins rel 0, gap 0 rel", "[grow]", ""));
        if (client.getTheme().isDark()) {
            this.gameListPanel.setBackground(client.getTheme().getMainBg());
        } else {
            this.gameListPanel.setBackground(new Color(180, 180, 180));
        }
        JScrollPane scroll = new JScrollPane(this.gameListPanel);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setViewportBorder(null);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scroll, "cell 2 1, grow");
    }

    private JPanel createCreateGamePanel() {
        String maintenance = ((WebSocketConnection)this.cc.getConnection()).getMaintenance();
        ThemedJPanel createGamePanel = new ThemedJPanel(new MigLayout());
        if (maintenance != null) {
            createGamePanel.add((Component)new ThemedJLabel("Server is in maintenance mode."), "wrap");
            createGamePanel.add((Component)new ThemedJLabel(maintenance), "wrap");
        } else {
            createGamePanel.add(new ThemedJLabel(I18nUtils._tr("Game title", new Object[0]) + ":"));
            String defaultTitle = this.cc.getConnection().getNickname() + "'s game";
            final JTextField gameTitle = new JTextField();
            gameTitle.setDocument(new LengthRestrictedDocument(60));
            gameTitle.setText(defaultTitle);
            createGamePanel.add((Component)gameTitle, "wrap, width 250::");
            createGamePanel.add(new ThemedJLabel(I18nUtils._tr("Password", new Object[0]) + ":"));
            final JPasswordField password = new JPasswordField();
            createGamePanel.add((Component)password, "wrap, width 250::");
            ThemedJLabel passwordHint = new ThemedJLabel(I18nUtils._tr("If you leave password empty, anybody can connect to your game.", new Object[0]));
            passwordHint.setFont(new Font(null, 2, 12));
            createGamePanel.add((Component)passwordHint, "wrap, span 2");
            JButton createGameButton = new JButton(I18nUtils._tr("Create game", new Object[0]));
            createGameButton.addActionListener(new ActionListener(){
                final /* synthetic */ ChannelPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = gameTitle.getText().trim();
                    String pwd = password.getText().toString();
                    this.this$0.cc.getConnection().send(new CreateGameMessage(title, this.this$0.cc.getChannel().getName(), pwd));
                }
            });
            createGamePanel.add((Component)createGameButton, "wrap, gaptop 20, span 2");
        }
        return createGamePanel;
    }

    @Subscribe
    public void clientListChanged(ClientListChangedEvent ev) {
        this.connectedClientsPanel.updateClients(ev.getClients());
    }

    @Subscribe
    public void gameListChanged(GameListChangedEvent ev) {
        this.gameListPanel.removeAll();
        for (GameController gc : ev.getGameControllers()) {
            this.gameListPanel.add((Component)new GameItemPanel(gc), "wrap, growx");
        }
        this.gameListPanel.validate();
        this.gameListPanel.repaint();
    }

    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }

    class GameItemPanel
    extends ThemedJPanel {
        private JLabel name;
        private JLabel expansionNames;
        private JLabel connectedClients;
        private JButton joinButton;
        private JButton abandonButton;
        private Joiner joiner = Joiner.on(", ").skipNulls();
        private Map<Expansion, Integer> expansions;

        public GameItemPanel(final GameController gc) {
            final Game game = gc.getGame();
            this.setLayout(new MigLayout());
            this.expansions = game.getSetup().getExpansions().toJavaMap();
            this.name = new ThemedJLabel(game.getName());
            this.name.setFont(FONT_GAME_TITLE);
            this.expansionNames = new ThemedJLabel();
            this.updateExpansionsLabel();
            this.connectedClients = new ThemedJLabel();
            this.updateClientsLabel(gc.getRemoteClients());
            ThemedJPanel buttons = new ThemedJPanel();
            buttons.setLayout(new MigLayout("ins 0"));
            final JPasswordField password = new JPasswordField();
            if (gc.isPasswordProtected()) {
                buttons.add(new ThemedJLabel(I18nUtils._tr("Password", new Object[0]) + ":"));
                buttons.add((Component)password, "width 160");
            }
            if (!this.expansions.containsKey(Expansion._MISSING_PLACEHOLDER)) {
                this.joinButton = new JButton(gc.getGameStatus() == GameMessage.GameStatus.OPEN ? I18nUtils._tr("Join game", new Object[0]) : I18nUtils._tr("Continue", new Object[0]));
                this.joinButton.addActionListener(new ActionListener(){
                    final /* synthetic */ GameItemPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JoinGameMessage msg = new JoinGameMessage();
                        msg.setGameId(game.getGameId());
                        if (gc.isPasswordProtected()) {
                            msg.setPassword(password.getText().toString());
                        }
                        this.this$1.ChannelPanel.this.cc.getConnection().send(msg);
                    }
                });
                buttons.add(this.joinButton);
            }
            if (gc.getGameStatus() != GameMessage.GameStatus.OPEN) {
                this.abandonButton = new JButton(I18nUtils._tr("Remove game", new Object[0]));
                this.abandonButton.addActionListener(new ActionListener(){
                    final /* synthetic */ GameItemPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int result = JOptionPane.showConfirmDialog(this.this$1.ChannelPanel.this.client, I18nUtils._tr("Do you want to remove game permanently?", new Object[0]), I18nUtils._tr("Remove game", new Object[0]), 0);
                        if (result == 0) {
                            this.this$1.ChannelPanel.this.cc.getConnection().send(new AbandonGameMessage(gc.getGame().getGameId()));
                        }
                    }
                });
                buttons.add(this.abandonButton);
            }
            this.add((Component)this.name, "wrap");
            this.add((Component)this.expansionNames, "wrap");
            this.add((Component)this.connectedClients, "wrap");
            this.add((Component)buttons, "wrap");
            gc.register(this);
        }

        private void updateClientsLabel(List<RemoteClient> clients) {
            if (clients == null) {
                return;
            }
            String label = this.joiner.join(Lists.transform(clients, new Function<RemoteClient, String>(){

                @Override
                public String apply(RemoteClient rc) {
                    return rc.getName();
                }
            }));
            this.connectedClients.setText(I18nUtils._tr("Players", new Object[0]) + ": " + label);
        }

        private void updateExpansionsLabel() {
            String label = this.joiner.join(this.expansions.keySet());
            if (label.length() == 0) {
                label = Expansion.BASIC.toString();
            }
            this.expansionNames.setText(I18nUtils._tr("Expansions", new Object[0]) + ": " + label);
        }

        @Subscribe
        public void clientListChanged(ClientListChangedEvent ev) {
            this.updateClientsLabel(ev.getClients());
        }

        @Subscribe
        public void expansionsChanged(ExpansionChangedEvent ev) {
            if (ev.getCount() > 0) {
                this.expansions.put(ev.getExpansion(), ev.getCount());
            } else {
                this.expansions.remove(ev.getExpansion());
            }
            this.updateExpansionsLabel();
        }
    }
}

