/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.config.Config;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.view.StartView;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectPlayOnlinePanel
extends ThemedJPanel {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client client;
    private JTextField nickField;
    private JButton btnConnect;
    private JButton btnBack;
    private JLabel message;

    public ConnectPlayOnlinePanel(Client client) {
        this.client = client;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectPlayOnlinePanel.this.btnConnect.setEnabled(false);
                ConnectPlayOnlinePanel.this.message.setForeground(Color.BLACK);
                ConnectPlayOnlinePanel.this.message.setText(I18nUtils._tr("Connecting", new Object[0]) + "...");
                ConnectPlayOnlinePanel.this.saveClientName();
                ConnectPlayOnlinePanel.this.connect();
            }
        };
        if (!client.getTheme().isDark()) {
            this.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        }
        this.setLayout(new MigLayout("", "[80.00][][grow]", "[][][][][]"));
        ThemedJLabel helpLabel = new ThemedJLabel("Enter your nickname");
        this.add((Component)helpLabel, "cell 0 0,spanx 3");
        ThemedJLabel hostLabel = new ThemedJLabel(I18nUtils._tr("Nickname", new Object[0]));
        this.add((Component)hostLabel, "cell 0 1,alignx left,aligny top, gaptop 10");
        this.nickField = new JTextField();
        this.nickField.addActionListener(actionListener);
        this.add((Component)this.nickField, "cell 1 1,spanx 2,growx, width 250::");
        this.nickField.setColumns(20);
        this.nickField.setText(this.getDefaultNick());
        this.btnConnect = new JButton(I18nUtils._tr("Connect", new Object[0]));
        this.btnConnect.addActionListener(actionListener);
        this.add((Component)this.btnConnect, "cell 1 2");
        this.btnBack = new JButton(I18nUtils._tr("Back", new Object[0]));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectPlayOnlinePanel.this.client.mountView(new StartView(ConnectPlayOnlinePanel.this.client));
            }
        });
        this.add((Component)this.btnBack, "cell 2 2");
        this.message = new ThemedJLabel("");
        this.message.setForeground(Color.BLACK);
        this.add((Component)this.message, "cell 1 3,spanx 2, height 20");
    }

    private String getDefaultNick() {
        if (System.getProperty("nick") != null) {
            return System.getProperty("nick");
        }
        String name = this.client.getConfig().getClient_name();
        String string = name = name == null ? "" : name.trim();
        if (name.equals("")) {
            name = System.getProperty("user.name");
        }
        return name;
    }

    private void saveClientName() {
        if (System.getProperty("nick") != null) {
            return;
        }
        String nick = this.nickField.getText().trim();
        if (nick.equals(System.getProperty("user.name"))) {
            return;
        }
        Config cfg = this.client.getConfig();
        cfg.setClient_name(nick);
        this.client.saveConfig();
    }

    public void onWebsocketError(Exception ex) {
        this.message.setForeground(Color.RED);
        this.btnConnect.setEnabled(true);
        if (ex instanceof UnresolvedAddressException) {
            this.message.setText(I18nUtils._tr("Connection failed. Unknown host.", new Object[0]));
        } else if (ex instanceof ConnectException && ex.getMessage().contains("Connection refused")) {
            this.message.setText(I18nUtils._tr("Connection refused.", new Object[0]));
        } else {
            this.message.setText(I18nUtils._tr("Connection failed.", new Object[0]) + " (" + ex.getMessage() + ")");
            this.logger.info(ex.getMessage(), ex);
        }
    }

    private void connect() {
        try {
            String nick = this.nickField.getText().trim();
            this.client.connectPlayOnline(nick);
            return;
        }
        catch (NumberFormatException nfe) {
            this.message.setText(I18nUtils._tr("Invalid port number.", new Object[0]));
            this.message.setForeground(Color.RED);
            this.btnConnect.setEnabled(true);
            return;
        }
    }
}

