/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.ai.AiPlayer;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.SupportedSetup;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import com.jcloisterzone.ui.panel.NameProvider;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import com.jcloisterzone.wsio.message.LeaveSlotMessage;
import com.jcloisterzone.wsio.message.TakeSlotMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGamePlayerPanel
extends ThemedJPanel {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1436952221307376517L;
    static Font FONT_PLAYER_TYPE = new Font(null, 2, 11);
    static Font FONT_SERIAL = new Font(null, 1, 32);
    private final PlayerSlot slot;
    private final PlayerSlot[] slots;
    private boolean ownSlot = false;
    private final Client client;
    private final GameController gc;
    private boolean mutableSlots;
    private boolean channel;
    private JButton icon;
    private JLabel status;
    private JTextField nickname;
    private NicknameUpdater nicknameUpdater;
    private JLabel serialLabel;
    private NameProvider nameProvider;

    public CreateGamePlayerPanel(Client client, GameController gc, boolean mutableSlots, PlayerSlot slot, PlayerSlot[] slots) {
        this.slot = slot;
        this.slots = slots;
        this.client = client;
        this.gc = gc;
        this.mutableSlots = mutableSlots;
        this.channel = gc.getChannel() != null;
        this.setLayout(new MigLayout("", "[][][10px][grow]", "[][]"));
        this.serialLabel = new ThemedJLabel("");
        this.serialLabel.setHorizontalAlignment(0);
        this.serialLabel.setForeground(new Color(180, 180, 180));
        this.serialLabel.setFont(FONT_SERIAL);
        this.add((Component)this.serialLabel, "cell 0 0 0 2,width 34!,height 60!");
        this.icon = new JButton();
        this.icon.addActionListener(mutableSlots ? new MutableIconActionListener() : new ImmutableIconActionListener());
        this.add((Component)this.icon, "cell 1 0 1 2,width 60!,height 60!");
        this.nickname = new JTextField();
        this.nickname.setDisabledTextColor(Color.BLACK);
        this.updateNickname(false);
        this.add((Component)this.nickname, "cell 3 0,growx,width :200:,gapy 10");
        this.status = new ThemedJLabel("");
        this.status.setFont(FONT_PLAYER_TYPE);
        this.add((Component)this.status, "cell 3 1,growx");
        this.updateSlot();
        if (mutableSlots && !this.channel) {
            this.nicknameUpdater = new NicknameUpdater();
            this.nicknameUpdater.setName("NickUpdater" + slot.getNumber());
            this.nicknameUpdater.start();
            this.nickname.addCaretListener(this.nicknameUpdater);
            this.nickname.addFocusListener(this.nicknameUpdater);
        }
    }

    public void disposePanel() {
        if (this.nicknameUpdater != null) {
            this.nicknameUpdater.setStopped(true);
            this.nicknameUpdater = null;
        }
    }

    public void updateSlot() {
        if (this.mutableSlots) {
            this.updateSlotMutable();
        } else {
            this.updateSlotImmutable();
        }
        this.ownSlot = this.slot.isOwn();
    }

    public PlayerSlot getSlot() {
        return this.slot;
    }

    private void updateNickname(boolean editable) {
        this.nickname.setEnabled(editable && !this.channel);
    }

    private void updateIcon(String iconType, Color color, boolean state) {
        Image imgRes = this.client.getResourceManager().getLayeredImage(new LayeredImageDescriptor("player-slot/" + iconType, color));
        imgRes = imgRes.getScaledInstance(60, 60, 4);
        ImageIcon img = new ImageIcon(imgRes);
        this.icon.setIcon(img);
        this.icon.setDisabledIcon(img);
        this.icon.setEnabled(state);
    }

    public void updateSlotImmutable() {
        Color color = this.slot.getColors().getMeepleColor();
        if (!this.slot.isOccupied()) {
            this.status.setText(I18nUtils._tr("Unassigned player", new Object[0]));
            this.updateIcon("open", color, true);
        } else if (!this.slot.isAi()) {
            if (this.slot.isOwn()) {
                this.status.setText(I18nUtils._tr("Local player", new Object[0]));
                this.updateIcon("local", color, true);
            } else {
                this.status.setText(I18nUtils._tr("Remote player", new Object[0]));
                this.updateIcon("remote", color, false);
            }
        } else if (this.slot.isOwn()) {
            this.status.setText(I18nUtils._tr("Computer player", new Object[0]));
            this.updateIcon("ai", color, false);
        } else {
            this.status.setText(I18nUtils._tr("Remote computer player", new Object[0]));
            this.updateIcon("remote_ai", color, false);
        }
        this.nickname.setText(this.slot.getNickname());
    }

    public void updateSlotMutable() {
        Color color = this.slot.getColors().getMeepleColor();
        if (!this.slot.isOccupied()) {
            this.status.setText(I18nUtils._tr("Open player slot", new Object[0]));
            this.updateIcon("open", color, true);
            this.updateNickname(false);
        } else if (!this.slot.isAi()) {
            if (this.slot.isOwn()) {
                this.status.setText(I18nUtils._tr("Local player", new Object[0]));
                this.updateIcon("local", color, true);
                this.updateNickname(true);
            } else {
                this.status.setText(I18nUtils._tr("Remote player", new Object[0]));
                this.updateIcon("remote", color, false);
                this.updateNickname(false);
            }
        } else {
            if (this.slot.isOwn()) {
                this.status.setText(I18nUtils._tr("Computer player", new Object[0]));
                this.updateIcon("ai", color, true);
            } else {
                this.status.setText(I18nUtils._tr("Remote computer player", new Object[0]));
                this.updateIcon("remote_ai", color, false);
            }
            this.updateNickname(false);
        }
        if (!this.ownSlot || !this.nickname.isEnabled()) {
            this.nickname.setText(this.slot.getNickname());
        }
    }

    public void setSerialText(String text) {
        this.serialLabel.setText(text);
    }

    private void sendTakeSlotMessage(PlayerSlot slot) {
        TakeSlotMessage msg = new TakeSlotMessage(slot.getNumber(), slot.getNickname());
        msg.setAiClassName(slot.getAiClassName());
        if (slot.getAiClassName() != null) {
            try {
                AiPlayer aiPlayer = (AiPlayer)Class.forName(slot.getAiClassName()).newInstance();
                msg.setSupportedSetup(aiPlayer.supportedSetup());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        } else {
            msg.setSupportedSetup(SupportedSetup.getCurrentClientSupported());
        }
        this.gc.getConnection().send(msg);
    }

    private void sendLeaveSlotMessage(PlayerSlot slot) {
        LeaveSlotMessage msg = new LeaveSlotMessage(slot.getNumber());
        this.gc.getConnection().send(msg);
    }

    public NameProvider getNameProvider() {
        return this.nameProvider;
    }

    public void setNameProvider(NameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    class MutableIconActionListener
    implements ActionListener {
        MutableIconActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean skipPlayer = false;
            if (CreateGamePlayerPanel.this.channel && !"true".equals(System.getProperty("allowHotSeatOnlineGame"))) {
                for (PlayerSlot other : CreateGamePlayerPanel.this.slots) {
                    if (other == CreateGamePlayerPanel.this.slot || !other.isOwn() || other.isAi()) continue;
                    skipPlayer = true;
                }
            }
            if (!CreateGamePlayerPanel.this.slot.isOccupied() && !skipPlayer) {
                String nick = CreateGamePlayerPanel.this.channel ? CreateGamePlayerPanel.this.gc.getConnection().getNickname() : CreateGamePlayerPanel.this.nameProvider.reserveName(false, CreateGamePlayerPanel.this.slot.getNumber());
                CreateGamePlayerPanel.this.slot.setNickname(nick);
                CreateGamePlayerPanel.this.nickname.setText(nick);
                CreateGamePlayerPanel.this.slot.setState(PlayerSlot.SlotState.OWN);
                CreateGamePlayerPanel.this.sendTakeSlotMessage(CreateGamePlayerPanel.this.slot);
            } else if (!CreateGamePlayerPanel.this.slot.isAi()) {
                CreateGamePlayerPanel.this.nameProvider.releaseName(false, CreateGamePlayerPanel.this.slot.getNumber());
                CreateGamePlayerPanel.this.slot.setAiClassName(CreateGamePlayerPanel.this.client.getConfig().getAi().getClass_name());
                String nick = CreateGamePlayerPanel.this.nameProvider.reserveName(true, CreateGamePlayerPanel.this.slot.getNumber());
                CreateGamePlayerPanel.this.slot.setNickname(nick);
                CreateGamePlayerPanel.this.nickname.setText(nick);
                CreateGamePlayerPanel.this.slot.setState(PlayerSlot.SlotState.OWN);
                CreateGamePlayerPanel.this.sendTakeSlotMessage(CreateGamePlayerPanel.this.slot);
            } else {
                CreateGamePlayerPanel.this.nameProvider.releaseName(true, CreateGamePlayerPanel.this.slot.getNumber());
                CreateGamePlayerPanel.this.slot.setNickname(null);
                CreateGamePlayerPanel.this.slot.setAiClassName(null);
                CreateGamePlayerPanel.this.slot.setState(PlayerSlot.SlotState.OPEN);
                CreateGamePlayerPanel.this.sendLeaveSlotMessage(CreateGamePlayerPanel.this.slot);
            }
        }
    }

    class ImmutableIconActionListener
    implements ActionListener {
        ImmutableIconActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CreateGamePlayerPanel.this.slot.isOccupied()) {
                CreateGamePlayerPanel.this.slot.setState(PlayerSlot.SlotState.OPEN);
                CreateGamePlayerPanel.this.sendLeaveSlotMessage(CreateGamePlayerPanel.this.slot);
            } else {
                CreateGamePlayerPanel.this.slot.setState(PlayerSlot.SlotState.OWN);
                CreateGamePlayerPanel.this.sendTakeSlotMessage(CreateGamePlayerPanel.this.slot);
            }
        }
    }

    class NicknameUpdater
    extends Thread
    implements CaretListener,
    FocusListener {
        private boolean stopped;
        private String update;

        NicknameUpdater() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            JTextField field = (JTextField)e.getSource();
            this.update = field.getText();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField field = (JTextField)e.getSource();
            this.update = field.getText();
        }

        private void requestUpdate() {
            if (CreateGamePlayerPanel.this.slot.isOwn() && this.update != null && !this.update.equals(CreateGamePlayerPanel.this.slot.getNickname())) {
                CreateGamePlayerPanel.this.slot.setNickname(this.update);
                CreateGamePlayerPanel.this.sendTakeSlotMessage(CreateGamePlayerPanel.this.slot);
                this.update = null;
            }
        }

        public void setStopped(boolean stopped) {
            this.stopped = stopped;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                if (this.update != null) {
                    this.requestUpdate();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

