/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.event.play.TilePlacedEvent;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.BazaarCapability;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.capability.FairyCapability;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.game.capability.KingAndRobberBaronCapability;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.capability.TradeGoodsCapability;
import com.jcloisterzone.game.capability.WindRoseCapability;
import com.jcloisterzone.game.state.CapabilitiesState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.GameController;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.UiUtils;
import com.jcloisterzone.ui.panel.Playtime;
import com.jcloisterzone.ui.resources.LayeredImageDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class GameOverPanel
extends JPanel {
    public static final ImageIcon COLLAPSE_ICON = UiUtils.scaleImageIcon("sysimages/chevron-left-gray.png", 20, 20);
    public static final ImageIcon EXPAND_ICON = UiUtils.scaleImageIcon("sysimages/chevron-right-gray.png", 20, 20);
    private final Client client;
    private final Game game;
    private JLabel collapseIcon;
    private boolean collapsed;

    public GameOverPanel(Client client, final GameController gc, boolean showPlayAgain) {
        this.client = client;
        this.game = gc.getGame();
        this.setOpaque(true);
        this.setBackground(client.getTheme().getSemiTransparentBg());
        this.setLayout(new MigLayout("ins 20", "[][grow]", "[]20[]"));
        this.add((Component)new PointStatsPanel(), "sx 2, wrap, hidemode 3");
        JButton btn = new JButton(I18nUtils._tr("Leave game", new Object[0]));
        btn.addActionListener(new ActionListener(){
            final /* synthetic */ GameOverPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                gc.leaveGame();
            }
        });
        this.add((Component)btn, "hidemode 3");
        if (showPlayAgain) {
            btn = new JButton(I18nUtils._tr("Play again", new Object[0]));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameOverPanel.this.client.createGame(GameOverPanel.this.game);
                }
            });
            this.add((Component)btn, "gapleft 5, hidemode 3");
        }
        this.collapseIcon = new JLabel(COLLAPSE_ICON);
        this.collapseIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    GameOverPanel.this.setCollapsed(!GameOverPanel.this.isCollapsed());
                    GameOverPanel.this.repaint();
                }
            }
        });
        this.add((Component)this.collapseIcon, "pos 4 4 20 20");
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        for (Component c : this.getComponents()) {
            if (c == this.collapseIcon) continue;
            c.setVisible(!collapsed);
        }
        this.collapseIcon.setIcon(collapsed ? EXPAND_ICON : COLLAPSE_ICON);
    }

    static String formatPlaytimeString(Playtime playtime) {
        return String.format("%d:%02d:%02d/\n%d:%02d:%02d", playtime.getHours(), playtime.getMinutes(), playtime.getSeconds(), playtime.getTotalHours(), playtime.getTotalMinutes(), playtime.getTotalSeconds());
    }

    static String formatPercentageString(Playtime playtime) {
        return String.format("%.0f%%", Float.valueOf(playtime.getPercentage()));
    }

    static int getPlaytimeByPlayer(Game game, Player player) {
        return (int)(game.getClocks().get(player.getIndex()).getTime(game.getClockStart()) / 1000L);
    }

    class PointStatsPanel
    extends JPanel {
        public PointStatsPanel() {
            GameState state = GameOverPanel.this.game.getState();
            CapabilitiesState capabilities = state.getCapabilities();
            boolean hasBazaars = capabilities.contains(BazaarCapability.class) && !state.getBooleanValue(Rule.BAZAAR_NO_AUCTION);
            StringBuilder rowSpec = new StringBuilder("[][]10[][]10[][]20[][][][]");
            if (capabilities.contains(CastleCapability.class)) {
                rowSpec.append("[]");
            }
            rowSpec.append("20");
            if (capabilities.contains(KingAndRobberBaronCapability.class)) {
                rowSpec.append("[][]20");
            }
            if (capabilities.contains(TradeGoodsCapability.class)) {
                rowSpec.append("[]");
            }
            if (capabilities.contains(GoldminesCapability.class)) {
                rowSpec.append("[]");
            }
            if (capabilities.contains(SheepCapability.class)) {
                rowSpec.append("[]");
            }
            if (capabilities.contains(FairyCapability.class)) {
                rowSpec.append("[]");
            }
            if (capabilities.contains(TowerCapability.class)) {
                rowSpec.append("[]");
            }
            if (hasBazaars) {
                rowSpec.append("[]");
            }
            if (capabilities.contains(WindRoseCapability.class)) {
                rowSpec.append("[]");
            }
            this.setOpaque(false);
            this.setLayout(new MigLayout("ins 0", "", rowSpec.toString()));
            int gridx = 0;
            int gridy = 1;
            this.add((Component)new JLabel(I18nUtils._tr("Player", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Rank", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Total points", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Tiles placed", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Time consumed:(Player/Game)", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Time consumed:(Percentage)", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Roads", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Cities", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Cloisters", new Object[0])), this.getLegendSpec(0, gridy++));
            this.add((Component)new JLabel(I18nUtils._tr("Farms", new Object[0])), this.getLegendSpec(0, gridy++));
            if (capabilities.contains(CastleCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Castles", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(KingAndRobberBaronCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("The biggest city", new Object[0])), this.getLegendSpec(0, gridy++));
                this.add((Component)new JLabel(I18nUtils._tr("The longest road", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(TradeGoodsCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Trade goods", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(GoldminesCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Gold", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(SheepCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Sheep", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(FairyCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Fairy", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(TowerCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Tower ransom", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (hasBazaars) {
                this.add((Component)new JLabel(I18nUtils._tr("Bazaars", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            if (capabilities.contains(WindRoseCapability.class)) {
                this.add((Component)new JLabel(I18nUtils._tr("Wind rose", new Object[0])), this.getLegendSpec(0, gridy++));
            }
            Player[] players = this.getSortedPlayers().toArray(new Player[state.getPlayers().length()]);
            int totalSecondsPlayed = 0;
            for (Player player : players) {
                totalSecondsPlayed += GameOverPanel.getPlaytimeByPlayer(GameOverPanel.this.game, player);
            }
            for (Player player : players) {
                gridy = 0;
                Color color = player.getColors().getMeepleColor();
                Image img = GameOverPanel.this.client.getResourceManager().getLayeredImage(new LayeredImageDescriptor(SmallFollower.class, color));
                ImageIcon icon = new ImageIcon(img.getScaledInstance(32, 32, 4));
                this.add((Component)new JLabel(icon, 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel(player.getNick(), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel(this.getRank(players, gridx), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel("" + player.getPoints(state), 0), this.getSpec(gridx, gridy++));
                int tilesPlaced = state.getEvents().filter(ev -> ev instanceof TilePlacedEvent && Integer.valueOf(player.getIndex()).equals(ev.getMetadata().getTriggeringPlayerIndex())).size();
                this.add((Component)new JLabel("" + tilesPlaced, 0), this.getSpec(gridx, gridy++));
                Playtime playtime = new Playtime(GameOverPanel.this.game, player, totalSecondsPlayed);
                this.add((Component)new JLabel(GameOverPanel.formatPlaytimeString(playtime), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel(GameOverPanel.formatPercentageString(playtime), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.ROAD), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.CITY), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.CLOISTER), 0), this.getSpec(gridx, gridy++));
                this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.FARM), 0), this.getSpec(gridx, gridy++));
                if (capabilities.contains(CastleCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.CASTLE), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(KingAndRobberBaronCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.BIGGEST_CITY), 0), this.getSpec(gridx, gridy++));
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.LONGEST_ROAD), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(TradeGoodsCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.TRADE_GOODS), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(GoldminesCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.GOLD), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(SheepCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.SHEEP), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(FairyCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.FAIRY), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(TowerCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.TOWER_RANSOM), 0), this.getSpec(gridx, gridy++));
                }
                if (hasBazaars) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.BAZAAR_AUCTION), 0), this.getSpec(gridx, gridy++));
                }
                if (capabilities.contains(WindRoseCapability.class)) {
                    this.add((Component)new JLabel("" + player.getPointsInCategory(state, PointCategory.WIND_ROSE), 0), this.getSpec(gridx, gridy++));
                }
                ++gridx;
            }
        }

        private String getRank(Player[] players, int i) {
            GameState state = GameOverPanel.this.game.getState();
            int endrank = i + 1;
            while (i > 0 && players[i - 1].getPoints(state) == players[i].getPoints(state)) {
                --i;
            }
            while (endrank < players.length && players[endrank].getPoints(state) == players[i].getPoints(state)) {
                ++endrank;
            }
            if (endrank == i + 1) {
                return "" + endrank;
            }
            return i + 1 + " - " + endrank;
        }

        private String getLegendSpec(int x, int y) {
            return "cell " + x + " " + y + ", width 170::";
        }

        private String getSpec(int x, int y) {
            return "cell " + x + " " + y + ", width 120::, right";
        }

        private List<Player> getSortedPlayers() {
            final GameState state = GameOverPanel.this.game.getState();
            List<Player> players = state.getPlayers().getPlayers().toJavaList();
            Collections.sort(players, new Comparator<Player>(){
                final /* synthetic */ PointStatsPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public int compare(Player o1, Player o2) {
                    if (o1.getPoints(state) < o2.getPoints(state)) {
                        return 1;
                    }
                    if (o1.getPoints(state) > o2.getPoints(state)) {
                        return -1;
                    }
                    return o1.getNick().compareToIgnoreCase(o2.getNick());
                }
            });
            return players;
        }
    }
}

