/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.panel;

import com.jcloisterzone.config.Config;
import java.util.ArrayList;
import java.util.List;

public class NameProvider {
    private List<ReservedName> aiNames = new ArrayList<ReservedName>();
    private List<ReservedName> playerNames = new ArrayList<ReservedName>();

    public NameProvider(Config config) {
        Config.PlayersConfig playersConfig = config.getPlayers();
        this.initNames(this.playerNames, playersConfig == null ? null : playersConfig.getNames());
        this.initNames(this.aiNames, playersConfig == null ? null : playersConfig.getAi_names());
    }

    private void initNames(List<ReservedName> lrn, List<String> names) {
        if (names != null) {
            for (String name : names) {
                lrn.add(new ReservedName(name, null));
            }
        }
    }

    public synchronized String reserveName(boolean ai, int slot) {
        List<ReservedName> lrn = ai ? this.aiNames : this.playerNames;
        for (ReservedName rn : lrn) {
            if (rn.slot != null) continue;
            rn.slot = slot;
            return rn.name;
        }
        return "";
    }

    public synchronized void releaseName(boolean ai, int slot) {
        List<ReservedName> lrn = ai ? this.aiNames : this.playerNames;
        for (ReservedName rn : lrn) {
            if (rn.slot == null || rn.slot != slot) continue;
            rn.slot = null;
            return;
        }
    }

    private static class ReservedName {
        String name;
        Integer slot;

        public ReservedName(String name, Integer slot) {
            this.name = name;
            this.slot = slot;
        }
    }
}

