/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.resources;

import com.jcloisterzone.board.Position;
import com.jcloisterzone.ui.resources.AreaRotationScaling;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class FeatureArea {
    public static final int DEFAULT_FARM_ZINDEX = 10;
    public static final int DEFAULT_CITY_ZINDEX = 20;
    public static final int DEFAULT_ROAD_ZINDEX = 30;
    public static final int DEFAULT_STRUCTURE_ZINDEX = 40;
    public static final int DEFAULT_BRIDGE_ZINDEX = 50;
    private final Area trackingArea;
    private final Area displayArea;
    private final int zIndex;
    private final Color forceAreaColor;
    private final AreaRotationScaling rotationScaling;
    private final boolean fixed;

    public FeatureArea(Area trackingArea, int zIndex) {
        this(trackingArea, null, zIndex, null, AreaRotationScaling.NORMAL, false);
    }

    public FeatureArea(Area trackingArea, Area displayArea, int zIndex) {
        this(trackingArea, displayArea, zIndex, null, AreaRotationScaling.NORMAL, false);
    }

    private FeatureArea(Area trackingArea, Area displayArea, int zIndex, Color forceAreaColor, AreaRotationScaling rotationScaling, boolean fixed) {
        this.trackingArea = trackingArea;
        this.displayArea = displayArea;
        this.zIndex = zIndex;
        this.forceAreaColor = forceAreaColor;
        this.rotationScaling = rotationScaling;
        this.fixed = fixed;
    }

    public FeatureArea transform(AffineTransform t) {
        Area trackingArea = null;
        Area displayArea = null;
        if (this.trackingArea != null) {
            trackingArea = this.trackingArea.createTransformedArea(t);
        }
        if (this.displayArea != null) {
            displayArea = this.displayArea.createTransformedArea(t);
        }
        return new FeatureArea(trackingArea, displayArea, this.zIndex, this.forceAreaColor, this.rotationScaling, this.fixed);
    }

    public FeatureArea translateTo(Position pos) {
        AffineTransform tx = AffineTransform.getTranslateInstance(pos.x * 1000, pos.y * 1000);
        return this.transform(tx);
    }

    public FeatureArea subtract(FeatureArea fa) {
        return this.subtract(fa.getTrackingArea());
    }

    public FeatureArea subtract(Area area) {
        Area trackingArea = null;
        Area displayArea = null;
        if (this.trackingArea != null) {
            trackingArea = new Area(this.trackingArea);
            trackingArea.subtract(area);
        }
        if (this.displayArea != null) {
            displayArea = new Area(this.displayArea);
            displayArea.subtract(area);
        }
        return new FeatureArea(trackingArea, displayArea, this.zIndex, this.forceAreaColor, this.rotationScaling, this.fixed);
    }

    public Area getTrackingArea() {
        return this.trackingArea;
    }

    public Area getDisplayArea() {
        return this.displayArea == null ? this.trackingArea : this.displayArea;
    }

    public int getzIndex() {
        return this.zIndex;
    }

    public Color getForceAreaColor() {
        return this.forceAreaColor;
    }

    public AreaRotationScaling getRotationScaling() {
        return this.rotationScaling;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public FeatureArea setForceAreaColor(Color forceAreaColor) {
        return new FeatureArea(this.trackingArea, this.displayArea, this.zIndex, forceAreaColor, this.rotationScaling, this.fixed);
    }

    public FeatureArea setRotationScaling(AreaRotationScaling rotationScaling) {
        return new FeatureArea(this.trackingArea, this.displayArea, this.zIndex, this.forceAreaColor, rotationScaling, this.fixed);
    }

    public FeatureArea setFixed(boolean fixed) {
        return new FeatureArea(this.trackingArea, this.displayArea, this.zIndex, this.forceAreaColor, this.rotationScaling, fixed);
    }

    public FeatureArea setZIndex(int zIndex) {
        return new FeatureArea(this.trackingArea, this.displayArea, zIndex, this.forceAreaColor, this.rotationScaling, this.fixed);
    }

    public String toString() {
        return this.zIndex + "/" + this.trackingArea.toString();
    }
}

