/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.view;

import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.EventProxyUiController;
import com.jcloisterzone.ui.UIEventListener;
import com.jcloisterzone.ui.view.UiView;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.util.LinkedList;

public abstract class AbstractUiView
implements UiView {
    protected final Client client;

    public AbstractUiView(Client client) {
        this.client = client;
    }

    @Override
    public boolean requestHide(UiView nextView) {
        return true;
    }

    @Override
    public void hide(UiView nextView) {
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        return false;
    }

    @Override
    public void onWebsocketError(Exception ex) {
        this.client.onUnhandledWebsocketError(ex);
    }

    @Override
    public void onWebsocketClose(int code, String reason, boolean remote) {
    }

    public Client getClient() {
        return this.client;
    }

    public void registerChildComponents(Container root, EventProxyUiController<?> ctrl) {
        LinkedList<Component> list = new LinkedList<Component>();
        list.add(root);
        while (!list.isEmpty()) {
            Component comp = (Component)list.pop();
            if (comp instanceof UIEventListener) {
                ((UIEventListener)((Object)comp)).registerTo(ctrl);
            }
            if (!(comp instanceof Container)) continue;
            for (Component child : ((Container)comp).getComponents()) {
                list.push(child);
            }
        }
    }

    public void unregisterChildComponents(Container root, EventProxyUiController<?> ctrl) {
        LinkedList<Component> list = new LinkedList<Component>();
        list.add(root);
        while (!list.isEmpty()) {
            Component comp = (Component)list.pop();
            if (comp instanceof UIEventListener) {
                ((UIEventListener)((Object)comp)).unregisterFrom(ctrl);
            }
            if (!(comp instanceof Container)) continue;
            for (Component child : ((Container)comp).getComponents()) {
                list.push(child);
            }
        }
    }
}

