/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.ui.view;

import com.jcloisterzone.ui.ChannelController;
import com.jcloisterzone.ui.Client;
import com.jcloisterzone.ui.MenuBar;
import com.jcloisterzone.ui.controls.chat.ChatPanel;
import com.jcloisterzone.ui.panel.ChannelPanel;
import com.jcloisterzone.ui.view.AbstractUiView;
import com.jcloisterzone.ui.view.StartView;
import com.jcloisterzone.ui.view.UiView;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

public class ChannelView
extends AbstractUiView {
    private final ChannelController cc;
    private ChannelPanel channelPanel;
    private ChatPanel chatPanel;

    public ChannelView(Client client, ChannelController cc) {
        super(client);
        this.cc = cc;
    }

    @Override
    public void show(Container pane) {
        this.channelPanel = new ChannelPanel(this.client, this.cc);
        pane.add(this.channelPanel);
        this.chatPanel = this.channelPanel.getChatPanel();
        this.cc.setChannelPanel(this.channelPanel);
        this.registerChildComponents(this.channelPanel, this.cc);
        MenuBar menu = this.client.getJMenuBar();
        menu.setItemActionListener(MenuBar.MenuItem.DISCONNECT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelView.this.cc.getConnection().close();
                ChannelView.this.client.mountView(new StartView(ChannelView.this.client));
            }
        });
        menu.setItemEnabled(MenuBar.MenuItem.LOAD, false);
        menu.setItemEnabled(MenuBar.MenuItem.NEW_GAME, false);
        menu.setItemEnabled(MenuBar.MenuItem.CONNECT_P2P, false);
        menu.setItemEnabled(MenuBar.MenuItem.PLAY_ONLINE, false);
        menu.setItemEnabled(MenuBar.MenuItem.DISCONNECT, true);
    }

    @Override
    public void hide(UiView nextView) {
        this.unregisterChildComponents(this.channelPanel, this.cc);
        MenuBar menu = this.client.getJMenuBar();
        if (nextView instanceof StartView) {
            menu.setItemEnabled(MenuBar.MenuItem.DISCONNECT, false);
            menu.setItemEnabled(MenuBar.MenuItem.LOAD, true);
            menu.setItemEnabled(MenuBar.MenuItem.NEW_GAME, true);
            menu.setItemEnabled(MenuBar.MenuItem.CONNECT_P2P, true);
            menu.setItemEnabled(MenuBar.MenuItem.PLAY_ONLINE, true);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.chatPanel.getInput().hasFocus()) {
            return false;
        }
        if (e.getID() == 401 && (e.getKeyChar() == '`' || e.getKeyChar() == ';')) {
            e.consume();
            this.chatPanel.activateChat();
            return true;
        }
        return false;
    }

    @Override
    public void onWebsocketClose(int code, String reason, boolean remote) {
        this.client.mountView(new StartView(this.client));
    }
}

