/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.wsio.message.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.jcloisterzone.game.Rule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RulesMapAdapter
extends TypeAdapter<Map<Rule, Object>> {
    @Override
    public void write(JsonWriter out, Map<Rule, Object> value) throws IOException {
        out.beginObject();
        for (Map.Entry<Rule, Object> entry : value.entrySet()) {
            out.name(entry.getKey().name());
            if (entry.getValue() instanceof Boolean) {
                out.value((Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                out.value((Integer)entry.getValue());
                continue;
            }
            out.value(entry.getValue().toString());
        }
        out.endObject();
    }

    @Override
    public Map<Rule, Object> read(JsonReader in) throws IOException {
        HashMap<Rule, Object> result = new HashMap<Rule, Object>();
        in.beginObject();
        while (in.hasNext()) {
            Rule rule = Rule.valueOf(in.nextName());
            JsonToken p = in.peek();
            if (p == JsonToken.BOOLEAN) {
                result.put(rule, in.nextBoolean());
                continue;
            }
            if (p == JsonToken.NUMBER) {
                result.put(rule, in.nextInt());
                continue;
            }
            result.put(rule, rule.unpackValue(in.nextString()));
        }
        in.endObject();
        return result;
    }
}

