/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.wsio.server;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.KeyUtils;
import com.jcloisterzone.VersionComparator;
import com.jcloisterzone.ai.AiPlayer;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Game;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.PlayerSlot;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.StandardGameCapability;
import com.jcloisterzone.game.save.SavedGame;
import com.jcloisterzone.wsio.MessageDispatcher;
import com.jcloisterzone.wsio.MessageParser;
import com.jcloisterzone.wsio.WsSubscribe;
import com.jcloisterzone.wsio.message.BazaarBidMessage;
import com.jcloisterzone.wsio.message.BazaarBuyOrSellMessage;
import com.jcloisterzone.wsio.message.CaptureFollowerMessage;
import com.jcloisterzone.wsio.message.ChatMessage;
import com.jcloisterzone.wsio.message.ClientUpdateMessage;
import com.jcloisterzone.wsio.message.CommitMessage;
import com.jcloisterzone.wsio.message.CornCircleRemoveOrDeployMessage;
import com.jcloisterzone.wsio.message.DeployFlierMessage;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import com.jcloisterzone.wsio.message.ErrorMessage;
import com.jcloisterzone.wsio.message.ExchangeFollowerChoiceMessage;
import com.jcloisterzone.wsio.message.FlockMessage;
import com.jcloisterzone.wsio.message.GameMessage;
import com.jcloisterzone.wsio.message.GameOverMessage;
import com.jcloisterzone.wsio.message.GameSetupMessage;
import com.jcloisterzone.wsio.message.HelloMessage;
import com.jcloisterzone.wsio.message.LeaveSlotMessage;
import com.jcloisterzone.wsio.message.MoveNeutralFigureMessage;
import com.jcloisterzone.wsio.message.PassMessage;
import com.jcloisterzone.wsio.message.PayRansomMessage;
import com.jcloisterzone.wsio.message.PingMessage;
import com.jcloisterzone.wsio.message.PlaceTileMessage;
import com.jcloisterzone.wsio.message.PlaceTokenMessage;
import com.jcloisterzone.wsio.message.PongMessage;
import com.jcloisterzone.wsio.message.PostChatMessage;
import com.jcloisterzone.wsio.message.ReturnMeepleMessage;
import com.jcloisterzone.wsio.message.SetCapabilityMessage;
import com.jcloisterzone.wsio.message.SetExpansionMessage;
import com.jcloisterzone.wsio.message.SetRuleMessage;
import com.jcloisterzone.wsio.message.SlotMessage;
import com.jcloisterzone.wsio.message.StartGameMessage;
import com.jcloisterzone.wsio.message.SyncGameMessage;
import com.jcloisterzone.wsio.message.TakeSlotMessage;
import com.jcloisterzone.wsio.message.UndoMessage;
import com.jcloisterzone.wsio.message.WelcomeMessage;
import com.jcloisterzone.wsio.message.WsChainedMessage;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import com.jcloisterzone.wsio.message.WsMessage;
import com.jcloisterzone.wsio.message.WsReplayableMessage;
import com.jcloisterzone.wsio.message.WsSaltMessage;
import com.jcloisterzone.wsio.server.RemoteClient;
import com.jcloisterzone.wsio.server.ServerPlayerSlot;
import com.jcloisterzone.wsio.server.ServerRemoteClient;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServer
extends WebSocketServer {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SimpleServerErrorHandler errHandler;
    private MessageParser parser = new MessageParser();
    private MessageDispatcher dispatcher = new MessageDispatcher();
    private GameSetup gameSetup;
    private String gameId;
    private long initialSeed;
    protected final ServerPlayerSlot[] slots;
    protected int slotSerial;
    private List<WsReplayableMessage> replay;
    private SavedGame savedGame;
    private boolean gameStarted;
    private Long clockStart;
    private String chainMessageId;
    protected Map<WebSocket, ServerRemoteClient> connections = HashMap.empty();
    protected Set<String> alreadyReceived = new HashSet<String>();
    private String hostClientId;
    private Random random = new Random();

    public SimpleServer(InetSocketAddress address, SimpleServerErrorHandler errHandler) {
        super(address);
        this.errHandler = errHandler;
        this.slots = new ServerPlayerSlot[6];
    }

    public void createGame(SavedGame savedGame, Game game, String hostClientId) {
        this.slotSerial = 0;
        this.gameStarted = false;
        this.savedGame = savedGame;
        this.hostClientId = hostClientId;
        if (savedGame != null) {
            this.gameId = savedGame.getGameId();
            this.initialSeed = savedGame.getInitialSeed();
            this.gameSetup = savedGame.getSetup().asGameSetup();
            this.replay = new ArrayList<WsReplayableMessage>(savedGame.getReplay());
            this.loadSlotsFromSavedGame(savedGame);
        } else {
            this.gameId = KeyUtils.createRandomId();
            this.initialSeed = this.random.nextLong();
            this.replay = new ArrayList<WsReplayableMessage>();
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = new ServerPlayerSlot(i);
            }
            if (game == null) {
                this.gameSetup = new GameSetup(HashMap.of(Expansion.BASIC, 1), io.vavr.collection.HashSet.of(StandardGameCapability.class), Rule.getDefaultRules());
            } else {
                this.gameSetup = game.getSetup();
                int maxSerial = 0;
                for (PlayerSlot slot : game.getPlayerSlots()) {
                    boolean ownedByCreator;
                    boolean bl = ownedByCreator = hostClientId != null && hostClientId.equals(slot.getClientId());
                    if (!ownedByCreator && slot.getAiClassName() == null) continue;
                    int idx = slot.getNumber();
                    this.slots[idx].setAutoAssignClientId(hostClientId);
                    this.slots[idx].setNickname(slot.getNickname());
                    this.slots[idx].setSerial(slot.getSerial());
                    this.slots[idx].setAiClassName(slot.getAiClassName());
                    if (slot.getAiClassName() != null) {
                        try {
                            AiPlayer aiPlayer = (AiPlayer)Class.forName(slot.getAiClassName()).newInstance();
                            this.slots[idx].setSupportedSetup(aiPlayer.supportedSetup());
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), e);
                        }
                    }
                    maxSerial = Math.max(maxSerial, slot.getSerial());
                }
                this.slotSerial = maxSerial + 1;
            }
        }
    }

    private void loadSlotsFromSavedGame(SavedGame savedGame) {
        int maxSerial = 0;
        for (SavedGame.SavedGamePlayerSlot sgSlot : savedGame.getSlots()) {
            int idx = sgSlot.getNumber();
            this.slots[idx] = new ServerPlayerSlot(idx);
            this.slots[idx].setAutoAssignClientId(sgSlot.getClientId());
            this.slots[idx].setNickname(sgSlot.getNickname());
            this.slots[idx].setSerial(sgSlot.getSerial());
            this.slots[idx].setAiClassName(sgSlot.getAiClassName());
            maxSerial = Math.max(maxSerial, sgSlot.getSerial());
        }
        this.slotSerial = maxSerial + 1;
    }

    @Override
    public void onClose(WebSocket ws, int code, String reason, boolean remote) {
        if (!remote) {
            return;
        }
        RemoteClient conn = (RemoteClient)this.connections.get(ws).getOrNull();
        if (conn == null) {
            return;
        }
        this.connections = this.connections.remove(ws);
        for (ServerPlayerSlot slot : this.slots) {
            if (slot == null || !conn.getSessionId().equals(slot.getSessionId())) continue;
            if (!this.gameStarted) {
                this.leaveSlot(slot);
                continue;
            }
            slot.setSessionId(null);
            this.broadcast(this.newSlotMessage(slot));
        }
        ClientUpdateMessage msg = new ClientUpdateMessage(conn.getSessionId(), null, ClientUpdateMessage.ClientState.OFFLINE);
        msg.setGameId(this.gameId);
        this.broadcast(msg);
    }

    @Override
    public void onError(WebSocket ws, Exception ex) {
        this.errHandler.onError(ws, ex);
    }

    @Override
    public synchronized void onMessage(WebSocket ws, String payload) {
        this.logger.info(payload);
        WsMessage msg = this.parser.fromJson(payload);
        if (this.alreadyReceived.contains(msg.getMessageId())) {
            this.logger.info("Dropping already received message. " + payload);
        } else {
            if (msg instanceof WsChainedMessage) {
                String parentId = ((WsChainedMessage)((Object)msg)).getParentId();
                if (parentId != null && !parentId.equals(this.chainMessageId)) {
                    this.logger.info("Invalid parent id");
                    return;
                }
                this.chainMessageId = msg.getMessageId();
            }
            this.alreadyReceived.add(msg.getMessageId());
            this.dispatcher.dispatch(msg, ws, this);
        }
    }

    @Override
    public void onOpen(WebSocket ws, ClientHandshake hs) {
    }

    private String getSessionId(WebSocket ws) {
        return this.connections.get(ws).get().getSessionId();
    }

    private SlotMessage newSlotMessage(ServerPlayerSlot slot) {
        SlotMessage msg = new SlotMessage(slot.getNumber(), slot.getSerial(), slot.getSessionId(), slot.getClientId(), slot.getNickname());
        msg.setGameId(this.gameId);
        msg.setAiClassName(slot.getAiClassName());
        msg.setSupportedSetup(slot.getSupportedSetup());
        return msg;
    }

    @Override
    public void start() {
        super.start();
    }

    private GameMessage newGameMessage(boolean includeReplay) {
        GameSetupMessage setupMessage = new GameSetupMessage(this.gameSetup.getRules().toJavaMap(), this.gameSetup.getCapabilities().toJavaSet(), this.gameSetup.getExpansions().toJavaMap());
        setupMessage.setGameId(this.gameId);
        GameMessage.GameStatus status = this.gameStarted ? GameMessage.GameStatus.RUNNING : (this.savedGame == null ? GameMessage.GameStatus.OPEN : GameMessage.GameStatus.PAUSED);
        GameMessage gm = new GameMessage(this.gameId, "", status, setupMessage);
        gm.setInitialSeed(this.initialSeed);
        gm.setClockStart(this.clockStart);
        ArrayList<SlotMessage> slotMsgs = new ArrayList<SlotMessage>();
        for (ServerPlayerSlot slot : this.slots) {
            if (slot == null) continue;
            SlotMessage sm = this.newSlotMessage(slot);
            slotMsgs.add(sm);
        }
        gm.setSlots(slotMsgs.toArray(new SlotMessage[slotMsgs.size()]));
        if (includeReplay) {
            gm.setReplay(this.replay);
        }
        return gm;
    }

    private String getWebsocketHost(WebSocket ws) {
        if (ws.getRemoteSocketAddress().getAddress().isLoopbackAddress()) {
            return "localhost";
        }
        return ws.getRemoteSocketAddress().getHostName();
    }

    @WsSubscribe
    public void handlePing(WebSocket ws, PingMessage msg) {
        this.send(ws, new PongMessage());
    }

    private boolean isParticipant(String clientId, String secret) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || !clientId.equals(this.slots[i].getClientId()) || !secret.equals(this.slots[i].getSecret())) continue;
            return true;
        }
        return false;
    }

    private boolean shouldAutoAssign(HelloMessage msg, String sessionId, ServerPlayerSlot slot) {
        if (this.gameStarted) {
            return msg.getClientId().equals(slot.getClientId()) && msg.getSecret().equals(slot.getSecret());
        }
        if (slot.getSessionId() == null) {
            boolean isHostClient = msg.getClientId().equals(this.hostClientId);
            return msg.getClientId().equals(slot.getAutoAssignClientId()) || isHostClient && slot.getAiClassName() != null;
        }
        return false;
    }

    private long createSalt() {
        return System.currentTimeMillis();
    }

    private void closeStaleConnections(String sessionId) {
        this.connections.filter((ws, client) -> client.getSessionId() == sessionId).forEach((ws, client) -> ws.close());
    }

    @WsSubscribe
    public void handleHello(WebSocket ws, HelloMessage msg) {
        if (new VersionComparator().compare("4.6.0", msg.getProtocolVersion()) != 0) {
            this.send(ws, new ErrorMessage("badVersion", "Protocol version 4.6.0 required."));
            ws.close();
            return;
        }
        if (this.gameStarted && !this.isParticipant(msg.getClientId(), msg.getSecret())) {
            this.send(ws, new ErrorMessage("notAllowed", "Join not allowed."));
            ws.close();
            return;
        }
        String nickname = msg.getNickname() + '@' + this.getWebsocketHost(ws);
        String sessionId = KeyUtils.createRandomId();
        ServerRemoteClient client = new ServerRemoteClient(sessionId, nickname, ClientUpdateMessage.ClientState.ACTIVE);
        client.setClientId(msg.getClientId());
        client.setSecret(msg.getSecret());
        for (ServerPlayerSlot slot : this.slots) {
            if (slot == null || !this.shouldAutoAssign(msg, sessionId, slot)) continue;
            if (this.gameStarted && slot.getSessionId() != null) {
                this.closeStaleConnections(slot.getSessionId());
            }
            slot.setClientId(msg.getClientId());
            slot.setSessionId(sessionId);
            slot.setSecret(msg.getSecret());
            this.broadcast(this.newSlotMessage(slot));
        }
        this.connections = this.connections.put(ws, client);
        this.send(ws, new WelcomeMessage(sessionId, nickname, 120, System.currentTimeMillis()));
        this.send(ws, this.newGameMessage(this.gameStarted));
        for (ServerRemoteClient rc : this.connections.values()) {
            if (rc.getSessionId().equals(sessionId)) continue;
            ClientUpdateMessage updateMsg = new ClientUpdateMessage(rc.getSessionId(), rc.getName(), ClientUpdateMessage.ClientState.ACTIVE);
            updateMsg.setGameId(this.gameId);
            this.send(ws, updateMsg);
        }
        ClientUpdateMessage updateMsg = new ClientUpdateMessage(sessionId, nickname, ClientUpdateMessage.ClientState.ACTIVE);
        updateMsg.setGameId(this.gameId);
        this.broadcast(updateMsg);
    }

    @WsSubscribe
    public void handleGameSetupMessage(WebSocket ws, GameSetupMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        this.gameSetup = new GameSetup(HashMap.ofAll(msg.getExpansions()), io.vavr.collection.HashSet.ofAll(msg.getCapabilities()), HashMap.ofAll(msg.getRules()));
        this.broadcast(msg);
    }

    @WsSubscribe
    public void handleTakeSlot(WebSocket ws, TakeSlotMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        ServerRemoteClient client = this.connections.get(ws).get();
        String sessionId = client.getSessionId();
        int number = msg.getNumber();
        if (number < 0 || number >= this.slots.length || this.slots[number] == null) {
            this.send(ws, new ErrorMessage("TAKE_SLOT", "Invalid slot number"));
            return;
        }
        ServerPlayerSlot slot = this.slots[number];
        if (!slot.isOccupied()) {
            slot.setSerial(++this.slotSerial);
        }
        slot.setNickname(msg.getNickname());
        slot.setAiClassName(msg.getAiClassName());
        slot.setSessionId(sessionId);
        slot.setSupportedSetup(msg.getSupportedSetup());
        slot.setClientId(client.getClientId());
        slot.setSecret(client.getSecret());
        this.broadcast(this.newSlotMessage(slot));
    }

    private void leaveSlot(ServerPlayerSlot slot) {
        if (this.savedGame == null) {
            slot.setNickname(null);
            slot.setAiClassName(null);
            slot.setSupportedSetup(null);
        }
        slot.setSerial(null);
        slot.setSessionId(null);
        slot.setClientId(null);
        slot.setSecret(null);
        this.broadcast(this.newSlotMessage(slot));
    }

    @WsSubscribe
    public void handleLeaveSlot(WebSocket ws, LeaveSlotMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        int number = msg.getNumber();
        if (number < 0 || number >= this.slots.length || this.slots[number] == null) {
            this.send(ws, new ErrorMessage("LEAVE_SLOT", "Invalid slot number"));
            return;
        }
        ServerPlayerSlot slot = this.slots[number];
        this.leaveSlot(slot);
    }

    @WsSubscribe
    public void handleSetExpansion(WebSocket ws, SetExpansionMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        Expansion expansion = msg.getExpansion();
        this.gameSetup = this.gameSetup.mapExpansions(expansions -> msg.getCount() > 0 ? expansions.put(expansion, msg.getCount()) : expansions.remove(expansion));
        this.broadcast(msg);
    }

    @WsSubscribe
    public void handleSetRule(WebSocket ws, SetRuleMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        Rule rule = msg.getRule();
        this.gameSetup = this.gameSetup.mapRules(rules -> msg.getValue() == null ? rules.remove(rule) : rules.put(rule, msg.getValue()));
        this.broadcast(msg);
    }

    @WsSubscribe
    public void handleSetCapability(WebSocket ws, SetCapabilityMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        Class<? extends Capability<?>> cap = msg.getCapability();
        this.gameSetup = this.gameSetup.mapCapabilities(cps -> msg.isEnabled() ? cps.add(cap) : cps.remove(cap));
        this.broadcast(msg);
    }

    @WsSubscribe
    public void handleStartGame(WebSocket ws, StartGameMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (this.gameStarted) {
            throw new IllegalArgumentException("Game is already started.");
        }
        if (this.savedGame == null) {
            int playerCount = 0;
            for (ServerPlayerSlot slot : this.slots) {
                if (!slot.isOccupied()) continue;
                ++playerCount;
                if (!this.gameSetup.getBooleanValue(Rule.RANDOM_SEATING_ORDER)) continue;
                slot.setSerial(this.random.nextInt());
            }
            this.clockStart = System.currentTimeMillis();
        } else {
            this.clockStart = System.currentTimeMillis() - this.savedGame.getClock();
        }
        this.gameStarted = true;
        this.broadcast(this.newGameMessage(true));
    }

    private void handleInGameMessage(WsInGameMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (!this.gameStarted) {
            throw new IllegalArgumentException("Game is not started.");
        }
        if (msg instanceof WsSaltMessage) {
            ((WsSaltMessage)msg).setSalt(this.createSalt());
        }
        this.broadcast(msg);
    }

    @WsSubscribe
    public void handleSyncGame(WebSocket ws, SyncGameMessage msg) {
        this.send(ws, this.newGameMessage(this.gameStarted));
    }

    @WsSubscribe
    public void handleDeployFlier(WebSocket ws, DeployFlierMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleCommit(WebSocket ws, CommitMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handlePass(WebSocket ws, PassMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handlePlaceTile(WebSocket ws, PlaceTileMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleDeployMeeple(WebSocket ws, DeployMeepleMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleReturnMeeple(WebSocket ws, ReturnMeepleMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleMoveNeutralFigureMessage(WebSocket ws, MoveNeutralFigureMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handlePlaceTokenMessage(WebSocket ws, PlaceTokenMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleCaptureFollowerMessage(WebSocket ws, CaptureFollowerMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handlePayRansomMessage(WebSocket ws, PayRansomMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleExchangeFollowerChoiceMessage(WebSocket ws, ExchangeFollowerChoiceMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleBazaarBidMessage(WebSocket ws, BazaarBidMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleBazaarBuyOrSellMessage(WebSocket ws, BazaarBuyOrSellMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleCornCircleRemoveOrDeployMessage(WebSocket ws, CornCircleRemoveOrDeployMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void hadleFlockMessage(WebSocket ws, FlockMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleGameOverMessage(WebSocket ws, GameOverMessage msg) {
        this.handleInGameMessage(msg);
    }

    @WsSubscribe
    public void handleUndo(WebSocket ws, UndoMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        if (!this.gameStarted) {
            throw new IllegalArgumentException("Game is not started.");
        }
        this.replay.remove(this.replay.size() - 1);
        this.broadcast(msg);
    }

    @WsSubscribe
    public void handlePostChat(WebSocket ws, PostChatMessage msg) {
        if (!msg.getGameId().equals(this.gameId)) {
            throw new IllegalArgumentException("Invalid game id.");
        }
        String sessionId = this.getSessionId(ws);
        ChatMessage reMsg = new ChatMessage(sessionId, msg.getText());
        reMsg.setGameId(msg.getGameId());
        this.broadcast(reMsg);
    }

    private void beforeSend(WsMessage msg) {
        if (msg.getMessageId() == null) {
            msg.setMessageId(UUID.randomUUID().toString());
        }
        if (this.gameStarted && msg instanceof WsReplayableMessage) {
            this.replay.add((WsReplayableMessage)msg);
            ((WsReplayableMessage)msg).setClock(System.currentTimeMillis() - this.clockStart);
        }
    }

    public void send(WebSocket ws, WsMessage msg) {
        this.beforeSend(msg);
        ws.send(this.parser.toJson(msg));
    }

    public void broadcast(WsMessage msg) {
        for (WebSocket ws : this.connections.keySet()) {
            if (!ws.isOpen()) continue;
            this.send(ws, msg);
        }
    }

    public static void main(String[] args) {
        final Logger logger = LoggerFactory.getLogger(SimpleServer.class);
        int port = 37447;
        String portStr = System.getProperty("port");
        if (portStr != null && portStr.length() > 0) {
            port = Integer.parseInt(portStr);
        }
        StandaloneSimpleServer server = new StandaloneSimpleServer(new InetSocketAddress(port), new SimpleServerErrorHandler(){

            @Override
            public void onError(WebSocket ws, Exception ex) {
                logger.error(ex.getMessage(), ex);
            }
        });
        server.createGame(null, null, null);
        server.start();
        logger.info("Simple server started on port {}", (Object)port);
    }

    public static interface SimpleServerErrorHandler {
        public void onError(WebSocket var1, Exception var2);
    }

    public static class StandaloneSimpleServer
    extends SimpleServer {
        public StandaloneSimpleServer(InetSocketAddress address, SimpleServerErrorHandler errHandler) {
            super(address, errHandler);
        }

        @WsSubscribe
        public void handleStandaloneGameOver(WebSocket ws, GameOverMessage msg) {
            for (WebSocket conn : this.connections.keySet()) {
                conn.close();
            }
            this.connections = HashMap.empty();
            this.createGame(null, null, null);
            this.logger.info("Game finished. Starting a new one.");
        }
    }
}

