/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.fix.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class UnimplementedCodeFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit root, boolean addMissingMethod, boolean makeTypeAbstract, IProblemLocation[] problems) {
        Assert.isLegal((!addMissingMethod || !makeTypeAbstract ? 1 : 0) != 0);
        if (!addMissingMethod && !makeTypeAbstract) {
            return null;
        }
        if (problems.length == 0) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        IProblemLocation[] iProblemLocationArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            if (addMissingMethod) {
                typeNode = UnimplementedCodeFixCore.getSelectedTypeNode(root, problem);
                if (typeNode != null && !UnimplementedCodeFixCore.isTypeBindingNull(typeNode)) {
                    operations.add(new AddUnimplementedMethodsOperation(typeNode, null));
                }
            } else {
                typeNode = UnimplementedCodeFixCore.getSelectedTypeNode(root, problem);
                if (typeNode instanceof TypeDeclaration) {
                    operations.add(new MakeTypeAbstractOperation((TypeDeclaration)typeNode));
                }
            }
            ++n2;
        }
        if (operations.isEmpty()) {
            return null;
        }
        String label = addMissingMethod ? CorrectionMessages.UnimplementedMethodsCorrectionProposal_description : CorrectionMessages.UnimplementedCodeFix_MakeAbstractFix_label;
        return new UnimplementedCodeFixCore(label, root, operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]));
    }

    public static IProposableFix createAddUnimplementedMethodsFix(CompilationUnit root, IProblemLocation problem) {
        ASTNode typeNode = UnimplementedCodeFixCore.getSelectedTypeNode(root, problem);
        if (typeNode == null) {
            return null;
        }
        if (UnimplementedCodeFixCore.isTypeBindingNull(typeNode)) {
            return null;
        }
        AddUnimplementedMethodsOperation operation = new AddUnimplementedMethodsOperation(typeNode, null);
        if (operation.getMethodsToImplement().length > 0) {
            return new UnimplementedCodeFixCore(CorrectionMessages.UnimplementedMethodsCorrectionProposal_description, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation});
        }
        return null;
    }

    public static UnimplementedCodeFixCore createMakeTypeAbstractFix(CompilationUnit root, IProblemLocation problem) {
        ASTNode typeNode = UnimplementedCodeFixCore.getSelectedTypeNode(root, problem);
        if (!(typeNode instanceof TypeDeclaration)) {
            return null;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)typeNode;
        MakeTypeAbstractOperation operation = new MakeTypeAbstractOperation(typeDeclaration);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, BasicElementLabels.getJavaElementName(typeDeclaration.getName().getIdentifier()));
        return new UnimplementedCodeFixCore(label, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation});
    }

    public static ASTNode getSelectedTypeNode(CompilationUnit root, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(root);
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getNodeType() == 1) {
            selectedNode = selectedNode.getParent();
        }
        if (selectedNode.getLocationInParent() == EnumConstantDeclaration.NAME_PROPERTY) {
            selectedNode = selectedNode.getParent();
        }
        if (selectedNode.getNodeType() == 42 && selectedNode.getParent() instanceof AbstractTypeDeclaration) {
            return selectedNode.getParent();
        }
        if (selectedNode.getNodeType() == 14) {
            return ((ClassInstanceCreation)selectedNode).getAnonymousClassDeclaration();
        }
        if (selectedNode.getNodeType() == 72) {
            EnumConstantDeclaration enumConst = (EnumConstantDeclaration)selectedNode;
            if (enumConst.getAnonymousClassDeclaration() != null) {
                return enumConst.getAnonymousClassDeclaration();
            }
            return enumConst;
        }
        return null;
    }

    private static boolean isTypeBindingNull(ASTNode typeNode) {
        if (typeNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)typeNode;
            return abstractTypeDeclaration.resolveBinding() == null;
        }
        if (typeNode instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)typeNode;
            return anonymousClassDeclaration.resolveBinding() == null;
        }
        return !(typeNode instanceof EnumConstantDeclaration);
    }

    public UnimplementedCodeFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class MakeTypeAbstractOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final TypeDeclaration fTypeDeclaration;

        public MakeTypeAbstractOperation(TypeDeclaration typeDeclaration) {
            this.fTypeDeclaration = typeDeclaration;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedProposalPositions) throws CoreException {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
            TextEditGroup textEditGroup = this.createTextEditGroup(CorrectionMessages.UnimplementedCodeFix_TextEditGroup_label, cuRewrite);
            rewrite.getListRewrite((ASTNode)this.fTypeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, textEditGroup);
            LinkedProposalPositionGroupCore group = new LinkedProposalPositionGroupCore("modifier");
            group.addPosition(rewrite.track((ASTNode)newModifier), !linkedProposalPositions.hasLinkedPositions());
            linkedProposalPositions.addPositionGroup(group);
        }
    }
}

