/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.corext.template.java.AbstractJavaContextTypeCore;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.IJavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.corext.template.java.VarResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class JavaContextType
extends AbstractJavaContextTypeCore {
    public static final String ID_ALL = "java";
    public static final String ID_MEMBERS = "java-members";
    public static final String ID_STATEMENTS = "java-statements";
    public static final String ID_MODULE = "module";

    public JavaContextType(String contextType) {
        this.setId(contextType);
        this.setName(contextType);
    }

    protected void initializeContext(IJavaContext context) {
        if (this.getId().equals(ID_MODULE)) {
            return;
        }
        if (!this.getId().equals(ID_ALL)) {
            context.addCompatibleContextType(ID_ALL);
        }
    }

    public void initializeContextTypeResolvers() {
        super.initializeContextTypeResolvers();
        this.addResolver("var", (TemplateVariableResolver)new VarResolver());
        this.addResolver(new SimpleType());
    }

    public synchronized void addResolver(String type, TemplateVariableResolver resolver) {
        resolver.setType(type);
        this.addResolver(resolver);
    }

    protected static class EnclosingJavaElement
    extends TemplateVariableResolver {
        protected final int fElementType;

        public EnclosingJavaElement(String name, String description, int elementType) {
            super(name, description);
            this.fElementType = elementType;
        }

        protected String resolve(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(this.fElementType);
            if (element instanceof IType) {
                return JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0L);
            }
            return element == null ? null : element.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class SimpleType
    extends EnclosingJavaElement {
        public SimpleType() {
            super("enclosing_simple_type", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_type, 7);
        }
    }
}

