var documenterSearchIndex = {"docs":
[{"location":"#AbstractLattices","page":"AbstractLattices","title":"AbstractLattices","text":"","category":"section"},{"location":"","page":"AbstractLattices","title":"AbstractLattices","text":"This module defines ∨ (for join) and ∧ (for meet) as binary operators so other modules can import them for their own purposes.","category":"page"},{"location":"","page":"AbstractLattices","title":"AbstractLattices","text":"We also define dist so distance can be defined in various modules. ","category":"page"},{"location":"#Usage","page":"AbstractLattices","title":"Usage","text":"","category":"section"},{"location":"","page":"AbstractLattices","title":"AbstractLattices","text":"Two of my modules use the meet and join operators. Here's what happens when we don't first define them via this module:","category":"page"},{"location":"","page":"AbstractLattices","title":"AbstractLattices","text":"julia> using SimplePartitions\n\njulia> using ClosedIntervals\n\njulia> A = 3..5\n[3,5]\n\njulia> B = 6..10\n[6,10]\n\njulia> A ∨ B\nWARNING: both ClosedIntervals and SimplePartitions export \"∨\"; uses of it in module Main must be qualified\nERROR: UndefVarError: ∨ not defined\nStacktrace:\n [1] top-level scope at none:0","category":"page"},{"location":"","page":"AbstractLattices","title":"AbstractLattices","text":"To fix this, my modules that use these operators need to import them from AbstractLattices.","category":"page"},{"location":"#As-Boolean-operations","page":"AbstractLattices","title":"As Boolean operations","text":"","category":"section"},{"location":"","page":"AbstractLattices","title":"AbstractLattices","text":"The  ∨ and ∧ operations are explicitly defined for Bool values. That is true ∨ false evaluates to true, and so forth.","category":"page"}]
}
