# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: account
using AWS.Compat
using AWS.UUIDs

"""
    accept_primary_email_update(account_id, otp, primary_email)
    accept_primary_email_update(account_id, otp, primary_email, params::Dict{String,<:Any})

Accepts the request that originated from StartPrimaryEmailUpdate to update the primary
email address (also known as the root user email address) for the specified account.

# Arguments
- `account_id`: Specifies the 12-digit account ID number of the Amazon Web Services account
  that you want to access or modify with this operation. To use this parameter, the caller
  must be an identity in the organization's management account or a delegated administrator
  account. The specified account ID must be a member account in the same organization. The
  organization must have all features enabled, and the organization must have trusted access
  enabled for the Account Management service, and optionally a delegated admin account
  assigned. This operation can only be called from the management account or the delegated
  administrator account of an organization for a member account.  The management account
  can't specify its own AccountId.
- `otp`: The OTP code sent to the PrimaryEmail specified on the StartPrimaryEmailUpdate API
  call.
- `primary_email`: The new primary email address for use with the specified account. This
  must match the PrimaryEmail from the StartPrimaryEmailUpdate API call.

"""
function accept_primary_email_update(
    AccountId, Otp, PrimaryEmail; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/acceptPrimaryEmailUpdate",
        Dict{String,Any}(
            "AccountId" => AccountId, "Otp" => Otp, "PrimaryEmail" => PrimaryEmail
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_primary_email_update(
    AccountId,
    Otp,
    PrimaryEmail,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/acceptPrimaryEmailUpdate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId, "Otp" => Otp, "PrimaryEmail" => PrimaryEmail
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_alternate_contact(alternate_contact_type)
    delete_alternate_contact(alternate_contact_type, params::Dict{String,<:Any})

Deletes the specified alternate contact from an Amazon Web Services account. For complete
details about how to use the alternate contact operations, see Access or updating the
alternate contacts.  Before you can update the alternate contact information for an Amazon
Web Services account that is managed by Organizations, you must first enable integration
between Amazon Web Services Account Management and Organizations. For more information, see
Enabling trusted access for Amazon Web Services Account Management.

# Arguments
- `alternate_contact_type`: Specifies which of the alternate contacts to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12 digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you do not specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account, and the specified account ID must
  be a member account in the same organization. The organization must have all features
  enabled, and the organization must have trusted access enabled for the Account Management
  service, and optionally a delegated admin account assigned.  The management account can't
  specify its own AccountId; it must call the operation in standalone context by not
  including the AccountId parameter.  To call this operation on an account that is not a
  member of an organization, then don't specify this parameter, and call the operation using
  an identity belonging to the account whose contacts you wish to retrieve or modify.
"""
function delete_alternate_contact(
    AlternateContactType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/deleteAlternateContact",
        Dict{String,Any}("AlternateContactType" => AlternateContactType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_alternate_contact(
    AlternateContactType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/deleteAlternateContact",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AlternateContactType" => AlternateContactType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_region(region_name)
    disable_region(region_name, params::Dict{String,<:Any})

Disables (opts-out) a particular Region for an account.  The act of disabling a Region will
remove all IAM access to any resources that reside in that Region.

# Arguments
- `region_name`: Specifies the Region-code for a given Region name (for example,
  af-south-1). When you disable a Region, Amazon Web Services performs actions to deactivate
  that Region in your account, such as destroying IAM resources in the Region. This process
  takes a few minutes for most accounts, but this can take several hours. You cannot enable
  the Region until the disabling process is fully completed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12-digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you don't specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account. The specified account ID must be a
  member account in the same organization. The organization must have all features enabled,
  and the organization must have trusted access enabled for the Account Management service,
  and optionally a delegated admin account assigned.  The management account can't specify
  its own AccountId. It must call the operation in standalone context by not including the
  AccountId parameter.  To call this operation on an account that is not a member of an
  organization, don't specify this parameter. Instead, call the operation using an identity
  belonging to the account whose contacts you wish to retrieve or modify.
"""
function disable_region(RegionName; aws_config::AbstractAWSConfig=current_aws_config())
    return account(
        "POST",
        "/disableRegion",
        Dict{String,Any}("RegionName" => RegionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_region(
    RegionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/disableRegion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegionName" => RegionName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_region(region_name)
    enable_region(region_name, params::Dict{String,<:Any})

Enables (opts-in) a particular Region for an account.

# Arguments
- `region_name`: Specifies the Region-code for a given Region name (for example,
  af-south-1). When you enable a Region, Amazon Web Services performs actions to prepare your
  account in that Region, such as distributing your IAM resources to the Region. This process
  takes a few minutes for most accounts, but it can take several hours. You cannot use the
  Region until this process is complete. Furthermore, you cannot disable the Region until the
  enabling process is fully completed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12-digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you don't specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account. The specified account ID must be a
  member account in the same organization. The organization must have all features enabled,
  and the organization must have trusted access enabled for the Account Management service,
  and optionally a delegated admin account assigned.  The management account can't specify
  its own AccountId. It must call the operation in standalone context by not including the
  AccountId parameter.  To call this operation on an account that is not a member of an
  organization, don't specify this parameter. Instead, call the operation using an identity
  belonging to the account whose contacts you wish to retrieve or modify.
"""
function enable_region(RegionName; aws_config::AbstractAWSConfig=current_aws_config())
    return account(
        "POST",
        "/enableRegion",
        Dict{String,Any}("RegionName" => RegionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_region(
    RegionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/enableRegion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegionName" => RegionName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_alternate_contact(alternate_contact_type)
    get_alternate_contact(alternate_contact_type, params::Dict{String,<:Any})

Retrieves the specified alternate contact attached to an Amazon Web Services account. For
complete details about how to use the alternate contact operations, see Access or updating
the alternate contacts.  Before you can update the alternate contact information for an
Amazon Web Services account that is managed by Organizations, you must first enable
integration between Amazon Web Services Account Management and Organizations. For more
information, see Enabling trusted access for Amazon Web Services Account Management.

# Arguments
- `alternate_contact_type`: Specifies which alternate contact you want to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12 digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you do not specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account, and the specified account ID must
  be a member account in the same organization. The organization must have all features
  enabled, and the organization must have trusted access enabled for the Account Management
  service, and optionally a delegated admin account assigned.  The management account can't
  specify its own AccountId; it must call the operation in standalone context by not
  including the AccountId parameter.  To call this operation on an account that is not a
  member of an organization, then don't specify this parameter, and call the operation using
  an identity belonging to the account whose contacts you wish to retrieve or modify.
"""
function get_alternate_contact(
    AlternateContactType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/getAlternateContact",
        Dict{String,Any}("AlternateContactType" => AlternateContactType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_alternate_contact(
    AlternateContactType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/getAlternateContact",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AlternateContactType" => AlternateContactType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact_information()
    get_contact_information(params::Dict{String,<:Any})

Retrieves the primary contact information of an Amazon Web Services account. For complete
details about how to use the primary contact operations, see Update the primary and
alternate contact information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12-digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you don't specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account. The specified account ID must be a
  member account in the same organization. The organization must have all features enabled,
  and the organization must have trusted access enabled for the Account Management service,
  and optionally a delegated admin account assigned.  The management account can't specify
  its own AccountId. It must call the operation in standalone context by not including the
  AccountId parameter.  To call this operation on an account that is not a member of an
  organization, don't specify this parameter. Instead, call the operation using an identity
  belonging to the account whose contacts you wish to retrieve or modify.
"""
function get_contact_information(; aws_config::AbstractAWSConfig=current_aws_config())
    return account(
        "POST",
        "/getContactInformation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact_information(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/getContactInformation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_primary_email(account_id)
    get_primary_email(account_id, params::Dict{String,<:Any})

Retrieves the primary email address for the specified account.

# Arguments
- `account_id`: Specifies the 12-digit account ID number of the Amazon Web Services account
  that you want to access or modify with this operation. To use this parameter, the caller
  must be an identity in the organization's management account or a delegated administrator
  account. The specified account ID must be a member account in the same organization. The
  organization must have all features enabled, and the organization must have trusted access
  enabled for the Account Management service, and optionally a delegated admin account
  assigned. This operation can only be called from the management account or the delegated
  administrator account of an organization for a member account.  The management account
  can't specify its own AccountId.

"""
function get_primary_email(AccountId; aws_config::AbstractAWSConfig=current_aws_config())
    return account(
        "POST",
        "/getPrimaryEmail",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_primary_email(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/getPrimaryEmail",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_region_opt_status(region_name)
    get_region_opt_status(region_name, params::Dict{String,<:Any})

Retrieves the opt-in status of a particular Region.

# Arguments
- `region_name`: Specifies the Region-code for a given Region name (for example,
  af-south-1). This function will return the status of whatever Region you pass into this
  parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12-digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you don't specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account. The specified account ID must be a
  member account in the same organization. The organization must have all features enabled,
  and the organization must have trusted access enabled for the Account Management service,
  and optionally a delegated admin account assigned.  The management account can't specify
  its own AccountId. It must call the operation in standalone context by not including the
  AccountId parameter.  To call this operation on an account that is not a member of an
  organization, don't specify this parameter. Instead, call the operation using an identity
  belonging to the account whose contacts you wish to retrieve or modify.
"""
function get_region_opt_status(
    RegionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/getRegionOptStatus",
        Dict{String,Any}("RegionName" => RegionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_region_opt_status(
    RegionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/getRegionOptStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RegionName" => RegionName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_regions()
    list_regions(params::Dict{String,<:Any})

Lists all the Regions for a given account and their respective opt-in statuses. Optionally,
this list can be filtered by the region-opt-status-contains parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12-digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you don't specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account. The specified account ID must be a
  member account in the same organization. The organization must have all features enabled,
  and the organization must have trusted access enabled for the Account Management service,
  and optionally a delegated admin account assigned.  The management account can't specify
  its own AccountId. It must call the operation in standalone context by not including the
  AccountId parameter.  To call this operation on an account that is not a member of an
  organization, don't specify this parameter. Instead, call the operation using an identity
  belonging to the account whose contacts you wish to retrieve or modify.
- `"MaxResults"`: The total number of items to return in the command’s output. If the
  total number of items available is more than the value specified, a NextToken is provided
  in the command’s output. To resume pagination, provide the NextToken value in the
  starting-token argument of a subsequent command. Do not use the NextToken response element
  directly outside of the Amazon Web Services CLI. For usage examples, see Pagination in the
  Amazon Web Services Command Line Interface User Guide.
- `"NextToken"`: A token used to specify where to start paginating. This is the NextToken
  from a previously truncated response. For usage examples, see Pagination in the Amazon Web
  Services Command Line Interface User Guide.
- `"RegionOptStatusContains"`: A list of Region statuses (Enabling, Enabled, Disabling,
  Disabled, Enabled_by_default) to use to filter the list of Regions for a given account. For
  example, passing in a value of ENABLING will only return a list of Regions with a Region
  status of ENABLING.
"""
function list_regions(; aws_config::AbstractAWSConfig=current_aws_config())
    return account(
        "POST", "/listRegions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_regions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/listRegions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_alternate_contact(alternate_contact_type, email_address, name, phone_number, title)
    put_alternate_contact(alternate_contact_type, email_address, name, phone_number, title, params::Dict{String,<:Any})

Modifies the specified alternate contact attached to an Amazon Web Services account. For
complete details about how to use the alternate contact operations, see Access or updating
the alternate contacts.  Before you can update the alternate contact information for an
Amazon Web Services account that is managed by Organizations, you must first enable
integration between Amazon Web Services Account Management and Organizations. For more
information, see Enabling trusted access for Amazon Web Services Account Management.

# Arguments
- `alternate_contact_type`: Specifies which alternate contact you want to create or update.
- `email_address`: Specifies an email address for the alternate contact.
- `name`: Specifies a name for the alternate contact.
- `phone_number`: Specifies a phone number for the alternate contact.
- `title`: Specifies a title for the alternate contact.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12 digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you do not specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account, and the specified account ID must
  be a member account in the same organization. The organization must have all features
  enabled, and the organization must have trusted access enabled for the Account Management
  service, and optionally a delegated admin account assigned.  The management account can't
  specify its own AccountId; it must call the operation in standalone context by not
  including the AccountId parameter.  To call this operation on an account that is not a
  member of an organization, then don't specify this parameter, and call the operation using
  an identity belonging to the account whose contacts you wish to retrieve or modify.
"""
function put_alternate_contact(
    AlternateContactType,
    EmailAddress,
    Name,
    PhoneNumber,
    Title;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/putAlternateContact",
        Dict{String,Any}(
            "AlternateContactType" => AlternateContactType,
            "EmailAddress" => EmailAddress,
            "Name" => Name,
            "PhoneNumber" => PhoneNumber,
            "Title" => Title,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_alternate_contact(
    AlternateContactType,
    EmailAddress,
    Name,
    PhoneNumber,
    Title,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/putAlternateContact",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AlternateContactType" => AlternateContactType,
                    "EmailAddress" => EmailAddress,
                    "Name" => Name,
                    "PhoneNumber" => PhoneNumber,
                    "Title" => Title,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_contact_information(contact_information)
    put_contact_information(contact_information, params::Dict{String,<:Any})

Updates the primary contact information of an Amazon Web Services account. For complete
details about how to use the primary contact operations, see Update the primary and
alternate contact information.

# Arguments
- `contact_information`: Contains the details of the primary contact information associated
  with an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: Specifies the 12-digit account ID number of the Amazon Web Services
  account that you want to access or modify with this operation. If you don't specify this
  parameter, it defaults to the Amazon Web Services account of the identity used to call the
  operation. To use this parameter, the caller must be an identity in the organization's
  management account or a delegated administrator account. The specified account ID must be a
  member account in the same organization. The organization must have all features enabled,
  and the organization must have trusted access enabled for the Account Management service,
  and optionally a delegated admin account assigned.  The management account can't specify
  its own AccountId. It must call the operation in standalone context by not including the
  AccountId parameter.  To call this operation on an account that is not a member of an
  organization, don't specify this parameter. Instead, call the operation using an identity
  belonging to the account whose contacts you wish to retrieve or modify.
"""
function put_contact_information(
    ContactInformation; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/putContactInformation",
        Dict{String,Any}("ContactInformation" => ContactInformation);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_contact_information(
    ContactInformation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/putContactInformation",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactInformation" => ContactInformation), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_primary_email_update(account_id, primary_email)
    start_primary_email_update(account_id, primary_email, params::Dict{String,<:Any})

Starts the process to update the primary email address for the specified account.

# Arguments
- `account_id`: Specifies the 12-digit account ID number of the Amazon Web Services account
  that you want to access or modify with this operation. To use this parameter, the caller
  must be an identity in the organization's management account or a delegated administrator
  account. The specified account ID must be a member account in the same organization. The
  organization must have all features enabled, and the organization must have trusted access
  enabled for the Account Management service, and optionally a delegated admin account
  assigned. This operation can only be called from the management account or the delegated
  administrator account of an organization for a member account.  The management account
  can't specify its own AccountId.
- `primary_email`: The new primary email address (also known as the root user email
  address) to use in the specified account.

"""
function start_primary_email_update(
    AccountId, PrimaryEmail; aws_config::AbstractAWSConfig=current_aws_config()
)
    return account(
        "POST",
        "/startPrimaryEmailUpdate",
        Dict{String,Any}("AccountId" => AccountId, "PrimaryEmail" => PrimaryEmail);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_primary_email_update(
    AccountId,
    PrimaryEmail,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return account(
        "POST",
        "/startPrimaryEmailUpdate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountId" => AccountId, "PrimaryEmail" => PrimaryEmail),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
