# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: chime_sdk_voice
using AWS.Compat
using AWS.UUIDs

"""
    associate_phone_numbers_with_voice_connector(e164_phone_numbers, voice_connector_id)
    associate_phone_numbers_with_voice_connector(e164_phone_numbers, voice_connector_id, params::Dict{String,<:Any})

Associates phone numbers with the specified Amazon Chime SDK Voice Connector.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceAssociate"`: If true, associates the provided phone numbers with the provided
  Amazon Chime SDK Voice Connector and removes any previously existing associations. If
  false, does not associate any phone numbers that have previously existing associations.
"""
function associate_phone_numbers_with_voice_connector(
    E164PhoneNumbers, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=associate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_phone_numbers_with_voice_connector(
    E164PhoneNumbers,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=associate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_phone_numbers_with_voice_connector_group(e164_phone_numbers, voice_connector_group_id)
    associate_phone_numbers_with_voice_connector_group(e164_phone_numbers, voice_connector_group_id, params::Dict{String,<:Any})

Associates phone numbers with the specified Amazon Chime SDK Voice Connector group.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_group_id`: The Amazon Chime SDK Voice Connector group ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceAssociate"`: If true, associates the provided phone numbers with the provided
  Amazon Chime SDK Voice Connector Group and removes any previously existing associations. If
  false, does not associate any phone numbers that have previously existing associations.
"""
function associate_phone_numbers_with_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=associate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_phone_numbers_with_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=associate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_phone_number(phone_number_ids)
    batch_delete_phone_number(phone_number_ids, params::Dict{String,<:Any})

 Moves phone numbers into the Deletion queue. Phone numbers must be disassociated from any
users or Amazon Chime SDK Voice Connectors before they can be deleted.   Phone numbers
remain in the Deletion queue for 7 days before they are deleted permanently.

# Arguments
- `phone_number_ids`: List of phone number IDs.

"""
function batch_delete_phone_number(
    PhoneNumberIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers?operation=batch-delete",
        Dict{String,Any}("PhoneNumberIds" => PhoneNumberIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_phone_number(
    PhoneNumberIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers?operation=batch-delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PhoneNumberIds" => PhoneNumberIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_phone_number(update_phone_number_request_items)
    batch_update_phone_number(update_phone_number_request_items, params::Dict{String,<:Any})

Updates phone number product types, calling names, or phone number names. You can update
one attribute at a time for each UpdatePhoneNumberRequestItem. For example, you can update
the product type, the calling name, or phone name.   You cannot have a duplicate
phoneNumberId in a request.

# Arguments
- `update_phone_number_request_items`: Lists the phone numbers in the update request.

"""
function batch_update_phone_number(
    UpdatePhoneNumberRequestItems; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers?operation=batch-update",
        Dict{String,Any}("UpdatePhoneNumberRequestItems" => UpdatePhoneNumberRequestItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_phone_number(
    UpdatePhoneNumberRequestItems,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers?operation=batch-update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "UpdatePhoneNumberRequestItems" => UpdatePhoneNumberRequestItems
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_phone_number_order(e164_phone_numbers, product_type)
    create_phone_number_order(e164_phone_numbers, product_type, params::Dict{String,<:Any})

Creates an order for phone numbers to be provisioned. For numbers outside the U.S., you
must use the Amazon Chime SDK SIP media application dial-in product type.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `product_type`: The phone number product type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: Specifies the name assigned to one or more phone numbers.
"""
function create_phone_number_order(
    E164PhoneNumbers, ProductType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/phone-number-orders",
        Dict{String,Any}(
            "E164PhoneNumbers" => E164PhoneNumbers, "ProductType" => ProductType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_phone_number_order(
    E164PhoneNumbers,
    ProductType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/phone-number-orders",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "E164PhoneNumbers" => E164PhoneNumbers, "ProductType" => ProductType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_proxy_session(capabilities, participant_phone_numbers, voice_connector_id)
    create_proxy_session(capabilities, participant_phone_numbers, voice_connector_id, params::Dict{String,<:Any})

Creates a proxy session for the specified Amazon Chime SDK Voice Connector for the
specified participant phone numbers.

# Arguments
- `capabilities`: The proxy session's capabilities.
- `participant_phone_numbers`: The participant phone numbers.
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpiryMinutes"`: The number of minutes allowed for the proxy session.
- `"GeoMatchLevel"`: The preference for matching the country or area code of the proxy
  phone number with that of the first participant.
- `"GeoMatchParams"`: The country and area code for the proxy phone number.
- `"Name"`: The name of the proxy session.
- `"NumberSelectionBehavior"`: The preference for proxy phone number reuse, or stickiness,
  between the same participants across sessions.
"""
function create_proxy_session(
    Capabilities,
    ParticipantPhoneNumbers,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions",
        Dict{String,Any}(
            "Capabilities" => Capabilities,
            "ParticipantPhoneNumbers" => ParticipantPhoneNumbers,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_proxy_session(
    Capabilities,
    ParticipantPhoneNumbers,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Capabilities" => Capabilities,
                    "ParticipantPhoneNumbers" => ParticipantPhoneNumbers,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sip_media_application(aws_region, endpoints, name)
    create_sip_media_application(aws_region, endpoints, name, params::Dict{String,<:Any})

Creates a SIP media application. For more information about SIP media applications, see
Managing SIP media applications and rules in the Amazon Chime SDK Administrator Guide.

# Arguments
- `aws_region`: The AWS Region assigned to the SIP media application.
- `endpoints`: List of endpoints (Lambda ARNs) specified for the SIP media application.
- `name`: The SIP media application's name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags assigned to the SIP media application.
"""
function create_sip_media_application(
    AwsRegion, Endpoints, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/sip-media-applications",
        Dict{String,Any}(
            "AwsRegion" => AwsRegion, "Endpoints" => Endpoints, "Name" => Name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sip_media_application(
    AwsRegion,
    Endpoints,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/sip-media-applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AwsRegion" => AwsRegion, "Endpoints" => Endpoints, "Name" => Name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sip_media_application_call(from_phone_number, to_phone_number, sip_media_application_id)
    create_sip_media_application_call(from_phone_number, to_phone_number, sip_media_application_id, params::Dict{String,<:Any})

Creates an outbound call to a phone number from the phone number specified in the request,
and it invokes the endpoint of the specified sipMediaApplicationId.

# Arguments
- `from_phone_number`: The phone number that a user calls from. This is a phone number in
  your Amazon Chime SDK phone number inventory.
- `to_phone_number`: The phone number that the service should call.
- `sip_media_application_id`: The ID of the SIP media application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ArgumentsMap"`: Context passed to a CreateSipMediaApplication API call. For example,
  you could pass key-value pairs such as: \"FirstName\": \"John\", \"LastName\": \"Doe\"
- `"SipHeaders"`: The SIP headers added to an outbound call leg.
"""
function create_sip_media_application_call(
    FromPhoneNumber,
    ToPhoneNumber,
    sipMediaApplicationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls",
        Dict{String,Any}(
            "FromPhoneNumber" => FromPhoneNumber, "ToPhoneNumber" => ToPhoneNumber
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sip_media_application_call(
    FromPhoneNumber,
    ToPhoneNumber,
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FromPhoneNumber" => FromPhoneNumber, "ToPhoneNumber" => ToPhoneNumber
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sip_rule(name, trigger_type, trigger_value)
    create_sip_rule(name, trigger_type, trigger_value, params::Dict{String,<:Any})

Creates a SIP rule, which can be used to run a SIP media application as a target for a
specific trigger type. For more information about SIP rules, see Managing SIP media
applications and rules in the Amazon Chime SDK Administrator Guide.

# Arguments
- `name`: The name of the SIP rule.
- `trigger_type`: The type of trigger assigned to the SIP rule in TriggerValue, currently
  RequestUriHostname or ToPhoneNumber.
- `trigger_value`: If TriggerType is RequestUriHostname, the value can be the outbound host
  name of a Voice Connector. If TriggerType is ToPhoneNumber, the value can be a
  customer-owned phone number in the E164 format. The SipMediaApplication specified in the
  SipRule is triggered if the request URI in an incoming SIP request matches the
  RequestUriHostname, or if the To header in the incoming SIP request matches the
  ToPhoneNumber value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: Disables or enables a SIP rule. You must disable SIP rules before you can
  delete them.
- `"TargetApplications"`: List of SIP media applications, with priority and AWS Region.
  Only one SIP application per AWS Region can be used.
"""
function create_sip_rule(
    Name, TriggerType, TriggerValue; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/sip-rules",
        Dict{String,Any}(
            "Name" => Name, "TriggerType" => TriggerType, "TriggerValue" => TriggerValue
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sip_rule(
    Name,
    TriggerType,
    TriggerValue,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/sip-rules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "TriggerType" => TriggerType,
                    "TriggerValue" => TriggerValue,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_connector(name, require_encryption)
    create_voice_connector(name, require_encryption, params::Dict{String,<:Any})

Creates an Amazon Chime SDK Voice Connector. For more information about Voice Connectors,
see Managing Amazon Chime SDK Voice Connector groups in the Amazon Chime SDK Administrator
Guide.

# Arguments
- `name`: The name of the Voice Connector.
- `require_encryption`: Enables or disables encryption for the Voice Connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AwsRegion"`: The AWS Region in which the Amazon Chime SDK Voice Connector is created.
  Default value: us-east-1 .
- `"Tags"`: The tags assigned to the Voice Connector.
"""
function create_voice_connector(
    Name, RequireEncryption; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors",
        Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_connector(
    Name,
    RequireEncryption,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_connector_group(name)
    create_voice_connector_group(name, params::Dict{String,<:Any})

Creates an Amazon Chime SDK Voice Connector group under the administrator's AWS account.
You can associate Amazon Chime SDK Voice Connectors with the Voice Connector group by
including VoiceConnectorItems in the request.  You can include Voice Connectors from
different AWS Regions in your group. This creates a fault tolerant mechanism for fallback
in case of availability events.

# Arguments
- `name`: The name of the Voice Connector group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VoiceConnectorItems"`: Lists the Voice Connectors that inbound calls are routed to.
"""
function create_voice_connector_group(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connector-groups",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_connector_group(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connector-groups",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_profile(speaker_search_task_id)
    create_voice_profile(speaker_search_task_id, params::Dict{String,<:Any})

Creates a voice profile, which consists of an enrolled user and their latest voice print.
Before creating any voice profiles, you must provide all notices and obtain all consents
from the speaker as required under applicable privacy and biometrics laws, and as required
under the AWS service terms for the Amazon Chime SDK.  For more information about voice
profiles and voice analytics, see Using Amazon Chime SDK Voice Analytics in the Amazon
Chime SDK Developer Guide.

# Arguments
- `speaker_search_task_id`: The ID of the speaker search task.

"""
function create_voice_profile(
    SpeakerSearchTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-profiles",
        Dict{String,Any}("SpeakerSearchTaskId" => SpeakerSearchTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_profile(
    SpeakerSearchTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-profiles",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SpeakerSearchTaskId" => SpeakerSearchTaskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_profile_domain(name, server_side_encryption_configuration)
    create_voice_profile_domain(name, server_side_encryption_configuration, params::Dict{String,<:Any})

Creates a voice profile domain, a collection of voice profiles, their voice prints, and
encrypted enrollment audio.  Before creating any voice profiles, you must provide all
notices and obtain all consents from the speaker as required under applicable privacy and
biometrics laws, and as required under the AWS service terms for the Amazon Chime SDK.  For
more information about voice profile domains, see Using Amazon Chime SDK Voice Analytics in
the Amazon Chime SDK Developer Guide.

# Arguments
- `name`: The name of the voice profile domain.
- `server_side_encryption_configuration`: The server-side encryption configuration for the
  request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: The unique identifier for the client request. Use a different
  token for different domain creation requests.
- `"Description"`: A description of the voice profile domain.
- `"Tags"`: The tags assigned to the domain.
"""
function create_voice_profile_domain(
    Name,
    ServerSideEncryptionConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-profile-domains",
        Dict{String,Any}(
            "Name" => Name,
            "ServerSideEncryptionConfiguration" => ServerSideEncryptionConfiguration,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_profile_domain(
    Name,
    ServerSideEncryptionConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-profile-domains",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "ServerSideEncryptionConfiguration" =>
                        ServerSideEncryptionConfiguration,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_phone_number(phone_number_id)
    delete_phone_number(phone_number_id, params::Dict{String,<:Any})

Moves the specified phone number into the Deletion queue. A phone number must be
disassociated from any users or Amazon Chime SDK Voice Connectors before it can be deleted.
Deleted phone numbers remain in the Deletion queue queue for 7 days before they are deleted
permanently.

# Arguments
- `phone_number_id`: The phone number ID.

"""
function delete_phone_number(
    phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/phone-numbers/$(phoneNumberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/phone-numbers/$(phoneNumberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_proxy_session(proxy_session_id, voice_connector_id)
    delete_proxy_session(proxy_session_id, voice_connector_id, params::Dict{String,<:Any})

Deletes the specified proxy session from the specified Amazon Chime SDK Voice Connector.

# Arguments
- `proxy_session_id`: The proxy session ID.
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_proxy_session(
    proxySessionId, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_proxy_session(
    proxySessionId,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sip_media_application(sip_media_application_id)
    delete_sip_media_application(sip_media_application_id, params::Dict{String,<:Any})

Deletes a SIP media application.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

"""
function delete_sip_media_application(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/sip-media-applications/$(sipMediaApplicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sip_media_application(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/sip-media-applications/$(sipMediaApplicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sip_rule(sip_rule_id)
    delete_sip_rule(sip_rule_id, params::Dict{String,<:Any})

Deletes a SIP rule.

# Arguments
- `sip_rule_id`: The SIP rule ID.

"""
function delete_sip_rule(sipRuleId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "DELETE",
        "/sip-rules/$(sipRuleId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sip_rule(
    sipRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/sip-rules/$(sipRuleId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector(voice_connector_id)
    delete_voice_connector(voice_connector_id, params::Dict{String,<:Any})

Deletes an Amazon Chime SDK Voice Connector. Any phone numbers associated with the Amazon
Chime SDK Voice Connector must be disassociated from it before it can be deleted.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_emergency_calling_configuration(voice_connector_id)
    delete_voice_connector_emergency_calling_configuration(voice_connector_id, params::Dict{String,<:Any})

Deletes the emergency calling details from the specified Amazon Chime SDK Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector_emergency_calling_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_emergency_calling_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_group(voice_connector_group_id)
    delete_voice_connector_group(voice_connector_group_id, params::Dict{String,<:Any})

Deletes an Amazon Chime SDK Voice Connector group. Any VoiceConnectorItems and phone
numbers associated with the group must be removed before it can be deleted.

# Arguments
- `voice_connector_group_id`: The Voice Connector Group ID.

"""
function delete_voice_connector_group(
    voiceConnectorGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connector-groups/$(voiceConnectorGroupId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_group(
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_origination(voice_connector_id)
    delete_voice_connector_origination(voice_connector_id, params::Dict{String,<:Any})

Deletes the origination settings for the specified Amazon Chime SDK Voice Connector.   If
emergency calling is configured for the Voice Connector, it must be deleted prior to
deleting the origination settings.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector_origination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/origination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_origination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/origination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_proxy(voice_connector_id)
    delete_voice_connector_proxy(voice_connector_id, params::Dict{String,<:Any})

Deletes the proxy configuration from the specified Amazon Chime SDK Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector_proxy(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_proxy(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_streaming_configuration(voice_connector_id)
    delete_voice_connector_streaming_configuration(voice_connector_id, params::Dict{String,<:Any})

Deletes a Voice Connector's streaming configuration.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector_streaming_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_streaming_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_termination(voice_connector_id)
    delete_voice_connector_termination(voice_connector_id, params::Dict{String,<:Any})

Deletes the termination settings for the specified Amazon Chime SDK Voice Connector.  If
emergency calling is configured for the Voice Connector, it must be deleted prior to
deleting the termination settings.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector_termination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/termination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_termination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/termination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_termination_credentials(usernames, voice_connector_id)
    delete_voice_connector_termination_credentials(usernames, voice_connector_id, params::Dict{String,<:Any})

Deletes the specified SIP credentials used by your equipment to authenticate during call
termination.

# Arguments
- `usernames`: The RFC2617 compliant username associated with the SIP credentials, in
  US-ASCII format.
- `voice_connector_id`: The Voice Connector ID.

"""
function delete_voice_connector_termination_credentials(
    Usernames, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=delete",
        Dict{String,Any}("Usernames" => Usernames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_termination_credentials(
    Usernames,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Usernames" => Usernames), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_profile(voice_profile_id)
    delete_voice_profile(voice_profile_id, params::Dict{String,<:Any})

Deletes a voice profile, including its voice print and enrollment data. WARNING: This
action is not reversible.

# Arguments
- `voice_profile_id`: The voice profile ID.

"""
function delete_voice_profile(
    VoiceProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-profiles/$(VoiceProfileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_profile(
    VoiceProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-profiles/$(VoiceProfileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_profile_domain(voice_profile_domain_id)
    delete_voice_profile_domain(voice_profile_domain_id, params::Dict{String,<:Any})

Deletes all voice profiles in the domain. WARNING: This action is not reversible.

# Arguments
- `voice_profile_domain_id`: The voice profile domain ID.

"""
function delete_voice_profile_domain(
    VoiceProfileDomainId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-profile-domains/$(VoiceProfileDomainId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_profile_domain(
    VoiceProfileDomainId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "DELETE",
        "/voice-profile-domains/$(VoiceProfileDomainId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_phone_numbers_from_voice_connector(e164_phone_numbers, voice_connector_id)
    disassociate_phone_numbers_from_voice_connector(e164_phone_numbers, voice_connector_id, params::Dict{String,<:Any})

Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice
Connector.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_id`: The Voice Connector ID.

"""
function disassociate_phone_numbers_from_voice_connector(
    E164PhoneNumbers, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=disassociate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_phone_numbers_from_voice_connector(
    E164PhoneNumbers,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=disassociate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_phone_numbers_from_voice_connector_group(e164_phone_numbers, voice_connector_group_id)
    disassociate_phone_numbers_from_voice_connector_group(e164_phone_numbers, voice_connector_group_id, params::Dict{String,<:Any})

Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice
Connector group.

# Arguments
- `e164_phone_numbers`: The list of phone numbers, in E.164 format.
- `voice_connector_group_id`: The Voice Connector group ID.

"""
function disassociate_phone_numbers_from_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=disassociate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_phone_numbers_from_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=disassociate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_global_settings()
    get_global_settings(params::Dict{String,<:Any})

Retrieves the global settings for the Amazon Chime SDK Voice Connectors in an AWS account.

"""
function get_global_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET", "/settings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_global_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET", "/settings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_phone_number(phone_number_id)
    get_phone_number(phone_number_id, params::Dict{String,<:Any})

Retrieves details for the specified phone number ID, such as associations, capabilities,
and product type.

# Arguments
- `phone_number_id`: The phone number ID.

"""
function get_phone_number(phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/phone-numbers/$(phoneNumberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/phone-numbers/$(phoneNumberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_phone_number_order(phone_number_order_id)
    get_phone_number_order(phone_number_order_id, params::Dict{String,<:Any})

Retrieves details for the specified phone number order, such as the order creation
timestamp, phone numbers in E.164 format, product type, and order status.

# Arguments
- `phone_number_order_id`: The ID of the phone number order .

"""
function get_phone_number_order(
    phoneNumberOrderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/phone-number-orders/$(phoneNumberOrderId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_phone_number_order(
    phoneNumberOrderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/phone-number-orders/$(phoneNumberOrderId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_phone_number_settings()
    get_phone_number_settings(params::Dict{String,<:Any})

Retrieves the phone number settings for the administrator's AWS account, such as the
default outbound calling name.

"""
function get_phone_number_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/settings/phone-number";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_phone_number_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/settings/phone-number",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_proxy_session(proxy_session_id, voice_connector_id)
    get_proxy_session(proxy_session_id, voice_connector_id, params::Dict{String,<:Any})

Retrieves the specified proxy session details for the specified Amazon Chime SDK Voice
Connector.

# Arguments
- `proxy_session_id`: The proxy session ID.
- `voice_connector_id`: The Voice Connector ID.

"""
function get_proxy_session(
    proxySessionId, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_proxy_session(
    proxySessionId,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_media_application(sip_media_application_id)
    get_sip_media_application(sip_media_application_id, params::Dict{String,<:Any})

Retrieves the information for a SIP media application, including name, AWS Region, and
endpoints.

# Arguments
- `sip_media_application_id`: The SIP media application ID .

"""
function get_sip_media_application(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_media_application(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_media_application_alexa_skill_configuration(sip_media_application_id)
    get_sip_media_application_alexa_skill_configuration(sip_media_application_id, params::Dict{String,<:Any})

Gets the Alexa Skill configuration for the SIP media application.  Due to changes made by
the Amazon Alexa service, this API is no longer available for use. For more information,
refer to the Alexa Smart Properties page.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

"""
function get_sip_media_application_alexa_skill_configuration(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)/alexa-skill-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_media_application_alexa_skill_configuration(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)/alexa-skill-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_media_application_logging_configuration(sip_media_application_id)
    get_sip_media_application_logging_configuration(sip_media_application_id, params::Dict{String,<:Any})

Retrieves the logging configuration for the specified SIP media application.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

"""
function get_sip_media_application_logging_configuration(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_media_application_logging_configuration(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_rule(sip_rule_id)
    get_sip_rule(sip_rule_id, params::Dict{String,<:Any})

Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target
endpoints.

# Arguments
- `sip_rule_id`: The SIP rule ID.

"""
function get_sip_rule(sipRuleId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/sip-rules/$(sipRuleId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_rule(
    sipRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/sip-rules/$(sipRuleId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_speaker_search_task(speaker_search_task_id, voice_connector_id)
    get_speaker_search_task(speaker_search_task_id, voice_connector_id, params::Dict{String,<:Any})

Retrieves the details of the specified speaker search task.

# Arguments
- `speaker_search_task_id`: The ID of the speaker search task.
- `voice_connector_id`: The Voice Connector ID.

"""
function get_speaker_search_task(
    SpeakerSearchTaskId,
    VoiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(VoiceConnectorId)/speaker-search-tasks/$(SpeakerSearchTaskId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_speaker_search_task(
    SpeakerSearchTaskId,
    VoiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(VoiceConnectorId)/speaker-search-tasks/$(SpeakerSearchTaskId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector(voice_connector_id)
    get_voice_connector(voice_connector_id, params::Dict{String,<:Any})

Retrieves details for the specified Amazon Chime SDK Voice Connector, such as
timestamps,name, outbound host, and encryption requirements.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_emergency_calling_configuration(voice_connector_id)
    get_voice_connector_emergency_calling_configuration(voice_connector_id, params::Dict{String,<:Any})

Retrieves the emergency calling configuration details for the specified Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_emergency_calling_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_emergency_calling_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_group(voice_connector_group_id)
    get_voice_connector_group(voice_connector_group_id, params::Dict{String,<:Any})

Retrieves details for the specified Amazon Chime SDK Voice Connector group, such as
timestamps,name, and associated VoiceConnectorItems.

# Arguments
- `voice_connector_group_id`: The Voice Connector group ID.

"""
function get_voice_connector_group(
    voiceConnectorGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connector-groups/$(voiceConnectorGroupId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_group(
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_logging_configuration(voice_connector_id)
    get_voice_connector_logging_configuration(voice_connector_id, params::Dict{String,<:Any})

Retrieves the logging configuration settings for the specified Voice Connector. Shows
whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_logging_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_logging_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_origination(voice_connector_id)
    get_voice_connector_origination(voice_connector_id, params::Dict{String,<:Any})

Retrieves the origination settings for the specified Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_origination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/origination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_origination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/origination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_proxy(voice_connector_id)
    get_voice_connector_proxy(voice_connector_id, params::Dict{String,<:Any})

Retrieves the proxy configuration details for the specified Amazon Chime SDK Voice
Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_proxy(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_proxy(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_streaming_configuration(voice_connector_id)
    get_voice_connector_streaming_configuration(voice_connector_id, params::Dict{String,<:Any})

Retrieves the streaming configuration details for the specified Amazon Chime SDK Voice
Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also
shows the retention period, in hours, for the Amazon Kinesis data.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_streaming_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_streaming_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_termination(voice_connector_id)
    get_voice_connector_termination(voice_connector_id, params::Dict{String,<:Any})

Retrieves the termination setting details for the specified Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_termination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_termination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_termination_health(voice_connector_id)
    get_voice_connector_termination_health(voice_connector_id, params::Dict{String,<:Any})

Retrieves information about the last time a SIP OPTIONS ping was received from your SIP
infrastructure for the specified Amazon Chime SDK Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function get_voice_connector_termination_health(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/health";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_termination_health(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/health",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_profile(voice_profile_id)
    get_voice_profile(voice_profile_id, params::Dict{String,<:Any})

Retrieves the details of the specified voice profile.

# Arguments
- `voice_profile_id`: The voice profile ID.

"""
function get_voice_profile(
    VoiceProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-profiles/$(VoiceProfileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_profile(
    VoiceProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-profiles/$(VoiceProfileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_profile_domain(voice_profile_domain_id)
    get_voice_profile_domain(voice_profile_domain_id, params::Dict{String,<:Any})

Retrieves the details of the specified voice profile domain.

# Arguments
- `voice_profile_domain_id`: The voice profile domain ID.

"""
function get_voice_profile_domain(
    VoiceProfileDomainId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-profile-domains/$(VoiceProfileDomainId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_profile_domain(
    VoiceProfileDomainId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-profile-domains/$(VoiceProfileDomainId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_tone_analysis_task(voice_connector_id, voice_tone_analysis_task_id, is_caller)
    get_voice_tone_analysis_task(voice_connector_id, voice_tone_analysis_task_id, is_caller, params::Dict{String,<:Any})

Retrieves the details of a voice tone analysis task.

# Arguments
- `voice_connector_id`: The Voice Connector ID.
- `voice_tone_analysis_task_id`: The ID of the voice tone anlysis task.
- `is_caller`: Specifies whether the voice being analyzed is the caller (originator) or the
  callee (responder).

"""
function get_voice_tone_analysis_task(
    VoiceConnectorId,
    VoiceToneAnalysisTaskId,
    isCaller;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(VoiceConnectorId)/voice-tone-analysis-tasks/$(VoiceToneAnalysisTaskId)",
        Dict{String,Any}("isCaller" => isCaller);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_tone_analysis_task(
    VoiceConnectorId,
    VoiceToneAnalysisTaskId,
    isCaller,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(VoiceConnectorId)/voice-tone-analysis-tasks/$(VoiceToneAnalysisTaskId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("isCaller" => isCaller), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_available_voice_connector_regions()
    list_available_voice_connector_regions(params::Dict{String,<:Any})

Lists the available AWS Regions in which you can create an Amazon Chime SDK Voice Connector.

"""
function list_available_voice_connector_regions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connector-regions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_available_voice_connector_regions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connector-regions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_phone_number_orders()
    list_phone_number_orders(params::Dict{String,<:Any})

Lists the phone numbers for an administrator's Amazon Chime SDK account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to retrieve the next page of results.
"""
function list_phone_number_orders(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/phone-number-orders";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_phone_number_orders(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/phone-number-orders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_phone_numbers()
    list_phone_numbers(params::Dict{String,<:Any})

Lists the phone numbers for the specified Amazon Chime SDK account, Amazon Chime SDK user,
Amazon Chime SDK Voice Connector, or Amazon Chime SDK Voice Connector group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter-name"`: The filter to limit the number of results.
- `"filter-value"`: The filter value.
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to return the next page of results.
- `"product-type"`: The phone number product types.
- `"status"`: The status of your organization's phone numbers.
"""
function list_phone_numbers(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET", "/phone-numbers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_phone_numbers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/phone-numbers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_proxy_sessions(voice_connector_id)
    list_proxy_sessions(voice_connector_id, params::Dict{String,<:Any})

Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to retrieve the next page of results.
- `"status"`: The proxy session status.
"""
function list_proxy_sessions(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_proxy_sessions(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sip_media_applications()
    list_sip_media_applications(params::Dict{String,<:Any})

Lists the SIP media applications under the administrator's AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Defaults to
  100.
- `"next-token"`: The token used to return the next page of results.
"""
function list_sip_media_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sip_media_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/sip-media-applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sip_rules()
    list_sip_rules(params::Dict{String,<:Any})

Lists the SIP rules under the administrator's AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Defaults to
  100.
- `"next-token"`: The token used to return the next page of results.
- `"sip-media-application"`: The SIP media application ID.
"""
function list_sip_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET", "/sip-rules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_sip_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET", "/sip-rules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_supported_phone_number_countries(product-type)
    list_supported_phone_number_countries(product-type, params::Dict{String,<:Any})

Lists the countries that you can order phone numbers from.

# Arguments
- `product-type`: The phone number product type.

"""
function list_supported_phone_number_countries(
    product_type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/phone-number-countries",
        Dict{String,Any}("product-type" => product_type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_supported_phone_number_countries(
    product_type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/phone-number-countries",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("product-type" => product_type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

Returns a list of the tags in a given resource.

# Arguments
- `arn`: The resource ARN.

"""
function list_tags_for_resource(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/tags",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/tags",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_connector_groups()
    list_voice_connector_groups(params::Dict{String,<:Any})

Lists the Amazon Chime SDK Voice Connector groups in the administrator's AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to return the next page of results.
"""
function list_voice_connector_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/voice-connector-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_voice_connector_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connector-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_connector_termination_credentials(voice_connector_id)
    list_voice_connector_termination_credentials(voice_connector_id, params::Dict{String,<:Any})

Lists the SIP credentials for the specified Amazon Chime SDK Voice Connector.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

"""
function list_voice_connector_termination_credentials(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_voice_connector_termination_credentials(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_connectors()
    list_voice_connectors(params::Dict{String,<:Any})

Lists the Amazon Chime SDK Voice Connectors in the administrators AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to return the next page of results.
"""
function list_voice_connectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET", "/voice-connectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_voice_connectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-connectors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_profile_domains()
    list_voice_profile_domains(params::Dict{String,<:Any})

Lists the specified voice profile domains in the administrator's AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to return the next page of results.
"""
function list_voice_profile_domains(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "GET",
        "/voice-profile-domains";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_voice_profile_domains(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-profile-domains",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_profiles(voice-profile-domain-id)
    list_voice_profiles(voice-profile-domain-id, params::Dict{String,<:Any})

Lists the voice profiles in a voice profile domain.

# Arguments
- `voice-profile-domain-id`: The ID of the voice profile domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results in the request.
- `"next-token"`: The token used to retrieve the next page of results.
"""
function list_voice_profiles(
    voice_profile_domain_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/voice-profiles",
        Dict{String,Any}("voice-profile-domain-id" => voice_profile_domain_id);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_voice_profiles(
    voice_profile_domain_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "GET",
        "/voice-profiles",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("voice-profile-domain-id" => voice_profile_domain_id),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_sip_media_application_alexa_skill_configuration(sip_media_application_id)
    put_sip_media_application_alexa_skill_configuration(sip_media_application_id, params::Dict{String,<:Any})

Updates the Alexa Skill configuration for the SIP media application.  Due to changes made
by the Amazon Alexa service, this API is no longer available for use. For more information,
refer to the Alexa Smart Properties page.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SipMediaApplicationAlexaSkillConfiguration"`: The Alexa Skill configuration.
"""
function put_sip_media_application_alexa_skill_configuration(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)/alexa-skill-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_sip_media_application_alexa_skill_configuration(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)/alexa-skill-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_sip_media_application_logging_configuration(sip_media_application_id)
    put_sip_media_application_logging_configuration(sip_media_application_id, params::Dict{String,<:Any})

Updates the logging configuration for the specified SIP media application.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SipMediaApplicationLoggingConfiguration"`: The logging configuration for the specified
  SIP media application.
"""
function put_sip_media_application_logging_configuration(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_sip_media_application_logging_configuration(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_emergency_calling_configuration(emergency_calling_configuration, voice_connector_id)
    put_voice_connector_emergency_calling_configuration(emergency_calling_configuration, voice_connector_id, params::Dict{String,<:Any})

Updates a Voice Connector's emergency calling configuration.

# Arguments
- `emergency_calling_configuration`: The configuration being updated.
- `voice_connector_id`: The Voice Connector ID.

"""
function put_voice_connector_emergency_calling_configuration(
    EmergencyCallingConfiguration,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        Dict{String,Any}("EmergencyCallingConfiguration" => EmergencyCallingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_emergency_calling_configuration(
    EmergencyCallingConfiguration,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EmergencyCallingConfiguration" => EmergencyCallingConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_logging_configuration(logging_configuration, voice_connector_id)
    put_voice_connector_logging_configuration(logging_configuration, voice_connector_id, params::Dict{String,<:Any})

Updates a Voice Connector's logging configuration.

# Arguments
- `logging_configuration`: The logging configuration being updated.
- `voice_connector_id`: The Voice Connector ID.

"""
function put_voice_connector_logging_configuration(
    LoggingConfiguration,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration",
        Dict{String,Any}("LoggingConfiguration" => LoggingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_logging_configuration(
    LoggingConfiguration,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LoggingConfiguration" => LoggingConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_origination(origination, voice_connector_id)
    put_voice_connector_origination(origination, voice_connector_id, params::Dict{String,<:Any})

Updates a Voice Connector's origination settings.

# Arguments
- `origination`: The origination settings being updated.
- `voice_connector_id`: The Voice Connector ID.

"""
function put_voice_connector_origination(
    Origination, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/origination",
        Dict{String,Any}("Origination" => Origination);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_origination(
    Origination,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/origination",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Origination" => Origination), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_proxy(default_session_expiry_minutes, phone_number_pool_countries, voice_connector_id)
    put_voice_connector_proxy(default_session_expiry_minutes, phone_number_pool_countries, voice_connector_id, params::Dict{String,<:Any})

Puts the specified proxy configuration to the specified Amazon Chime SDK Voice Connector.

# Arguments
- `default_session_expiry_minutes`: The default number of minutes allowed for proxy session.
- `phone_number_pool_countries`: The countries for proxy phone numbers to be selected from.
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: When true, stops proxy sessions from being created on the specified Amazon
  Chime SDK Voice Connector.
- `"FallBackPhoneNumber"`: The phone number to route calls to after a proxy session expires.
"""
function put_voice_connector_proxy(
    DefaultSessionExpiryMinutes,
    PhoneNumberPoolCountries,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        Dict{String,Any}(
            "DefaultSessionExpiryMinutes" => DefaultSessionExpiryMinutes,
            "PhoneNumberPoolCountries" => PhoneNumberPoolCountries,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_proxy(
    DefaultSessionExpiryMinutes,
    PhoneNumberPoolCountries,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DefaultSessionExpiryMinutes" => DefaultSessionExpiryMinutes,
                    "PhoneNumberPoolCountries" => PhoneNumberPoolCountries,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_streaming_configuration(streaming_configuration, voice_connector_id)
    put_voice_connector_streaming_configuration(streaming_configuration, voice_connector_id, params::Dict{String,<:Any})

Updates a Voice Connector's streaming configuration settings.

# Arguments
- `streaming_configuration`: The streaming settings being updated.
- `voice_connector_id`: The Voice Connector ID.

"""
function put_voice_connector_streaming_configuration(
    StreamingConfiguration,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        Dict{String,Any}("StreamingConfiguration" => StreamingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_streaming_configuration(
    StreamingConfiguration,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StreamingConfiguration" => StreamingConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_termination(termination, voice_connector_id)
    put_voice_connector_termination(termination, voice_connector_id, params::Dict{String,<:Any})

Updates a Voice Connector's termination settings.

# Arguments
- `termination`: The termination settings to be updated.
- `voice_connector_id`: The Voice Connector ID.

"""
function put_voice_connector_termination(
    Termination, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/termination",
        Dict{String,Any}("Termination" => Termination);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_termination(
    Termination,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/termination",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Termination" => Termination), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_termination_credentials(voice_connector_id)
    put_voice_connector_termination_credentials(voice_connector_id, params::Dict{String,<:Any})

Updates a Voice Connector's termination credentials.

# Arguments
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Credentials"`: The termination credentials being updated.
"""
function put_voice_connector_termination_credentials(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=put";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_termination_credentials(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=put",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_phone_number(phone_number_id)
    restore_phone_number(phone_number_id, params::Dict{String,<:Any})

Restores a deleted phone number.

# Arguments
- `phone_number_id`: The ID of the phone number being restored.

"""
function restore_phone_number(
    phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers/$(phoneNumberId)?operation=restore";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers/$(phoneNumberId)?operation=restore",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_available_phone_numbers()
    search_available_phone_numbers(params::Dict{String,<:Any})

Searches the provisioned phone numbers in an organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"area-code"`: Confines a search to just the phone numbers associated with the specified
  area code.
- `"city"`: Confines a search to just the phone numbers associated with the specified city.
- `"country"`: Confines a search to just the phone numbers associated with the specified
  country.
- `"max-results"`: The maximum number of results to return.
- `"next-token"`: The token used to return the next page of results.
- `"phone-number-type"`: Confines a search to just the phone numbers associated with the
  specified phone number type, either local or toll-free.
- `"state"`: Confines a search to just the phone numbers associated with the specified
  state.
- `"toll-free-prefix"`: Confines a search to just the phone numbers associated with the
  specified toll-free prefix.
"""
function search_available_phone_numbers(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/search?type=phone-numbers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_available_phone_numbers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "GET",
        "/search?type=phone-numbers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_speaker_search_task(transaction_id, voice_connector_id, voice_profile_domain_id)
    start_speaker_search_task(transaction_id, voice_connector_id, voice_profile_domain_id, params::Dict{String,<:Any})

Starts a speaker search task.  Before starting any speaker search tasks, you must provide
all notices and obtain all consents from the speaker as required under applicable privacy
and biometrics laws, and as required under the AWS service terms for the Amazon Chime SDK.

# Arguments
- `transaction_id`: The transaction ID of the call being analyzed.
- `voice_connector_id`: The Voice Connector ID.
- `voice_profile_domain_id`: The ID of the voice profile domain that will store the voice
  profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CallLeg"`: Specifies which call leg to stream for speaker search.
- `"ClientRequestToken"`: The unique identifier for the client request. Use a different
  token for different speaker search tasks.
"""
function start_speaker_search_task(
    TransactionId,
    VoiceConnectorId,
    VoiceProfileDomainId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/speaker-search-tasks",
        Dict{String,Any}(
            "TransactionId" => TransactionId, "VoiceProfileDomainId" => VoiceProfileDomainId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_speaker_search_task(
    TransactionId,
    VoiceConnectorId,
    VoiceProfileDomainId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/speaker-search-tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransactionId" => TransactionId,
                    "VoiceProfileDomainId" => VoiceProfileDomainId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_voice_tone_analysis_task(language_code, transaction_id, voice_connector_id)
    start_voice_tone_analysis_task(language_code, transaction_id, voice_connector_id, params::Dict{String,<:Any})

Starts a voice tone analysis task. For more information about voice tone analysis, see
Using Amazon Chime SDK voice analytics in the Amazon Chime SDK Developer Guide.  Before
starting any voice tone analysis tasks, you must provide all notices and obtain all
consents from the speaker as required under applicable privacy and biometrics laws, and as
required under the AWS service terms for the Amazon Chime SDK.

# Arguments
- `language_code`: The language code.
- `transaction_id`: The transaction ID.
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: The unique identifier for the client request. Use a different
  token for different voice tone analysis tasks.
"""
function start_voice_tone_analysis_task(
    LanguageCode,
    TransactionId,
    VoiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/voice-tone-analysis-tasks",
        Dict{String,Any}("LanguageCode" => LanguageCode, "TransactionId" => TransactionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_voice_tone_analysis_task(
    LanguageCode,
    TransactionId,
    VoiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/voice-tone-analysis-tasks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LanguageCode" => LanguageCode, "TransactionId" => TransactionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_speaker_search_task(speaker_search_task_id, voice_connector_id)
    stop_speaker_search_task(speaker_search_task_id, voice_connector_id, params::Dict{String,<:Any})

Stops a speaker search task.

# Arguments
- `speaker_search_task_id`: The speaker search task ID.
- `voice_connector_id`: The Voice Connector ID.

"""
function stop_speaker_search_task(
    SpeakerSearchTaskId,
    VoiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/speaker-search-tasks/$(SpeakerSearchTaskId)?operation=stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_speaker_search_task(
    SpeakerSearchTaskId,
    VoiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/speaker-search-tasks/$(SpeakerSearchTaskId)?operation=stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_voice_tone_analysis_task(voice_connector_id, voice_tone_analysis_task_id)
    stop_voice_tone_analysis_task(voice_connector_id, voice_tone_analysis_task_id, params::Dict{String,<:Any})

Stops a voice tone analysis task.

# Arguments
- `voice_connector_id`: The Voice Connector ID.
- `voice_tone_analysis_task_id`: The ID of the voice tone analysis task.

"""
function stop_voice_tone_analysis_task(
    VoiceConnectorId,
    VoiceToneAnalysisTaskId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/voice-tone-analysis-tasks/$(VoiceToneAnalysisTaskId)?operation=stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_voice_tone_analysis_task(
    VoiceConnectorId,
    VoiceToneAnalysisTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(VoiceConnectorId)/voice-tone-analysis-tasks/$(VoiceToneAnalysisTaskId)?operation=stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds a tag to the specified resource.

# Arguments
- `resource_arn`: The ARN of the resource being tagged.
- `tags`: A list of the tags being added to the resource.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "POST",
        "/tags?operation=tag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/tags?operation=tag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a resource.

# Arguments
- `resource_arn`: The ARN of the resource having its tags removed.
- `tag_keys`: The keys of the tags being removed from the resource.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/tags?operation=untag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/tags?operation=untag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_global_settings()
    update_global_settings(params::Dict{String,<:Any})

Updates global settings for the Amazon Chime SDK Voice Connectors in an AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VoiceConnector"`: The Voice Connector settings.
"""
function update_global_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime_sdk_voice(
        "PUT", "/settings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_global_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT", "/settings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    update_phone_number(phone_number_id)
    update_phone_number(phone_number_id, params::Dict{String,<:Any})

Updates phone number details, such as product type, calling name, or phone number name for
the specified phone number ID. You can update one phone number detail at a time. For
example, you can update either the product type, calling name, or phone number name in one
action. For numbers outside the U.S., you must use the Amazon Chime SDK SIP Media
Application Dial-In product type. Updates to outbound calling names can take 72 hours to
complete. Pending updates to outbound calling names must be complete before you can request
another update.

# Arguments
- `phone_number_id`: The phone number ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CallingName"`: The outbound calling name associated with the phone number.
- `"Name"`: Specifies the updated name assigned to one or more phone numbers.
- `"ProductType"`: The product type.
"""
function update_phone_number(
    phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers/$(phoneNumberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/phone-numbers/$(phoneNumberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_phone_number_settings(calling_name)
    update_phone_number_settings(calling_name, params::Dict{String,<:Any})

Updates the phone number settings for the administrator's AWS account, such as the default
outbound calling name. You can update the default outbound calling name once every seven
days. Outbound calling names can take up to 72 hours to update.

# Arguments
- `calling_name`: The default outbound calling name for the account.

"""
function update_phone_number_settings(
    CallingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/settings/phone-number",
        Dict{String,Any}("CallingName" => CallingName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_phone_number_settings(
    CallingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/settings/phone-number",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CallingName" => CallingName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_proxy_session(capabilities, proxy_session_id, voice_connector_id)
    update_proxy_session(capabilities, proxy_session_id, voice_connector_id, params::Dict{String,<:Any})

Updates the specified proxy session details, such as voice or SMS capabilities.

# Arguments
- `capabilities`: The proxy session capabilities.
- `proxy_session_id`: The proxy session ID.
- `voice_connector_id`: The Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpiryMinutes"`: The number of minutes allowed for the proxy session.
"""
function update_proxy_session(
    Capabilities,
    proxySessionId,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        Dict{String,Any}("Capabilities" => Capabilities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_proxy_session(
    Capabilities,
    proxySessionId,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Capabilities" => Capabilities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sip_media_application(sip_media_application_id)
    update_sip_media_application(sip_media_application_id, params::Dict{String,<:Any})

Updates the details of the specified SIP media application.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Endpoints"`: The new set of endpoints for the specified SIP media application.
- `"Name"`: The new name for the specified SIP media application.
"""
function update_sip_media_application(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sip_media_application(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sip_media_application_call(arguments, sip_media_application_id, transaction_id)
    update_sip_media_application_call(arguments, sip_media_application_id, transaction_id, params::Dict{String,<:Any})

Invokes the AWS Lambda function associated with the SIP media application and transaction
ID in an update request. The Lambda function can then return a new set of actions.

# Arguments
- `arguments`: Arguments made available to the Lambda function as part of the
  CALL_UPDATE_REQUESTED event. Can contain 0-20 key-value pairs.
- `sip_media_application_id`: The ID of the SIP media application handling the call.
- `transaction_id`: The ID of the call transaction.

"""
function update_sip_media_application_call(
    Arguments,
    sipMediaApplicationId,
    transactionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls/$(transactionId)",
        Dict{String,Any}("Arguments" => Arguments);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sip_media_application_call(
    Arguments,
    sipMediaApplicationId,
    transactionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls/$(transactionId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Arguments" => Arguments), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sip_rule(name, sip_rule_id)
    update_sip_rule(name, sip_rule_id, params::Dict{String,<:Any})

Updates the details of the specified SIP rule.

# Arguments
- `name`: The new name for the specified SIP rule.
- `sip_rule_id`: The SIP rule ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: The new value that indicates whether the rule is disabled.
- `"TargetApplications"`: The new list of target applications.
"""
function update_sip_rule(
    Name, sipRuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/sip-rules/$(sipRuleId)",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sip_rule(
    Name,
    sipRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/sip-rules/$(sipRuleId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_connector(name, require_encryption, voice_connector_id)
    update_voice_connector(name, require_encryption, voice_connector_id, params::Dict{String,<:Any})

Updates the details for the specified Amazon Chime SDK Voice Connector.

# Arguments
- `name`: The name of the Voice Connector.
- `require_encryption`: When enabled, requires encryption for the Voice Connector.
- `voice_connector_id`: The Voice Connector ID.

"""
function update_voice_connector(
    Name,
    RequireEncryption,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)",
        Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_connector(
    Name,
    RequireEncryption,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_connector_group(name, voice_connector_items, voice_connector_group_id)
    update_voice_connector_group(name, voice_connector_items, voice_connector_group_id, params::Dict{String,<:Any})

Updates the settings for the specified Amazon Chime SDK Voice Connector group.

# Arguments
- `name`: The name of the Voice Connector group.
- `voice_connector_items`: The VoiceConnectorItems to associate with the Voice Connector
  group.
- `voice_connector_group_id`: The Voice Connector ID.

"""
function update_voice_connector_group(
    Name,
    VoiceConnectorItems,
    voiceConnectorGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        Dict{String,Any}("Name" => Name, "VoiceConnectorItems" => VoiceConnectorItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_connector_group(
    Name,
    VoiceConnectorItems,
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "VoiceConnectorItems" => VoiceConnectorItems
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_profile(speaker_search_task_id, voice_profile_id)
    update_voice_profile(speaker_search_task_id, voice_profile_id, params::Dict{String,<:Any})

Updates the specified voice profile’s voice print and refreshes its expiration timestamp.
 As a condition of using this feature, you acknowledge that the collection, use, storage,
and retention of your caller’s biometric identifiers and biometric information
(“biometric data”) in the form of a digital voiceprint requires the caller’s informed
consent via a written release. Such consent is required under various state laws, including
biometrics laws in Illinois, Texas, Washington and other state privacy laws. You must
provide a written release to each caller through a process that clearly reflects each
caller’s informed consent before using Amazon Chime SDK Voice Insights service, as
required under the terms of your agreement with AWS governing your use of the service.

# Arguments
- `speaker_search_task_id`: The ID of the speaker search task.
- `voice_profile_id`: The profile ID.

"""
function update_voice_profile(
    SpeakerSearchTaskId, VoiceProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/voice-profiles/$(VoiceProfileId)",
        Dict{String,Any}("SpeakerSearchTaskId" => SpeakerSearchTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_profile(
    SpeakerSearchTaskId,
    VoiceProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-profiles/$(VoiceProfileId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SpeakerSearchTaskId" => SpeakerSearchTaskId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_profile_domain(voice_profile_domain_id)
    update_voice_profile_domain(voice_profile_domain_id, params::Dict{String,<:Any})

Updates the settings for the specified voice profile domain.

# Arguments
- `voice_profile_domain_id`: The domain ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the voice profile domain.
- `"Name"`: The name of the voice profile domain.
"""
function update_voice_profile_domain(
    VoiceProfileDomainId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime_sdk_voice(
        "PUT",
        "/voice-profile-domains/$(VoiceProfileDomainId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_profile_domain(
    VoiceProfileDomainId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "PUT",
        "/voice-profile-domains/$(VoiceProfileDomainId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_e911_address(aws_account_id, city, country, postal_code, state, street_info, street_number)
    validate_e911_address(aws_account_id, city, country, postal_code, state, street_info, street_number, params::Dict{String,<:Any})

Validates an address to be used for 911 calls made with Amazon Chime SDK Voice Connectors.
You can use validated addresses in a Presence Information Data Format Location Object file
that you include in SIP requests. That helps ensure that addresses are routed to the
appropriate Public Safety Answering Point.

# Arguments
- `aws_account_id`: The AWS account ID.
- `city`: The address city, such as Portland.
- `country`: The country in the address being validated.
- `postal_code`: The dress postal code, such 04352.
- `state`: The address state, such as ME.
- `street_info`: The address street information, such as 8th Avenue.
- `street_number`: The address street number, such as 200 or 2121.

"""
function validate_e911_address(
    AwsAccountId,
    City,
    Country,
    PostalCode,
    State,
    StreetInfo,
    StreetNumber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/emergency-calling/address",
        Dict{String,Any}(
            "AwsAccountId" => AwsAccountId,
            "City" => City,
            "Country" => Country,
            "PostalCode" => PostalCode,
            "State" => State,
            "StreetInfo" => StreetInfo,
            "StreetNumber" => StreetNumber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_e911_address(
    AwsAccountId,
    City,
    Country,
    PostalCode,
    State,
    StreetInfo,
    StreetNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime_sdk_voice(
        "POST",
        "/emergency-calling/address",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AwsAccountId" => AwsAccountId,
                    "City" => City,
                    "Country" => Country,
                    "PostalCode" => PostalCode,
                    "State" => State,
                    "StreetInfo" => StreetInfo,
                    "StreetNumber" => StreetNumber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
