# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: kafka
using AWS.Compat
using AWS.UUIDs

"""
    batch_associate_scram_secret(cluster_arn, secret_arn_list)
    batch_associate_scram_secret(cluster_arn, secret_arn_list, params::Dict{String,<:Any})


            Associates one or more Scram Secrets with an Amazon MSK cluster.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster to be updated.
  
- `secret_arn_list`: 
            List of AWS Secrets Manager secret ARNs.

"""
function batch_associate_scram_secret(
    clusterArn, secretArnList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "POST",
        "/v1/clusters/$(clusterArn)/scram-secrets",
        Dict{String,Any}("secretArnList" => secretArnList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_associate_scram_secret(
    clusterArn,
    secretArnList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/clusters/$(clusterArn)/scram-secrets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("secretArnList" => secretArnList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disassociate_scram_secret(cluster_arn, secret_arn_list)
    batch_disassociate_scram_secret(cluster_arn, secret_arn_list, params::Dict{String,<:Any})


            Disassociates one or more Scram Secrets from an Amazon MSK cluster.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster to be updated.
  
- `secret_arn_list`: 
            List of AWS Secrets Manager secret ARNs.

"""
function batch_disassociate_scram_secret(
    clusterArn, secretArnList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PATCH",
        "/v1/clusters/$(clusterArn)/scram-secrets",
        Dict{String,Any}("secretArnList" => secretArnList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disassociate_scram_secret(
    clusterArn,
    secretArnList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PATCH",
        "/v1/clusters/$(clusterArn)/scram-secrets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("secretArnList" => secretArnList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster(broker_node_group_info, cluster_name, kafka_version, number_of_broker_nodes)
    create_cluster(broker_node_group_info, cluster_name, kafka_version, number_of_broker_nodes, params::Dict{String,<:Any})


            Creates a new MSK cluster.

# Arguments
- `broker_node_group_info`: 
            Information about the broker nodes in the
  cluster.
- `cluster_name`: 
            The name of the cluster.
- `kafka_version`: 
            The version of Apache Kafka.
- `number_of_broker_nodes`: 
            The number of broker nodes in the cluster.
  

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientAuthentication"`: 
            Includes all client authentication related
  information.
- `"configurationInfo"`: 
            Represents the configuration that you want MSK to use
  for the brokers in a cluster.
- `"encryptionInfo"`: 
            Includes all encryption-related information.
- `"enhancedMonitoring"`: 
            Specifies the level of monitoring for the MSK
  cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and
  PER_TOPIC_PER_PARTITION.
- `"loggingInfo"`:
- `"openMonitoring"`: 
            The settings for open monitoring.
- `"storageMode"`: 
            This controls storage mode for supported storage tiers.
  
- `"tags"`: 
            Create tags when creating the cluster.
"""
function create_cluster(
    brokerNodeGroupInfo,
    clusterName,
    kafkaVersion,
    numberOfBrokerNodes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/clusters",
        Dict{String,Any}(
            "brokerNodeGroupInfo" => brokerNodeGroupInfo,
            "clusterName" => clusterName,
            "kafkaVersion" => kafkaVersion,
            "numberOfBrokerNodes" => numberOfBrokerNodes,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster(
    brokerNodeGroupInfo,
    clusterName,
    kafkaVersion,
    numberOfBrokerNodes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/clusters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "brokerNodeGroupInfo" => brokerNodeGroupInfo,
                    "clusterName" => clusterName,
                    "kafkaVersion" => kafkaVersion,
                    "numberOfBrokerNodes" => numberOfBrokerNodes,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cluster_v2(cluster_name)
    create_cluster_v2(cluster_name, params::Dict{String,<:Any})


            Creates a new MSK cluster.

# Arguments
- `cluster_name`: 
            The name of the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"provisioned"`: 
            Information about the provisioned cluster.
- `"serverless"`: 
            Information about the serverless cluster.
- `"tags"`: 
            A map of tags that you want the cluster to have.
"""
function create_cluster_v2(clusterName; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "POST",
        "/api/v2/clusters",
        Dict{String,Any}("clusterName" => clusterName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cluster_v2(
    clusterName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/api/v2/clusters",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clusterName" => clusterName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_configuration(name, server_properties)
    create_configuration(name, server_properties, params::Dict{String,<:Any})


            Creates a new MSK configuration.

# Arguments
- `name`: 
            The name of the configuration.
- `server_properties`: 
            Contents of the server.properties file. When using the
  API, you must ensure that the contents of the file are base64 encoded. 
               When
  using the AWS Management Console, the SDK, or the AWS CLI, the contents of
  server.properties can be in plaintext.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: 
            The description of the configuration.
- `"kafkaVersions"`: 
            The versions of Apache Kafka with which you can use this
  MSK configuration.
"""
function create_configuration(
    name, serverProperties; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "POST",
        "/v1/configurations",
        Dict{String,Any}("name" => name, "serverProperties" => serverProperties);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_configuration(
    name,
    serverProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/configurations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("name" => name, "serverProperties" => serverProperties),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_replicator(kafka_clusters, replication_info_list, replicator_name, service_execution_role_arn)
    create_replicator(kafka_clusters, replication_info_list, replicator_name, service_execution_role_arn, params::Dict{String,<:Any})

Creates the replicator.

# Arguments
- `kafka_clusters`: Kafka Clusters to use in setting up sources / targets for replication.
- `replication_info_list`: A list of replication configurations, where each configuration
  targets a given source cluster to target cluster replication flow.
- `replicator_name`: The name of the replicator. Alpha-numeric characters with '-' are
  allowed.
- `service_execution_role_arn`: The ARN of the IAM role used by the replicator to access
  resources in the customer's account (e.g source and target clusters)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A summary description of the replicator.
- `"tags"`: List of tags to attach to created Replicator.
"""
function create_replicator(
    kafkaClusters,
    replicationInfoList,
    replicatorName,
    serviceExecutionRoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/replication/v1/replicators",
        Dict{String,Any}(
            "kafkaClusters" => kafkaClusters,
            "replicationInfoList" => replicationInfoList,
            "replicatorName" => replicatorName,
            "serviceExecutionRoleArn" => serviceExecutionRoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_replicator(
    kafkaClusters,
    replicationInfoList,
    replicatorName,
    serviceExecutionRoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/replication/v1/replicators",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "kafkaClusters" => kafkaClusters,
                    "replicationInfoList" => replicationInfoList,
                    "replicatorName" => replicatorName,
                    "serviceExecutionRoleArn" => serviceExecutionRoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_connection(authentication, client_subnets, security_groups, target_cluster_arn, vpc_id)
    create_vpc_connection(authentication, client_subnets, security_groups, target_cluster_arn, vpc_id, params::Dict{String,<:Any})


            Creates a new MSK VPC connection.

# Arguments
- `authentication`: 
            The authentication type of VPC connection.
- `client_subnets`: 
            The list of client subnets.
- `security_groups`: 
            The list of security groups.
- `target_cluster_arn`: 
            The cluster Amazon Resource Name (ARN) for the VPC
  connection.
- `vpc_id`: 
            The VPC ID of VPC connection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: 
            A map of tags for the VPC connection.
"""
function create_vpc_connection(
    authentication,
    clientSubnets,
    securityGroups,
    targetClusterArn,
    vpcId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/vpc-connection",
        Dict{String,Any}(
            "authentication" => authentication,
            "clientSubnets" => clientSubnets,
            "securityGroups" => securityGroups,
            "targetClusterArn" => targetClusterArn,
            "vpcId" => vpcId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_connection(
    authentication,
    clientSubnets,
    securityGroups,
    targetClusterArn,
    vpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/vpc-connection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "authentication" => authentication,
                    "clientSubnets" => clientSubnets,
                    "securityGroups" => securityGroups,
                    "targetClusterArn" => targetClusterArn,
                    "vpcId" => vpcId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster(cluster_arn)
    delete_cluster(cluster_arn, params::Dict{String,<:Any})


            Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the
request.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentVersion"`: 
            The current version of the MSK cluster.
"""
function delete_cluster(clusterArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "DELETE",
        "/v1/clusters/$(clusterArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "DELETE",
        "/v1/clusters/$(clusterArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cluster_policy(cluster_arn)
    delete_cluster_policy(cluster_arn, params::Dict{String,<:Any})


            Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in
the request.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster.

"""
function delete_cluster_policy(
    clusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "DELETE",
        "/v1/clusters/$(clusterArn)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cluster_policy(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "DELETE",
        "/v1/clusters/$(clusterArn)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_configuration(arn)
    delete_configuration(arn, params::Dict{String,<:Any})


            Deletes an MSK Configuration.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies an MSK
  configuration.

"""
function delete_configuration(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "DELETE",
        "/v1/configurations/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_configuration(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "DELETE",
        "/v1/configurations/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_replicator(replicator_arn)
    delete_replicator(replicator_arn, params::Dict{String,<:Any})

Deletes a replicator.

# Arguments
- `replicator_arn`: The Amazon Resource Name (ARN) of the replicator to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentVersion"`: The current version of the replicator.
"""
function delete_replicator(
    replicatorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "DELETE",
        "/replication/v1/replicators/$(replicatorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_replicator(
    replicatorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "DELETE",
        "/replication/v1/replicators/$(replicatorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_connection(arn)
    delete_vpc_connection(arn, params::Dict{String,<:Any})


            Deletes a MSK VPC connection.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies an MSK VPC
  connection.

"""
function delete_vpc_connection(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "DELETE",
        "/v1/vpc-connection/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_connection(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "DELETE",
        "/v1/vpc-connection/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster(cluster_arn)
    describe_cluster(cluster_arn, params::Dict{String,<:Any})


            Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is
specified in the request.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.

"""
function describe_cluster(clusterArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_operation(cluster_operation_arn)
    describe_cluster_operation(cluster_operation_arn, params::Dict{String,<:Any})


            Returns a description of the cluster operation specified by the ARN.

# Arguments
- `cluster_operation_arn`: 
            The Amazon Resource Name (ARN) that uniquely
  identifies the MSK cluster operation.

"""
function describe_cluster_operation(
    clusterOperationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/operations/$(clusterOperationArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_operation(
    clusterOperationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/operations/$(clusterOperationArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_operation_v2(cluster_operation_arn)
    describe_cluster_operation_v2(cluster_operation_arn, params::Dict{String,<:Any})


            Returns a description of the cluster operation specified by the ARN.

# Arguments
- `cluster_operation_arn`: ARN of the cluster operation to describe.

"""
function describe_cluster_operation_v2(
    clusterOperationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/api/v2/operations/$(clusterOperationArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_operation_v2(
    clusterOperationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/api/v2/operations/$(clusterOperationArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cluster_v2(cluster_arn)
    describe_cluster_v2(cluster_arn, params::Dict{String,<:Any})


            Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is
specified in the request.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.

"""
function describe_cluster_v2(clusterArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/api/v2/clusters/$(clusterArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cluster_v2(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/api/v2/clusters/$(clusterArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration(arn)
    describe_configuration(arn, params::Dict{String,<:Any})


            Returns a description of this MSK configuration.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies an MSK
  configuration and all of its revisions.

"""
function describe_configuration(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/configurations/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/configurations/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_configuration_revision(arn, revision)
    describe_configuration_revision(arn, revision, params::Dict{String,<:Any})


            Returns a description of this revision of the configuration.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies an MSK
  configuration and all of its revisions.
- `revision`: 
            A string that uniquely identifies a revision of an MSK
  configuration.

"""
function describe_configuration_revision(
    arn, revision; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/configurations/$(arn)/revisions/$(revision)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_configuration_revision(
    arn,
    revision,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/configurations/$(arn)/revisions/$(revision)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_replicator(replicator_arn)
    describe_replicator(replicator_arn, params::Dict{String,<:Any})

Describes a replicator.

# Arguments
- `replicator_arn`: The Amazon Resource Name (ARN) of the replicator to be described.

"""
function describe_replicator(
    replicatorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/replication/v1/replicators/$(replicatorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_replicator(
    replicatorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/replication/v1/replicators/$(replicatorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_connection(arn)
    describe_vpc_connection(arn, params::Dict{String,<:Any})


            Returns a description of this MSK VPC connection.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies a MSK VPC
  connection.

"""
function describe_vpc_connection(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/vpc-connection/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_connection(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/vpc-connection/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bootstrap_brokers(cluster_arn)
    get_bootstrap_brokers(cluster_arn, params::Dict{String,<:Any})


            A list of brokers that a client application can use to bootstrap.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.

"""
function get_bootstrap_brokers(
    clusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/bootstrap-brokers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bootstrap_brokers(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/bootstrap-brokers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cluster_policy(cluster_arn)
    get_cluster_policy(cluster_arn, params::Dict{String,<:Any})


            Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the
request.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster.

"""
function get_cluster_policy(clusterArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cluster_policy(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compatible_kafka_versions()
    get_compatible_kafka_versions(params::Dict{String,<:Any})


            Gets the Apache Kafka versions to which you can update the MSK cluster.


# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clusterArn"`: 
            The Amazon Resource Name (ARN) of the cluster check.
  
"""
function get_compatible_kafka_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/compatible-kafka-versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compatible_kafka_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/compatible-kafka-versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_client_vpc_connections(cluster_arn)
    list_client_vpc_connections(cluster_arn, params::Dict{String,<:Any})


            Returns a list of all the VPC connections in this Region.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_client_vpc_connections(
    clusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/client-vpc-connections";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_client_vpc_connections(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/client-vpc-connections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_cluster_operations(cluster_arn)
    list_cluster_operations(cluster_arn, params::Dict{String,<:Any})


            Returns a list of all the operations that have been performed on the specified
MSK cluster.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_cluster_operations(
    clusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/operations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_cluster_operations(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/operations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_cluster_operations_v2(cluster_arn)
    list_cluster_operations_v2(cluster_arn, params::Dict{String,<:Any})


            Returns a list of all the operations that have been performed on the specified
MSK cluster.

# Arguments
- `cluster_arn`: The arn of the cluster whose operations are being requested.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maxResults of the query.
- `"nextToken"`: The nextToken of the query.
"""
function list_cluster_operations_v2(
    clusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/api/v2/clusters/$(clusterArn)/operations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_cluster_operations_v2(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/api/v2/clusters/$(clusterArn)/operations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_clusters()
    list_clusters(params::Dict{String,<:Any})


            Returns a list of all the MSK clusters in the current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clusterNameFilter"`: 
            Specify a prefix of the name of the clusters that you
  want to list. The service lists all the clusters whose names start with this prefix.
  
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_clusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET", "/v1/clusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_clusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/clusters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_clusters_v2()
    list_clusters_v2(params::Dict{String,<:Any})


            Returns a list of all the MSK clusters in the current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clusterNameFilter"`: 
            Specify a prefix of the names of the clusters that
  you want to list. The service lists all the clusters whose names start with this prefix.
  
- `"clusterTypeFilter"`: 
            Specify either PROVISIONED or SERVERLESS.
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_clusters_v2(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET", "/api/v2/clusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_clusters_v2(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/api/v2/clusters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_configuration_revisions(arn)
    list_configuration_revisions(arn, params::Dict{String,<:Any})


            Returns a list of all the MSK configurations in this Region.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies an MSK
  configuration and all of its revisions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_configuration_revisions(
    arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/configurations/$(arn)/revisions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_configuration_revisions(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/configurations/$(arn)/revisions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_configurations()
    list_configurations(params::Dict{String,<:Any})


            Returns a list of all the MSK configurations in this Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET", "/v1/configurations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_kafka_versions()
    list_kafka_versions(params::Dict{String,<:Any})


            Returns a list of Apache Kafka versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. To get the next batch,
  provide this token in your next request.
"""
function list_kafka_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET", "/v1/kafka-versions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_kafka_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/kafka-versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_nodes(cluster_arn)
    list_nodes(cluster_arn, params::Dict{String,<:Any})


            Returns a list of the broker nodes in the cluster.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_nodes(clusterArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/nodes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_nodes(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/nodes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_replicators()
    list_replicators(params::Dict{String,<:Any})

Lists the replicators.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If there are
  more results, the response includes a NextToken parameter.
- `"nextToken"`: If the response of ListReplicators is truncated, it returns a NextToken in
  the response. This NextToken should be sent in the subsequent request to ListReplicators.
- `"replicatorNameFilter"`: Returns replicators starting with given name.
"""
function list_replicators(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/replication/v1/replicators";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_replicators(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/replication/v1/replicators",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_scram_secrets(cluster_arn)
    list_scram_secrets(cluster_arn, params::Dict{String,<:Any})


            Returns a list of the Scram Secrets associated with an Amazon MSK cluster.


# Arguments
- `cluster_arn`: 
            The arn of the cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maxResults of the query.
- `"nextToken"`: 
            The nextToken of the query.
"""
function list_scram_secrets(clusterArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/scram-secrets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_scram_secrets(
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/clusters/$(clusterArn)/scram-secrets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})


            Returns a list of the tags associated with the specified resource.

# Arguments
- `resource_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  resource that's associated with the tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "GET",
        "/v1/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_vpc_connections()
    list_vpc_connections(params::Dict{String,<:Any})


            Returns a list of all the VPC connections in this Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: 
            The maximum number of results to return in the response. If
  there are more results, the response includes a NextToken parameter.
- `"nextToken"`: 
            The paginated results marker. When the result of the
  operation is truncated, the call returns NextToken in the response. 
            To get the
  next batch, provide this token in your next request.
"""
function list_vpc_connections(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "GET", "/v1/vpc-connections"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_vpc_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "GET",
        "/v1/vpc-connections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_cluster_policy(cluster_arn, policy)
    put_cluster_policy(cluster_arn, policy, params::Dict{String,<:Any})


            Creates or updates the MSK cluster policy specified by the cluster Amazon
Resource Name (ARN) in the request.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster.
- `policy`: 
            The policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentVersion"`: 
            The policy version.
"""
function put_cluster_policy(
    clusterArn, policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/policy",
        Dict{String,Any}("policy" => policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_cluster_policy(
    clusterArn,
    policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/policy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("policy" => policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_broker(broker_ids, cluster_arn)
    reboot_broker(broker_ids, cluster_arn, params::Dict{String,<:Any})

Reboots brokers.

# Arguments
- `broker_ids`: 
            The list of broker IDs to be rebooted. The reboot-broker
  operation supports rebooting one broker at a time.
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster to be updated.
  

"""
function reboot_broker(
    brokerIds, clusterArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/reboot-broker",
        Dict{String,Any}("brokerIds" => brokerIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_broker(
    brokerIds,
    clusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/reboot-broker",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("brokerIds" => brokerIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_client_vpc_connection(cluster_arn, vpc_connection_arn)
    reject_client_vpc_connection(cluster_arn, vpc_connection_arn, params::Dict{String,<:Any})


            Returns empty response.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster.
- `vpc_connection_arn`: 
            The VPC connection ARN.

"""
function reject_client_vpc_connection(
    clusterArn, vpcConnectionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/client-vpc-connection",
        Dict{String,Any}("vpcConnectionArn" => vpcConnectionArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_client_vpc_connection(
    clusterArn,
    vpcConnectionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/client-vpc-connection",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("vpcConnectionArn" => vpcConnectionArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})


            Adds tags to the specified MSK resource.

# Arguments
- `resource_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  resource that's associated with the tags.
- `tags`: 
            The key-value pair for the resource tag.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return kafka(
        "POST",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "POST",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})


            Removes the tags associated with the keys that are provided in the query.


# Arguments
- `resource_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  resource that's associated with the tags.
- `tag_keys`: 
            Tag keys must be unique for a given cluster. In addition, the
  following restrictions apply:
            
               
                  Each tag key
  must be unique. If you add a tag with a key that's already in
                  use, your
  new tag overwrites the existing key-value pair.
         You can't start a tag key with aws: because this prefix is reserved for use
           by  AWS.  AWS creates tags that begin with this prefix on your behalf, but
            you can't edit or delete them.
  Tag keys must be between 1 and 128 Unicode characters in length.
      
                  Tag keys must consist of the following characters: Unicode letters,
  digits,
                  white space, and the following special characters: _ . / = + -
                    @.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "DELETE",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "DELETE",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_broker_count(cluster_arn, current_version, target_number_of_broker_nodes)
    update_broker_count(cluster_arn, current_version, target_number_of_broker_nodes, params::Dict{String,<:Any})


            Updates the number of broker nodes in the cluster.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.
- `current_version`: 
            The version of cluster to update from. A successful
  operation will then generate a new version.
- `target_number_of_broker_nodes`: 
            The number of broker nodes that you want
  the cluster to have after this operation completes successfully.

"""
function update_broker_count(
    clusterArn,
    currentVersion,
    targetNumberOfBrokerNodes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/nodes/count",
        Dict{String,Any}(
            "currentVersion" => currentVersion,
            "targetNumberOfBrokerNodes" => targetNumberOfBrokerNodes,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_broker_count(
    clusterArn,
    currentVersion,
    targetNumberOfBrokerNodes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/nodes/count",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "currentVersion" => currentVersion,
                    "targetNumberOfBrokerNodes" => targetNumberOfBrokerNodes,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_broker_storage(cluster_arn, current_version, target_broker_ebsvolume_info)
    update_broker_storage(cluster_arn, current_version, target_broker_ebsvolume_info, params::Dict{String,<:Any})


            Updates the EBS storage associated with MSK brokers.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.
- `current_version`: 
            The version of cluster to update from. A successful
  operation will then generate a new version.
- `target_broker_ebsvolume_info`: 
            Describes the target volume size and the ID
  of the broker to apply the update to.

"""
function update_broker_storage(
    clusterArn,
    currentVersion,
    targetBrokerEBSVolumeInfo;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/nodes/storage",
        Dict{String,Any}(
            "currentVersion" => currentVersion,
            "targetBrokerEBSVolumeInfo" => targetBrokerEBSVolumeInfo,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_broker_storage(
    clusterArn,
    currentVersion,
    targetBrokerEBSVolumeInfo,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/nodes/storage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "currentVersion" => currentVersion,
                    "targetBrokerEBSVolumeInfo" => targetBrokerEBSVolumeInfo,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_broker_type(cluster_arn, current_version, target_instance_type)
    update_broker_type(cluster_arn, current_version, target_instance_type, params::Dict{String,<:Any})


            Updates EC2 instance type.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.
- `current_version`: 
            The cluster version that you want to change. After this
  operation completes successfully, the cluster will have a new version.
- `target_instance_type`: 
            The Amazon MSK broker type that you want all of the
  brokers in this cluster to be.

"""
function update_broker_type(
    clusterArn,
    currentVersion,
    targetInstanceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/nodes/type",
        Dict{String,Any}(
            "currentVersion" => currentVersion, "targetInstanceType" => targetInstanceType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_broker_type(
    clusterArn,
    currentVersion,
    targetInstanceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/nodes/type",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "currentVersion" => currentVersion,
                    "targetInstanceType" => targetInstanceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_cluster_configuration(cluster_arn, configuration_info, current_version)
    update_cluster_configuration(cluster_arn, configuration_info, current_version, params::Dict{String,<:Any})


            Updates the cluster with the configuration that is specified in the request
body.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.
- `configuration_info`: 
            Represents the configuration that you want MSK to use
  for the brokers in a cluster.
- `current_version`: 
            The version of the cluster that needs to be updated.
  

"""
function update_cluster_configuration(
    clusterArn,
    configurationInfo,
    currentVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/configuration",
        Dict{String,Any}(
            "configurationInfo" => configurationInfo, "currentVersion" => currentVersion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_cluster_configuration(
    clusterArn,
    configurationInfo,
    currentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configurationInfo" => configurationInfo,
                    "currentVersion" => currentVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_cluster_kafka_version(cluster_arn, current_version, target_kafka_version)
    update_cluster_kafka_version(cluster_arn, current_version, target_kafka_version, params::Dict{String,<:Any})


            Updates the Apache Kafka version for the cluster.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster to be updated.
  
- `current_version`: 
            Current cluster version.
- `target_kafka_version`: 
            Target Kafka version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"configurationInfo"`: 
            The custom configuration that should be applied on
  the new version of cluster.
"""
function update_cluster_kafka_version(
    clusterArn,
    currentVersion,
    targetKafkaVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/version",
        Dict{String,Any}(
            "currentVersion" => currentVersion, "targetKafkaVersion" => targetKafkaVersion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_cluster_kafka_version(
    clusterArn,
    currentVersion,
    targetKafkaVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/version",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "currentVersion" => currentVersion,
                    "targetKafkaVersion" => targetKafkaVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_configuration(arn, server_properties)
    update_configuration(arn, server_properties, params::Dict{String,<:Any})


            Updates an MSK configuration.

# Arguments
- `arn`: 
            The Amazon Resource Name (ARN) of the configuration.
- `server_properties`: 
            Contents of the server.properties file. When using the
  API, you must ensure that the contents of the file are base64 encoded. 
               When
  using the AWS Management Console, the SDK, or the AWS CLI, the contents of
  server.properties can be in plaintext.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: 
            The description of the configuration revision.
"""
function update_configuration(
    arn, serverProperties; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PUT",
        "/v1/configurations/$(arn)",
        Dict{String,Any}("serverProperties" => serverProperties);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_configuration(
    arn,
    serverProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/configurations/$(arn)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("serverProperties" => serverProperties), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connectivity(cluster_arn, connectivity_info, current_version)
    update_connectivity(cluster_arn, connectivity_info, current_version, params::Dict{String,<:Any})


            Updates the cluster's connectivity configuration.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the configuration.
- `connectivity_info`: 
            Information about the broker access configuration.
  
- `current_version`: 
            The version of the MSK cluster to update. Cluster
  versions aren't simple numbers. You can describe an MSK cluster to find its version. When
  this update operation is successful, it generates a new cluster version.

"""
function update_connectivity(
    clusterArn,
    connectivityInfo,
    currentVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/connectivity",
        Dict{String,Any}(
            "connectivityInfo" => connectivityInfo, "currentVersion" => currentVersion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connectivity(
    clusterArn,
    connectivityInfo,
    currentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/connectivity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "connectivityInfo" => connectivityInfo,
                    "currentVersion" => currentVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_monitoring(cluster_arn, current_version)
    update_monitoring(cluster_arn, current_version, params::Dict{String,<:Any})


            Updates the monitoring settings for the cluster. You can use this operation to
specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You
can also specify settings for open monitoring with Prometheus.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.
- `current_version`: 
            The version of the MSK cluster to update. Cluster
  versions aren't simple numbers. You can describe an MSK cluster to find its version. When
  this update operation is successful, it generates a new cluster version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enhancedMonitoring"`: 
            Specifies which Apache Kafka metrics Amazon MSK
  gathers and sends to Amazon CloudWatch for this cluster.
- `"loggingInfo"`:
- `"openMonitoring"`: 
            The settings for open monitoring.
"""
function update_monitoring(
    clusterArn, currentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/monitoring",
        Dict{String,Any}("currentVersion" => currentVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_monitoring(
    clusterArn,
    currentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/monitoring",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("currentVersion" => currentVersion), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_replication_info(current_version, replicator_arn, source_kafka_cluster_arn, target_kafka_cluster_arn)
    update_replication_info(current_version, replicator_arn, source_kafka_cluster_arn, target_kafka_cluster_arn, params::Dict{String,<:Any})

Updates replication info of a replicator.

# Arguments
- `current_version`: Current replicator version.
- `replicator_arn`: The Amazon Resource Name (ARN) of the replicator to be updated.
- `source_kafka_cluster_arn`: The ARN of the source Kafka cluster.
- `target_kafka_cluster_arn`: The ARN of the target Kafka cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"consumerGroupReplication"`: Updated consumer group replication information.
- `"topicReplication"`: Updated topic replication information.
"""
function update_replication_info(
    currentVersion,
    replicatorArn,
    sourceKafkaClusterArn,
    targetKafkaClusterArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/replication/v1/replicators/$(replicatorArn)/replication-info",
        Dict{String,Any}(
            "currentVersion" => currentVersion,
            "sourceKafkaClusterArn" => sourceKafkaClusterArn,
            "targetKafkaClusterArn" => targetKafkaClusterArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_replication_info(
    currentVersion,
    replicatorArn,
    sourceKafkaClusterArn,
    targetKafkaClusterArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/replication/v1/replicators/$(replicatorArn)/replication-info",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "currentVersion" => currentVersion,
                    "sourceKafkaClusterArn" => sourceKafkaClusterArn,
                    "targetKafkaClusterArn" => targetKafkaClusterArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_security(cluster_arn, current_version)
    update_security(cluster_arn, current_version, params::Dict{String,<:Any})


            Updates the security settings for the cluster. You can use this operation to
specify encryption and authentication on existing clusters.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) that uniquely identifies the
  cluster.
- `current_version`: 
            The version of the MSK cluster to update. Cluster
  versions aren't simple numbers. You can describe an MSK cluster to find its version. When
  this update operation is successful, it generates a new cluster version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientAuthentication"`: 
            Includes all client authentication related
  information.
- `"encryptionInfo"`: 
            Includes all encryption-related information.
"""
function update_security(
    clusterArn, currentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PATCH",
        "/v1/clusters/$(clusterArn)/security",
        Dict{String,Any}("currentVersion" => currentVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_security(
    clusterArn,
    currentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PATCH",
        "/v1/clusters/$(clusterArn)/security",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("currentVersion" => currentVersion), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_storage(cluster_arn, current_version)
    update_storage(cluster_arn, current_version, params::Dict{String,<:Any})

Updates cluster broker volume size (or) sets cluster storage mode to TIERED.

# Arguments
- `cluster_arn`: 
            The Amazon Resource Name (ARN) of the cluster to be updated.
  
- `current_version`: 
            The version of cluster to update from. A successful
  operation will then generate a new version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"provisionedThroughput"`: 
            EBS volume provisioned throughput information.
  
- `"storageMode"`: 
            Controls storage mode for supported storage tiers.
- `"volumeSizeGB"`: 
            size of the EBS volume to update.
"""
function update_storage(
    clusterArn, currentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/storage",
        Dict{String,Any}("currentVersion" => currentVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_storage(
    clusterArn,
    currentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafka(
        "PUT",
        "/v1/clusters/$(clusterArn)/storage",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("currentVersion" => currentVersion), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
