# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: location
using AWS.Compat
using AWS.UUIDs

"""
    associate_tracker_consumer(consumer_arn, tracker_name)
    associate_tracker_consumer(consumer_arn, tracker_name, params::Dict{String,<:Any})

Creates an association between a geofence collection and a tracker resource. This allows
the tracker resource to communicate location data to the linked geofence collection.  You
can associate up to five geofence collections to each tracker resource.  Currently not
supported — Cross-account configurations, such as creating associations between a tracker
resource in one account and a geofence collection in another account.

# Arguments
- `consumer_arn`: The Amazon Resource Name (ARN) for the geofence collection to be
  associated to tracker resource. Used when you need to specify a resource across all Amazon
  Web Services.   Format example:
  arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer
- `tracker_name`: The name of the tracker resource to be associated with a geofence
  collection.

"""
function associate_tracker_consumer(
    ConsumerArn, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/consumers",
        Dict{String,Any}("ConsumerArn" => ConsumerArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_tracker_consumer(
    ConsumerArn,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/consumers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConsumerArn" => ConsumerArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_device_position_history(device_ids, tracker_name)
    batch_delete_device_position_history(device_ids, tracker_name, params::Dict{String,<:Any})

Deletes the position history of one or more devices from a tracker resource.

# Arguments
- `device_ids`: Devices whose position history you want to delete.   For example, for two
  devices: “DeviceIds” : [DeviceId1,DeviceId2]
- `tracker_name`: The name of the tracker resource to delete the device position history
  from.

"""
function batch_delete_device_position_history(
    DeviceIds, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/delete-positions",
        Dict{String,Any}("DeviceIds" => DeviceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_device_position_history(
    DeviceIds,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/delete-positions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeviceIds" => DeviceIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_geofence(collection_name, geofence_ids)
    batch_delete_geofence(collection_name, geofence_ids, params::Dict{String,<:Any})

Deletes a batch of geofences from a geofence collection.  This operation deletes the
resource permanently.

# Arguments
- `collection_name`: The geofence collection storing the geofences to be deleted.
- `geofence_ids`: The batch of geofences to be deleted.

"""
function batch_delete_geofence(
    CollectionName, GeofenceIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/delete-geofences",
        Dict{String,Any}("GeofenceIds" => GeofenceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_geofence(
    CollectionName,
    GeofenceIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/delete-geofences",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GeofenceIds" => GeofenceIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_evaluate_geofences(collection_name, device_position_updates)
    batch_evaluate_geofences(collection_name, device_position_updates, params::Dict{String,<:Any})

Evaluates device positions against the geofence geometries from a given geofence
collection. This operation always returns an empty response because geofences are
asynchronously evaluated. The evaluation determines if the device has entered or exited a
geofenced area, and then publishes one of the following events to Amazon EventBridge:
ENTER if Amazon Location determines that the tracked device has entered a geofenced area.
 EXIT if Amazon Location determines that the tracked device has exited a geofenced area.
The last geofence that a device was observed within is tracked for 30 days after the most
recent device position update.   Geofence evaluation uses the given device position. It
does not account for the optional Accuracy of a DevicePositionUpdate.   The DeviceID is
used as a string to represent the device. You do not need to have a Tracker associated with
the DeviceID.

# Arguments
- `collection_name`: The geofence collection used in evaluating the position of devices
  against its geofences.
- `device_position_updates`: Contains device details for each device to be evaluated
  against the given geofence collection.

"""
function batch_evaluate_geofences(
    CollectionName,
    DevicePositionUpdates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/positions",
        Dict{String,Any}("DevicePositionUpdates" => DevicePositionUpdates);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_evaluate_geofences(
    CollectionName,
    DevicePositionUpdates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/positions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DevicePositionUpdates" => DevicePositionUpdates),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_device_position(device_ids, tracker_name)
    batch_get_device_position(device_ids, tracker_name, params::Dict{String,<:Any})

Lists the latest device positions for requested devices.

# Arguments
- `device_ids`: Devices whose position you want to retrieve.   For example, for two
  devices: device-ids=DeviceId1&amp;device-ids=DeviceId2
- `tracker_name`: The tracker resource retrieving the device position.

"""
function batch_get_device_position(
    DeviceIds, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/get-positions",
        Dict{String,Any}("DeviceIds" => DeviceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_device_position(
    DeviceIds,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/get-positions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeviceIds" => DeviceIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_put_geofence(collection_name, entries)
    batch_put_geofence(collection_name, entries, params::Dict{String,<:Any})

A batch request for storing geofence geometries into a given geofence collection, or
updates the geometry of an existing geofence if a geofence ID is included in the request.

# Arguments
- `collection_name`: The geofence collection storing the geofences.
- `entries`: The batch of geofences to be stored in a geofence collection.

"""
function batch_put_geofence(
    CollectionName, Entries; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/put-geofences",
        Dict{String,Any}("Entries" => Entries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_put_geofence(
    CollectionName,
    Entries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/put-geofences",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Entries" => Entries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_device_position(tracker_name, updates)
    batch_update_device_position(tracker_name, updates, params::Dict{String,<:Any})

Uploads position update data for one or more devices to a tracker resource (up to 10
devices per batch). Amazon Location uses the data when it reports the last known device
position and position history. Amazon Location retains location data for 30 days.  Position
updates are handled based on the PositionFiltering property of the tracker. When
PositionFiltering is set to TimeBased, updates are evaluated against linked geofence
collections, and location data is stored at a maximum of one position per 30 second
interval. If your update frequency is more often than every 30 seconds, only one update per
30 seconds is stored for each unique device ID. When PositionFiltering is set to
DistanceBased filtering, location data is stored and evaluated against linked geofence
collections only if the device has moved more than 30 m (98.4 ft). When PositionFiltering
is set to AccuracyBased filtering, location data is stored and evaluated against linked
geofence collections only if the device has moved more than the measured accuracy. For
example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10
m, the second update is neither stored or evaluated if the device has moved less than 15 m.
If PositionFiltering is set to AccuracyBased filtering, Amazon Location uses the default
value { \"Horizontal\": 0} when accuracy is not provided on a DevicePositionUpdate.

# Arguments
- `tracker_name`: The name of the tracker resource to update.
- `updates`: Contains the position update details for each device, up to 10 devices.

"""
function batch_update_device_position(
    TrackerName, Updates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/positions",
        Dict{String,Any}("Updates" => Updates);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_device_position(
    TrackerName,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/positions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Updates" => Updates), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    calculate_route(calculator_name, departure_position, destination_position)
    calculate_route(calculator_name, departure_position, destination_position, params::Dict{String,<:Any})

 Calculates a route given the following required parameters: DeparturePosition and
DestinationPosition. Requires that you first create a route calculator resource. By
default, a request that doesn't specify a departure time uses the best time of day to
travel with the best traffic conditions when calculating the route. Additional options
include:    Specifying a departure time using either DepartureTime or DepartNow. This
calculates a route based on predictive traffic data at the given time.   You can't specify
both DepartureTime and DepartNow in a single request. Specifying both parameters returns a
validation error.     Specifying a travel mode using TravelMode sets the transportation
mode used to calculate the routes. This also lets you specify additional route preferences
in CarModeOptions if traveling by Car, or TruckModeOptions if traveling by Truck.  If you
specify walking for the travel mode and your data provider is Esri, the start and
destination must be within 40km.

# Arguments
- `calculator_name`: The name of the route calculator resource that you want to use to
  calculate the route.
- `departure_position`: The start position for the route. Defined in World Geodetic System
  (WGS 84) format: [longitude, latitude].   For example, [-123.115, 49.285]     If you
  specify a departure that's not located on a road, Amazon Location moves the position to the
  nearest road. If Esri is the provider for your route calculator, specifying a route that is
  longer than 400 km returns a 400 RoutesValidationException error.  Valid Values: [-180 to
  180,-90 to 90]
- `destination_position`: The finish position for the route. Defined in World Geodetic
  System (WGS 84) format: [longitude, latitude].    For example, [-122.339, 47.615]     If
  you specify a destination that's not located on a road, Amazon Location moves the position
  to the nearest road.   Valid Values: [-180 to 180,-90 to 90]

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ArrivalTime"`: Specifies the desired time of arrival. Uses the given time to calculate
  the route. Otherwise, the best time of day to travel with the best traffic conditions is
  used to calculate the route.  ArrivalTime is not supported Esri.
- `"CarModeOptions"`: Specifies route preferences when traveling by Car, such as avoiding
  routes that use ferries or tolls. Requirements: TravelMode must be specified as Car.
- `"DepartNow"`: Sets the time of departure as the current time. Uses the current time to
  calculate a route. Otherwise, the best time of day to travel with the best traffic
  conditions is used to calculate the route. Default Value: false  Valid Values: false | true
- `"DepartureTime"`: Specifies the desired time of departure. Uses the given time to
  calculate the route. Otherwise, the best time of day to travel with the best traffic
  conditions is used to calculate the route.   In ISO 8601 format: YYYY-MM-DDThh:mm:ss.sssZ.
  For example, 2020–07-2T12:15:20.000Z+01:00
- `"DistanceUnit"`: Set the unit system to specify the distance. Default Value: Kilometers
- `"IncludeLegGeometry"`: Set to include the geometry details in the result for each path
  between a pair of positions. Default Value: false  Valid Values: false | true
- `"OptimizeFor"`: Specifies the distance to optimize for when calculating a route.
- `"TravelMode"`: Specifies the mode of transport when calculating a route. Used in
  estimating the speed of travel and road compatibility. You can choose Car, Truck, Walking,
  Bicycle or Motorcycle as options for the TravelMode.   Bicycle and Motorcycle are only
  valid when using Grab as a data provider, and only within Southeast Asia.  Truck is not
  available for Grab. For more details on the using Grab for routing, including areas of
  coverage, see GrabMaps in the Amazon Location Service Developer Guide.  The TravelMode you
  specify also determines how you specify route preferences:    If traveling by Car use the
  CarModeOptions parameter.   If traveling by Truck use the TruckModeOptions parameter.
  Default Value: Car
- `"TruckModeOptions"`: Specifies route preferences when traveling by Truck, such as
  avoiding routes that use ferries or tolls, and truck specifications to consider when
  choosing an optimal road. Requirements: TravelMode must be specified as Truck.
- `"WaypointPositions"`: Specifies an ordered list of up to 23 intermediate positions to
  include along a route between the departure position and destination position.    For
  example, from the DeparturePosition [-123.115, 49.285], the route follows the order that
  the waypoint positions are given [[-122.757, 49.0021],[-122.349, 47.620]]     If you
  specify a waypoint position that's not located on a road, Amazon Location moves the
  position to the nearest road.  Specifying more than 23 waypoints returns a 400
  ValidationException error. If Esri is the provider for your route calculator, specifying a
  route that is longer than 400 km returns a 400 RoutesValidationException error.  Valid
  Values: [-180 to 180,-90 to 90]
- `"key"`: The optional API key to authorize the request.
"""
function calculate_route(
    CalculatorName,
    DeparturePosition,
    DestinationPosition;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/routes/v0/calculators/$(CalculatorName)/calculate/route",
        Dict{String,Any}(
            "DeparturePosition" => DeparturePosition,
            "DestinationPosition" => DestinationPosition,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function calculate_route(
    CalculatorName,
    DeparturePosition,
    DestinationPosition,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/routes/v0/calculators/$(CalculatorName)/calculate/route",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeparturePosition" => DeparturePosition,
                    "DestinationPosition" => DestinationPosition,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    calculate_route_matrix(calculator_name, departure_positions, destination_positions)
    calculate_route_matrix(calculator_name, departure_positions, destination_positions, params::Dict{String,<:Any})

  Calculates a route matrix given the following required parameters: DeparturePositions and
DestinationPositions. CalculateRouteMatrix calculates routes and returns the travel time
and travel distance from each departure position to each destination position in the
request. For example, given departure positions A and B, and destination positions X and Y,
CalculateRouteMatrix will return time and distance for routes from A to X, A to Y, B to X,
and B to Y (in that order). The number of results returned (and routes calculated) will be
the number of DeparturePositions times the number of DestinationPositions.  Your account is
charged for each route calculated, not the number of requests.  Requires that you first
create a route calculator resource. By default, a request that doesn't specify a departure
time uses the best time of day to travel with the best traffic conditions when calculating
routes. Additional options include:     Specifying a departure time using either
DepartureTime or DepartNow. This calculates routes based on predictive traffic data at the
given time.   You can't specify both DepartureTime and DepartNow in a single request.
Specifying both parameters returns a validation error.     Specifying a travel mode using
TravelMode sets the transportation mode used to calculate the routes. This also lets you
specify additional route preferences in CarModeOptions if traveling by Car, or
TruckModeOptions if traveling by Truck.

# Arguments
- `calculator_name`: The name of the route calculator resource that you want to use to
  calculate the route matrix.
- `departure_positions`: The list of departure (origin) positions for the route matrix. An
  array of points, each of which is itself a 2-value array defined in WGS 84 format:
  [longitude, latitude]. For example, [-123.115, 49.285].  Depending on the data provider
  selected in the route calculator resource there may be additional restrictions on the
  inputs you can choose. See  Position restrictions in the Amazon Location Service Developer
  Guide.   For route calculators that use Esri as the data provider, if you specify a
  departure that's not located on a road, Amazon Location  moves the position to the nearest
  road. The snapped value is available in the result in SnappedDeparturePositions.  Valid
  Values: [-180 to 180,-90 to 90]
- `destination_positions`: The list of destination positions for the route matrix. An array
  of points, each of which is itself a 2-value array defined in WGS 84 format: [longitude,
  latitude]. For example, [-122.339, 47.615]   Depending on the data provider selected in the
  route calculator resource there may be additional restrictions on the inputs you can
  choose. See  Position restrictions in the Amazon Location Service Developer Guide.   For
  route calculators that use Esri as the data provider, if you specify a destination that's
  not located on a road, Amazon Location  moves the position to the nearest road. The snapped
  value is available in the result in SnappedDestinationPositions.  Valid Values: [-180 to
  180,-90 to 90]

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CarModeOptions"`: Specifies route preferences when traveling by Car, such as avoiding
  routes that use ferries or tolls. Requirements: TravelMode must be specified as Car.
- `"DepartNow"`: Sets the time of departure as the current time. Uses the current time to
  calculate the route matrix. You can't set both DepartureTime and DepartNow. If neither is
  set, the best time of day to travel with the best traffic conditions is used to calculate
  the route matrix. Default Value: false  Valid Values: false | true
- `"DepartureTime"`: Specifies the desired time of departure. Uses the given time to
  calculate the route matrix. You can't set both DepartureTime and DepartNow. If neither is
  set, the best time of day to travel with the best traffic conditions is used to calculate
  the route matrix.  Setting a departure time in the past returns a 400 ValidationException
  error.    In ISO 8601 format: YYYY-MM-DDThh:mm:ss.sssZ. For example,
  2020–07-2T12:15:20.000Z+01:00
- `"DistanceUnit"`: Set the unit system to specify the distance. Default Value: Kilometers
- `"TravelMode"`: Specifies the mode of transport when calculating a route. Used in
  estimating the speed of travel and road compatibility. The TravelMode you specify also
  determines how you specify route preferences:    If traveling by Car use the CarModeOptions
  parameter.   If traveling by Truck use the TruckModeOptions parameter.     Bicycle or
  Motorcycle are only valid when using Grab as a data provider, and only within Southeast
  Asia.  Truck is not available for Grab. For more information about using Grab as a data
  provider, see GrabMaps in the Amazon Location Service Developer Guide.  Default Value: Car
- `"TruckModeOptions"`: Specifies route preferences when traveling by Truck, such as
  avoiding routes that use ferries or tolls, and truck specifications to consider when
  choosing an optimal road. Requirements: TravelMode must be specified as Truck.
- `"key"`: The optional API key to authorize the request.
"""
function calculate_route_matrix(
    CalculatorName,
    DeparturePositions,
    DestinationPositions;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/routes/v0/calculators/$(CalculatorName)/calculate/route-matrix",
        Dict{String,Any}(
            "DeparturePositions" => DeparturePositions,
            "DestinationPositions" => DestinationPositions,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function calculate_route_matrix(
    CalculatorName,
    DeparturePositions,
    DestinationPositions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/routes/v0/calculators/$(CalculatorName)/calculate/route-matrix",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeparturePositions" => DeparturePositions,
                    "DestinationPositions" => DestinationPositions,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_geofence_collection(collection_name)
    create_geofence_collection(collection_name, params::Dict{String,<:Any})

Creates a geofence collection, which manages and stores geofences.

# Arguments
- `collection_name`: A custom name for the geofence collection. Requirements:   Contain
  only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and
  underscores (_).    Must be a unique geofence collection name.   No spaces allowed. For
  example, ExampleGeofenceCollection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: An optional description for the geofence collection.
- `"KmsKeyId"`: A key identifier for an Amazon Web Services KMS customer managed key. Enter
  a key ID, key ARN, alias name, or alias ARN.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"PricingPlanDataSource"`: This parameter is no longer used.
- `"Tags"`: Applies one or more tags to the geofence collection. A tag is a key-value pair
  helps manage, identify, search, and filter your resources by labelling them. Format:
  \"key\" : \"value\"  Restrictions:   Maximum 50 tags per resource   Each resource tag must
  be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in
  UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric
  characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.    Cannot
  use \"aws:\" as a prefix for a key.
"""
function create_geofence_collection(
    CollectionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/geofencing/v0/collections",
        Dict{String,Any}("CollectionName" => CollectionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_geofence_collection(
    CollectionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CollectionName" => CollectionName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_key(key_name, restrictions)
    create_key(key_name, restrictions, params::Dict{String,<:Any})

Creates an API key resource in your Amazon Web Services account, which lets you grant
actions for Amazon Location resources to the API key bearer.  For more information, see
Using API keys.

# Arguments
- `key_name`: A custom name for the API key resource. Requirements:   Contain only
  alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores
  (_).    Must be a unique API key name.   No spaces allowed. For example, ExampleAPIKey.
- `restrictions`: The API key restrictions for the API key resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: An optional description for the API key resource.
- `"ExpireTime"`: The optional timestamp for when the API key resource will expire in  ISO
  8601 format: YYYY-MM-DDThh:mm:ss.sssZ. One of NoExpiry or ExpireTime must be set.
- `"NoExpiry"`: Optionally set to true to set no expiration time for the API key. One of
  NoExpiry or ExpireTime must be set.
- `"Tags"`: Applies one or more tags to the map resource. A tag is a key-value pair that
  helps manage, identify, search, and filter your resources by labelling them. Format:
  \"key\" : \"value\"  Restrictions:   Maximum 50 tags per resource   Each resource tag must
  be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in
  UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric
  characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.    Cannot
  use \"aws:\" as a prefix for a key.
"""
function create_key(
    KeyName, Restrictions; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/metadata/v0/keys",
        Dict{String,Any}("KeyName" => KeyName, "Restrictions" => Restrictions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_key(
    KeyName,
    Restrictions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/metadata/v0/keys",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("KeyName" => KeyName, "Restrictions" => Restrictions),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_map(configuration, map_name)
    create_map(configuration, map_name, params::Dict{String,<:Any})

Creates a map resource in your Amazon Web Services account, which provides map tiles of
different styles sourced from global location data providers.  If your application is
tracking or routing assets you use in your business, such as delivery vehicles or
employees, you must not use Esri as your geolocation provider. See section 82 of the Amazon
Web Services service terms for more details.

# Arguments
- `configuration`: Specifies the MapConfiguration, including the map style, for the map
  resource that you create. The map style defines the look of maps and the data provider for
  your map resource.
- `map_name`: The name for the map resource. Requirements:   Must contain only alphanumeric
  characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).    Must be
  a unique map resource name.    No spaces allowed. For example, ExampleMap.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: An optional description for the map resource.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"Tags"`: Applies one or more tags to the map resource. A tag is a key-value pair helps
  manage, identify, search, and filter your resources by labelling them. Format: \"key\" :
  \"value\"  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique
  with a maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8
  Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric characters
  (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.    Cannot use
  \"aws:\" as a prefix for a key.
"""
function create_map(
    Configuration, MapName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/maps/v0/maps",
        Dict{String,Any}("Configuration" => Configuration, "MapName" => MapName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_map(
    Configuration,
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/maps/v0/maps",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Configuration" => Configuration, "MapName" => MapName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_place_index(data_source, index_name)
    create_place_index(data_source, index_name, params::Dict{String,<:Any})

Creates a place index resource in your Amazon Web Services account. Use a place index
resource to geocode addresses and other text queries by using the SearchPlaceIndexForText
operation, and reverse geocode coordinates by using the SearchPlaceIndexForPosition
operation, and enable autosuggestions by using the SearchPlaceIndexForSuggestions
operation.  If your application is tracking or routing assets you use in your business,
such as delivery vehicles or employees, you must not use Esri as your geolocation provider.
See section 82 of the Amazon Web Services service terms for more details.

# Arguments
- `data_source`: Specifies the geospatial data provider for the new place index.  This
  field is case-sensitive. Enter the valid values as shown. For example, entering HERE
  returns an error.  Valid values include:    Esri – For additional information about
  Esri's coverage in your region of interest, see Esri details on geocoding coverage.    Grab
  – Grab provides place index functionality for Southeast Asia. For additional information
  about GrabMaps' coverage, see GrabMaps countries and areas covered.    Here – For
  additional information about HERE Technologies' coverage in your region of interest, see
  HERE details on goecoding coverage.  If you specify HERE Technologies (Here) as the data
  provider, you may not store results for locations in Japan. For more information, see the
  Amazon Web Services Service Terms for Amazon Location Service.    For additional
  information , see Data providers on the Amazon Location Service Developer Guide.
- `index_name`: The name of the place index resource.  Requirements:   Contain only
  alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores
  (_).   Must be a unique place index resource name.   No spaces allowed. For example,
  ExamplePlaceIndex.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceConfiguration"`: Specifies the data storage option requesting Places.
- `"Description"`: The optional description for the place index resource.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"Tags"`: Applies one or more tags to the place index resource. A tag is a key-value pair
  that helps you manage, identify, search, and filter your resources. Format: \"key\" :
  \"value\"  Restrictions:   Maximum 50 tags per resource.   Each tag key must be unique and
  must have exactly one associated value.   Maximum key length: 128 Unicode characters in
  UTF-8.   Maximum value length: 256 Unicode characters in UTF-8.   Can use alphanumeric
  characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @   Cannot
  use \"aws:\" as a prefix for a key.
"""
function create_place_index(
    DataSource, IndexName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/places/v0/indexes",
        Dict{String,Any}("DataSource" => DataSource, "IndexName" => IndexName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_place_index(
    DataSource,
    IndexName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/places/v0/indexes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DataSource" => DataSource, "IndexName" => IndexName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_route_calculator(calculator_name, data_source)
    create_route_calculator(calculator_name, data_source, params::Dict{String,<:Any})

Creates a route calculator resource in your Amazon Web Services account. You can send
requests to a route calculator resource to estimate travel time, distance, and get
directions. A route calculator sources traffic and road network data from your chosen data
provider.  If your application is tracking or routing assets you use in your business, such
as delivery vehicles or employees, you must not use Esri as your geolocation provider. See
section 82 of the Amazon Web Services service terms for more details.

# Arguments
- `calculator_name`: The name of the route calculator resource.  Requirements:   Can use
  alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores
  (_).   Must be a unique Route calculator resource name.   No spaces allowed. For example,
  ExampleRouteCalculator.
- `data_source`: Specifies the data provider of traffic and road network data.  This field
  is case-sensitive. Enter the valid values as shown. For example, entering HERE returns an
  error.  Valid values include:    Esri – For additional information about Esri's coverage
  in your region of interest, see Esri details on street networks and traffic coverage. Route
  calculators that use Esri as a data source only calculate routes that are shorter than 400
  km.    Grab – Grab provides routing functionality for Southeast Asia. For additional
  information about GrabMaps' coverage, see GrabMaps countries and areas covered.    Here –
  For additional information about HERE Technologies' coverage in your region of interest,
  see HERE car routing coverage and HERE truck routing coverage.   For additional information
  , see Data providers on the Amazon Location Service Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The optional description for the route calculator resource.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"Tags"`: Applies one or more tags to the route calculator resource. A tag is a key-value
  pair helps manage, identify, search, and filter your resources by labelling them.   For
  example: { \"tag1\" : \"value1\", \"tag2\" : \"value2\"}   Format: \"key\" : \"value\"
  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique with a
  maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8   Maximum value
  length: 256 Unicode characters in UTF-8   Can use alphanumeric characters (A–Z, a–z,
  0–9), and the following characters: + - = . _ : / @.    Cannot use \"aws:\" as a prefix
  for a key.
"""
function create_route_calculator(
    CalculatorName, DataSource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/routes/v0/calculators",
        Dict{String,Any}("CalculatorName" => CalculatorName, "DataSource" => DataSource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_route_calculator(
    CalculatorName,
    DataSource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/routes/v0/calculators",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CalculatorName" => CalculatorName, "DataSource" => DataSource
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tracker(tracker_name)
    create_tracker(tracker_name, params::Dict{String,<:Any})

Creates a tracker resource in your Amazon Web Services account, which lets you retrieve
current and historical location of devices.

# Arguments
- `tracker_name`: The name for the tracker resource. Requirements:   Contain only
  alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
  Must be a unique tracker resource name.   No spaces allowed. For example, ExampleTracker.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: An optional description for the tracker resource.
- `"EventBridgeEnabled"`: Whether to enable position UPDATE events from this tracker to be
  sent to EventBridge.  You do not need enable this feature to get ENTER and EXIT events for
  geofences with this tracker. Those events are always sent to EventBridge.
- `"KmsKeyEnableGeospatialQueries"`: Enables GeospatialQueries for a tracker that uses a
  Amazon Web Services KMS customer managed key. This parameter is only used if you are using
  a KMS customer managed key.  If you wish to encrypt your data using your own KMS customer
  managed key, then the Bounding Polygon Queries feature will be disabled by default. This is
  because by using this feature, a representation of your device positions will not be
  encrypted using the your KMS managed key. The exact device position, however; is still
  encrypted using your managed key. You can choose to opt-in to the Bounding Polygon Quseries
  feature. This is done by setting the KmsKeyEnableGeospatialQueries parameter to true when
  creating or updating a Tracker.
- `"KmsKeyId"`: A key identifier for an Amazon Web Services KMS customer managed key. Enter
  a key ID, key ARN, alias name, or alias ARN.
- `"PositionFiltering"`: Specifies the position filtering for the tracker resource. Valid
  values:    TimeBased - Location updates are evaluated against linked geofence collections,
  but not every location update is stored. If your update frequency is more often than 30
  seconds, only one update per 30 seconds is stored for each unique device ID.
  DistanceBased - If the device has moved less than 30 m (98.4 ft), location updates are
  ignored. Location updates within this area are neither evaluated against linked geofence
  collections, nor stored. This helps control costs by reducing the number of geofence
  evaluations and historical device positions to paginate through. Distance-based filtering
  can also reduce the effects of GPS noise when displaying device trajectories on a map.
  AccuracyBased - If the device has moved less than the measured accuracy, location updates
  are ignored. For example, if two consecutive updates from a device have a horizontal
  accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15
  m. Ignored location updates are neither evaluated against linked geofence collections, nor
  stored. This can reduce the effects of GPS noise when displaying device trajectories on a
  map, and can help control your costs by reducing the number of geofence evaluations.
  This field is optional. If not specified, the default value is TimeBased.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"PricingPlanDataSource"`: This parameter is no longer used.
- `"Tags"`: Applies one or more tags to the tracker resource. A tag is a key-value pair
  helps manage, identify, search, and filter your resources by labelling them. Format:
  \"key\" : \"value\"  Restrictions:   Maximum 50 tags per resource   Each resource tag must
  be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in
  UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric
  characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.    Cannot
  use \"aws:\" as a prefix for a key.
"""
function create_tracker(TrackerName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/tracking/v0/trackers",
        Dict{String,Any}("TrackerName" => TrackerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tracker(
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TrackerName" => TrackerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_geofence_collection(collection_name)
    delete_geofence_collection(collection_name, params::Dict{String,<:Any})

Deletes a geofence collection from your Amazon Web Services account.  This operation
deletes the resource permanently. If the geofence collection is the target of a tracker
resource, the devices will no longer be monitored.

# Arguments
- `collection_name`: The name of the geofence collection to be deleted.

"""
function delete_geofence_collection(
    CollectionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "DELETE",
        "/geofencing/v0/collections/$(CollectionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_geofence_collection(
    CollectionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/geofencing/v0/collections/$(CollectionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_key(key_name)
    delete_key(key_name, params::Dict{String,<:Any})

Deletes the specified API key. The API key must have been deactivated more than 90 days
previously.

# Arguments
- `key_name`: The name of the API key to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"forceDelete"`: ForceDelete bypasses an API key's expiry conditions and deletes the key.
  Set the parameter true to delete the key or to false to not preemptively delete the API
  key. Valid values: true, or false. Required: No  This action is irreversible. Only use
  ForceDelete if you are certain the key is no longer in use.
"""
function delete_key(KeyName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "DELETE",
        "/metadata/v0/keys/$(KeyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_key(
    KeyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/metadata/v0/keys/$(KeyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_map(map_name)
    delete_map(map_name, params::Dict{String,<:Any})

Deletes a map resource from your Amazon Web Services account.  This operation deletes the
resource permanently. If the map is being used in an application, the map may not render.

# Arguments
- `map_name`: The name of the map resource to be deleted.

"""
function delete_map(MapName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "DELETE",
        "/maps/v0/maps/$(MapName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_map(
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/maps/v0/maps/$(MapName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_place_index(index_name)
    delete_place_index(index_name, params::Dict{String,<:Any})

Deletes a place index resource from your Amazon Web Services account.  This operation
deletes the resource permanently.

# Arguments
- `index_name`: The name of the place index resource to be deleted.

"""
function delete_place_index(IndexName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "DELETE",
        "/places/v0/indexes/$(IndexName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_place_index(
    IndexName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/places/v0/indexes/$(IndexName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_route_calculator(calculator_name)
    delete_route_calculator(calculator_name, params::Dict{String,<:Any})

Deletes a route calculator resource from your Amazon Web Services account.  This operation
deletes the resource permanently.

# Arguments
- `calculator_name`: The name of the route calculator resource to be deleted.

"""
function delete_route_calculator(
    CalculatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "DELETE",
        "/routes/v0/calculators/$(CalculatorName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_route_calculator(
    CalculatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/routes/v0/calculators/$(CalculatorName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tracker(tracker_name)
    delete_tracker(tracker_name, params::Dict{String,<:Any})

Deletes a tracker resource from your Amazon Web Services account.  This operation deletes
the resource permanently. If the tracker resource is in use, you may encounter an error.
Make sure that the target resource isn't a dependency for your applications.

# Arguments
- `tracker_name`: The name of the tracker resource to be deleted.

"""
function delete_tracker(TrackerName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "DELETE",
        "/tracking/v0/trackers/$(TrackerName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tracker(
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/tracking/v0/trackers/$(TrackerName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_geofence_collection(collection_name)
    describe_geofence_collection(collection_name, params::Dict{String,<:Any})

Retrieves the geofence collection details.

# Arguments
- `collection_name`: The name of the geofence collection.

"""
function describe_geofence_collection(
    CollectionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/geofencing/v0/collections/$(CollectionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_geofence_collection(
    CollectionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/geofencing/v0/collections/$(CollectionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_key(key_name)
    describe_key(key_name, params::Dict{String,<:Any})

Retrieves the API key resource details.

# Arguments
- `key_name`: The name of the API key resource.

"""
function describe_key(KeyName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "GET",
        "/metadata/v0/keys/$(KeyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_key(
    KeyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/metadata/v0/keys/$(KeyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_map(map_name)
    describe_map(map_name, params::Dict{String,<:Any})

Retrieves the map resource details.

# Arguments
- `map_name`: The name of the map resource.

"""
function describe_map(MapName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_map(
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_place_index(index_name)
    describe_place_index(index_name, params::Dict{String,<:Any})

Retrieves the place index resource details.

# Arguments
- `index_name`: The name of the place index resource.

"""
function describe_place_index(IndexName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "GET",
        "/places/v0/indexes/$(IndexName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_place_index(
    IndexName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/places/v0/indexes/$(IndexName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_route_calculator(calculator_name)
    describe_route_calculator(calculator_name, params::Dict{String,<:Any})

Retrieves the route calculator resource details.

# Arguments
- `calculator_name`: The name of the route calculator resource.

"""
function describe_route_calculator(
    CalculatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/routes/v0/calculators/$(CalculatorName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_route_calculator(
    CalculatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/routes/v0/calculators/$(CalculatorName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tracker(tracker_name)
    describe_tracker(tracker_name, params::Dict{String,<:Any})

Retrieves the tracker resource details.

# Arguments
- `tracker_name`: The name of the tracker resource.

"""
function describe_tracker(TrackerName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "GET",
        "/tracking/v0/trackers/$(TrackerName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_tracker(
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/tracking/v0/trackers/$(TrackerName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_tracker_consumer(consumer_arn, tracker_name)
    disassociate_tracker_consumer(consumer_arn, tracker_name, params::Dict{String,<:Any})

Removes the association between a tracker resource and a geofence collection.  Once you
unlink a tracker resource from a geofence collection, the tracker positions will no longer
be automatically evaluated against geofences.

# Arguments
- `consumer_arn`: The Amazon Resource Name (ARN) for the geofence collection to be
  disassociated from the tracker resource. Used when you need to specify a resource across
  all Amazon Web Services.    Format example:
  arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer
- `tracker_name`: The name of the tracker resource to be dissociated from the consumer.

"""
function disassociate_tracker_consumer(
    ConsumerArn, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "DELETE",
        "/tracking/v0/trackers/$(TrackerName)/consumers/$(ConsumerArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_tracker_consumer(
    ConsumerArn,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/tracking/v0/trackers/$(TrackerName)/consumers/$(ConsumerArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    forecast_geofence_events(collection_name, device_state)
    forecast_geofence_events(collection_name, device_state, params::Dict{String,<:Any})

Evaluates device positions against geofence geometries from a given geofence collection.
The event forecasts three states for which a device can be in relative to a geofence:
ENTER: If a device is outside of a geofence, but would breach the fence if the device is
moving at its current speed within time horizon window.  EXIT: If a device is inside of a
geofence, but would breach the fence if the device is moving at its current speed within
time horizon window.  IDLE: If a device is inside of a geofence, and the device is not
moving.

# Arguments
- `collection_name`: The name of the geofence collection.
- `device_state`: The device's state, including current position and speed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DistanceUnit"`: The distance unit used for the NearestDistance property returned in a
  forecasted event. The measurement system must match for DistanceUnit and SpeedUnit; if
  Kilometers is specified for DistanceUnit, then SpeedUnit must be KilometersPerHour.
  Default Value: Kilometers
- `"MaxResults"`: An optional limit for the number of resources returned in a single call.
  Default value: 20
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page. Default value: null
- `"SpeedUnit"`: The speed unit for the device captured by the device state. The
  measurement system must match for DistanceUnit and SpeedUnit; if Kilometers is specified
  for DistanceUnit, then SpeedUnit must be KilometersPerHour. Default Value:
  KilometersPerHour.
- `"TimeHorizonMinutes"`: Specifies the time horizon in minutes for the forecasted events.
"""
function forecast_geofence_events(
    CollectionName, DeviceState; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/forecast-geofence-events",
        Dict{String,Any}("DeviceState" => DeviceState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function forecast_geofence_events(
    CollectionName,
    DeviceState,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/forecast-geofence-events",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeviceState" => DeviceState), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_position(device_id, tracker_name)
    get_device_position(device_id, tracker_name, params::Dict{String,<:Any})

Retrieves a device's most recent position according to its sample time.  Device positions
are deleted after 30 days.

# Arguments
- `device_id`: The device whose position you want to retrieve.
- `tracker_name`: The tracker resource receiving the position update.

"""
function get_device_position(
    DeviceId, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/tracking/v0/trackers/$(TrackerName)/devices/$(DeviceId)/positions/latest";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_position(
    DeviceId,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/tracking/v0/trackers/$(TrackerName)/devices/$(DeviceId)/positions/latest",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_position_history(device_id, tracker_name)
    get_device_position_history(device_id, tracker_name, params::Dict{String,<:Any})

Retrieves the device position history from a tracker resource within a specified range of
time.  Device positions are deleted after 30 days.

# Arguments
- `device_id`: The device whose position history you want to retrieve.
- `tracker_name`: The tracker resource receiving the request for the device position
  history.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EndTimeExclusive"`: Specify the end time for the position history in  ISO 8601 format:
  YYYY-MM-DDThh:mm:ss.sssZ. By default, the value will be the time that the request is made.
  Requirement:   The time specified for EndTimeExclusive must be after the time for
  StartTimeInclusive.
- `"MaxResults"`: An optional limit for the number of device positions returned in a single
  call. Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page.  Default value: null
- `"StartTimeInclusive"`: Specify the start time for the position history in  ISO 8601
  format: YYYY-MM-DDThh:mm:ss.sssZ. By default, the value will be 24 hours prior to the time
  that the request is made. Requirement:   The time specified for StartTimeInclusive must be
  before EndTimeExclusive.
"""
function get_device_position_history(
    DeviceId, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/devices/$(DeviceId)/list-positions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_position_history(
    DeviceId,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/devices/$(DeviceId)/list-positions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_geofence(collection_name, geofence_id)
    get_geofence(collection_name, geofence_id, params::Dict{String,<:Any})

Retrieves the geofence details from a geofence collection.  The returned geometry will
always match the geometry format used when the geofence was created.

# Arguments
- `collection_name`: The geofence collection storing the target geofence.
- `geofence_id`: The geofence you're retrieving details for.

"""
function get_geofence(
    CollectionName, GeofenceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/geofencing/v0/collections/$(CollectionName)/geofences/$(GeofenceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_geofence(
    CollectionName,
    GeofenceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/geofencing/v0/collections/$(CollectionName)/geofences/$(GeofenceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_map_glyphs(font_stack, font_unicode_range, map_name)
    get_map_glyphs(font_stack, font_unicode_range, map_name, params::Dict{String,<:Any})

Retrieves glyphs used to display labels on a map.

# Arguments
- `font_stack`: A comma-separated list of fonts to load glyphs from in order of preference.
  For example, Noto Sans Regular, Arial Unicode. Valid font stacks for Esri styles:
  VectorEsriDarkGrayCanvas – Ubuntu Medium Italic | Ubuntu Medium | Ubuntu Italic | Ubuntu
  Regular | Ubuntu Bold    VectorEsriLightGrayCanvas – Ubuntu Italic | Ubuntu Regular |
  Ubuntu Light | Ubuntu Bold    VectorEsriTopographic – Noto Sans Italic | Noto Sans
  Regular | Noto Sans Bold | Noto Serif Regular | Roboto Condensed Light Italic
  VectorEsriStreets – Arial Regular | Arial Italic | Arial Bold    VectorEsriNavigation –
  Arial Regular | Arial Italic | Arial Bold    Valid font stacks for HERE Technologies
  styles:   VectorHereContrast – Fira GO Regular | Fira GO Bold    VectorHereExplore,
  VectorHereExploreTruck, HybridHereExploreSatellite – Fira GO Italic | Fira GO Map | Fira
  GO Map Bold | Noto Sans CJK JP Bold | Noto Sans CJK JP Light | Noto Sans CJK JP Regular
  Valid font stacks for GrabMaps styles:   VectorGrabStandardLight, VectorGrabStandardDark
  – Noto Sans Regular | Noto Sans Medium | Noto Sans Bold    Valid font stacks for Open
  Data styles:   VectorOpenDataStandardLight, VectorOpenDataStandardDark,
  VectorOpenDataVisualizationLight, VectorOpenDataVisualizationDark – Amazon Ember
  Regular,Noto Sans Regular | Amazon Ember Bold,Noto Sans Bold | Amazon Ember Medium,Noto
  Sans Medium | Amazon Ember Regular Italic,Noto Sans Italic | Amazon Ember Condensed RC
  Regular,Noto Sans Regular | Amazon Ember Condensed RC Bold,Noto Sans Bold | Amazon Ember
  Regular,Noto Sans Regular,Noto Sans Arabic Regular | Amazon Ember Condensed RC Bold,Noto
  Sans Bold,Noto Sans Arabic Condensed Bold | Amazon Ember Bold,Noto Sans Bold,Noto Sans
  Arabic Bold | Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular |
  Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular |
  Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium     The fonts used by the Open
  Data map styles are combined fonts that use Amazon Ember for most glyphs but Noto Sans for
  glyphs unsupported by Amazon Ember.
- `font_unicode_range`: A Unicode range of characters to download glyphs for. Each response
  will contain 256 characters. For example, 0–255 includes all characters from range U+0000
  to 00FF. Must be aligned to multiples of 256.
- `map_name`: The map resource associated with the glyph ﬁle.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"key"`: The optional API key to authorize the request.
"""
function get_map_glyphs(
    FontStack, FontUnicodeRange, MapName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/glyphs/$(FontStack)/$(FontUnicodeRange)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_map_glyphs(
    FontStack,
    FontUnicodeRange,
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/glyphs/$(FontStack)/$(FontUnicodeRange)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_map_sprites(file_name, map_name)
    get_map_sprites(file_name, map_name, params::Dict{String,<:Any})

Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image
paired with a JSON document describing the offsets of individual icons that will be
displayed on a rendered map.

# Arguments
- `file_name`: The name of the sprite ﬁle. Use the following ﬁle names for the sprite
  sheet:    sprites.png     sprites@2x.png for high pixel density displays   For the JSON
  document containing image offsets. Use the following ﬁle names:    sprites.json
  sprites@2x.json for high pixel density displays
- `map_name`: The map resource associated with the sprite ﬁle.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"key"`: The optional API key to authorize the request.
"""
function get_map_sprites(
    FileName, MapName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/sprites/$(FileName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_map_sprites(
    FileName,
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/sprites/$(FileName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_map_style_descriptor(map_name)
    get_map_style_descriptor(map_name, params::Dict{String,<:Any})

Retrieves the map style descriptor from a map resource.  The style descriptor contains
speciﬁcations on how features render on a map. For example, what data to display, what
order to display the data in, and the style for the data. Style descriptors follow the
Mapbox Style Specification.

# Arguments
- `map_name`: The map resource to retrieve the style descriptor from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"key"`: The optional API key to authorize the request.
"""
function get_map_style_descriptor(
    MapName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/style-descriptor";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_map_style_descriptor(
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/style-descriptor",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_map_tile(map_name, x, y, z)
    get_map_tile(map_name, x, y, z, params::Dict{String,<:Any})

Retrieves a vector data tile from the map resource. Map tiles are used by clients to render
a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z
(zoom) level.  The origin (0, 0) is the top left of the map. Increasing the zoom level by 1
doubles both the X and Y dimensions, so a tile containing data for the entire world at
(0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).

# Arguments
- `map_name`: The map resource to retrieve the map tiles from.
- `x`: The X axis value for the map tile.
- `y`: The Y axis value for the map tile.
- `z`: The zoom value for the map tile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"key"`: The optional API key to authorize the request.
"""
function get_map_tile(MapName, X, Y, Z; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/tiles/$(Z)/$(X)/$(Y)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_map_tile(
    MapName,
    X,
    Y,
    Z,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/maps/v0/maps/$(MapName)/tiles/$(Z)/$(X)/$(Y)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_place(index_name, place_id)
    get_place(index_name, place_id, params::Dict{String,<:Any})

Finds a place by its unique ID. A PlaceId is returned by other search operations.  A
PlaceId is valid only if all of the following are the same in the original search request
and the call to GetPlace.   Customer Amazon Web Services account   Amazon Web Services
Region   Data provider specified in the place index resource

# Arguments
- `index_name`: The name of the place index resource that you want to use for the search.
- `place_id`: The identifier of the place to find.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"key"`: The optional API key to authorize the request.
- `"language"`: The preferred language used to return results. The value must be a valid
  BCP 47 language tag, for example, en for English. This setting affects the languages used
  in the results, but not the results themselves. If no language is specified, or not
  supported for a particular result, the partner automatically chooses a language for the
  result. For an example, we'll use the Greek language. You search for a location around
  Athens, Greece, with the language parameter set to en. The city in the results will most
  likely be returned as Athens. If you set the language parameter to el, for Greek, then the
  city in the results will more likely be returned as Αθήνα. If the data provider does
  not have a value for Greek, the result will be in a language that the provider does support.
"""
function get_place(IndexName, PlaceId; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "GET",
        "/places/v0/indexes/$(IndexName)/places/$(PlaceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_place(
    IndexName,
    PlaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/places/v0/indexes/$(IndexName)/places/$(PlaceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_device_positions(tracker_name)
    list_device_positions(tracker_name, params::Dict{String,<:Any})

A batch request to retrieve all device positions.

# Arguments
- `tracker_name`: The tracker resource containing the requested devices.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FilterGeometry"`: The geometry used to filter device positions.
- `"MaxResults"`: An optional limit for the number of entries returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page. Default value: null
"""
function list_device_positions(
    TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/list-positions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_device_positions(
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/list-positions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_geofence_collections()
    list_geofence_collections(params::Dict{String,<:Any})

Lists geofence collections in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional limit for the number of resources returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page.  Default value: null
"""
function list_geofence_collections(; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/geofencing/v0/list-collections";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_geofence_collections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/geofencing/v0/list-collections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_geofences(collection_name)
    list_geofences(collection_name, params::Dict{String,<:Any})

Lists geofences stored in a given geofence collection.

# Arguments
- `collection_name`: The name of the geofence collection storing the list of geofences.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional limit for the number of geofences returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page.  Default value: null
"""
function list_geofences(CollectionName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/list-geofences";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_geofences(
    CollectionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/geofencing/v0/collections/$(CollectionName)/list-geofences",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_keys()
    list_keys(params::Dict{String,<:Any})

Lists API key resources in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: Optionally filter the list to only Active or Expired API keys.
- `"MaxResults"`: An optional limit for the number of resources returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page.  Default value: null
"""
function list_keys(; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/metadata/v0/list-keys";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_keys(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/metadata/v0/list-keys",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_maps()
    list_maps(params::Dict{String,<:Any})

Lists map resources in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional limit for the number of resources returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page. Default value: null
"""
function list_maps(; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST", "/maps/v0/list-maps"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_maps(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/maps/v0/list-maps",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_place_indexes()
    list_place_indexes(params::Dict{String,<:Any})

Lists place index resources in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional limit for the maximum number of results returned in a single
  call. Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page. Default value: null
"""
function list_place_indexes(; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/places/v0/list-indexes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_place_indexes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/places/v0/list-indexes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_route_calculators()
    list_route_calculators(params::Dict{String,<:Any})

Lists route calculator resources in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional maximum number of results returned in a single call. Default
  Value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page. Default Value: null
"""
function list_route_calculators(; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/routes/v0/list-calculators";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_route_calculators(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/routes/v0/list-calculators",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of tags that are applied to the specified Amazon Location resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource whose tags you want to
  retrieve.   Format example: arn:aws:geo:region:account-id:resourcetype/ExampleResource

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tracker_consumers(tracker_name)
    list_tracker_consumers(tracker_name, params::Dict{String,<:Any})

Lists geofence collections currently associated to the given tracker resource.

# Arguments
- `tracker_name`: The tracker resource whose associated geofence collections you want to
  list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional limit for the number of resources returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page.  Default value: null
"""
function list_tracker_consumers(
    TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/list-consumers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tracker_consumers(
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/list-consumers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_trackers()
    list_trackers(params::Dict{String,<:Any})

Lists tracker resources in your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: An optional limit for the number of resources returned in a single call.
  Default value: 100
- `"NextToken"`: The pagination token specifying which page of results to return in the
  response. If no token is provided, the default page is the first page.  Default value: null
"""
function list_trackers(; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/tracking/v0/list-trackers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_trackers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/list-trackers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_geofence(collection_name, geofence_id, geometry)
    put_geofence(collection_name, geofence_id, geometry, params::Dict{String,<:Any})

Stores a geofence geometry in a given geofence collection, or updates the geometry of an
existing geofence if a geofence ID is included in the request.

# Arguments
- `collection_name`: The geofence collection to store the geofence in.
- `geofence_id`: An identifier for the geofence. For example, ExampleGeofence-1.
- `geometry`: Contains the details to specify the position of the geofence. Can be a
  polygon, a circle or a polygon encoded in Geobuf format. Including multiple selections will
  return a validation error.  The  geofence polygon format supports a maximum of 1,000
  vertices. The Geofence Geobuf format supports a maximum of 100,000 vertices.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GeofenceProperties"`: Associates one of more properties with the geofence. A property
  is a key-value pair stored with the geofence and added to any geofence event triggered with
  that geofence. Format: \"key\" : \"value\"
"""
function put_geofence(
    CollectionName, GeofenceId, Geometry; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "PUT",
        "/geofencing/v0/collections/$(CollectionName)/geofences/$(GeofenceId)",
        Dict{String,Any}("Geometry" => Geometry);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_geofence(
    CollectionName,
    GeofenceId,
    Geometry,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PUT",
        "/geofencing/v0/collections/$(CollectionName)/geofences/$(GeofenceId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Geometry" => Geometry), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_place_index_for_position(index_name, position)
    search_place_index_for_position(index_name, position, params::Dict{String,<:Any})

Reverse geocodes a given coordinate and returns a legible address. Allows you to search for
Places or points of interest near a given position.

# Arguments
- `index_name`: The name of the place index resource you want to use for the search.
- `position`: Specifies the longitude and latitude of the position to query.  This
  parameter must contain a pair of numbers. The first number represents the X coordinate, or
  longitude; the second number represents the Y coordinate, or latitude. For example,
  [-123.1174, 49.2847] represents a position with longitude -123.1174 and latitude 49.2847.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Language"`: The preferred language used to return results. The value must be a valid
  BCP 47 language tag, for example, en for English. This setting affects the languages used
  in the results, but not the results themselves. If no language is specified, or not
  supported for a particular result, the partner automatically chooses a language for the
  result. For an example, we'll use the Greek language. You search for a location around
  Athens, Greece, with the language parameter set to en. The city in the results will most
  likely be returned as Athens. If you set the language parameter to el, for Greek, then the
  city in the results will more likely be returned as Αθήνα. If the data provider does
  not have a value for Greek, the result will be in a language that the provider does support.
- `"MaxResults"`: An optional parameter. The maximum number of results returned per
  request. Default value: 50
- `"key"`: The optional API key to authorize the request.
"""
function search_place_index_for_position(
    IndexName, Position; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/places/v0/indexes/$(IndexName)/search/position",
        Dict{String,Any}("Position" => Position);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_place_index_for_position(
    IndexName,
    Position,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/places/v0/indexes/$(IndexName)/search/position",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Position" => Position), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_place_index_for_suggestions(index_name, text)
    search_place_index_for_suggestions(index_name, text, params::Dict{String,<:Any})

Generates suggestions for addresses and points of interest based on partial or misspelled
free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy
matching. Optional parameters let you narrow your search results by bounding box or
country, or bias your search toward a specific position on the globe.  You can search for
suggested place names near a specified position by using BiasPosition, or filter results
within a bounding box by using FilterBBox. These parameters are mutually exclusive; using
both BiasPosition and FilterBBox in the same command returns an error.

# Arguments
- `index_name`: The name of the place index resource you want to use for the search.
- `text`: The free-form partial text to use to generate place suggestions. For example,
  eiffel tow.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BiasPosition"`: An optional parameter that indicates a preference for place suggestions
  that are closer to a specified position.  If provided, this parameter must contain a pair
  of numbers. The first number represents the X coordinate, or longitude; the second number
  represents the Y coordinate, or latitude. For example, [-123.1174, 49.2847] represents the
  position with longitude -123.1174 and latitude 49.2847.   BiasPosition and FilterBBox are
  mutually exclusive. Specifying both options results in an error.
- `"FilterBBox"`: An optional parameter that limits the search results by returning only
  suggestions within a specified bounding box.  If provided, this parameter must contain a
  total of four consecutive numbers in two pairs. The first pair of numbers represents the X
  and Y coordinates (longitude and latitude, respectively) of the southwest corner of the
  bounding box; the second pair of numbers represents the X and Y coordinates (longitude and
  latitude, respectively) of the northeast corner of the bounding box. For example,
  [-12.7935, -37.4835, -12.0684, -36.9542] represents a bounding box where the southwest
  corner has longitude -12.7935 and latitude -37.4835, and the northeast corner has longitude
  -12.0684 and latitude -36.9542.   FilterBBox and BiasPosition are mutually exclusive.
  Specifying both options results in an error.
- `"FilterCategories"`: A list of one or more Amazon Location categories to filter the
  returned places. If you include more than one category, the results will include results
  that match any of the categories listed. For more information about using categories,
  including a list of Amazon Location categories, see Categories and filtering, in the Amazon
  Location Service Developer Guide.
- `"FilterCountries"`: An optional parameter that limits the search results by returning
  only suggestions within the provided list of countries.   Use the ISO 3166 3-digit country
  code. For example, Australia uses three upper-case characters: AUS.
- `"Language"`: The preferred language used to return results. The value must be a valid
  BCP 47 language tag, for example, en for English. This setting affects the languages used
  in the results. If no language is specified, or not supported for a particular result, the
  partner automatically chooses a language for the result. For an example, we'll use the
  Greek language. You search for Athens, Gr to get suggestions with the language parameter
  set to en. The results found will most likely be returned as Athens, Greece. If you set the
  language parameter to el, for Greek, then the result found will more likely be returned as
  Αθήνα, Ελλάδα. If the data provider does not have a value for Greek, the result
  will be in a language that the provider does support.
- `"MaxResults"`: An optional parameter. The maximum number of results returned per
  request.  The default: 5
- `"key"`: The optional API key to authorize the request.
"""
function search_place_index_for_suggestions(
    IndexName, Text; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/places/v0/indexes/$(IndexName)/search/suggestions",
        Dict{String,Any}("Text" => Text);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_place_index_for_suggestions(
    IndexName,
    Text,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/places/v0/indexes/$(IndexName)/search/suggestions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Text" => Text), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_place_index_for_text(index_name, text)
    search_place_index_for_text(index_name, text, params::Dict{String,<:Any})

Geocodes free-form text, such as an address, name, city, or region to allow you to search
for Places or points of interest.  Optional parameters let you narrow your search results
by bounding box or country, or bias your search toward a specific position on the globe.
You can search for places near a given position using BiasPosition, or filter results
within a bounding box using FilterBBox. Providing both parameters simultaneously returns an
error.  Search results are returned in order of highest to lowest relevance.

# Arguments
- `index_name`: The name of the place index resource you want to use for the search.
- `text`: The address, name, city, or region to be used in the search in free-form text
  format. For example, 123 Any Street.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BiasPosition"`: An optional parameter that indicates a preference for places that are
  closer to a specified position.  If provided, this parameter must contain a pair of
  numbers. The first number represents the X coordinate, or longitude; the second number
  represents the Y coordinate, or latitude. For example, [-123.1174, 49.2847] represents the
  position with longitude -123.1174 and latitude 49.2847.   BiasPosition and FilterBBox are
  mutually exclusive. Specifying both options results in an error.
- `"FilterBBox"`: An optional parameter that limits the search results by returning only
  places that are within the provided bounding box.  If provided, this parameter must contain
  a total of four consecutive numbers in two pairs. The first pair of numbers represents the
  X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the
  bounding box; the second pair of numbers represents the X and Y coordinates (longitude and
  latitude, respectively) of the northeast corner of the bounding box. For example,
  [-12.7935, -37.4835, -12.0684, -36.9542] represents a bounding box where the southwest
  corner has longitude -12.7935 and latitude -37.4835, and the northeast corner has longitude
  -12.0684 and latitude -36.9542.   FilterBBox and BiasPosition are mutually exclusive.
  Specifying both options results in an error.
- `"FilterCategories"`: A list of one or more Amazon Location categories to filter the
  returned places. If you include more than one category, the results will include results
  that match any of the categories listed. For more information about using categories,
  including a list of Amazon Location categories, see Categories and filtering, in the Amazon
  Location Service Developer Guide.
- `"FilterCountries"`: An optional parameter that limits the search results by returning
  only places that are in a specified list of countries.   Valid values include ISO 3166
  3-digit country codes. For example, Australia uses three upper-case characters: AUS.
- `"Language"`: The preferred language used to return results. The value must be a valid
  BCP 47 language tag, for example, en for English. This setting affects the languages used
  in the results, but not the results themselves. If no language is specified, or not
  supported for a particular result, the partner automatically chooses a language for the
  result. For an example, we'll use the Greek language. You search for Athens, Greece, with
  the language parameter set to en. The result found will most likely be returned as Athens.
  If you set the language parameter to el, for Greek, then the result found will more likely
  be returned as Αθήνα. If the data provider does not have a value for Greek, the result
  will be in a language that the provider does support.
- `"MaxResults"`: An optional parameter. The maximum number of results returned per
  request.  The default: 50
- `"key"`: The optional API key to authorize the request.
"""
function search_place_index_for_text(
    IndexName, Text; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/places/v0/indexes/$(IndexName)/search/text",
        Dict{String,Any}("Text" => Text);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_place_index_for_text(
    IndexName,
    Text,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/places/v0/indexes/$(IndexName)/search/text",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Text" => Text), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags (key-value pairs) to the specified Amazon Location Service
resource. Tags can help you organize and categorize your resources. You can also use them
to scope user permissions, by granting a user permission to access or change only resources
with certain tag values. You can use the TagResource operation with an Amazon Location
Service resource that already has tags. If you specify a new tag key for the resource, this
tag is appended to the tags already associated with the resource. If you specify a tag key
that's already associated with the resource, the new tag value that you specify replaces
the previous value for that tag.  You can associate up to 50 tags with a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource whose tags you want to
  update.   Format example: arn:aws:geo:region:account-id:resourcetype/ExampleResource
- `tags`: Applies one or more tags to specific resource. A tag is a key-value pair that
  helps you manage, identify, search, and filter your resources. Format: \"key\" : \"value\"
  Restrictions:   Maximum 50 tags per resource.   Each tag key must be unique and must have
  exactly one associated value.   Maximum key length: 128 Unicode characters in UTF-8.
  Maximum value length: 256 Unicode characters in UTF-8.   Can use alphanumeric characters
  (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @   Cannot use \"aws:\"
  as a prefix for a key.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified Amazon Location resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource from which you want to
  remove tags.   Format example: arn:aws:geo:region:account-id:resourcetype/ExampleResource
- `tag_keys`: The list of tag keys to remove from the specified resource.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_geofence_collection(collection_name)
    update_geofence_collection(collection_name, params::Dict{String,<:Any})

Updates the specified properties of a given geofence collection.

# Arguments
- `collection_name`: The name of the geofence collection to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Updates the description for the geofence collection.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"PricingPlanDataSource"`: This parameter is no longer used.
"""
function update_geofence_collection(
    CollectionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "PATCH",
        "/geofencing/v0/collections/$(CollectionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_geofence_collection(
    CollectionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PATCH",
        "/geofencing/v0/collections/$(CollectionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_key(key_name)
    update_key(key_name, params::Dict{String,<:Any})

Updates the specified properties of a given API key resource.

# Arguments
- `key_name`: The name of the API key resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Updates the description for the API key resource.
- `"ExpireTime"`: Updates the timestamp for when the API key resource will expire in  ISO
  8601 format: YYYY-MM-DDThh:mm:ss.sssZ.
- `"ForceUpdate"`: The boolean flag to be included for updating ExpireTime or Restrictions
  details. Must be set to true to update an API key resource that has been used in the past 7
  days.  False if force update is not preferred Default value: False
- `"NoExpiry"`: Whether the API key should expire. Set to true to set the API key to have
  no expiration time.
- `"Restrictions"`: Updates the API key restrictions for the API key resource.
"""
function update_key(KeyName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "PATCH",
        "/metadata/v0/keys/$(KeyName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_key(
    KeyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PATCH",
        "/metadata/v0/keys/$(KeyName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_map(map_name)
    update_map(map_name, params::Dict{String,<:Any})

Updates the specified properties of a given map resource.

# Arguments
- `map_name`: The name of the map resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfigurationUpdate"`: Updates the parts of the map configuration that can be updated,
  including the political view.
- `"Description"`: Updates the description for the map resource.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
"""
function update_map(MapName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "PATCH",
        "/maps/v0/maps/$(MapName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_map(
    MapName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PATCH",
        "/maps/v0/maps/$(MapName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_place_index(index_name)
    update_place_index(index_name, params::Dict{String,<:Any})

Updates the specified properties of a given place index resource.

# Arguments
- `index_name`: The name of the place index resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataSourceConfiguration"`: Updates the data storage option for the place index resource.
- `"Description"`: Updates the description for the place index resource.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
"""
function update_place_index(IndexName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "PATCH",
        "/places/v0/indexes/$(IndexName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_place_index(
    IndexName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PATCH",
        "/places/v0/indexes/$(IndexName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_route_calculator(calculator_name)
    update_route_calculator(calculator_name, params::Dict{String,<:Any})

Updates the specified properties for a given route calculator resource.

# Arguments
- `calculator_name`: The name of the route calculator resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Updates the description for the route calculator resource.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
"""
function update_route_calculator(
    CalculatorName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "PATCH",
        "/routes/v0/calculators/$(CalculatorName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_route_calculator(
    CalculatorName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PATCH",
        "/routes/v0/calculators/$(CalculatorName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_tracker(tracker_name)
    update_tracker(tracker_name, params::Dict{String,<:Any})

Updates the specified properties of a given tracker resource.

# Arguments
- `tracker_name`: The name of the tracker resource to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Updates the description for the tracker resource.
- `"EventBridgeEnabled"`: Whether to enable position UPDATE events from this tracker to be
  sent to EventBridge.  You do not need enable this feature to get ENTER and EXIT events for
  geofences with this tracker. Those events are always sent to EventBridge.
- `"KmsKeyEnableGeospatialQueries"`: Enables GeospatialQueries for a tracker that uses a
  Amazon Web Services KMS customer managed key. This parameter is only used if you are using
  a KMS customer managed key.
- `"PositionFiltering"`: Updates the position filtering for the tracker resource. Valid
  values:    TimeBased - Location updates are evaluated against linked geofence collections,
  but not every location update is stored. If your update frequency is more often than 30
  seconds, only one update per 30 seconds is stored for each unique device ID.
  DistanceBased - If the device has moved less than 30 m (98.4 ft), location updates are
  ignored. Location updates within this distance are neither evaluated against linked
  geofence collections, nor stored. This helps control costs by reducing the number of
  geofence evaluations and historical device positions to paginate through. Distance-based
  filtering can also reduce the effects of GPS noise when displaying device trajectories on a
  map.     AccuracyBased - If the device has moved less than the measured accuracy, location
  updates are ignored. For example, if two consecutive updates from a device have a
  horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved
  less than 15 m. Ignored location updates are neither evaluated against linked geofence
  collections, nor stored. This helps educe the effects of GPS noise when displaying device
  trajectories on a map, and can help control costs by reducing the number of geofence
  evaluations.
- `"PricingPlan"`: No longer used. If included, the only allowed value is RequestBasedUsage.
- `"PricingPlanDataSource"`: This parameter is no longer used.
"""
function update_tracker(TrackerName; aws_config::AbstractAWSConfig=current_aws_config())
    return location(
        "PATCH",
        "/tracking/v0/trackers/$(TrackerName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_tracker(
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "PATCH",
        "/tracking/v0/trackers/$(TrackerName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_device_position(device_state, tracker_name)
    verify_device_position(device_state, tracker_name, params::Dict{String,<:Any})

Verifies the integrity of the device's position by determining if it was reported behind a
proxy, and by comparing it to an inferred position estimated based on the device's state.

# Arguments
- `device_state`: The device's state, including position, IP address, cell signals and
  Wi-Fi access points.
- `tracker_name`: The name of the tracker resource to be associated with verification
  request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DistanceUnit"`: The distance unit for the verification request. Default Value:
  Kilometers
"""
function verify_device_position(
    DeviceState, TrackerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/positions/verify",
        Dict{String,Any}("DeviceState" => DeviceState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_device_position(
    DeviceState,
    TrackerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return location(
        "POST",
        "/tracking/v0/trackers/$(TrackerName)/positions/verify",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeviceState" => DeviceState), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
