# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: marketplace_commerce_analytics
using AWS.Compat
using AWS.UUIDs

"""
    generate_data_set(data_set_publication_date, data_set_type, destination_s3_bucket_name, role_name_arn, sns_topic_arn)
    generate_data_set(data_set_publication_date, data_set_type, destination_s3_bucket_name, role_name_arn, sns_topic_arn, params::Dict{String,<:Any})

Given a data set type and data set publication date, asynchronously publishes the requested
data set to the specified S3 bucket and notifies the specified SNS topic once the data is
available. Returns a unique request identifier that can be used to correlate requests with
notifications from the SNS topic. Data sets will be published in comma-separated values
(CSV) format with the file name {data_set_type}_YYYY-MM-DD.csv. If a file with the same
name already exists (e.g. if the same data set is requested twice), the original file will
be overwritten by the new file. Requires a Role with an attached permissions policy
providing Allow permissions for the following actions: s3:PutObject, s3:GetBucketLocation,
sns:GetTopicAttributes, sns:Publish, iam:GetRolePolicy.

# Arguments
- `data_set_publication_date`: The date a data set was published. For daily data sets,
  provide a date with day-level granularity for the desired day. For monthly data sets except
  those with prefix disbursed_amount, provide a date with month-level granularity for the
  desired month (the day value will be ignored). For data sets with prefix disbursed_amount,
  provide a date with day-level granularity for the desired day. For these data sets we will
  look backwards in time over the range of 31 days until the first data set is found (the
  latest one).
- `data_set_type`: The desired data set type.
  customer_subscriber_hourly_monthly_subscriptions From 2017-09-15 to present: Available
  daily by 24:00 UTC.   customer_subscriber_annual_subscriptions From 2017-09-15 to present:
  Available daily by 24:00 UTC.   daily_business_usage_by_instance_type From 2017-09-15 to
  present: Available daily by 24:00 UTC.   daily_business_fees From 2017-09-15 to present:
  Available daily by 24:00 UTC.   daily_business_free_trial_conversions From 2017-09-15 to
  present: Available daily by 24:00 UTC.   daily_business_new_instances From 2017-09-15 to
  present: Available daily by 24:00 UTC.   daily_business_new_product_subscribers From
  2017-09-15 to present: Available daily by 24:00 UTC.
  daily_business_canceled_product_subscribers From 2017-09-15 to present: Available daily by
  24:00 UTC.   monthly_revenue_billing_and_revenue_data From 2017-09-15 to present: Available
  monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g.
  hourly) from one month prior.   monthly_revenue_annual_subscriptions From 2017-09-15 to
  present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes
  up-front software charges (e.g. annual) from one month prior.
  monthly_revenue_field_demonstration_usage From 2018-03-15 to present: Available monthly on
  the 15th day of the month by 24:00 UTC.   monthly_revenue_flexible_payment_schedule From
  2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
  disbursed_amount_by_product From 2017-09-15 to present: Available every 30 days by 24:00
  UTC.   disbursed_amount_by_instance_hours From 2017-09-15 to present: Available every 30
  days by 24:00 UTC.   disbursed_amount_by_customer_geo From 2017-09-15 to present: Available
  every 30 days by 24:00 UTC.   disbursed_amount_by_age_of_uncollected_funds From 2017-09-15
  to present: Available every 30 days by 24:00 UTC.
  disbursed_amount_by_age_of_disbursed_funds From 2017-09-15 to present: Available every 30
  days by 24:00 UTC.   disbursed_amount_by_age_of_past_due_funds From 2018-04-07 to present:
  Available every 30 days by 24:00 UTC.   disbursed_amount_by_uncollected_funds_breakdown
  From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
  sales_compensation_billed_revenue From 2017-09-15 to present: Available monthly on the 15th
  day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one
  month prior, and up-front software charges (e.g. annual) from one month prior.
  us_sales_and_use_tax_records From 2017-09-15 to present: Available monthly on the 15th day
  of the month by 24:00 UTC.   disbursed_amount_by_product_with_uncollected_funds This data
  set is deprecated. Download related reports from AMMP instead!
  customer_profile_by_industry This data set is deprecated. Download related reports from
  AMMP instead!   customer_profile_by_revenue This data set is deprecated. Download related
  reports from AMMP instead!   customer_profile_by_geography This data set is deprecated.
  Download related reports from AMMP instead!
- `destination_s3_bucket_name`: The name (friendly name, not ARN) of the destination S3
  bucket.
- `role_name_arn`: The Amazon Resource Name (ARN) of the Role with an attached permissions
  policy to interact with the provided AWS services.
- `sns_topic_arn`: Amazon Resource Name (ARN) for the SNS Topic that will be notified when
  the data set has been published or if an error has occurred.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"customerDefinedValues"`: (Optional) Key-value pairs which will be returned, unmodified,
  in the Amazon SNS notification message and the data set metadata file. These key-value
  pairs can be used to correlated responses with tracking information from other systems.
- `"destinationS3Prefix"`: (Optional) The desired S3 prefix for the published data set,
  similar to a directory path in standard file systems. For example, if given the bucket name
  \"mybucket\" and the prefix \"myprefix/mydatasets\", the output file \"outputfile\" would
  be published to \"s3://mybucket/myprefix/mydatasets/outputfile\". If the prefix directory
  structure does not exist, it will be created. If no prefix is provided, the data set will
  be published to the S3 bucket root.
"""
function generate_data_set(
    dataSetPublicationDate,
    dataSetType,
    destinationS3BucketName,
    roleNameArn,
    snsTopicArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_commerce_analytics(
        "GenerateDataSet",
        Dict{String,Any}(
            "dataSetPublicationDate" => dataSetPublicationDate,
            "dataSetType" => dataSetType,
            "destinationS3BucketName" => destinationS3BucketName,
            "roleNameArn" => roleNameArn,
            "snsTopicArn" => snsTopicArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function generate_data_set(
    dataSetPublicationDate,
    dataSetType,
    destinationS3BucketName,
    roleNameArn,
    snsTopicArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_commerce_analytics(
        "GenerateDataSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "dataSetPublicationDate" => dataSetPublicationDate,
                    "dataSetType" => dataSetType,
                    "destinationS3BucketName" => destinationS3BucketName,
                    "roleNameArn" => roleNameArn,
                    "snsTopicArn" => snsTopicArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_support_data_export(data_set_type, destination_s3_bucket_name, from_date, role_name_arn, sns_topic_arn)
    start_support_data_export(data_set_type, destination_s3_bucket_name, from_date, role_name_arn, sns_topic_arn, params::Dict{String,<:Any})

This target has been deprecated. Given a data set type and a from date, asynchronously
publishes the requested customer support data to the specified S3 bucket and notifies the
specified SNS topic once the data is available. Returns a unique request identifier that
can be used to correlate requests with notifications from the SNS topic. Data sets will be
published in comma-separated values (CSV) format with the file name
{data_set_type}_YYYY-MM-DD'T'HH-mm-ss'Z'.csv. If a file with the same name already exists
(e.g. if the same data set is requested twice), the original file will be overwritten by
the new file. Requires a Role with an attached permissions policy providing Allow
permissions for the following actions: s3:PutObject, s3:GetBucketLocation,
sns:GetTopicAttributes, sns:Publish, iam:GetRolePolicy.

# Arguments
- `data_set_type`:  This target has been deprecated. Specifies the data set type to be
  written to the output csv file. The data set types customer_support_contacts_data and
  test_customer_support_contacts_data both result in a csv file containing the following
  fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start
  Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title,
  Country Code, ZIP Code, Operation Type, and Operation Time.
  customer_support_contacts_data Customer support contact data. The data set will contain all
  changes (Creates, Updates, and Deletes) to customer support contact data from the date
  specified in the from_date parameter. test_customer_support_contacts_data An example data
  set containing static test data in the same format as customer_support_contacts_data
- `destination_s3_bucket_name`: This target has been deprecated. The name (friendly name,
  not ARN) of the destination S3 bucket.
- `from_date`: This target has been deprecated. The start date from which to retrieve the
  data set in UTC. This parameter only affects the customer_support_contacts_data data set
  type.
- `role_name_arn`: This target has been deprecated. The Amazon Resource Name (ARN) of the
  Role with an attached permissions policy to interact with the provided AWS services.
- `sns_topic_arn`: This target has been deprecated. Amazon Resource Name (ARN) for the SNS
  Topic that will be notified when the data set has been published or if an error has
  occurred.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"customerDefinedValues"`: This target has been deprecated. (Optional) Key-value pairs
  which will be returned, unmodified, in the Amazon SNS notification message and the data set
  metadata file.
- `"destinationS3Prefix"`: This target has been deprecated. (Optional) The desired S3
  prefix for the published data set, similar to a directory path in standard file systems.
  For example, if given the bucket name \"mybucket\" and the prefix \"myprefix/mydatasets\",
  the output file \"outputfile\" would be published to
  \"s3://mybucket/myprefix/mydatasets/outputfile\". If the prefix directory structure does
  not exist, it will be created. If no prefix is provided, the data set will be published to
  the S3 bucket root.
"""
function start_support_data_export(
    dataSetType,
    destinationS3BucketName,
    fromDate,
    roleNameArn,
    snsTopicArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_commerce_analytics(
        "StartSupportDataExport",
        Dict{String,Any}(
            "dataSetType" => dataSetType,
            "destinationS3BucketName" => destinationS3BucketName,
            "fromDate" => fromDate,
            "roleNameArn" => roleNameArn,
            "snsTopicArn" => snsTopicArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_support_data_export(
    dataSetType,
    destinationS3BucketName,
    fromDate,
    roleNameArn,
    snsTopicArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return marketplace_commerce_analytics(
        "StartSupportDataExport",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "dataSetType" => dataSetType,
                    "destinationS3BucketName" => destinationS3BucketName,
                    "fromDate" => fromDate,
                    "roleNameArn" => roleNameArn,
                    "snsTopicArn" => snsTopicArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
