# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: route53profiles
using AWS.Compat
using AWS.UUIDs

"""
    associate_profile(name, profile_id, resource_id)
    associate_profile(name, profile_id, resource_id, params::Dict{String,<:Any})

 Associates a Route 53 Profiles profile with a VPC. A VPC can have only one Profile
associated with it, but a Profile can be associated with 1000 of VPCs (and you can request
a higher quota). For more information, see
https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-ent
ities.

# Arguments
- `name`:  A name for the association.
- `profile_id`:  ID of the Profile.
- `resource_id`:  The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:  A list of the tag keys and values that you want to identify the Profile
  association.
"""
function associate_profile(
    Name, ProfileId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "POST",
        "/profileassociation",
        Dict{String,Any}(
            "Name" => Name, "ProfileId" => ProfileId, "ResourceId" => ResourceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_profile(
    Name,
    ProfileId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "POST",
        "/profileassociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "ProfileId" => ProfileId, "ResourceId" => ResourceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_resource_to_profile(name, profile_id, resource_arn)
    associate_resource_to_profile(name, profile_id, resource_arn, params::Dict{String,<:Any})

 Associates a DNS reource configuration to a Route 53 Profile.

# Arguments
- `name`:  Name for the resource association.
- `profile_id`:  ID of the Profile.
- `resource_arn`:  Amazon resource number, ARN, of the DNS resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ResourceProperties"`:  If you are adding a DNS Firewall rule group, include also a
  priority. The priority indicates the processing order for the rule groups, starting with
  the priority assinged the lowest value.  The allowed values for priority are between 100
  and 9900.
"""
function associate_resource_to_profile(
    Name, ProfileId, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "POST",
        "/profileresourceassociation",
        Dict{String,Any}(
            "Name" => Name, "ProfileId" => ProfileId, "ResourceArn" => ResourceArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_resource_to_profile(
    Name,
    ProfileId,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "POST",
        "/profileresourceassociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "ProfileId" => ProfileId, "ResourceArn" => ResourceArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_profile(client_token, name)
    create_profile(client_token, name, params::Dict{String,<:Any})

 Creates an empty Route 53 Profile.

# Arguments
- `client_token`:  ClientToken is an idempotency token that ensures a call to CreateProfile
  completes only once. You choose the value to pass. For example, an issue might prevent you
  from getting a response from CreateProfile. In this case, safely retry your call to
  CreateProfile by using the same CreateProfile parameter value.
- `name`:  A name for the Profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:  A list of the tag keys and values that you want to associate with the Route 53
  Profile.
"""
function create_profile(
    ClientToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "POST",
        "/profile",
        Dict{String,Any}("ClientToken" => ClientToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_profile(
    ClientToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "POST",
        "/profile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientToken" => ClientToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile(profile_id)
    delete_profile(profile_id, params::Dict{String,<:Any})

 Deletes the specified Route 53 Profile. Before you can delete a profile, you must first
disassociate it from all VPCs.

# Arguments
- `profile_id`:  The ID of the Profile that you want to delete.

"""
function delete_profile(ProfileId; aws_config::AbstractAWSConfig=current_aws_config())
    return route53profiles(
        "DELETE",
        "/profile/$(ProfileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile(
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "DELETE",
        "/profile/$(ProfileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_profile(profile_id, resource_id)
    disassociate_profile(profile_id, resource_id, params::Dict{String,<:Any})

 Dissociates a specified Route 53 Profile from the specified VPC.

# Arguments
- `profile_id`:  ID of the Profile.
- `resource_id`:  The ID of the VPC.

"""
function disassociate_profile(
    ProfileId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "DELETE",
        "/profileassociation/Profileid/$(ProfileId)/resourceid/$(ResourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_profile(
    ProfileId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "DELETE",
        "/profileassociation/Profileid/$(ProfileId)/resourceid/$(ResourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_resource_from_profile(profile_id, resource_arn)
    disassociate_resource_from_profile(profile_id, resource_arn, params::Dict{String,<:Any})

 Dissoaciated a specified resource, from the Route 53 Profile.

# Arguments
- `profile_id`:  The ID of the Profile.
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function disassociate_resource_from_profile(
    ProfileId, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "DELETE",
        "/profileresourceassociation/profileid/$(ProfileId)/resourcearn/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_resource_from_profile(
    ProfileId,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "DELETE",
        "/profileresourceassociation/profileid/$(ProfileId)/resourcearn/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile(profile_id)
    get_profile(profile_id, params::Dict{String,<:Any})

 Returns information about a specified Route 53 Profile, such as whether whether the
Profile is shared, and the current status of the Profile.

# Arguments
- `profile_id`:  ID of the Profile.

"""
function get_profile(ProfileId; aws_config::AbstractAWSConfig=current_aws_config())
    return route53profiles(
        "GET",
        "/profile/$(ProfileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile(
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "GET",
        "/profile/$(ProfileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile_association(profile_association_id)
    get_profile_association(profile_association_id, params::Dict{String,<:Any})

 Retrieves a Route 53 Profile association for a VPC. A VPC can have only one Profile
association, but a Profile can be associated with up to 5000 VPCs.

# Arguments
- `profile_association_id`:  The identifier of the association you want to get information
  about.

"""
function get_profile_association(
    ProfileAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "GET",
        "/profileassociation/$(ProfileAssociationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile_association(
    ProfileAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "GET",
        "/profileassociation/$(ProfileAssociationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile_resource_association(profile_resource_association_id)
    get_profile_resource_association(profile_resource_association_id, params::Dict{String,<:Any})

 Returns information about a specified Route 53 Profile resource association.

# Arguments
- `profile_resource_association_id`:  The ID of the profile resource association that you
  want to get information about.

"""
function get_profile_resource_association(
    ProfileResourceAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "GET",
        "/profileresourceassociation/$(ProfileResourceAssociationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile_resource_association(
    ProfileResourceAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "GET",
        "/profileresourceassociation/$(ProfileResourceAssociationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_profile_associations()
    list_profile_associations(params::Dict{String,<:Any})

 Lists all the VPCs that the specified Route 53 Profile is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of objects that you want to return for this request.
  If more objects are available, in the response, a NextToken value, which you can use in a
  subsequent call to get the next batch of objects, is provided.  If you don't specify a
  value for MaxResults, up to 100 objects are returned.
- `"nextToken"`:  For the first call to this list request, omit this value.  When you
  request a list of objects, at most the number of objects specified by MaxResults is
  returned. If more objects are available for retrieval, a NextToken value is returned in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
- `"profileId"`:  ID of the Profile.
- `"resourceId"`:  ID of the VPC.
"""
function list_profile_associations(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53profiles(
        "GET",
        "/profileassociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_profile_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "GET",
        "/profileassociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_profile_resource_associations(profile_id)
    list_profile_resource_associations(profile_id, params::Dict{String,<:Any})

 Lists all the resource associations for the specified Route 53 Profile.

# Arguments
- `profile_id`:  The ID of the Profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of objects that you want to return for this request.
  If more objects are available, in the response, a NextToken value, which you can use in a
  subsequent call to get the next batch of objects, is provided.  If you don't specify a
  value for MaxResults, up to 100 objects are returned.
- `"nextToken"`:  For the first call to this list request, omit this value.  When you
  request a list of objects, at most the number of objects specified by MaxResults is
  returned. If more objects are available for retrieval, a NextToken value is returned in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
- `"resourceType"`:  ID of a resource if you want information on only one type.
"""
function list_profile_resource_associations(
    ProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "GET",
        "/profileresourceassociations/profileid/$(ProfileId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_profile_resource_associations(
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "GET",
        "/profileresourceassociations/profileid/$(ProfileId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_profiles()
    list_profiles(params::Dict{String,<:Any})

 Lists all the Route 53 Profiles associated with your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`:  The maximum number of objects that you want to return for this request.
  If more objects are available, in the response, a NextToken value, which you can use in a
  subsequent call to get the next batch of objects, is provided.  If you don't specify a
  value for MaxResults, up to 100 objects are returned.
- `"nextToken"`:  For the first call to this list request, omit this value.  When you
  request a list of objects, at most the number of objects specified by MaxResults is
  returned. If more objects are available for retrieval, a NextToken value is returned in the
  response. To retrieve the next batch of objects, use the token that was returned for the
  prior request in your next request.
"""
function list_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return route53profiles(
        "GET", "/profiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "GET", "/profiles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

 Lists the tags that you associated with the specified resource.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) for the resource that you want to list
  the tags for.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

 Adds one or more tags to a specified resource.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) for the resource that you want to add
  tags to.
- `tags`:  The tags that you want to add to the specified resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return route53profiles(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

 Removes one or more tags from a specified resource.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) for the resource that you want to remove
  tags from.
- `tag_keys`:  The tags that you want to remove to the specified resource.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_profile_resource_association(profile_resource_association_id)
    update_profile_resource_association(profile_resource_association_id, params::Dict{String,<:Any})

 Updates the specified Route 53 Profile resourse association.

# Arguments
- `profile_resource_association_id`:  ID of the resource association.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`:  Name of the resource association.
- `"ResourceProperties"`:  If you are adding a DNS Firewall rule group, include also a
  priority. The priority indicates the processing order for the rule groups, starting with
  the priority assinged the lowest value.  The allowed values for priority are between 100
  and 9900.
"""
function update_profile_resource_association(
    ProfileResourceAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return route53profiles(
        "PATCH",
        "/profileresourceassociation/$(ProfileResourceAssociationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_profile_resource_association(
    ProfileResourceAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return route53profiles(
        "PATCH",
        "/profileresourceassociation/$(ProfileResourceAssociationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
