# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: sts
using AWS.Compat
using AWS.UUIDs

"""
    assume_role(role_arn, role_session_name)
    assume_role(role_arn, role_session_name, params::Dict{String,<:Any})

Returns a set of temporary security credentials that you can use to access Amazon Web
Services resources. These temporary credentials consist of an access key ID, a secret
access key, and a security token. Typically, you use AssumeRole within your account or for
cross-account access. For a comparison of AssumeRole with other API operations that produce
temporary credentials, see Requesting Temporary Security Credentials and Comparing the
Amazon Web Services STS API operations in the IAM User Guide.  Permissions  The temporary
security credentials created by AssumeRole can be used to make API calls to any Amazon Web
Services service with the following exception: You cannot call the Amazon Web Services STS
GetFederationToken or GetSessionToken API operations. (Optional) You can pass inline or
managed session policies to this operation. You can pass a single JSON policy document to
use as an inline session policy. You can also specify up to 10 managed policy Amazon
Resource Names (ARNs) to use as managed session policies. The plaintext that you use for
both inline and managed session policies can't exceed 2,048 characters. Passing policies to
this operation returns new temporary credentials. The resulting session's permissions are
the intersection of the role's identity-based policy and the session policies. You can use
the role's temporary credentials in subsequent Amazon Web Services API calls to access
resources in the account that owns the role. You cannot use session policies to grant more
permissions than those allowed by the identity-based policy of the role that is being
assumed. For more information, see Session Policies in the IAM User Guide. When you create
a role, you create two policies: a role trust policy that specifies who can assume the
role, and a permissions policy that specifies what can be done with the role. You specify
the trusted principal that is allowed to assume the role in the role trust policy. To
assume a role from a different account, your Amazon Web Services account must be trusted by
the role. The trust relationship is defined in the role's trust policy when the role is
created. That trust policy states which accounts are allowed to delegate that access to
users in the account.  A user who wants to access a role in a different account must also
have permissions that are delegated from the account administrator. The administrator must
attach a policy that allows the user to call AssumeRole for the ARN of the role in the
other account. To allow a user to assume a role in the same account, you can do either of
the following:   Attach a policy to the user that allows the user to call AssumeRole (as
long as the role's trust policy trusts the account).   Add the user as a principal directly
in the role's trust policy.   You can do either because the role’s trust policy acts as
an IAM resource-based policy. When a resource-based policy grants access to a principal in
the same account, no additional identity-based policy is required. For more information
about trust policies and resource-based policies, see IAM Policies in the IAM User Guide.
Tags  (Optional) You can pass tag key-value pairs to your session. These tags are called
session tags. For more information about session tags, see Passing Session Tags in STS in
the IAM User Guide. An administrator must grant you the permissions necessary to pass
session tags. The administrator can also create granular permissions to allow you to pass
only specific session tags. For more information, see Tutorial: Using Tags for
Attribute-Based Access Control in the IAM User Guide. You can set the session tags as
transitive. Transitive tags persist during role chaining. For more information, see
Chaining Roles with Session Tags in the IAM User Guide.  Using MFA with AssumeRole
(Optional) You can include multi-factor authentication (MFA) information when you call
AssumeRole. This is useful for cross-account scenarios to ensure that the user that assumes
the role has been authenticated with an Amazon Web Services MFA device. In that scenario,
the trust policy of the role being assumed includes a condition that tests for MFA
authentication. If the caller does not include valid MFA information, the request to assume
the role is denied. The condition in a trust policy that tests for MFA authentication might
look like the following example.  \"Condition\": {\"Bool\":
{\"aws:MultiFactorAuthPresent\": true}}  For more information, see Configuring
MFA-Protected API Access in the IAM User Guide guide. To use MFA with AssumeRole, you pass
values for the SerialNumber and TokenCode parameters. The SerialNumber value identifies the
user's hardware or virtual MFA device. The TokenCode is the time-based one-time password
(TOTP) that the MFA device produces.

# Arguments
- `role_arn`: The Amazon Resource Name (ARN) of the role to assume.
- `role_session_name`: An identifier for the assumed role session. Use the role session
  name to uniquely identify a session when the same role is assumed by different principals
  or for different reasons. In cross-account scenarios, the role session name is visible to,
  and can be logged by the account that owns the role. The role session name is also used in
  the ARN of the assumed role principal. This means that subsequent cross-account API
  requests that use the temporary security credentials will expose the role session name to
  the external account in their CloudTrail logs. The regex used to validate this parameter is
  a string of characters consisting of upper- and lower-case alphanumeric characters with no
  spaces. You can also include underscores or any of the following characters: =,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationSeconds"`: The duration, in seconds, of the role session. The value specified
  can range from 900 seconds (15 minutes) up to the maximum session duration set for the
  role. The maximum session duration setting can have a value from 1 hour to 12 hours. If you
  specify a value higher than this setting or the administrator setting (whichever is lower),
  the operation fails. For example, if you specify a session duration of 12 hours, but your
  administrator set the maximum session duration to 6 hours, your operation fails.  Role
  chaining limits your Amazon Web Services CLI or Amazon Web Services API role session to a
  maximum of one hour. When you use the AssumeRole API operation to assume a role, you can
  specify the duration of your role session with the DurationSeconds parameter. You can
  specify a parameter value of up to 43200 seconds (12 hours), depending on the maximum
  session duration setting for your role. However, if you assume a role using role chaining
  and provide a DurationSeconds parameter value greater than one hour, the operation fails.
  To learn how to view the maximum value for your role, see View the Maximum Session Duration
  Setting for a Role in the IAM User Guide. By default, the value is set to 3600 seconds.
  The DurationSeconds parameter is separate from the duration of a console session that you
  might request using the returned credentials. The request to the federation endpoint for a
  console sign-in token takes a SessionDuration parameter that specifies the maximum length
  of the console session. For more information, see Creating a URL that Enables Federated
  Users to Access the Amazon Web Services Management Console in the IAM User Guide.
- `"ExternalId"`: A unique identifier that might be required when you assume a role in
  another account. If the administrator of the account to which the role belongs provided you
  with an external ID, then provide that value in the ExternalId parameter. This value can be
  any string, such as a passphrase or account number. A cross-account role is usually set up
  to trust everyone in an account. Therefore, the administrator of the trusting account might
  send an external ID to the administrator of the trusted account. That way, only someone
  with the ID can assume the role, rather than everyone in the account. For more information
  about the external ID, see How to Use an External ID When Granting Access to Your Amazon
  Web Services Resources to a Third Party in the IAM User Guide. The regex used to validate
  this parameter is a string of characters consisting of upper- and lower-case alphanumeric
  characters with no spaces. You can also include underscores or any of the following
  characters: =,.@:/-
- `"Policy"`: An IAM policy in JSON format that you want to use as an inline session
  policy. This parameter is optional. Passing policies to this operation returns new
  temporary credentials. The resulting session's permissions are the intersection of the
  role's identity-based policy and the session policies. You can use the role's temporary
  credentials in subsequent Amazon Web Services API calls to access resources in the account
  that owns the role. You cannot use session policies to grant more permissions than those
  allowed by the identity-based policy of the role that is being assumed. For more
  information, see Session Policies in the IAM User Guide. The plaintext that you use for
  both inline and managed session policies can't exceed 2,048 characters. The JSON policy
  characters can be any ASCII character from the space character to the end of the valid
  character list (u0020 through u00FF). It can also include the tab (u0009), linefeed
  (u000A), and carriage return (u000D) characters.  An Amazon Web Services conversion
  compresses the passed inline session policy, managed policy ARNs, and session tags into a
  packed binary format that has a separate limit. Your request can fail for this limit even
  if your plaintext meets the other requirements. The PackedPolicySize response element
  indicates by percentage how close the policies and tags for your request are to the upper
  size limit.
- `"PolicyArns"`: The Amazon Resource Names (ARNs) of the IAM managed policies that you
  want to use as managed session policies. The policies must exist in the same account as the
  role. This parameter is optional. You can provide up to 10 managed policy ARNs. However,
  the plaintext that you use for both inline and managed session policies can't exceed 2,048
  characters. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
  Web Services Service Namespaces in the Amazon Web Services General Reference.  An Amazon
  Web Services conversion compresses the passed inline session policy, managed policy ARNs,
  and session tags into a packed binary format that has a separate limit. Your request can
  fail for this limit even if your plaintext meets the other requirements. The
  PackedPolicySize response element indicates by percentage how close the policies and tags
  for your request are to the upper size limit.  Passing policies to this operation returns
  new temporary credentials. The resulting session's permissions are the intersection of the
  role's identity-based policy and the session policies. You can use the role's temporary
  credentials in subsequent Amazon Web Services API calls to access resources in the account
  that owns the role. You cannot use session policies to grant more permissions than those
  allowed by the identity-based policy of the role that is being assumed. For more
  information, see Session Policies in the IAM User Guide.
- `"ProvidedContexts"`: A list of previously acquired trusted context assertions in the
  format of a JSON array. The trusted context assertion is signed and encrypted by Amazon Web
  Services STS. The following is an example of a ProvidedContext value that includes a single
  trusted context assertion and the ARN of the context provider from which the trusted
  context assertion was generated.
  [{\"ProviderArn\":\"arn:aws:iam::aws:contextProvider/IdentityCenter\",\"ContextAssertion
  \":\"trusted-context-assertion\"}]
- `"SerialNumber"`: The identification number of the MFA device that is associated with the
  user who is making the AssumeRole call. Specify this value if the trust policy of the role
  being assumed includes a condition that requires MFA authentication. The value is either
  the serial number for a hardware device (such as GAHT12345678) or an Amazon Resource Name
  (ARN) for a virtual device (such as arn:aws:iam::123456789012:mfa/user). The regex used to
  validate this parameter is a string of characters consisting of upper- and lower-case
  alphanumeric characters with no spaces. You can also include underscores or any of the
  following characters: =,.@-
- `"SourceIdentity"`: The source identity specified by the principal that is calling the
  AssumeRole operation. You can require users to specify a source identity when they assume a
  role. You do this by using the sts:SourceIdentity condition key in a role trust policy. You
  can use source identity information in CloudTrail logs to determine who took actions with a
  role. You can use the aws:SourceIdentity condition key to further control access to Amazon
  Web Services resources based on the value of source identity. For more information about
  using source identity, see Monitor and control actions taken with assumed roles in the IAM
  User Guide. The regex used to validate this parameter is a string of characters consisting
  of upper- and lower-case alphanumeric characters with no spaces. You can also include
  underscores or any of the following characters: =,.@-. You cannot use a value that begins
  with the text aws:. This prefix is reserved for Amazon Web Services internal use.
- `"Tags"`: A list of session tags that you want to pass. Each session tag consists of a
  key name and an associated value. For more information about session tags, see Tagging
  Amazon Web Services STS Sessions in the IAM User Guide. This parameter is optional. You can
  pass up to 50 session tags. The plaintext session tag keys can’t exceed 128 characters,
  and the values can’t exceed 256 characters. For these and additional limits, see IAM and
  STS Character Limits in the IAM User Guide.  An Amazon Web Services conversion compresses
  the passed inline session policy, managed policy ARNs, and session tags into a packed
  binary format that has a separate limit. Your request can fail for this limit even if your
  plaintext meets the other requirements. The PackedPolicySize response element indicates by
  percentage how close the policies and tags for your request are to the upper size limit.
  You can pass a session tag with the same key as a tag that is already attached to the role.
  When you do, session tags override a role tag with the same key.  Tag key–value pairs are
  not case sensitive, but case is preserved. This means that you cannot have separate
  Department and department tag keys. Assume that the role has the Department=Marketing tag
  and you pass the department=engineering session tag. Department and department are not
  saved as separate tags, and the session tag passed in the request takes precedence over the
  role tag. Additionally, if you used temporary credentials to perform this operation, the
  new session inherits any transitive session tags from the calling session. If you pass a
  session tag with the same key as an inherited tag, the operation fails. To view the
  inherited tags for a session, see the CloudTrail logs. For more information, see Viewing
  Session Tags in CloudTrail in the IAM User Guide.
- `"TokenCode"`: The value provided by the MFA device, if the trust policy of the role
  being assumed requires MFA. (In other words, if the policy includes a condition that tests
  for MFA). If the role being assumed requires MFA and if the TokenCode value is missing or
  expired, the AssumeRole call returns an \"access denied\" error. The format for this
  parameter, as described by its regex pattern, is a sequence of six numeric digits.
- `"TransitiveTagKeys"`: A list of keys for session tags that you want to set as
  transitive. If you set a tag key as transitive, the corresponding key and value passes to
  subsequent sessions in a role chain. For more information, see Chaining Roles with Session
  Tags in the IAM User Guide. This parameter is optional. When you set session tags as
  transitive, the session policy and session tags packed binary limit is not affected. If you
  choose not to specify a transitive tag key, then no tags are passed from this session to
  any subsequent sessions.
"""
function assume_role(
    RoleArn, RoleSessionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "AssumeRole",
        Dict{String,Any}("RoleArn" => RoleArn, "RoleSessionName" => RoleSessionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assume_role(
    RoleArn,
    RoleSessionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sts(
        "AssumeRole",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RoleArn" => RoleArn, "RoleSessionName" => RoleSessionName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assume_role_with_saml(principal_arn, role_arn, samlassertion)
    assume_role_with_saml(principal_arn, role_arn, samlassertion, params::Dict{String,<:Any})

Returns a set of temporary security credentials for users who have been authenticated via a
SAML authentication response. This operation provides a mechanism for tying an enterprise
identity store or directory to role-based Amazon Web Services access without user-specific
credentials or configuration. For a comparison of AssumeRoleWithSAML with the other API
operations that produce temporary credentials, see Requesting Temporary Security
Credentials and Comparing the Amazon Web Services STS API operations in the IAM User Guide.
The temporary security credentials returned by this operation consist of an access key ID,
a secret access key, and a security token. Applications can use these temporary security
credentials to sign calls to Amazon Web Services services.  Session Duration  By default,
the temporary security credentials created by AssumeRoleWithSAML last for one hour.
However, you can use the optional DurationSeconds parameter to specify the duration of your
session. Your role session lasts for the duration that you specify, or until the time
specified in the SAML authentication response's SessionNotOnOrAfter value, whichever is
shorter. You can provide a DurationSeconds value from 900 seconds (15 minutes) up to the
maximum session duration setting for the role. This setting can have a value from 1 hour to
12 hours. To learn how to view the maximum value for your role, see View the Maximum
Session Duration Setting for a Role in the IAM User Guide. The maximum session duration
limit applies when you use the AssumeRole* API operations or the assume-role* CLI commands.
However the limit does not apply when you use those operations to create a console URL. For
more information, see Using IAM Roles in the IAM User Guide.   Role chaining limits your
CLI or Amazon Web Services API role session to a maximum of one hour. When you use the
AssumeRole API operation to assume a role, you can specify the duration of your role
session with the DurationSeconds parameter. You can specify a parameter value of up to
43200 seconds (12 hours), depending on the maximum session duration setting for your role.
However, if you assume a role using role chaining and provide a DurationSeconds parameter
value greater than one hour, the operation fails.   Permissions  The temporary security
credentials created by AssumeRoleWithSAML can be used to make API calls to any Amazon Web
Services service with the following exception: you cannot call the STS GetFederationToken
or GetSessionToken API operations. (Optional) You can pass inline or managed session
policies to this operation. You can pass a single JSON policy document to use as an inline
session policy. You can also specify up to 10 managed policy Amazon Resource Names (ARNs)
to use as managed session policies. The plaintext that you use for both inline and managed
session policies can't exceed 2,048 characters. Passing policies to this operation returns
new temporary credentials. The resulting session's permissions are the intersection of the
role's identity-based policy and the session policies. You can use the role's temporary
credentials in subsequent Amazon Web Services API calls to access resources in the account
that owns the role. You cannot use session policies to grant more permissions than those
allowed by the identity-based policy of the role that is being assumed. For more
information, see Session Policies in the IAM User Guide. Calling AssumeRoleWithSAML does
not require the use of Amazon Web Services security credentials. The identity of the caller
is validated by using keys in the metadata document that is uploaded for the SAML provider
entity for your identity provider.   Calling AssumeRoleWithSAML can result in an entry in
your CloudTrail logs. The entry includes the value in the NameID element of the SAML
assertion. We recommend that you use a NameIDType that is not associated with any
personally identifiable information (PII). For example, you could instead use the
persistent identifier (urn:oasis:names:tc:SAML:2.0:nameid-format:persistent).   Tags
(Optional) You can configure your IdP to pass attributes into your SAML assertion as
session tags. Each session tag consists of a key name and an associated value. For more
information about session tags, see Passing Session Tags in STS in the IAM User Guide. You
can pass up to 50 session tags. The plaintext session tag keys can’t exceed 128
characters and the values can’t exceed 256 characters. For these and additional limits,
see IAM and STS Character Limits in the IAM User Guide.  An Amazon Web Services conversion
compresses the passed inline session policy, managed policy ARNs, and session tags into a
packed binary format that has a separate limit. Your request can fail for this limit even
if your plaintext meets the other requirements. The PackedPolicySize response element
indicates by percentage how close the policies and tags for your request are to the upper
size limit.  You can pass a session tag with the same key as a tag that is attached to the
role. When you do, session tags override the role's tags with the same key. An
administrator must grant you the permissions necessary to pass session tags. The
administrator can also create granular permissions to allow you to pass only specific
session tags. For more information, see Tutorial: Using Tags for Attribute-Based Access
Control in the IAM User Guide. You can set the session tags as transitive. Transitive tags
persist during role chaining. For more information, see Chaining Roles with Session Tags in
the IAM User Guide.  SAML Configuration  Before your application can call
AssumeRoleWithSAML, you must configure your SAML identity provider (IdP) to issue the
claims required by Amazon Web Services. Additionally, you must use Identity and Access
Management (IAM) to create a SAML provider entity in your Amazon Web Services account that
represents your identity provider. You must also create an IAM role that specifies this
SAML provider in its trust policy.  For more information, see the following resources:
About SAML 2.0-based Federation in the IAM User Guide.     Creating SAML Identity Providers
in the IAM User Guide.     Configuring a Relying Party and Claims in the IAM User Guide.
 Creating a Role for SAML 2.0 Federation in the IAM User Guide.

# Arguments
- `principal_arn`: The Amazon Resource Name (ARN) of the SAML provider in IAM that
  describes the IdP.
- `role_arn`: The Amazon Resource Name (ARN) of the role that the caller is assuming.
- `samlassertion`: The base64 encoded SAML authentication response provided by the IdP. For
  more information, see Configuring a Relying Party and Adding Claims in the IAM User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationSeconds"`: The duration, in seconds, of the role session. Your role session
  lasts for the duration that you specify for the DurationSeconds parameter, or until the
  time specified in the SAML authentication response's SessionNotOnOrAfter value, whichever
  is shorter. You can provide a DurationSeconds value from 900 seconds (15 minutes) up to the
  maximum session duration setting for the role. This setting can have a value from 1 hour to
  12 hours. If you specify a value higher than this setting, the operation fails. For
  example, if you specify a session duration of 12 hours, but your administrator set the
  maximum session duration to 6 hours, your operation fails. To learn how to view the maximum
  value for your role, see View the Maximum Session Duration Setting for a Role in the IAM
  User Guide. By default, the value is set to 3600 seconds.   The DurationSeconds parameter
  is separate from the duration of a console session that you might request using the
  returned credentials. The request to the federation endpoint for a console sign-in token
  takes a SessionDuration parameter that specifies the maximum length of the console session.
  For more information, see Creating a URL that Enables Federated Users to Access the Amazon
  Web Services Management Console in the IAM User Guide.
- `"Policy"`: An IAM policy in JSON format that you want to use as an inline session
  policy. This parameter is optional. Passing policies to this operation returns new
  temporary credentials. The resulting session's permissions are the intersection of the
  role's identity-based policy and the session policies. You can use the role's temporary
  credentials in subsequent Amazon Web Services API calls to access resources in the account
  that owns the role. You cannot use session policies to grant more permissions than those
  allowed by the identity-based policy of the role that is being assumed. For more
  information, see Session Policies in the IAM User Guide.  The plaintext that you use for
  both inline and managed session policies can't exceed 2,048 characters. The JSON policy
  characters can be any ASCII character from the space character to the end of the valid
  character list (u0020 through u00FF). It can also include the tab (u0009), linefeed
  (u000A), and carriage return (u000D) characters.  An Amazon Web Services conversion
  compresses the passed inline session policy, managed policy ARNs, and session tags into a
  packed binary format that has a separate limit. Your request can fail for this limit even
  if your plaintext meets the other requirements. The PackedPolicySize response element
  indicates by percentage how close the policies and tags for your request are to the upper
  size limit.
- `"PolicyArns"`: The Amazon Resource Names (ARNs) of the IAM managed policies that you
  want to use as managed session policies. The policies must exist in the same account as the
  role. This parameter is optional. You can provide up to 10 managed policy ARNs. However,
  the plaintext that you use for both inline and managed session policies can't exceed 2,048
  characters. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
  Web Services Service Namespaces in the Amazon Web Services General Reference.  An Amazon
  Web Services conversion compresses the passed inline session policy, managed policy ARNs,
  and session tags into a packed binary format that has a separate limit. Your request can
  fail for this limit even if your plaintext meets the other requirements. The
  PackedPolicySize response element indicates by percentage how close the policies and tags
  for your request are to the upper size limit.  Passing policies to this operation returns
  new temporary credentials. The resulting session's permissions are the intersection of the
  role's identity-based policy and the session policies. You can use the role's temporary
  credentials in subsequent Amazon Web Services API calls to access resources in the account
  that owns the role. You cannot use session policies to grant more permissions than those
  allowed by the identity-based policy of the role that is being assumed. For more
  information, see Session Policies in the IAM User Guide.
"""
function assume_role_with_saml(
    PrincipalArn, RoleArn, SAMLAssertion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "AssumeRoleWithSAML",
        Dict{String,Any}(
            "PrincipalArn" => PrincipalArn,
            "RoleArn" => RoleArn,
            "SAMLAssertion" => SAMLAssertion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assume_role_with_saml(
    PrincipalArn,
    RoleArn,
    SAMLAssertion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sts(
        "AssumeRoleWithSAML",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PrincipalArn" => PrincipalArn,
                    "RoleArn" => RoleArn,
                    "SAMLAssertion" => SAMLAssertion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assume_role_with_web_identity(role_arn, role_session_name, web_identity_token)
    assume_role_with_web_identity(role_arn, role_session_name, web_identity_token, params::Dict{String,<:Any})

Returns a set of temporary security credentials for users who have been authenticated in a
mobile or web application with a web identity provider. Example providers include the OAuth
2.0 providers Login with Amazon and Facebook, or any OpenID Connect-compatible identity
provider such as Google or Amazon Cognito federated identities.  For mobile applications,
we recommend that you use Amazon Cognito. You can use Amazon Cognito with the Amazon Web
Services SDK for iOS Developer Guide and the Amazon Web Services SDK for Android Developer
Guide to uniquely identify a user. You can also supply the user with a consistent identity
throughout the lifetime of an application. To learn more about Amazon Cognito, see Amazon
Cognito identity pools in Amazon Cognito Developer Guide.  Calling
AssumeRoleWithWebIdentity does not require the use of Amazon Web Services security
credentials. Therefore, you can distribute an application (for example, on mobile devices)
that requests temporary security credentials without including long-term Amazon Web
Services credentials in the application. You also don't need to deploy server-based proxy
services that use long-term Amazon Web Services credentials. Instead, the identity of the
caller is validated by using a token from the web identity provider. For a comparison of
AssumeRoleWithWebIdentity with the other API operations that produce temporary credentials,
see Requesting Temporary Security Credentials and Comparing the Amazon Web Services STS API
operations in the IAM User Guide. The temporary security credentials returned by this API
consist of an access key ID, a secret access key, and a security token. Applications can
use these temporary security credentials to sign calls to Amazon Web Services service API
operations.  Session Duration  By default, the temporary security credentials created by
AssumeRoleWithWebIdentity last for one hour. However, you can use the optional
DurationSeconds parameter to specify the duration of your session. You can provide a value
from 900 seconds (15 minutes) up to the maximum session duration setting for the role. This
setting can have a value from 1 hour to 12 hours. To learn how to view the maximum value
for your role, see View the Maximum Session Duration Setting for a Role in the IAM User
Guide. The maximum session duration limit applies when you use the AssumeRole* API
operations or the assume-role* CLI commands. However the limit does not apply when you use
those operations to create a console URL. For more information, see Using IAM Roles in the
IAM User Guide.   Permissions  The temporary security credentials created by
AssumeRoleWithWebIdentity can be used to make API calls to any Amazon Web Services service
with the following exception: you cannot call the STS GetFederationToken or GetSessionToken
API operations. (Optional) You can pass inline or managed session policies to this
operation. You can pass a single JSON policy document to use as an inline session policy.
You can also specify up to 10 managed policy Amazon Resource Names (ARNs) to use as managed
session policies. The plaintext that you use for both inline and managed session policies
can't exceed 2,048 characters. Passing policies to this operation returns new temporary
credentials. The resulting session's permissions are the intersection of the role's
identity-based policy and the session policies. You can use the role's temporary
credentials in subsequent Amazon Web Services API calls to access resources in the account
that owns the role. You cannot use session policies to grant more permissions than those
allowed by the identity-based policy of the role that is being assumed. For more
information, see Session Policies in the IAM User Guide.  Tags  (Optional) You can
configure your IdP to pass attributes into your web identity token as session tags. Each
session tag consists of a key name and an associated value. For more information about
session tags, see Passing Session Tags in STS in the IAM User Guide. You can pass up to 50
session tags. The plaintext session tag keys can’t exceed 128 characters and the values
can’t exceed 256 characters. For these and additional limits, see IAM and STS Character
Limits in the IAM User Guide.  An Amazon Web Services conversion compresses the passed
inline session policy, managed policy ARNs, and session tags into a packed binary format
that has a separate limit. Your request can fail for this limit even if your plaintext
meets the other requirements. The PackedPolicySize response element indicates by percentage
how close the policies and tags for your request are to the upper size limit.  You can pass
a session tag with the same key as a tag that is attached to the role. When you do, the
session tag overrides the role tag with the same key. An administrator must grant you the
permissions necessary to pass session tags. The administrator can also create granular
permissions to allow you to pass only specific session tags. For more information, see
Tutorial: Using Tags for Attribute-Based Access Control in the IAM User Guide. You can set
the session tags as transitive. Transitive tags persist during role chaining. For more
information, see Chaining Roles with Session Tags in the IAM User Guide.  Identities
Before your application can call AssumeRoleWithWebIdentity, you must have an identity token
from a supported identity provider and create a role that the application can assume. The
role that your application assumes must trust the identity provider that is associated with
the identity token. In other words, the identity provider must be specified in the role's
trust policy.   Calling AssumeRoleWithWebIdentity can result in an entry in your CloudTrail
logs. The entry includes the Subject of the provided web identity token. We recommend that
you avoid using any personally identifiable information (PII) in this field. For example,
you could instead use a GUID or a pairwise identifier, as suggested in the OIDC
specification.  For more information about how to use web identity federation and the
AssumeRoleWithWebIdentity API, see the following resources:     Using Web Identity
Federation API Operations for Mobile Apps and Federation Through a Web-based Identity
Provider.      Web Identity Federation Playground. Walk through the process of
authenticating through Login with Amazon, Facebook, or Google, getting temporary security
credentials, and then using those credentials to make a request to Amazon Web Services.
Amazon Web Services SDK for iOS Developer Guide and Amazon Web Services SDK for Android
Developer Guide. These toolkits contain sample apps that show how to invoke the identity
providers. The toolkits then show how to use the information from these providers to get
and use temporary security credentials.     Web Identity Federation with Mobile
Applications. This article discusses web identity federation and shows an example of how to
use web identity federation to get access to content in Amazon S3.

# Arguments
- `role_arn`: The Amazon Resource Name (ARN) of the role that the caller is assuming.
- `role_session_name`: An identifier for the assumed role session. Typically, you pass the
  name or identifier that is associated with the user who is using your application. That
  way, the temporary security credentials that your application will use are associated with
  that user. This session name is included as part of the ARN and assumed role ID in the
  AssumedRoleUser response element. The regex used to validate this parameter is a string of
  characters consisting of upper- and lower-case alphanumeric characters with no spaces. You
  can also include underscores or any of the following characters: =,.@-
- `web_identity_token`: The OAuth 2.0 access token or OpenID Connect ID token that is
  provided by the identity provider. Your application must get this token by authenticating
  the user who is using your application with a web identity provider before the application
  makes an AssumeRoleWithWebIdentity call. Only tokens with RSA algorithms (RS256) are
  supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationSeconds"`: The duration, in seconds, of the role session. The value can range
  from 900 seconds (15 minutes) up to the maximum session duration setting for the role. This
  setting can have a value from 1 hour to 12 hours. If you specify a value higher than this
  setting, the operation fails. For example, if you specify a session duration of 12 hours,
  but your administrator set the maximum session duration to 6 hours, your operation fails.
  To learn how to view the maximum value for your role, see View the Maximum Session Duration
  Setting for a Role in the IAM User Guide. By default, the value is set to 3600 seconds.
  The DurationSeconds parameter is separate from the duration of a console session that you
  might request using the returned credentials. The request to the federation endpoint for a
  console sign-in token takes a SessionDuration parameter that specifies the maximum length
  of the console session. For more information, see Creating a URL that Enables Federated
  Users to Access the Amazon Web Services Management Console in the IAM User Guide.
- `"Policy"`: An IAM policy in JSON format that you want to use as an inline session
  policy. This parameter is optional. Passing policies to this operation returns new
  temporary credentials. The resulting session's permissions are the intersection of the
  role's identity-based policy and the session policies. You can use the role's temporary
  credentials in subsequent Amazon Web Services API calls to access resources in the account
  that owns the role. You cannot use session policies to grant more permissions than those
  allowed by the identity-based policy of the role that is being assumed. For more
  information, see Session Policies in the IAM User Guide. The plaintext that you use for
  both inline and managed session policies can't exceed 2,048 characters. The JSON policy
  characters can be any ASCII character from the space character to the end of the valid
  character list (u0020 through u00FF). It can also include the tab (u0009), linefeed
  (u000A), and carriage return (u000D) characters.  An Amazon Web Services conversion
  compresses the passed inline session policy, managed policy ARNs, and session tags into a
  packed binary format that has a separate limit. Your request can fail for this limit even
  if your plaintext meets the other requirements. The PackedPolicySize response element
  indicates by percentage how close the policies and tags for your request are to the upper
  size limit.
- `"PolicyArns"`: The Amazon Resource Names (ARNs) of the IAM managed policies that you
  want to use as managed session policies. The policies must exist in the same account as the
  role. This parameter is optional. You can provide up to 10 managed policy ARNs. However,
  the plaintext that you use for both inline and managed session policies can't exceed 2,048
  characters. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
  Web Services Service Namespaces in the Amazon Web Services General Reference.  An Amazon
  Web Services conversion compresses the passed inline session policy, managed policy ARNs,
  and session tags into a packed binary format that has a separate limit. Your request can
  fail for this limit even if your plaintext meets the other requirements. The
  PackedPolicySize response element indicates by percentage how close the policies and tags
  for your request are to the upper size limit.  Passing policies to this operation returns
  new temporary credentials. The resulting session's permissions are the intersection of the
  role's identity-based policy and the session policies. You can use the role's temporary
  credentials in subsequent Amazon Web Services API calls to access resources in the account
  that owns the role. You cannot use session policies to grant more permissions than those
  allowed by the identity-based policy of the role that is being assumed. For more
  information, see Session Policies in the IAM User Guide.
- `"ProviderId"`: The fully qualified host component of the domain name of the OAuth 2.0
  identity provider. Do not specify this value for an OpenID Connect identity provider.
  Currently www.amazon.com and graph.facebook.com are the only supported identity providers
  for OAuth 2.0 access tokens. Do not include URL schemes and port numbers. Do not specify
  this value for OpenID Connect ID tokens.
"""
function assume_role_with_web_identity(
    RoleArn,
    RoleSessionName,
    WebIdentityToken;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sts(
        "AssumeRoleWithWebIdentity",
        Dict{String,Any}(
            "RoleArn" => RoleArn,
            "RoleSessionName" => RoleSessionName,
            "WebIdentityToken" => WebIdentityToken,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assume_role_with_web_identity(
    RoleArn,
    RoleSessionName,
    WebIdentityToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sts(
        "AssumeRoleWithWebIdentity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RoleArn" => RoleArn,
                    "RoleSessionName" => RoleSessionName,
                    "WebIdentityToken" => WebIdentityToken,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    decode_authorization_message(encoded_message)
    decode_authorization_message(encoded_message, params::Dict{String,<:Any})

Decodes additional information about the authorization status of a request from an encoded
message returned in response to an Amazon Web Services request. For example, if a user is
not authorized to perform an operation that he or she has requested, the request returns a
Client.UnauthorizedOperation response (an HTTP 403 response). Some Amazon Web Services
operations additionally return an encoded message that can provide details about this
authorization failure.   Only certain Amazon Web Services operations return an encoded
authorization message. The documentation for an individual operation indicates whether that
operation returns an encoded message in addition to returning an HTTP code.  The message is
encoded because the details of the authorization status can contain privileged information
that the user who requested the operation should not see. To decode an authorization status
message, a user must be granted permissions through an IAM policy to request the
DecodeAuthorizationMessage (sts:DecodeAuthorizationMessage) action.  The decoded message
includes the following type of information:   Whether the request was denied due to an
explicit deny or due to the absence of an explicit allow. For more information, see
Determining Whether a Request is Allowed or Denied in the IAM User Guide.    The principal
who made the request.   The requested action.   The requested resource.   The values of
condition keys in the context of the user's request.

# Arguments
- `encoded_message`: The encoded message that was returned with the response.

"""
function decode_authorization_message(
    EncodedMessage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "DecodeAuthorizationMessage",
        Dict{String,Any}("EncodedMessage" => EncodedMessage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function decode_authorization_message(
    EncodedMessage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sts(
        "DecodeAuthorizationMessage",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EncodedMessage" => EncodedMessage), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_access_key_info(access_key_id)
    get_access_key_info(access_key_id, params::Dict{String,<:Any})

Returns the account identifier for the specified access key ID. Access keys consist of two
parts: an access key ID (for example, AKIAIOSFODNN7EXAMPLE) and a secret access key (for
example, wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY). For more information about access keys,
see Managing Access Keys for IAM Users in the IAM User Guide. When you pass an access key
ID to this operation, it returns the ID of the Amazon Web Services account to which the
keys belong. Access key IDs beginning with AKIA are long-term credentials for an IAM user
or the Amazon Web Services account root user. Access key IDs beginning with ASIA are
temporary credentials that are created using STS operations. If the account in the response
belongs to you, you can sign in as the root user and review your root user access keys.
Then, you can pull a credentials report to learn which IAM user owns the keys. To learn who
requested the temporary credentials for an ASIA access key, view the STS events in your
CloudTrail logs in the IAM User Guide. This operation does not indicate the state of the
access key. The key might be active, inactive, or deleted. Active keys might not have
permissions to perform an operation. Providing a deleted access key might return an error
that the key doesn't exist.

# Arguments
- `access_key_id`: The identifier of an access key. This parameter allows (through its
  regex pattern) a string of characters that can consist of any upper- or lowercase letter or
  digit.

"""
function get_access_key_info(
    AccessKeyId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "GetAccessKeyInfo",
        Dict{String,Any}("AccessKeyId" => AccessKeyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_access_key_info(
    AccessKeyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return sts(
        "GetAccessKeyInfo",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessKeyId" => AccessKeyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_caller_identity()
    get_caller_identity(params::Dict{String,<:Any})

Returns details about the IAM user or role whose credentials are used to call the
operation.  No permissions are required to perform this operation. If an administrator
attaches a policy to your identity that explicitly denies access to the
sts:GetCallerIdentity action, you can still perform this operation. Permissions are not
required because the same information is returned when access is denied. To view an example
response, see I Am Not Authorized to Perform: iam:DeleteVirtualMFADevice in the IAM User
Guide.

"""
function get_caller_identity(; aws_config::AbstractAWSConfig=current_aws_config())
    return sts("GetCallerIdentity"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_caller_identity(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "GetCallerIdentity", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_federation_token(name)
    get_federation_token(name, params::Dict{String,<:Any})

Returns a set of temporary security credentials (consisting of an access key ID, a secret
access key, and a security token) for a user. A typical use is in a proxy application that
gets temporary security credentials on behalf of distributed applications inside a
corporate network. You must call the GetFederationToken operation using the long-term
security credentials of an IAM user. As a result, this call is appropriate in contexts
where those credentials can be safeguarded, usually in a server-based application. For a
comparison of GetFederationToken with the other API operations that produce temporary
credentials, see Requesting Temporary Security Credentials and Comparing the Amazon Web
Services STS API operations in the IAM User Guide. Although it is possible to call
GetFederationToken using the security credentials of an Amazon Web Services account root
user rather than an IAM user that you create for the purpose of a proxy application, we do
not recommend it. For more information, see Safeguard your root user credentials and don't
use them for everyday tasks in the IAM User Guide.   You can create a mobile-based or
browser-based app that can authenticate users using a web identity provider like Login with
Amazon, Facebook, Google, or an OpenID Connect-compatible identity provider. In this case,
we recommend that you use Amazon Cognito or AssumeRoleWithWebIdentity. For more
information, see Federation Through a Web-based Identity Provider in the IAM User Guide.
Session duration  The temporary credentials are valid for the specified duration, from 900
seconds (15 minutes) up to a maximum of 129,600 seconds (36 hours). The default session
duration is 43,200 seconds (12 hours). Temporary credentials obtained by using the root
user credentials have a maximum duration of 3,600 seconds (1 hour).  Permissions  You can
use the temporary credentials created by GetFederationToken in any Amazon Web Services
service with the following exceptions:   You cannot call any IAM operations using the CLI
or the Amazon Web Services API. This limitation does not apply to console sessions.   You
cannot call any STS operations except GetCallerIdentity.   You can use temporary
credentials for single sign-on (SSO) to the console. You must pass an inline or managed
session policy to this operation. You can pass a single JSON policy document to use as an
inline session policy. You can also specify up to 10 managed policy Amazon Resource Names
(ARNs) to use as managed session policies. The plaintext that you use for both inline and
managed session policies can't exceed 2,048 characters. Though the session policy
parameters are optional, if you do not pass a policy, then the resulting federated user
session has no permissions. When you pass session policies, the session permissions are the
intersection of the IAM user policies and the session policies that you pass. This gives
you a way to further restrict the permissions for a federated user. You cannot use session
policies to grant more permissions than those that are defined in the permissions policy of
the IAM user. For more information, see Session Policies in the IAM User Guide. For
information about using GetFederationToken to create temporary security credentials, see
GetFederationToken—Federation Through a Custom Identity Broker.  You can use the
credentials to access a resource that has a resource-based policy. If that policy
specifically references the federated user session in the Principal element of the policy,
the session has the permissions allowed by the policy. These permissions are granted in
addition to the permissions granted by the session policies.  Tags  (Optional) You can pass
tag key-value pairs to your session. These are called session tags. For more information
about session tags, see Passing Session Tags in STS in the IAM User Guide.  You can create
a mobile-based or browser-based app that can authenticate users using a web identity
provider like Login with Amazon, Facebook, Google, or an OpenID Connect-compatible identity
provider. In this case, we recommend that you use Amazon Cognito or
AssumeRoleWithWebIdentity. For more information, see Federation Through a Web-based
Identity Provider in the IAM User Guide.  An administrator must grant you the permissions
necessary to pass session tags. The administrator can also create granular permissions to
allow you to pass only specific session tags. For more information, see Tutorial: Using
Tags for Attribute-Based Access Control in the IAM User Guide. Tag key–value pairs are
not case sensitive, but case is preserved. This means that you cannot have separate
Department and department tag keys. Assume that the user that you are federating has the
Department=Marketing tag and you pass the department=engineering session tag. Department
and department are not saved as separate tags, and the session tag passed in the request
takes precedence over the user tag.

# Arguments
- `name`: The name of the federated user. The name is used as an identifier for the
  temporary security credentials (such as Bob). For example, you can reference the federated
  user name in a resource-based policy, such as in an Amazon S3 bucket policy. The regex used
  to validate this parameter is a string of characters consisting of upper- and lower-case
  alphanumeric characters with no spaces. You can also include underscores or any of the
  following characters: =,.@-

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationSeconds"`: The duration, in seconds, that the session should last. Acceptable
  durations for federation sessions range from 900 seconds (15 minutes) to 129,600 seconds
  (36 hours), with 43,200 seconds (12 hours) as the default. Sessions obtained using root
  user credentials are restricted to a maximum of 3,600 seconds (one hour). If the specified
  duration is longer than one hour, the session obtained by using root user credentials
  defaults to one hour.
- `"Policy"`: An IAM policy in JSON format that you want to use as an inline session
  policy. You must pass an inline or managed session policy to this operation. You can pass a
  single JSON policy document to use as an inline session policy. You can also specify up to
  10 managed policy Amazon Resource Names (ARNs) to use as managed session policies. This
  parameter is optional. However, if you do not pass any session policies, then the resulting
  federated user session has no permissions. When you pass session policies, the session
  permissions are the intersection of the IAM user policies and the session policies that you
  pass. This gives you a way to further restrict the permissions for a federated user. You
  cannot use session policies to grant more permissions than those that are defined in the
  permissions policy of the IAM user. For more information, see Session Policies in the IAM
  User Guide. The resulting credentials can be used to access a resource that has a
  resource-based policy. If that policy specifically references the federated user session in
  the Principal element of the policy, the session has the permissions allowed by the policy.
  These permissions are granted in addition to the permissions that are granted by the
  session policies. The plaintext that you use for both inline and managed session policies
  can't exceed 2,048 characters. The JSON policy characters can be any ASCII character from
  the space character to the end of the valid character list (u0020 through u00FF). It can
  also include the tab (u0009), linefeed (u000A), and carriage return (u000D) characters.  An
  Amazon Web Services conversion compresses the passed inline session policy, managed policy
  ARNs, and session tags into a packed binary format that has a separate limit. Your request
  can fail for this limit even if your plaintext meets the other requirements. The
  PackedPolicySize response element indicates by percentage how close the policies and tags
  for your request are to the upper size limit.
- `"PolicyArns"`: The Amazon Resource Names (ARNs) of the IAM managed policies that you
  want to use as a managed session policy. The policies must exist in the same account as the
  IAM user that is requesting federated access. You must pass an inline or managed session
  policy to this operation. You can pass a single JSON policy document to use as an inline
  session policy. You can also specify up to 10 managed policy Amazon Resource Names (ARNs)
  to use as managed session policies. The plaintext that you use for both inline and managed
  session policies can't exceed 2,048 characters. You can provide up to 10 managed policy
  ARNs. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web
  Services Service Namespaces in the Amazon Web Services General Reference. This parameter is
  optional. However, if you do not pass any session policies, then the resulting federated
  user session has no permissions. When you pass session policies, the session permissions
  are the intersection of the IAM user policies and the session policies that you pass. This
  gives you a way to further restrict the permissions for a federated user. You cannot use
  session policies to grant more permissions than those that are defined in the permissions
  policy of the IAM user. For more information, see Session Policies in the IAM User Guide.
  The resulting credentials can be used to access a resource that has a resource-based
  policy. If that policy specifically references the federated user session in the Principal
  element of the policy, the session has the permissions allowed by the policy. These
  permissions are granted in addition to the permissions that are granted by the session
  policies.  An Amazon Web Services conversion compresses the passed inline session policy,
  managed policy ARNs, and session tags into a packed binary format that has a separate
  limit. Your request can fail for this limit even if your plaintext meets the other
  requirements. The PackedPolicySize response element indicates by percentage how close the
  policies and tags for your request are to the upper size limit.
- `"Tags"`: A list of session tags. Each session tag consists of a key name and an
  associated value. For more information about session tags, see Passing Session Tags in STS
  in the IAM User Guide. This parameter is optional. You can pass up to 50 session tags. The
  plaintext session tag keys can’t exceed 128 characters and the values can’t exceed 256
  characters. For these and additional limits, see IAM and STS Character Limits in the IAM
  User Guide.  An Amazon Web Services conversion compresses the passed inline session policy,
  managed policy ARNs, and session tags into a packed binary format that has a separate
  limit. Your request can fail for this limit even if your plaintext meets the other
  requirements. The PackedPolicySize response element indicates by percentage how close the
  policies and tags for your request are to the upper size limit.  You can pass a session tag
  with the same key as a tag that is already attached to the user you are federating. When
  you do, session tags override a user tag with the same key.  Tag key–value pairs are not
  case sensitive, but case is preserved. This means that you cannot have separate Department
  and department tag keys. Assume that the role has the Department=Marketing tag and you pass
  the department=engineering session tag. Department and department are not saved as separate
  tags, and the session tag passed in the request takes precedence over the role tag.
"""
function get_federation_token(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return sts(
        "GetFederationToken",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_federation_token(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "GetFederationToken",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_session_token()
    get_session_token(params::Dict{String,<:Any})

Returns a set of temporary credentials for an Amazon Web Services account or IAM user. The
credentials consist of an access key ID, a secret access key, and a security token.
Typically, you use GetSessionToken if you want to use MFA to protect programmatic calls to
specific Amazon Web Services API operations like Amazon EC2 StopInstances. MFA-enabled IAM
users must call GetSessionToken and submit an MFA code that is associated with their MFA
device. Using the temporary security credentials that the call returns, IAM users can then
make programmatic calls to API operations that require MFA authentication. An incorrect MFA
code causes the API to return an access denied error. For a comparison of GetSessionToken
with the other API operations that produce temporary credentials, see Requesting Temporary
Security Credentials and Comparing the Amazon Web Services STS API operations in the IAM
User Guide.  No permissions are required for users to perform this operation. The purpose
of the sts:GetSessionToken operation is to authenticate the user using MFA. You cannot use
policies to control authentication operations. For more information, see Permissions for
GetSessionToken in the IAM User Guide.   Session Duration  The GetSessionToken operation
must be called by using the long-term Amazon Web Services security credentials of an IAM
user. Credentials that are created by IAM users are valid for the duration that you
specify. This duration can range from 900 seconds (15 minutes) up to a maximum of 129,600
seconds (36 hours), with a default of 43,200 seconds (12 hours). Credentials based on
account credentials can range from 900 seconds (15 minutes) up to 3,600 seconds (1 hour),
with a default of 1 hour.   Permissions  The temporary security credentials created by
GetSessionToken can be used to make API calls to any Amazon Web Services service with the
following exceptions:   You cannot call any IAM API operations unless MFA authentication
information is included in the request.   You cannot call any STS API except AssumeRole or
GetCallerIdentity.   The credentials that GetSessionToken returns are based on permissions
associated with the IAM user whose credentials were used to call the operation. The
temporary credentials have the same permissions as the IAM user.  Although it is possible
to call GetSessionToken using the security credentials of an Amazon Web Services account
root user rather than an IAM user, we do not recommend it. If GetSessionToken is called
using root user credentials, the temporary credentials have root user permissions. For more
information, see Safeguard your root user credentials and don't use them for everyday tasks
in the IAM User Guide   For more information about using GetSessionToken to create
temporary credentials, see Temporary Credentials for Users in Untrusted Environments in the
IAM User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DurationSeconds"`: The duration, in seconds, that the credentials should remain valid.
  Acceptable durations for IAM user sessions range from 900 seconds (15 minutes) to 129,600
  seconds (36 hours), with 43,200 seconds (12 hours) as the default. Sessions for Amazon Web
  Services account owners are restricted to a maximum of 3,600 seconds (one hour). If the
  duration is longer than one hour, the session for Amazon Web Services account owners
  defaults to one hour.
- `"SerialNumber"`: The identification number of the MFA device that is associated with the
  IAM user who is making the GetSessionToken call. Specify this value if the IAM user has a
  policy that requires MFA authentication. The value is either the serial number for a
  hardware device (such as GAHT12345678) or an Amazon Resource Name (ARN) for a virtual
  device (such as arn:aws:iam::123456789012:mfa/user). You can find the device for an IAM
  user by going to the Amazon Web Services Management Console and viewing the user's security
  credentials.  The regex used to validate this parameter is a string of characters
  consisting of upper- and lower-case alphanumeric characters with no spaces. You can also
  include underscores or any of the following characters: =,.@:/-
- `"TokenCode"`: The value provided by the MFA device, if MFA is required. If any policy
  requires the IAM user to submit an MFA code, specify this value. If MFA authentication is
  required, the user must provide a code when requesting a set of temporary security
  credentials. A user who fails to provide the code receives an \"access denied\" response
  when requesting resources that require MFA authentication. The format for this parameter,
  as described by its regex pattern, is a sequence of six numeric digits.
"""
function get_session_token(; aws_config::AbstractAWSConfig=current_aws_config())
    return sts("GetSessionToken"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_session_token(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return sts(
        "GetSessionToken", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
