var documenterSearchIndex = {"docs":
[{"location":"#Bijections","page":"Bijections","title":"Bijections","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"A Bijection data type for Julia.","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"A Dict in Julia is not one-to-one. Two different keys might have the same value. A Bijection data structure behaves just like a Dict except it prevents assigning the same value to two different keys.","category":"page"},{"location":"#Getting-Started","page":"Bijections","title":"Getting Started","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"After using Bijections we create a new Bijection in one of the following ways:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"b = Bijection(): This gives a new Bijection in which the keys","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"and values are of Any type.","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"b = Bijection{S,T}(): This gives a new Bijection in which the keys are of type S and the values are of type T.\nb = Bijection(x,y): This gives a new Bijection in which the keys are type typeof(x), the values are type typeof(y) and the key-value pair (x,y) is inserted into the Bijection.\nb = Bijection(dict::AbstractDict{S, T}): This gives a new Bijection in which the keys are type S, the values are type T and all key-value pairs in dict are inserted into the Bijection.\nb = Bijection(pair_list::Vector{Pair{S, T}}): Create a new Bijection using a list of pairs.","category":"page"},{"location":"#Adding-and-Deleting-Pairs","page":"Bijections","title":"Adding and Deleting Pairs","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"Once a Bijection, b, is created, we add a new key-value pair in the same manner as with a Dict:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b[1] = \"hello\"\n\"hello\"\n\njulia> b[2] = \"bye\"\n\"bye\"","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"Notice, however, that if we add a new key with a value that already exists in the Bijection an error ensues:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b = Bijection{Int, String}()\nBijection Dict{Int64, String}()\n\njulia> b[3] = \"hello\"\nERROR: One of x or y already in this Bijection","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"Likewise, if a key already has a value it cannot be changed by giving it a new value:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b[1] = \"ciao\"\nERROR: One of x or y already in this Bijection","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"If we wish to change the value associated with a given key, the pair must first be deleted using delete!:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> delete!(b,1)\nBijection Dict{Int64, String} with 1 entry:\n  2 => \"bye\"\n\njulia> b[1] = \"ciao\"\n\"ciao\"","category":"page"},{"location":"#Using-a-Bijection","page":"Bijections","title":"Using a Bijection","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"To access a value associated with a given key, we use the same syntax as for a Dict:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b[1]\n\"ciao\"\n\njulia> b[2]\n\"bye\"","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"If the key is not in the Bijection an error is raised:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b[3]\nERROR: KeyError: 3 not found","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"Since the values in a Bijection must be distinct, we can give a value as an input and retrieve its associate key. The function inverse(b,y) finds the value x such that b[x]==y. However, we provide the handy short cut b(y):","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b(\"bye\")\n2\n\njulia> b(\"ciao\")\n1","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"Naturally, if the requested value is not in the Bijection an error is raised:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b(\"hello\")\nERROR: KeyError: hello not found","category":"page"},{"location":"#Creating-an-Inverse-Bijection","page":"Bijections","title":"Creating an Inverse Bijection","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"There are two functions that take a Bijection and return a new Bijection that is the functional inverse of the original: inv and active_inv.","category":"page"},{"location":"#Independent-inverse:-inv","page":"Bijections","title":"Independent inverse: inv","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"Given a Bijection b, calling inv(b) creates a new Bijection that is the inverse of b. The new Bijection is completely independent of the original, b. Changes to one do not affect the other:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b = Bijection{Int,String}()\nBijection Dict{Int64, String}()\n\njulia> b[1] = \"alpha\"\n\"alpha\"\n\njulia> b[2] = \"beta\"\n\"beta\"\n\njulia> bb = inv(b)\nBijection Dict{String, Int64} with 2 entries:\n  \"alpha\" => 1\n  \"beta\"  => 2\n\njulia> bb[\"alpha\"]\n1\n\njulia> bb[\"alpha\"]\n1\n\njulia> b[3] = \"gamma\"\n\"gamma\"\n\njulia> bb[\"gamma\"]\nERROR: KeyError: key \"gamma\" not found","category":"page"},{"location":"#Active-inverse:-active_inv","page":"Bijections","title":"Active inverse: active_inv","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"The active_inv function also creates an inverse Bijection, but in this case the original and the inverse are actively tied together. That is, modification of one immediately affects the other. The two Bijections remain inverses no matter how either is modified.","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> b = Bijection{Int,String}()\nBijection Dict{Int64, String}()\n\njulia> b[1] = \"alpha\"\n\"alpha\"\n\njulia> b[2] = \"beta\"\n\"beta\"\n\njulia> bb = active_inv(b)\nBijection Dict{String, Int64} with 2 entries:\n  \"alpha\" => 1\n  \"beta\"  => 2\n  \njulia> b[3] = \"gamma\"\n\"gamma\"\n\njulia> bb[\"gamma\"]\n3","category":"page"},{"location":"#Iteration","page":"Bijections","title":"Iteration","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"Bijections can be used in a for statement just like Julia dictionaries:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> for (x,y) in b; println(\"$x --> $y\"); end\n2 --> beta\n3 --> gamma\n1 --> alpha","category":"page"},{"location":"#Inspection","page":"Bijections","title":"Inspection","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"Thinking of a Bijection as a mapping between finite sets, we provide the functions domain and image. These return, respectively, the set of keys and the set of values of the Bijection.","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> domain(b)\nSet(Any[2,1])\n\njulia> image(b)\nSet(Any[\"bye\",\"ciao\"])","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"The collect function returns the Bijection as an array of key-value pairs:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> collect(b)\n2-element Array{Tuple{Any,Any},1}:\n (2,\"bye\")\n (1,\"ciao\")","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"The length function returns the number of key-value pairs:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> length(b)\n2","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"The isempty function returns true exactly when the Bijection contains no pairs:","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> isempty(b)\nfalse","category":"page"},{"location":"#Composition","page":"Bijections","title":"Composition","text":"","category":"section"},{"location":"","page":"Bijections","title":"Bijections","text":"Given two Bijections a and b, their composition c = a*b is a new  Bijection with the property that c[x] = a[b[x]] for all x in the  domain of b.","category":"page"},{"location":"","page":"Bijections","title":"Bijections","text":"julia> a = Bijection{Int,Int}(); a[1] = 10; a[2] = 20;\n\njulia> b = Bijection{String,Int}(); b[\"hi\"] = 1; b[\"bye\"] = 2;\n\njulia> c = a * b;\n\njulia> c[\"hi\"]\n10","category":"page"}]
}
