module CodecZstd

export
    ZstdCompressor,
    ZstdCompressorStream,
    ZstdFrameCompressor,
    ZstdDecompressor,
    ZstdDecompressorStream

if VERSION >= v"1.11.0-DEV.469"
    eval(Meta.parse("""
        public
            level_bounds,
            windowLog_bounds,
            windowLogMax_bounds,
            DEFAULT_COMPRESSION_LEVEL,
            ZSTD_WINDOWLOG_LIMIT_DEFAULT
    """))
end

import TranscodingStreams:
    TranscodingStreams,
    TranscodingStream,
    Memory,
    Error,
    initialize,
    finalize,
    splitkwargs

using Zstd_jll

# Module containing directly wrapped ccalls generated by CLang.jl
include("LibZstd_clang.jl")
# Library functions that have a Julian interface. This file originally preceded the above module
include("libzstd.jl")
include("compression.jl")
include("decompression.jl")

end # module
