[![Travis Build Status](https://travis-ci.org/JuliaCollections/DataStructures.jl.svg?branch=master)](https://travis-ci.org/JuliaCollections/DataStructures.jl)
[![Appveyor Build Status](https://ci.appveyor.com/api/projects/status/5gw9xok4e58aixsv?svg=true)](https://ci.appveyor.com/project/kmsquire/datastructures-jl)
[![Test Coverage](https://coveralls.io/repos/github/JuliaCollections/DataStructures.jl/badge.svg?branch=master)](https://coveralls.io/github/JuliaCollections/DataStructures.jl?branch=master)
[![Test Coverage](https://codecov.io/github/JuliaCollections/DataStructures.jl/coverage.svg?branch=master)](https://codecov.io/github/JuliaCollections/DataStructures.jl?branch=master)
[![Documentation](https://img.shields.io/badge/docs-latest-blue.svg)](https://juliacollections.github.io/DataStructures.jl/latest)
[![ColPrac: Contributor's Guide on Collaborative Practices for Community Packages](https://img.shields.io/badge/ColPrac-Contributor's%20Guide-blueviolet)](https://github.com/SciML/ColPrac)

DataStructures.jl
=================

This package implements a variety of data structures, including

-   Deque (implemented with an [unrolled linked list](https://en.wikipedia.org/wiki/Unrolled_linked_list))
-   CircularBuffer
-   CircularDeque (based on a circular buffer)
-   Stack
-   Queue
-   Priority Queue
-   Fenwick Tree
-   Accumulators and Counters (i.e. Multisets / Bags)
-   Disjoint Sets
-   Binary Heap
-   Mutable Binary Heap
-   Ordered Dicts and Sets
-   RobinDict (implemented with [Robin Hood Hashing](https://cs.uwaterloo.ca/research/tr/1986/CS-86-14.pdf))
-   SwissDict (inspired from [SwissTables](https://abseil.io/blog/20180927-swisstables))
-   Dictionaries with Defaults
-   Trie
-   Linked List and Mutable Linked List
-   Sorted Dict, Sorted Multi-Dict and Sorted Set
-   DataStructures.IntSet
-   SparseIntSet
-   DiBitVector (in which each element can store two bits)
-   Red Black Tree
-   AVL Tree
-   Splay Tree

Resources
---------

-   **Documentation**: https://juliacollections.github.io/DataStructures.jl/latest
